/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum DataTypeEnum {
    ADDRESS("Address", "http://hl7.org/fhir/data-types"),
    AGE("Age", "http://hl7.org/fhir/data-types"),
    ATTACHMENT("Attachment", "http://hl7.org/fhir/data-types"),
    CODEABLECONCEPT("CodeableConcept", "http://hl7.org/fhir/data-types"),
    CODING("Coding", "http://hl7.org/fhir/data-types"),
    CONTACT("Contact", "http://hl7.org/fhir/data-types"),
    COUNT("Count", "http://hl7.org/fhir/data-types"),
    DISTANCE("Distance", "http://hl7.org/fhir/data-types"),
    DURATION("Duration", "http://hl7.org/fhir/data-types"),
    EXTENSION("Extension", "http://hl7.org/fhir/data-types"),
    HUMANNAME("HumanName", "http://hl7.org/fhir/data-types"),
    IDENTIFIER("Identifier", "http://hl7.org/fhir/data-types"),
    MONEY("Money", "http://hl7.org/fhir/data-types"),
    NARRATIVE("Narrative", "http://hl7.org/fhir/data-types"),
    PERIOD("Period", "http://hl7.org/fhir/data-types"),
    QUANTITY("Quantity", "http://hl7.org/fhir/data-types"),
    RANGE("Range", "http://hl7.org/fhir/data-types"),
    RATIO("Ratio", "http://hl7.org/fhir/data-types"),
    RESOURCEREFERENCE("ResourceReference", "http://hl7.org/fhir/data-types"),
    SAMPLEDDATA("SampledData", "http://hl7.org/fhir/data-types"),
    SCHEDULE("Schedule", "http://hl7.org/fhir/data-types"),
    BASE64BINARY("base64Binary", "http://hl7.org/fhir/data-types"),
    BOOLEAN("boolean", "http://hl7.org/fhir/data-types"),
    CODE("code", "http://hl7.org/fhir/data-types"),
    DATE("date", "http://hl7.org/fhir/data-types"),
    DATETIME("dateTime", "http://hl7.org/fhir/data-types"),
    DECIMAL("decimal", "http://hl7.org/fhir/data-types"),
    ID("id", "http://hl7.org/fhir/data-types"),
    INSTANT("instant", "http://hl7.org/fhir/data-types"),
    INTEGER("integer", "http://hl7.org/fhir/data-types"),
    OID("oid", "http://hl7.org/fhir/data-types"),
    STRING("string", "http://hl7.org/fhir/data-types"),
    URI("uri", "http://hl7.org/fhir/data-types"),
    UUID("uuid", "http://hl7.org/fhir/data-types");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/data-types";
    public static final String VALUESET_NAME = "DataType";
    private static Map<String, DataTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, DataTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<DataTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static DataTypeEnum forCode(String theCode) {
        DataTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private DataTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, DataTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, DataTypeEnum>>();
        for (DataTypeEnum next : DataTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<DataTypeEnum>(){

            public String toCodeString(DataTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(DataTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public DataTypeEnum fromCodeString(String theCodeString) {
                return (DataTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public DataTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (DataTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

