/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Substance;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.dstu.valueset.SupplyDispenseStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.SupplyItemTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.SupplyStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.SupplyTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Supply", profile="http://hl7.org/fhir/profiles/Supply", id="supply")
public class Supply
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="kind", path="Supply.kind", description="", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="identifier", path="Supply.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="Supply.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="patient", path="Supply.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Supply.patient");
    @SearchParamDefinition(name="supplier", path="Supply.dispense.supplier", description="", type="reference")
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    public static final Include INCLUDE_DISPENSE_SUPPLIER = new Include("Supply.dispense.supplier");
    @SearchParamDefinition(name="dispenseid", path="Supply.dispense.identifier", description="", type="token")
    public static final String SP_DISPENSEID = "dispenseid";
    public static final TokenClientParam DISPENSEID = new TokenClientParam("dispenseid");
    @SearchParamDefinition(name="dispensestatus", path="Supply.dispense.status", description="", type="token")
    public static final String SP_DISPENSESTATUS = "dispensestatus";
    public static final TokenClientParam DISPENSESTATUS = new TokenClientParam("dispensestatus");
    @Child(name="kind", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The kind of supply (central, non-stock, etc)", formalDefinition="Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process")
    private BoundCodeableConceptDt<SupplyTypeEnum> myKind;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier for this supply request")
    private IdentifierDt myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="requested | dispensed | received | failed | cancelled", formalDefinition="Status of the supply request")
    private BoundCodeDt<SupplyStatusEnum> myStatus;
    @Child(name="orderedItem", order=3, min=0, max=1, summary=false, modifier=false, type={Medication.class, Substance.class, Device.class})
    @Description(shortDefinition="Medication, Substance, or Device requested to be supplied", formalDefinition="The item that is requested to be supplied")
    private ResourceReferenceDt myOrderedItem;
    @Child(name="patient", order=4, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Patient for whom the item is supplied", formalDefinition="A link to a resource representing the person whom the ordered item is for")
    private ResourceReferenceDt myPatient;
    @Child(name="dispense", order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Supply details", formalDefinition="Indicates the details of the dispense event such as the days supply and quantity of a supply dispensed.")
    private List<Dispense> myDispense;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myKind, this.myIdentifier, this.myStatus, this.myOrderedItem, this.myPatient, this.myDispense});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myKind, this.myIdentifier, this.myStatus, this.myOrderedItem, this.myPatient, this.myDispense});
    }

    public BoundCodeableConceptDt<SupplyTypeEnum> getKind() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeableConceptDt<SupplyTypeEnum>(SupplyTypeEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public BoundCodeableConceptDt<SupplyTypeEnum> getKindElement() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeableConceptDt<SupplyTypeEnum>(SupplyTypeEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public Supply setKind(BoundCodeableConceptDt<SupplyTypeEnum> theValue) {
        this.myKind = theValue;
        return this;
    }

    public Supply setKind(SupplyTypeEnum theValue) {
        this.getKind().setValueAsEnum(theValue);
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Supply setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Supply setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Supply setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public BoundCodeDt<SupplyStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SupplyStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<SupplyStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SupplyStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Supply setStatus(BoundCodeDt<SupplyStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Supply setStatus(SupplyStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getOrderedItem() {
        if (this.myOrderedItem == null) {
            this.myOrderedItem = new ResourceReferenceDt();
        }
        return this.myOrderedItem;
    }

    public ResourceReferenceDt getOrderedItemElement() {
        if (this.myOrderedItem == null) {
            this.myOrderedItem = new ResourceReferenceDt();
        }
        return this.myOrderedItem;
    }

    public Supply setOrderedItem(ResourceReferenceDt theValue) {
        this.myOrderedItem = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public Supply setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public List<Dispense> getDispense() {
        if (this.myDispense == null) {
            this.myDispense = new ArrayList<Dispense>();
        }
        return this.myDispense;
    }

    public List<Dispense> getDispenseElement() {
        if (this.myDispense == null) {
            this.myDispense = new ArrayList<Dispense>();
        }
        return this.myDispense;
    }

    public Supply setDispense(List<Dispense> theValue) {
        this.myDispense = theValue;
        return this;
    }

    public Dispense addDispense() {
        Dispense newType = new Dispense();
        this.getDispense().add(newType);
        return newType;
    }

    public Dispense getDispenseFirstRep() {
        if (this.getDispense().isEmpty()) {
            return this.addDispense();
        }
        return this.getDispense().get(0);
    }

    public String getResourceName() {
        return "Supply";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Dispense
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="External identifier", formalDefinition="Identifier assigned by the dispensing facility when the dispense occurs")
        private IdentifierDt myIdentifier;
        @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
        @Description(shortDefinition="in progress | dispensed | abandoned", formalDefinition="A code specifying the state of the dispense event.")
        private BoundCodeDt<SupplyDispenseStatusEnum> myStatus;
        @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Category of dispense event", formalDefinition="Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
        private BoundCodeableConceptDt<SupplyItemTypeEnum> myType;
        @Child(name="quantity", type={QuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount dispensed", formalDefinition="The amount of supply that has been dispensed. Includes unit of measure.")
        private QuantityDt myQuantity;
        @Child(name="suppliedItem", order=4, min=0, max=1, summary=false, modifier=false, type={Medication.class, Substance.class, Device.class})
        @Description(shortDefinition="Medication, Substance, or Device supplied", formalDefinition="Identifies the medication or substance being dispensed. This is either a link to a resource representing the details of the medication or substance or a simple attribute carrying a code that identifies the medication from a known list of medications.")
        private ResourceReferenceDt mySuppliedItem;
        @Child(name="supplier", order=5, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="Dispenser", formalDefinition="The individual responsible for dispensing the medication")
        private ResourceReferenceDt mySupplier;
        @Child(name="whenPrepared", type={PeriodDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Dispensing time", formalDefinition="The time the dispense event occurred.")
        private PeriodDt myWhenPrepared;
        @Child(name="whenHandedOver", type={PeriodDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Handover time", formalDefinition="The time the dispensed item was sent or handed to the patient (or agent).")
        private PeriodDt myWhenHandedOver;
        @Child(name="destination", order=8, min=0, max=1, summary=false, modifier=false, type={Location.class})
        @Description(shortDefinition="Where the Supply was sent", formalDefinition="Identification of the facility/location where the Supply was shipped to, as part of the dispense event.")
        private ResourceReferenceDt myDestination;
        @Child(name="receiver", order=9, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="Who collected the Supply", formalDefinition="Identifies the person who picked up the Supply.")
        private List<ResourceReferenceDt> myReceiver;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myQuantity, this.mySuppliedItem, this.mySupplier, this.myWhenPrepared, this.myWhenHandedOver, this.myDestination, this.myReceiver});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myQuantity, this.mySuppliedItem, this.mySupplier, this.myWhenPrepared, this.myWhenHandedOver, this.myDestination, this.myReceiver});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public IdentifierDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Dispense setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Dispense setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Dispense setIdentifier(String theSystem, String theValue) {
            this.myIdentifier = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public BoundCodeDt<SupplyDispenseStatusEnum> getStatus() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(SupplyDispenseStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public BoundCodeDt<SupplyDispenseStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(SupplyDispenseStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public Dispense setStatus(BoundCodeDt<SupplyDispenseStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Dispense setStatus(SupplyDispenseStatusEnum theValue) {
            this.getStatus().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeableConceptDt<SupplyItemTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeableConceptDt<SupplyItemTypeEnum>(SupplyItemTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeableConceptDt<SupplyItemTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeableConceptDt<SupplyItemTypeEnum>(SupplyItemTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public Dispense setType(BoundCodeableConceptDt<SupplyItemTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Dispense setType(SupplyItemTypeEnum theValue) {
            this.getType().setValueAsEnum(theValue);
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public Dispense setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dispense setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dispense setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ResourceReferenceDt getSuppliedItem() {
            if (this.mySuppliedItem == null) {
                this.mySuppliedItem = new ResourceReferenceDt();
            }
            return this.mySuppliedItem;
        }

        public ResourceReferenceDt getSuppliedItemElement() {
            if (this.mySuppliedItem == null) {
                this.mySuppliedItem = new ResourceReferenceDt();
            }
            return this.mySuppliedItem;
        }

        public Dispense setSuppliedItem(ResourceReferenceDt theValue) {
            this.mySuppliedItem = theValue;
            return this;
        }

        public ResourceReferenceDt getSupplier() {
            if (this.mySupplier == null) {
                this.mySupplier = new ResourceReferenceDt();
            }
            return this.mySupplier;
        }

        public ResourceReferenceDt getSupplierElement() {
            if (this.mySupplier == null) {
                this.mySupplier = new ResourceReferenceDt();
            }
            return this.mySupplier;
        }

        public Dispense setSupplier(ResourceReferenceDt theValue) {
            this.mySupplier = theValue;
            return this;
        }

        public PeriodDt getWhenPrepared() {
            if (this.myWhenPrepared == null) {
                this.myWhenPrepared = new PeriodDt();
            }
            return this.myWhenPrepared;
        }

        public PeriodDt getWhenPreparedElement() {
            if (this.myWhenPrepared == null) {
                this.myWhenPrepared = new PeriodDt();
            }
            return this.myWhenPrepared;
        }

        public Dispense setWhenPrepared(PeriodDt theValue) {
            this.myWhenPrepared = theValue;
            return this;
        }

        public PeriodDt getWhenHandedOver() {
            if (this.myWhenHandedOver == null) {
                this.myWhenHandedOver = new PeriodDt();
            }
            return this.myWhenHandedOver;
        }

        public PeriodDt getWhenHandedOverElement() {
            if (this.myWhenHandedOver == null) {
                this.myWhenHandedOver = new PeriodDt();
            }
            return this.myWhenHandedOver;
        }

        public Dispense setWhenHandedOver(PeriodDt theValue) {
            this.myWhenHandedOver = theValue;
            return this;
        }

        public ResourceReferenceDt getDestination() {
            if (this.myDestination == null) {
                this.myDestination = new ResourceReferenceDt();
            }
            return this.myDestination;
        }

        public ResourceReferenceDt getDestinationElement() {
            if (this.myDestination == null) {
                this.myDestination = new ResourceReferenceDt();
            }
            return this.myDestination;
        }

        public Dispense setDestination(ResourceReferenceDt theValue) {
            this.myDestination = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getReceiver() {
            if (this.myReceiver == null) {
                this.myReceiver = new ArrayList<ResourceReferenceDt>();
            }
            return this.myReceiver;
        }

        public List<ResourceReferenceDt> getReceiverElement() {
            if (this.myReceiver == null) {
                this.myReceiver = new ArrayList<ResourceReferenceDt>();
            }
            return this.myReceiver;
        }

        public Dispense setReceiver(List<ResourceReferenceDt> theValue) {
            this.myReceiver = theValue;
            return this;
        }

        public ResourceReferenceDt addReceiver() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getReceiver().add(newType);
            return newType;
        }
    }
}

