/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AddressDt;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.AdministrativeGenderCodesEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="RelatedPerson", profile="http://hl7.org/fhir/profiles/RelatedPerson", id="relatedperson")
public class RelatedPerson
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="RelatedPerson.identifier", description="A patient Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="RelatedPerson.name", description="A portion of name in any name part", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="phonetic", path="", description="A portion of name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="RelatedPerson.telecom", description="The value in any kind of contact", type="string")
    public static final String SP_TELECOM = "telecom";
    public static final StringClientParam TELECOM = new StringClientParam("telecom");
    @SearchParamDefinition(name="address", path="RelatedPerson.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="gender", path="RelatedPerson.gender", description="Gender of the person", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="patient", path="RelatedPerson.patient", description="The patient this person is related to", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("RelatedPerson.patient");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=true)
    @Description(shortDefinition="A Human identifier for this person", formalDefinition="Identifier for a person within a particular scope.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="patient", order=1, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="The patient this person is related to", formalDefinition="The patient this person is related to")
    private ResourceReferenceDt myPatient;
    @Child(name="relationship", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="The nature of the relationship", formalDefinition="The nature of the relationship between a patient and the related person")
    private CodeableConceptDt myRelationship;
    @Child(name="name", type={HumanNameDt.class}, order=3, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="A name associated with the person", formalDefinition="A name associated with the person")
    private HumanNameDt myName;
    @Child(name="telecom", type={ContactDt.class}, order=4, min=0, max=-1, summary=true, modifier=true)
    @Description(shortDefinition="A contact detail for the person", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
    private List<ContactDt> myTelecom;
    @Child(name="gender", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="Gender for administrative purposes", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    private BoundCodeableConceptDt<AdministrativeGenderCodesEnum> myGender;
    @Child(name="address", type={AddressDt.class}, order=6, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="Address where the related person can be contacted or visited", formalDefinition="Address where the related person can be contacted or visited")
    private AddressDt myAddress;
    @Child(name="photo", type={AttachmentDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Image of the person", formalDefinition="Image of the person")
    private List<AttachmentDt> myPhoto;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPatient, this.myRelationship, this.myName, this.myTelecom, this.myGender, this.myAddress, this.myPhoto});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPatient, this.myRelationship, this.myName, this.myTelecom, this.myGender, this.myAddress, this.myPhoto});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public RelatedPerson setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public RelatedPerson addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public RelatedPerson addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public RelatedPerson setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public CodeableConceptDt getRelationship() {
        if (this.myRelationship == null) {
            this.myRelationship = new CodeableConceptDt();
        }
        return this.myRelationship;
    }

    public CodeableConceptDt getRelationshipElement() {
        if (this.myRelationship == null) {
            this.myRelationship = new CodeableConceptDt();
        }
        return this.myRelationship;
    }

    public RelatedPerson setRelationship(CodeableConceptDt theValue) {
        this.myRelationship = theValue;
        return this;
    }

    public HumanNameDt getName() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public HumanNameDt getNameElement() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public RelatedPerson setName(HumanNameDt theValue) {
        this.myName = theValue;
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public RelatedPerson setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public RelatedPerson addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public RelatedPerson addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGender() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public RelatedPerson setGender(BoundCodeableConceptDt<AdministrativeGenderCodesEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public RelatedPerson setGender(AdministrativeGenderCodesEnum theValue) {
        this.getGender().setValueAsEnum(theValue);
        return this;
    }

    public AddressDt getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new AddressDt();
        }
        return this.myAddress;
    }

    public AddressDt getAddressElement() {
        if (this.myAddress == null) {
            this.myAddress = new AddressDt();
        }
        return this.myAddress;
    }

    public RelatedPerson setAddress(AddressDt theValue) {
        this.myAddress = theValue;
        return this;
    }

    public List<AttachmentDt> getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public List<AttachmentDt> getPhotoElement() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public RelatedPerson setPhoto(List<AttachmentDt> theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public AttachmentDt addPhoto() {
        AttachmentDt newType = new AttachmentDt();
        this.getPhoto().add(newType);
        return newType;
    }

    public AttachmentDt getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            return this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public String getResourceName() {
        return "RelatedPerson";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

