/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.DurationDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RatioDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.ScheduleDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Condition;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.MedicationPrescriptionStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="MedicationPrescription", profile="http://hl7.org/fhir/profiles/MedicationPrescription", id="medicationprescription")
public class MedicationPrescription
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="datewritten", path="MedicationPrescription.dateWritten", description="Return prescriptions written on this date", type="date")
    public static final String SP_DATEWRITTEN = "datewritten";
    public static final DateClientParam DATEWRITTEN = new DateClientParam("datewritten");
    @SearchParamDefinition(name="encounter", path="MedicationPrescription.encounter", description="Return prescriptions with this encounter identity", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("MedicationPrescription.encounter");
    @SearchParamDefinition(name="identifier", path="MedicationPrescription.identifier", description="Return prescriptions with this external identity", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationPrescription.medication", description="Code for medicine or text in medicine name", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationPrescription.medication");
    @SearchParamDefinition(name="patient", path="MedicationPrescription.patient", description="The identity of a patient to list dispenses  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationPrescription.patient");
    @SearchParamDefinition(name="status", path="MedicationPrescription.status", description="Status of the prescription", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External identifier", formalDefinition="External identifier - one that would be used by another non-FHIR system - for example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an erntire workflow process where records have to be tracked through an entire system.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="dateWritten", type={DateTimeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When prescription was authorized", formalDefinition="The date (and perhaps time) when the prescription was written")
    private DateTimeDt myDateWritten;
    @Child(name="status", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="active | on hold | completed | entered in error | stopped | superceded", formalDefinition="A code specifying the state of the order.  Generally this will be active or completed state")
    private BoundCodeDt<MedicationPrescriptionStatusEnum> myStatus;
    @Child(name="patient", order=3, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Who prescription is for", formalDefinition="A link to a resource representing the person to whom the medication will be given.")
    private ResourceReferenceDt myPatient;
    @Child(name="prescriber", order=4, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Who ordered the medication(s)", formalDefinition="The healthcare professional responsible for authorizing the prescription")
    private ResourceReferenceDt myPrescriber;
    @Child(name="encounter", order=5, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="Created during encounter / admission / stay", formalDefinition="A link to a resource that identifies the particular occurrence of contact between patient and health care provider.")
    private ResourceReferenceDt myEncounter;
    @Child(name="reason", order=6, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Condition.class})
    @Description(shortDefinition="Reason or indication for writing the prescription", formalDefinition="Can be the reason or the indication for writing the prescription.")
    private IDatatype myReason;
    @Child(name="medication", order=7, min=0, max=1, summary=false, modifier=false, type={Medication.class})
    @Description(shortDefinition="Medication to be taken", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    private ResourceReferenceDt myMedication;
    @Child(name="dosageInstruction", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="How medication should be taken", formalDefinition="Indicates how the medication is to be used by the patient")
    private List<DosageInstruction> myDosageInstruction;
    @Child(name="dispense", order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Medication supply authorization", formalDefinition="Deals with details of the dispense part of the order")
    private Dispense myDispense;
    @Child(name="substitution", order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Any restrictions on medication substitution?", formalDefinition="Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen, and in others it does not matter. This block explains the prescriber's intent. If nothing is specified substitution may be done.")
    private Substitution mySubstitution;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDateWritten, this.myStatus, this.myPatient, this.myPrescriber, this.myEncounter, this.myReason, this.myMedication, this.myDosageInstruction, this.myDispense, this.mySubstitution});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDateWritten, this.myStatus, this.myPatient, this.myPrescriber, this.myEncounter, this.myReason, this.myMedication, this.myDosageInstruction, this.myDispense, this.mySubstitution});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public MedicationPrescription setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public MedicationPrescription addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public MedicationPrescription addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public DateTimeDt getDateWritten() {
        if (this.myDateWritten == null) {
            this.myDateWritten = new DateTimeDt();
        }
        return this.myDateWritten;
    }

    public DateTimeDt getDateWrittenElement() {
        if (this.myDateWritten == null) {
            this.myDateWritten = new DateTimeDt();
        }
        return this.myDateWritten;
    }

    public MedicationPrescription setDateWritten(DateTimeDt theValue) {
        this.myDateWritten = theValue;
        return this;
    }

    public MedicationPrescription setDateWritten(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateWritten = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public MedicationPrescription setDateWrittenWithSecondsPrecision(Date theDate) {
        this.myDateWritten = new DateTimeDt(theDate);
        return this;
    }

    public BoundCodeDt<MedicationPrescriptionStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationPrescriptionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<MedicationPrescriptionStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationPrescriptionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public MedicationPrescription setStatus(BoundCodeDt<MedicationPrescriptionStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public MedicationPrescription setStatus(MedicationPrescriptionStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationPrescription setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getPrescriber() {
        if (this.myPrescriber == null) {
            this.myPrescriber = new ResourceReferenceDt();
        }
        return this.myPrescriber;
    }

    public ResourceReferenceDt getPrescriberElement() {
        if (this.myPrescriber == null) {
            this.myPrescriber = new ResourceReferenceDt();
        }
        return this.myPrescriber;
    }

    public MedicationPrescription setPrescriber(ResourceReferenceDt theValue) {
        this.myPrescriber = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ResourceReferenceDt getEncounterElement() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public MedicationPrescription setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public IDatatype getReasonElement() {
        return this.myReason;
    }

    public MedicationPrescription setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public ResourceReferenceDt getMedication() {
        if (this.myMedication == null) {
            this.myMedication = new ResourceReferenceDt();
        }
        return this.myMedication;
    }

    public ResourceReferenceDt getMedicationElement() {
        if (this.myMedication == null) {
            this.myMedication = new ResourceReferenceDt();
        }
        return this.myMedication;
    }

    public MedicationPrescription setMedication(ResourceReferenceDt theValue) {
        this.myMedication = theValue;
        return this;
    }

    public List<DosageInstruction> getDosageInstruction() {
        if (this.myDosageInstruction == null) {
            this.myDosageInstruction = new ArrayList<DosageInstruction>();
        }
        return this.myDosageInstruction;
    }

    public List<DosageInstruction> getDosageInstructionElement() {
        if (this.myDosageInstruction == null) {
            this.myDosageInstruction = new ArrayList<DosageInstruction>();
        }
        return this.myDosageInstruction;
    }

    public MedicationPrescription setDosageInstruction(List<DosageInstruction> theValue) {
        this.myDosageInstruction = theValue;
        return this;
    }

    public DosageInstruction addDosageInstruction() {
        DosageInstruction newType = new DosageInstruction();
        this.getDosageInstruction().add(newType);
        return newType;
    }

    public DosageInstruction getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            return this.addDosageInstruction();
        }
        return this.getDosageInstruction().get(0);
    }

    public Dispense getDispense() {
        if (this.myDispense == null) {
            this.myDispense = new Dispense();
        }
        return this.myDispense;
    }

    public Dispense getDispenseElement() {
        if (this.myDispense == null) {
            this.myDispense = new Dispense();
        }
        return this.myDispense;
    }

    public MedicationPrescription setDispense(Dispense theValue) {
        this.myDispense = theValue;
        return this;
    }

    public Substitution getSubstitution() {
        if (this.mySubstitution == null) {
            this.mySubstitution = new Substitution();
        }
        return this.mySubstitution;
    }

    public Substitution getSubstitutionElement() {
        if (this.mySubstitution == null) {
            this.mySubstitution = new Substitution();
        }
        return this.mySubstitution;
    }

    public MedicationPrescription setSubstitution(Substitution theValue) {
        this.mySubstitution = theValue;
        return this;
    }

    public String getResourceName() {
        return "MedicationPrescription";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Substitution
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="generic | formulary +", formalDefinition="A code signifying whether a different drug should be dispensed from what was prescribed.")
        private CodeableConceptDt myType;
        @Child(name="reason", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Why should substitution (not) be made", formalDefinition="Indicates the reason for the substitution, or why substitution must or must not be performed.")
        private CodeableConceptDt myReason;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myReason});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myReason});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public CodeableConceptDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Substitution setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodeableConceptDt getReason() {
            if (this.myReason == null) {
                this.myReason = new CodeableConceptDt();
            }
            return this.myReason;
        }

        public CodeableConceptDt getReasonElement() {
            if (this.myReason == null) {
                this.myReason = new CodeableConceptDt();
            }
            return this.myReason;
        }

        public Substitution setReason(CodeableConceptDt theValue) {
            this.myReason = theValue;
            return this;
        }
    }

    @Block
    public static class Dispense
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="medication", order=0, min=0, max=1, summary=false, modifier=false, type={Medication.class})
        @Description(shortDefinition="Product to be supplied", formalDefinition="Identifies the medication that is to be dispensed.  This may be a more specifically defined than the medicationPrescription.medication . This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
        private ResourceReferenceDt myMedication;
        @Child(name="validityPeriod", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Time period supply is authorized for", formalDefinition="Design Comments: This indicates the validity period of a prescription (stale dating the Prescription) It reflects the prescriber perspective for the validity of the prescription. Dispenses must not be made against the prescription outside of this period. The lower-bound of the Dispensing Window signifies the earliest date that the prescription can be filled for the first time. If an upper-bound is not specified then the Prescription is open-ended or will default to a stale-date based on regulations. Rationale: Indicates when the Prescription becomes valid, and when it ceases to be a dispensable Prescription.")
        private PeriodDt myValidityPeriod;
        @Child(name="numberOfRepeatsAllowed", type={IntegerDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="# of refills authorized", formalDefinition="An integer indicating the number of repeats of the Dispense. UsageNotes: For example, the number of times the prescribed quantity is to be supplied including the initial standard fill.")
        private IntegerDt myNumberOfRepeatsAllowed;
        @Child(name="quantity", type={QuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount of medication to supply per dispense", formalDefinition="The amount that is to be dispensed.")
        private QuantityDt myQuantity;
        @Child(name="expectedSupplyDuration", type={DurationDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Days supply per dispense", formalDefinition="Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last. In some situations, this attribute may be used instead of quantity to identify the amount supplied by how long it is expected to last, rather than the physical quantity issued, e.g. 90 days supply of medication (based on an ordered dosage) When possible, it is always better to specify quantity, as this tends to be more precise. expectedSupplyDuration will always be an estimate that can be influenced by external factors.")
        private DurationDt myExpectedSupplyDuration;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myMedication, this.myValidityPeriod, this.myNumberOfRepeatsAllowed, this.myQuantity, this.myExpectedSupplyDuration});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMedication, this.myValidityPeriod, this.myNumberOfRepeatsAllowed, this.myQuantity, this.myExpectedSupplyDuration});
        }

        public ResourceReferenceDt getMedication() {
            if (this.myMedication == null) {
                this.myMedication = new ResourceReferenceDt();
            }
            return this.myMedication;
        }

        public ResourceReferenceDt getMedicationElement() {
            if (this.myMedication == null) {
                this.myMedication = new ResourceReferenceDt();
            }
            return this.myMedication;
        }

        public Dispense setMedication(ResourceReferenceDt theValue) {
            this.myMedication = theValue;
            return this;
        }

        public PeriodDt getValidityPeriod() {
            if (this.myValidityPeriod == null) {
                this.myValidityPeriod = new PeriodDt();
            }
            return this.myValidityPeriod;
        }

        public PeriodDt getValidityPeriodElement() {
            if (this.myValidityPeriod == null) {
                this.myValidityPeriod = new PeriodDt();
            }
            return this.myValidityPeriod;
        }

        public Dispense setValidityPeriod(PeriodDt theValue) {
            this.myValidityPeriod = theValue;
            return this;
        }

        public IntegerDt getNumberOfRepeatsAllowed() {
            if (this.myNumberOfRepeatsAllowed == null) {
                this.myNumberOfRepeatsAllowed = new IntegerDt();
            }
            return this.myNumberOfRepeatsAllowed;
        }

        public IntegerDt getNumberOfRepeatsAllowedElement() {
            if (this.myNumberOfRepeatsAllowed == null) {
                this.myNumberOfRepeatsAllowed = new IntegerDt();
            }
            return this.myNumberOfRepeatsAllowed;
        }

        public Dispense setNumberOfRepeatsAllowed(IntegerDt theValue) {
            this.myNumberOfRepeatsAllowed = theValue;
            return this;
        }

        public Dispense setNumberOfRepeatsAllowed(int theInteger) {
            this.myNumberOfRepeatsAllowed = new IntegerDt(theInteger);
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public Dispense setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dispense setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dispense setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public DurationDt getExpectedSupplyDuration() {
            if (this.myExpectedSupplyDuration == null) {
                this.myExpectedSupplyDuration = new DurationDt();
            }
            return this.myExpectedSupplyDuration;
        }

        public DurationDt getExpectedSupplyDurationElement() {
            if (this.myExpectedSupplyDuration == null) {
                this.myExpectedSupplyDuration = new DurationDt();
            }
            return this.myExpectedSupplyDuration;
        }

        public Dispense setExpectedSupplyDuration(DurationDt theValue) {
            this.myExpectedSupplyDuration = theValue;
            return this;
        }
    }

    @Block
    public static class DosageInstruction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="text", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Dosage instructions expressed as text", formalDefinition="Free text dosage instructions for cases where the instructions are too complex to code.")
        private StringDt myText;
        @Child(name="additionalInstructions", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Supplemental instructions - e.g. \"with meals\"", formalDefinition="Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.")
        private CodeableConceptDt myAdditionalInstructions;
        @Child(name="timing", order=2, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class, ScheduleDt.class})
        @Description(shortDefinition="When medication should be administered", formalDefinition="The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\"")
        private IDatatype myTiming;
        @Child(name="asNeeded", order=3, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="Take \"as needed\" f(or x)", formalDefinition="If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication")
        private IDatatype myAsNeeded;
        @Child(name="site", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Body site to administer to", formalDefinition="A coded specification of the anatomic site where the medication first enters the body")
        private CodeableConceptDt mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="How drug should enter body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Technique for administering medication", formalDefinition="A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.Terminologies used often pre-coordinate this term with the route and or form of administration.")
        private CodeableConceptDt myMethod;
        @Child(name="doseQuantity", type={QuantityDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        private QuantityDt myDoseQuantity;
        @Child(name="rate", type={RatioDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount of medication per unit of time", formalDefinition="Identifies the speed with which the substance is introduced into the subject. Typically the rate for an infusion. 200ml in 2 hours.")
        private RatioDt myRate;
        @Child(name="maxDosePerPeriod", type={RatioDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Upper limit on medication per unit of time", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time. E.g. 1000mg in 24 hours.")
        private RatioDt myMaxDosePerPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myText, this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myDoseQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myText, this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myDoseQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public StringDt getText() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public DosageInstruction setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public DosageInstruction setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getAdditionalInstructions() {
            if (this.myAdditionalInstructions == null) {
                this.myAdditionalInstructions = new CodeableConceptDt();
            }
            return this.myAdditionalInstructions;
        }

        public CodeableConceptDt getAdditionalInstructionsElement() {
            if (this.myAdditionalInstructions == null) {
                this.myAdditionalInstructions = new CodeableConceptDt();
            }
            return this.myAdditionalInstructions;
        }

        public DosageInstruction setAdditionalInstructions(CodeableConceptDt theValue) {
            this.myAdditionalInstructions = theValue;
            return this;
        }

        public IDatatype getTiming() {
            return this.myTiming;
        }

        public IDatatype getTimingElement() {
            return this.myTiming;
        }

        public DosageInstruction setTiming(IDatatype theValue) {
            this.myTiming = theValue;
            return this;
        }

        public IDatatype getAsNeeded() {
            return this.myAsNeeded;
        }

        public IDatatype getAsNeededElement() {
            return this.myAsNeeded;
        }

        public DosageInstruction setAsNeeded(IDatatype theValue) {
            this.myAsNeeded = theValue;
            return this;
        }

        public CodeableConceptDt getSite() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public CodeableConceptDt getSiteElement() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public DosageInstruction setSite(CodeableConceptDt theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public CodeableConceptDt getRouteElement() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public DosageInstruction setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public CodeableConceptDt getMethodElement() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public DosageInstruction setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public QuantityDt getDoseQuantity() {
            if (this.myDoseQuantity == null) {
                this.myDoseQuantity = new QuantityDt();
            }
            return this.myDoseQuantity;
        }

        public QuantityDt getDoseQuantityElement() {
            if (this.myDoseQuantity == null) {
                this.myDoseQuantity = new QuantityDt();
            }
            return this.myDoseQuantity;
        }

        public DosageInstruction setDoseQuantity(QuantityDt theValue) {
            this.myDoseQuantity = theValue;
            return this;
        }

        public DosageInstruction setDoseQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myDoseQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public DosageInstruction setDoseQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myDoseQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public DosageInstruction setDoseQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myDoseQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public DosageInstruction setDoseQuantity(double theValue) {
            this.myDoseQuantity = new QuantityDt(theValue);
            return this;
        }

        public DosageInstruction setDoseQuantity(long theValue) {
            this.myDoseQuantity = new QuantityDt(theValue);
            return this;
        }

        public DosageInstruction setDoseQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myDoseQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public RatioDt getRate() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public RatioDt getRateElement() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public DosageInstruction setRate(RatioDt theValue) {
            this.myRate = theValue;
            return this;
        }

        public RatioDt getMaxDosePerPeriod() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public RatioDt getMaxDosePerPeriodElement() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public DosageInstruction setMaxDosePerPeriod(RatioDt theValue) {
            this.myMaxDosePerPeriod = theValue;
            return this;
        }
    }
}

