/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RatioDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.MedicationPrescription;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.MedicationAdministrationStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="MedicationAdministration", profile="http://hl7.org/fhir/profiles/MedicationAdministration", id="medicationadministration")
public class MedicationAdministration
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="device", path="MedicationAdministration.device", description="Return administrations with this administration device identity", type="reference")
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("MedicationAdministration.device");
    @SearchParamDefinition(name="encounter", path="MedicationAdministration.encounter", description="Return administrations that share this encounter", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("MedicationAdministration.encounter");
    @SearchParamDefinition(name="identifier", path="MedicationAdministration.identifier", description="Return administrations with this external identity", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationAdministration.medication", description="Return administrations of this medication", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationAdministration.medication");
    @SearchParamDefinition(name="notgiven", path="MedicationAdministration.wasNotGiven", description="Administrations that were not made", type="token")
    public static final String SP_NOTGIVEN = "notgiven";
    public static final TokenClientParam NOTGIVEN = new TokenClientParam("notgiven");
    @SearchParamDefinition(name="patient", path="MedicationAdministration.patient", description="The identity of a patient to list administrations  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationAdministration.patient");
    @SearchParamDefinition(name="prescription", path="MedicationAdministration.prescription", description="The identity of a prescription to list administrations from", type="reference")
    public static final String SP_PRESCRIPTION = "prescription";
    public static final ReferenceClientParam PRESCRIPTION = new ReferenceClientParam("prescription");
    public static final Include INCLUDE_PRESCRIPTION = new Include("MedicationAdministration.prescription");
    @SearchParamDefinition(name="status", path="MedicationAdministration.status", description="MedicationAdministration event status (for example one of active/paused/completed/nullified)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="whengiven", path="MedicationAdministration.whenGiven", description="Date of administration", type="date")
    public static final String SP_WHENGIVEN = "whengiven";
    public static final DateClientParam WHENGIVEN = new DateClientParam("whengiven");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External identifier", formalDefinition="External identifier - FHIR will generate its own internal IDs (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="in progress | on hold | completed | entered in error | stopped", formalDefinition="Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.")
    private BoundCodeDt<MedicationAdministrationStatusEnum> myStatus;
    @Child(name="patient", order=2, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Who received medication?", formalDefinition="The person or animal to whom the medication was given.")
    private ResourceReferenceDt myPatient;
    @Child(name="practitioner", order=3, min=1, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Who administered substance?", formalDefinition="The individual who was responsible for giving the medication to the patient.")
    private ResourceReferenceDt myPractitioner;
    @Child(name="encounter", order=4, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="Encounter administered as part of", formalDefinition="The visit or admission the or other contact between patient and health care provider the medication administration was performed as part of.")
    private ResourceReferenceDt myEncounter;
    @Child(name="prescription", order=5, min=1, max=1, summary=false, modifier=false, type={MedicationPrescription.class})
    @Description(shortDefinition="Order administration performed against", formalDefinition="The original request, instruction or authority to perform the administration.")
    private ResourceReferenceDt myPrescription;
    @Child(name="wasNotGiven", type={BooleanDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="True if medication not administered", formalDefinition="Set this to true if the record is saying that the medication was NOT administered.")
    private BooleanDt myWasNotGiven;
    @Child(name="reasonNotGiven", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Reason administration not performed", formalDefinition="A code indicating why the administration was not performed.")
    private List<CodeableConceptDt> myReasonNotGiven;
    @Child(name="whenGiven", type={PeriodDt.class}, order=8, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Start and end time of administration", formalDefinition="An interval of time during which the administration took place.  For many administrations, such as swallowing a tablet the lower and upper values of the interval will be the same.")
    private PeriodDt myWhenGiven;
    @Child(name="medication", order=9, min=0, max=1, summary=false, modifier=false, type={Medication.class})
    @Description(shortDefinition="What was administered?", formalDefinition="Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    private ResourceReferenceDt myMedication;
    @Child(name="device", order=10, min=0, max=-1, summary=false, modifier=false, type={Device.class})
    @Description(shortDefinition="Device used to administer", formalDefinition="The device used in administering the medication to the patient.  E.g. a particular infusion pump")
    private List<ResourceReferenceDt> myDevice;
    @Child(name="dosage", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Medicine administration instructions to the patient/carer", formalDefinition="Provides details of how much of the medication was administered")
    private List<Dosage> myDosage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myPractitioner, this.myEncounter, this.myPrescription, this.myWasNotGiven, this.myReasonNotGiven, this.myWhenGiven, this.myMedication, this.myDevice, this.myDosage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myPractitioner, this.myEncounter, this.myPrescription, this.myWasNotGiven, this.myReasonNotGiven, this.myWhenGiven, this.myMedication, this.myDevice, this.myDosage});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public MedicationAdministration setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public MedicationAdministration addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public MedicationAdministration addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public BoundCodeDt<MedicationAdministrationStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationAdministrationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<MedicationAdministrationStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationAdministrationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public MedicationAdministration setStatus(BoundCodeDt<MedicationAdministrationStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public MedicationAdministration setStatus(MedicationAdministrationStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationAdministration setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getPractitioner() {
        if (this.myPractitioner == null) {
            this.myPractitioner = new ResourceReferenceDt();
        }
        return this.myPractitioner;
    }

    public ResourceReferenceDt getPractitionerElement() {
        if (this.myPractitioner == null) {
            this.myPractitioner = new ResourceReferenceDt();
        }
        return this.myPractitioner;
    }

    public MedicationAdministration setPractitioner(ResourceReferenceDt theValue) {
        this.myPractitioner = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ResourceReferenceDt getEncounterElement() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public MedicationAdministration setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getPrescription() {
        if (this.myPrescription == null) {
            this.myPrescription = new ResourceReferenceDt();
        }
        return this.myPrescription;
    }

    public ResourceReferenceDt getPrescriptionElement() {
        if (this.myPrescription == null) {
            this.myPrescription = new ResourceReferenceDt();
        }
        return this.myPrescription;
    }

    public MedicationAdministration setPrescription(ResourceReferenceDt theValue) {
        this.myPrescription = theValue;
        return this;
    }

    public BooleanDt getWasNotGiven() {
        if (this.myWasNotGiven == null) {
            this.myWasNotGiven = new BooleanDt();
        }
        return this.myWasNotGiven;
    }

    public BooleanDt getWasNotGivenElement() {
        if (this.myWasNotGiven == null) {
            this.myWasNotGiven = new BooleanDt();
        }
        return this.myWasNotGiven;
    }

    public MedicationAdministration setWasNotGiven(BooleanDt theValue) {
        this.myWasNotGiven = theValue;
        return this;
    }

    public MedicationAdministration setWasNotGiven(boolean theBoolean) {
        this.myWasNotGiven = new BooleanDt(theBoolean);
        return this;
    }

    public List<CodeableConceptDt> getReasonNotGiven() {
        if (this.myReasonNotGiven == null) {
            this.myReasonNotGiven = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonNotGiven;
    }

    public List<CodeableConceptDt> getReasonNotGivenElement() {
        if (this.myReasonNotGiven == null) {
            this.myReasonNotGiven = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonNotGiven;
    }

    public MedicationAdministration setReasonNotGiven(List<CodeableConceptDt> theValue) {
        this.myReasonNotGiven = theValue;
        return this;
    }

    public CodeableConceptDt addReasonNotGiven() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReasonNotGiven().add(newType);
        return newType;
    }

    public CodeableConceptDt getReasonNotGivenFirstRep() {
        if (this.getReasonNotGiven().isEmpty()) {
            return this.addReasonNotGiven();
        }
        return this.getReasonNotGiven().get(0);
    }

    public PeriodDt getWhenGiven() {
        if (this.myWhenGiven == null) {
            this.myWhenGiven = new PeriodDt();
        }
        return this.myWhenGiven;
    }

    public PeriodDt getWhenGivenElement() {
        if (this.myWhenGiven == null) {
            this.myWhenGiven = new PeriodDt();
        }
        return this.myWhenGiven;
    }

    public MedicationAdministration setWhenGiven(PeriodDt theValue) {
        this.myWhenGiven = theValue;
        return this;
    }

    public ResourceReferenceDt getMedication() {
        if (this.myMedication == null) {
            this.myMedication = new ResourceReferenceDt();
        }
        return this.myMedication;
    }

    public ResourceReferenceDt getMedicationElement() {
        if (this.myMedication == null) {
            this.myMedication = new ResourceReferenceDt();
        }
        return this.myMedication;
    }

    public MedicationAdministration setMedication(ResourceReferenceDt theValue) {
        this.myMedication = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getDevice() {
        if (this.myDevice == null) {
            this.myDevice = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDevice;
    }

    public List<ResourceReferenceDt> getDeviceElement() {
        if (this.myDevice == null) {
            this.myDevice = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDevice;
    }

    public MedicationAdministration setDevice(List<ResourceReferenceDt> theValue) {
        this.myDevice = theValue;
        return this;
    }

    public ResourceReferenceDt addDevice() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getDevice().add(newType);
        return newType;
    }

    public List<Dosage> getDosage() {
        if (this.myDosage == null) {
            this.myDosage = new ArrayList<Dosage>();
        }
        return this.myDosage;
    }

    public List<Dosage> getDosageElement() {
        if (this.myDosage == null) {
            this.myDosage = new ArrayList<Dosage>();
        }
        return this.myDosage;
    }

    public MedicationAdministration setDosage(List<Dosage> theValue) {
        this.myDosage = theValue;
        return this;
    }

    public Dosage addDosage() {
        Dosage newType = new Dosage();
        this.getDosage().add(newType);
        return newType;
    }

    public Dosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            return this.addDosage();
        }
        return this.getDosage().get(0);
    }

    public String getResourceName() {
        return "MedicationAdministration";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Dosage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="timing", order=0, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class})
        @Description(shortDefinition="When dose(s) were given", formalDefinition="The timing schedule for giving the medication to the patient.  This may be a single time point (using dateTime) or it may be a start and end dateTime (Period)")
        private IDatatype myTiming;
        @Child(name="asNeeded", order=1, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="Take \"as needed\" f(or x)", formalDefinition="If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication")
        private IDatatype myAsNeeded;
        @Child(name="site", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Body site administered to", formalDefinition="A coded specification of the anatomic site where the medication first entered the body.  E.g. \"left arm\"")
        private CodeableConceptDt mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Path of substance into body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.   E.g. topical, intravenous, etc.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="How drug was administered", formalDefinition="A coded value indicating the method by which the medication was introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.Terminologies used often pre-coordinate this term with the route and or form of administration.")
        private CodeableConceptDt myMethod;
        @Child(name="quantity", type={QuantityDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount administered in one dose", formalDefinition="The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.")
        private QuantityDt myQuantity;
        @Child(name="rate", type={RatioDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Dose quantity per unit of time", formalDefinition="Identifies the speed with which the medication was introduced into the patient. Typically the rate for an infusion e.g. 200ml in 2 hours.  May also expressed as a rate per unit of time such as 100ml per hour - the duration is then not specified, or is specified in the quantity.")
        private RatioDt myRate;
        @Child(name="maxDosePerPeriod", type={RatioDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Total dose that was consumed per unit of time", formalDefinition="The maximum total quantity of a therapeutic substance that was administered to the patient over the specified period of time. E.g. 1000mg in 24 hours.")
        private RatioDt myMaxDosePerPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public IDatatype getTiming() {
            return this.myTiming;
        }

        public IDatatype getTimingElement() {
            return this.myTiming;
        }

        public Dosage setTiming(IDatatype theValue) {
            this.myTiming = theValue;
            return this;
        }

        public IDatatype getAsNeeded() {
            return this.myAsNeeded;
        }

        public IDatatype getAsNeededElement() {
            return this.myAsNeeded;
        }

        public Dosage setAsNeeded(IDatatype theValue) {
            this.myAsNeeded = theValue;
            return this;
        }

        public CodeableConceptDt getSite() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public CodeableConceptDt getSiteElement() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public Dosage setSite(CodeableConceptDt theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public CodeableConceptDt getRouteElement() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public Dosage setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public CodeableConceptDt getMethodElement() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public Dosage setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public Dosage setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dosage setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dosage setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public RatioDt getRate() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public RatioDt getRateElement() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public Dosage setRate(RatioDt theValue) {
            this.myRate = theValue;
            return this;
        }

        public RatioDt getMaxDosePerPeriod() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public RatioDt getMaxDosePerPeriodElement() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public Dosage setMaxDosePerPeriod(RatioDt theValue) {
            this.myMaxDosePerPeriod = theValue;
            return this;
        }
    }
}

