/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RatioDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Substance;
import ca.uhn.fhir.model.dstu.valueset.MedicationKindEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Medication", profile="http://hl7.org/fhir/profiles/Medication", id="medication")
public class Medication
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="Medication.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="name", path="Medication.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="manufacturer", path="Medication.manufacturer", description="", type="reference")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Medication.manufacturer");
    @SearchParamDefinition(name="form", path="Medication.product.form", description="", type="token")
    public static final String SP_FORM = "form";
    public static final TokenClientParam FORM = new TokenClientParam("form");
    @SearchParamDefinition(name="ingredient", path="Medication.product.ingredient.item", description="", type="reference")
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_PRODUCT_INGREDIENT_ITEM = new Include("Medication.product.ingredient.item");
    @SearchParamDefinition(name="container", path="Medication.package.container", description="", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="content", path="Medication.package.content.item", description="", type="reference")
    public static final String SP_CONTENT = "content";
    public static final ReferenceClientParam CONTENT = new ReferenceClientParam("content");
    public static final Include INCLUDE_PACKAGE_CONTENT_ITEM = new Include("Medication.package.content.item");
    @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Common / Commercial name", formalDefinition="The common/commercial name of the medication absent information such as strength, form, etc.  E.g. Acetaminophen, Tylenol 3, etc.  The fully coordinated name is communicated as the display of Medication.code")
    private StringDt myName;
    @Child(name="code", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Codes that identify this medication", formalDefinition="A code (or set of codes) that identify this medication.   Usage note: This could be a standard drug code such as a drug regulator code, RxNorm code, SNOMED CT code, etc. It could also be a local formulary code, optionally with translations to the standard drug codes")
    private CodeableConceptDt myCode;
    @Child(name="isBrand", type={BooleanDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="True if a brand", formalDefinition="Set to true if the item is attributable to a specific manufacturer (even if we don't know who that is)")
    private BooleanDt myIsBrand;
    @Child(name="manufacturer", order=3, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="Manufacturer of the item", formalDefinition="Describes the details of the manufacturer")
    private ResourceReferenceDt myManufacturer;
    @Child(name="kind", type={CodeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="product | package", formalDefinition="Medications are either a single administrable product or a package that contains one or more products.")
    private BoundCodeDt<MedicationKindEnum> myKind;
    @Child(name="product", order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Administrable medication details", formalDefinition="Information that only applies to products (not packages)")
    private Product myProduct;
    @Child(name="package", order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products)")
    private Package myPackage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myCode, this.myIsBrand, this.myManufacturer, this.myKind, this.myProduct, this.myPackage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myCode, this.myIsBrand, this.myManufacturer, this.myKind, this.myProduct, this.myPackage});
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public Medication setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Medication setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public CodeableConceptDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Medication setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public BooleanDt getIsBrand() {
        if (this.myIsBrand == null) {
            this.myIsBrand = new BooleanDt();
        }
        return this.myIsBrand;
    }

    public BooleanDt getIsBrandElement() {
        if (this.myIsBrand == null) {
            this.myIsBrand = new BooleanDt();
        }
        return this.myIsBrand;
    }

    public Medication setIsBrand(BooleanDt theValue) {
        this.myIsBrand = theValue;
        return this;
    }

    public Medication setIsBrand(boolean theBoolean) {
        this.myIsBrand = new BooleanDt(theBoolean);
        return this;
    }

    public ResourceReferenceDt getManufacturer() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new ResourceReferenceDt();
        }
        return this.myManufacturer;
    }

    public ResourceReferenceDt getManufacturerElement() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new ResourceReferenceDt();
        }
        return this.myManufacturer;
    }

    public Medication setManufacturer(ResourceReferenceDt theValue) {
        this.myManufacturer = theValue;
        return this;
    }

    public BoundCodeDt<MedicationKindEnum> getKind() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeDt(MedicationKindEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public BoundCodeDt<MedicationKindEnum> getKindElement() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeDt(MedicationKindEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public Medication setKind(BoundCodeDt<MedicationKindEnum> theValue) {
        this.myKind = theValue;
        return this;
    }

    public Medication setKind(MedicationKindEnum theValue) {
        this.getKind().setValueAsEnum((Enum)theValue);
        return this;
    }

    public Product getProduct() {
        if (this.myProduct == null) {
            this.myProduct = new Product();
        }
        return this.myProduct;
    }

    public Product getProductElement() {
        if (this.myProduct == null) {
            this.myProduct = new Product();
        }
        return this.myProduct;
    }

    public Medication setProduct(Product theValue) {
        this.myProduct = theValue;
        return this;
    }

    public Package getPackage() {
        if (this.myPackage == null) {
            this.myPackage = new Package();
        }
        return this.myPackage;
    }

    public Package getPackageElement() {
        if (this.myPackage == null) {
            this.myPackage = new Package();
        }
        return this.myPackage;
    }

    public Medication setPackage(Package theValue) {
        this.myPackage = theValue;
        return this;
    }

    public String getResourceName() {
        return "Medication";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class PackageContent
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="item", order=0, min=1, max=1, summary=false, modifier=false, type={Medication.class})
        @Description(shortDefinition="A product in the package", formalDefinition="Identifies one of the items in the package")
        private ResourceReferenceDt myItem;
        @Child(name="amount", type={QuantityDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="How many are in the package?", formalDefinition="The amount of the product that is in the package")
        private QuantityDt myAmount;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myItem, this.myAmount});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myItem, this.myAmount});
        }

        public ResourceReferenceDt getItem() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public ResourceReferenceDt getItemElement() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public PackageContent setItem(ResourceReferenceDt theValue) {
            this.myItem = theValue;
            return this;
        }

        public QuantityDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new QuantityDt();
            }
            return this.myAmount;
        }

        public QuantityDt getAmountElement() {
            if (this.myAmount == null) {
                this.myAmount = new QuantityDt();
            }
            return this.myAmount;
        }

        public PackageContent setAmount(QuantityDt theValue) {
            this.myAmount = theValue;
            return this;
        }

        public PackageContent setAmount(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myAmount = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public PackageContent setAmount(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myAmount = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public PackageContent setAmount(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myAmount = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public PackageContent setAmount(double theValue) {
            this.myAmount = new QuantityDt(theValue);
            return this;
        }

        public PackageContent setAmount(long theValue) {
            this.myAmount = new QuantityDt(theValue);
            return this;
        }

        public PackageContent setAmount(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myAmount = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }
    }

    @Block
    public static class Package
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="container", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="E.g. box, vial, blister-pack", formalDefinition="The kind of container that this package comes as")
        private CodeableConceptDt myContainer;
        @Child(name="content", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="What is  in the package?", formalDefinition="A set of components that go to make up the described item.")
        private List<PackageContent> myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myContainer, this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContainer, this.myContent});
        }

        public CodeableConceptDt getContainer() {
            if (this.myContainer == null) {
                this.myContainer = new CodeableConceptDt();
            }
            return this.myContainer;
        }

        public CodeableConceptDt getContainerElement() {
            if (this.myContainer == null) {
                this.myContainer = new CodeableConceptDt();
            }
            return this.myContainer;
        }

        public Package setContainer(CodeableConceptDt theValue) {
            this.myContainer = theValue;
            return this;
        }

        public List<PackageContent> getContent() {
            if (this.myContent == null) {
                this.myContent = new ArrayList<PackageContent>();
            }
            return this.myContent;
        }

        public List<PackageContent> getContentElement() {
            if (this.myContent == null) {
                this.myContent = new ArrayList<PackageContent>();
            }
            return this.myContent;
        }

        public Package setContent(List<PackageContent> theValue) {
            this.myContent = theValue;
            return this;
        }

        public PackageContent addContent() {
            PackageContent newType = new PackageContent();
            this.getContent().add(newType);
            return newType;
        }

        public PackageContent getContentFirstRep() {
            if (this.getContent().isEmpty()) {
                return this.addContent();
            }
            return this.getContent().get(0);
        }
    }

    @Block
    public static class ProductIngredient
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="item", order=0, min=1, max=1, summary=false, modifier=false, type={Substance.class, Medication.class})
        @Description(shortDefinition="The product contained", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication")
        private ResourceReferenceDt myItem;
        @Child(name="amount", type={RatioDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="How much ingredient in product", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  E.g. 250 mg per tablet")
        private RatioDt myAmount;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myItem, this.myAmount});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myItem, this.myAmount});
        }

        public ResourceReferenceDt getItem() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public ResourceReferenceDt getItemElement() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public ProductIngredient setItem(ResourceReferenceDt theValue) {
            this.myItem = theValue;
            return this;
        }

        public RatioDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new RatioDt();
            }
            return this.myAmount;
        }

        public RatioDt getAmountElement() {
            if (this.myAmount == null) {
                this.myAmount = new RatioDt();
            }
            return this.myAmount;
        }

        public ProductIngredient setAmount(RatioDt theValue) {
            this.myAmount = theValue;
            return this;
        }
    }

    @Block
    public static class Product
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="form", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="powder | tablets | carton +", formalDefinition="Describes the form of the item.  Powder; tables; carton")
        private CodeableConceptDt myForm;
        @Child(name="ingredient", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product")
        private List<ProductIngredient> myIngredient;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myForm, this.myIngredient});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myForm, this.myIngredient});
        }

        public CodeableConceptDt getForm() {
            if (this.myForm == null) {
                this.myForm = new CodeableConceptDt();
            }
            return this.myForm;
        }

        public CodeableConceptDt getFormElement() {
            if (this.myForm == null) {
                this.myForm = new CodeableConceptDt();
            }
            return this.myForm;
        }

        public Product setForm(CodeableConceptDt theValue) {
            this.myForm = theValue;
            return this;
        }

        public List<ProductIngredient> getIngredient() {
            if (this.myIngredient == null) {
                this.myIngredient = new ArrayList<ProductIngredient>();
            }
            return this.myIngredient;
        }

        public List<ProductIngredient> getIngredientElement() {
            if (this.myIngredient == null) {
                this.myIngredient = new ArrayList<ProductIngredient>();
            }
            return this.myIngredient;
        }

        public Product setIngredient(List<ProductIngredient> theValue) {
            this.myIngredient = theValue;
            return this;
        }

        public ProductIngredient addIngredient() {
            ProductIngredient newType = new ProductIngredient();
            this.getIngredient().add(newType);
            return newType;
        }

        public ProductIngredient getIngredientFirstRep() {
            if (this.getIngredient().isEmpty()) {
                return this.addIngredient();
            }
            return this.getIngredient().get(0);
        }
    }
}

