/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AddressDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.LocationModeEnum;
import ca.uhn.fhir.model.dstu.valueset.LocationStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.LocationTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Location", profile="http://hl7.org/fhir/profiles/Location", id="location")
public class Location
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Location.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Location.name", description="A (portion of the) name of the location", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="type", path="Location.type", description="A code for the type of location", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="address", path="Location.address", description="A (part of the) address of the location", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="status", path="Location.status", description="Searches for locations with a specific kind of status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="partof", path="Location.partOf", description="The location of which this location is a part", type="reference")
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("Location.partOf");
    @SearchParamDefinition(name="near", path="", description="The coordinates expressed as [lat],[long] (using KML, see notes) to find locations near to (servers may search using a square rather than a circle for efficiency)", type="token")
    public static final String SP_NEAR = "near";
    public static final TokenClientParam NEAR = new TokenClientParam("near");
    @SearchParamDefinition(name="near-distance", path="", description="A distance quantity to limit the near search to locations within a specific distance", type="token")
    public static final String SP_NEAR_DISTANCE = "near-distance";
    public static final TokenClientParam NEAR_DISTANCE = new TokenClientParam("near-distance");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Unique code or number identifying the location to its users", formalDefinition="Unique code or number identifying the location to its users")
    private IdentifierDt myIdentifier;
    @Child(name="name", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Name of the location as used by humans", formalDefinition="Name of the location as used by humans. Does not need to be unique.")
    private StringDt myName;
    @Child(name="description", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Description of the Location, which helps in finding or referencing the place", formalDefinition="Description of the Location, which helps in finding or referencing the place")
    private StringDt myDescription;
    @Child(name="type", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Indicates the type of function performed at the location", formalDefinition="Indicates the type of function performed at the location")
    private BoundCodeableConceptDt<LocationTypeEnum> myType;
    @Child(name="telecom", type={ContactDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Contact details of the location", formalDefinition="The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites")
    private List<ContactDt> myTelecom;
    @Child(name="address", type={AddressDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Physical location", formalDefinition="")
    private AddressDt myAddress;
    @Child(name="physicalType", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Physical form of the location", formalDefinition="Physical form of the location, e.g. building, room, vehicle, road")
    private CodeableConceptDt myPhysicalType;
    @Child(name="position", order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The absolute geographic location", formalDefinition="The absolute geographic location of the Location, expressed in a KML compatible manner (see notes below for KML)")
    private Position myPosition;
    @Child(name="managingOrganization", order=8, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="The organization that is responsible for the provisioning and upkeep of the location", formalDefinition="")
    private ResourceReferenceDt myManagingOrganization;
    @Child(name="status", type={CodeDt.class}, order=9, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="active | suspended | inactive", formalDefinition="")
    private BoundCodeDt<LocationStatusEnum> myStatus;
    @Child(name="partOf", order=10, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="Another Location which this Location is physically part of", formalDefinition="")
    private ResourceReferenceDt myPartOf;
    @Child(name="mode", type={CodeDt.class}, order=11, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="instance | kind", formalDefinition="Indicates whether a resource instance represents a specific location or a class of locations")
    private BoundCodeDt<LocationModeEnum> myMode;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myName, this.myDescription, this.myType, this.myTelecom, this.myAddress, this.myPhysicalType, this.myPosition, this.myManagingOrganization, this.myStatus, this.myPartOf, this.myMode});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myName, this.myDescription, this.myType, this.myTelecom, this.myAddress, this.myPhysicalType, this.myPosition, this.myManagingOrganization, this.myStatus, this.myPartOf, this.myMode});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Location setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Location setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Location setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public Location setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Location setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public Location setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Location setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public BoundCodeableConceptDt<LocationTypeEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeableConceptDt<LocationTypeEnum>(LocationTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public BoundCodeableConceptDt<LocationTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeableConceptDt<LocationTypeEnum>(LocationTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public Location setType(BoundCodeableConceptDt<LocationTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Location setType(LocationTypeEnum theValue) {
        this.getType().setValueAsEnum(theValue);
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public Location setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Location addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public Location addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public AddressDt getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new AddressDt();
        }
        return this.myAddress;
    }

    public AddressDt getAddressElement() {
        if (this.myAddress == null) {
            this.myAddress = new AddressDt();
        }
        return this.myAddress;
    }

    public Location setAddress(AddressDt theValue) {
        this.myAddress = theValue;
        return this;
    }

    public CodeableConceptDt getPhysicalType() {
        if (this.myPhysicalType == null) {
            this.myPhysicalType = new CodeableConceptDt();
        }
        return this.myPhysicalType;
    }

    public CodeableConceptDt getPhysicalTypeElement() {
        if (this.myPhysicalType == null) {
            this.myPhysicalType = new CodeableConceptDt();
        }
        return this.myPhysicalType;
    }

    public Location setPhysicalType(CodeableConceptDt theValue) {
        this.myPhysicalType = theValue;
        return this;
    }

    public Position getPosition() {
        if (this.myPosition == null) {
            this.myPosition = new Position();
        }
        return this.myPosition;
    }

    public Position getPositionElement() {
        if (this.myPosition == null) {
            this.myPosition = new Position();
        }
        return this.myPosition;
    }

    public Location setPosition(Position theValue) {
        this.myPosition = theValue;
        return this;
    }

    public ResourceReferenceDt getManagingOrganization() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public ResourceReferenceDt getManagingOrganizationElement() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public Location setManagingOrganization(ResourceReferenceDt theValue) {
        this.myManagingOrganization = theValue;
        return this;
    }

    public BoundCodeDt<LocationStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(LocationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<LocationStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(LocationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Location setStatus(BoundCodeDt<LocationStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Location setStatus(LocationStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getPartOf() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public ResourceReferenceDt getPartOfElement() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public Location setPartOf(ResourceReferenceDt theValue) {
        this.myPartOf = theValue;
        return this;
    }

    public BoundCodeDt<LocationModeEnum> getMode() {
        if (this.myMode == null) {
            this.myMode = new BoundCodeDt(LocationModeEnum.VALUESET_BINDER);
        }
        return this.myMode;
    }

    public BoundCodeDt<LocationModeEnum> getModeElement() {
        if (this.myMode == null) {
            this.myMode = new BoundCodeDt(LocationModeEnum.VALUESET_BINDER);
        }
        return this.myMode;
    }

    public Location setMode(BoundCodeDt<LocationModeEnum> theValue) {
        this.myMode = theValue;
        return this;
    }

    public Location setMode(LocationModeEnum theValue) {
        this.getMode().setValueAsEnum((Enum)theValue);
        return this;
    }

    public String getResourceName() {
        return "Location";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Position
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="longitude", type={DecimalDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Longitude as expressed in KML", formalDefinition="Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below)")
        private DecimalDt myLongitude;
        @Child(name="latitude", type={DecimalDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Latitude as expressed in KML", formalDefinition="Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below)")
        private DecimalDt myLatitude;
        @Child(name="altitude", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Altitude as expressed in KML", formalDefinition="Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below)")
        private DecimalDt myAltitude;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLongitude, this.myLatitude, this.myAltitude});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLongitude, this.myLatitude, this.myAltitude});
        }

        public DecimalDt getLongitude() {
            if (this.myLongitude == null) {
                this.myLongitude = new DecimalDt();
            }
            return this.myLongitude;
        }

        public DecimalDt getLongitudeElement() {
            if (this.myLongitude == null) {
                this.myLongitude = new DecimalDt();
            }
            return this.myLongitude;
        }

        public Position setLongitude(DecimalDt theValue) {
            this.myLongitude = theValue;
            return this;
        }

        public Position setLongitude(long theValue) {
            this.myLongitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLongitude(double theValue) {
            this.myLongitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLongitude(BigDecimal theValue) {
            this.myLongitude = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getLatitude() {
            if (this.myLatitude == null) {
                this.myLatitude = new DecimalDt();
            }
            return this.myLatitude;
        }

        public DecimalDt getLatitudeElement() {
            if (this.myLatitude == null) {
                this.myLatitude = new DecimalDt();
            }
            return this.myLatitude;
        }

        public Position setLatitude(DecimalDt theValue) {
            this.myLatitude = theValue;
            return this;
        }

        public Position setLatitude(long theValue) {
            this.myLatitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLatitude(double theValue) {
            this.myLatitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLatitude(BigDecimal theValue) {
            this.myLatitude = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getAltitude() {
            if (this.myAltitude == null) {
                this.myAltitude = new DecimalDt();
            }
            return this.myAltitude;
        }

        public DecimalDt getAltitudeElement() {
            if (this.myAltitude == null) {
                this.myAltitude = new DecimalDt();
            }
            return this.myAltitude;
        }

        public Position setAltitude(DecimalDt theValue) {
            this.myAltitude = theValue;
            return this;
        }

        public Position setAltitude(long theValue) {
            this.myAltitude = new DecimalDt(theValue);
            return this;
        }

        public Position setAltitude(double theValue) {
            this.myAltitude = new DecimalDt(theValue);
            return this;
        }

        public Position setAltitude(BigDecimal theValue) {
            this.myAltitude = new DecimalDt(theValue);
            return this;
        }
    }
}

