/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ImagingModalityEnum;
import ca.uhn.fhir.model.dstu.valueset.InstanceAvailabilityEnum;
import ca.uhn.fhir.model.dstu.valueset.ModalityEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.OidDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ImagingStudy", profile="http://hl7.org/fhir/profiles/ImagingStudy", id="imagingstudy")
public class ImagingStudy
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="ImagingStudy.subject", description="Who the study is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ImagingStudy.subject");
    @SearchParamDefinition(name="date", path="ImagingStudy.dateTime", description="The date the study was done was taken", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="accession", path="ImagingStudy.accessionNo", description="The accession id for the image", type="token")
    public static final String SP_ACCESSION = "accession";
    public static final TokenClientParam ACCESSION = new TokenClientParam("accession");
    @SearchParamDefinition(name="study", path="ImagingStudy.uid", description="The study id for the image", type="token")
    public static final String SP_STUDY = "study";
    public static final TokenClientParam STUDY = new TokenClientParam("study");
    @SearchParamDefinition(name="series", path="ImagingStudy.series.uid", description="The series id for the image", type="token")
    public static final String SP_SERIES = "series";
    public static final TokenClientParam SERIES = new TokenClientParam("series");
    @SearchParamDefinition(name="modality", path="ImagingStudy.series.modality", description="The modality of the image", type="token")
    public static final String SP_MODALITY = "modality";
    public static final TokenClientParam MODALITY = new TokenClientParam("modality");
    @SearchParamDefinition(name="size", path="", description="The size of the image in MB - may include > or < in the value", type="number")
    public static final String SP_SIZE = "size";
    public static final NumberClientParam SIZE = new NumberClientParam("size");
    @SearchParamDefinition(name="bodysite", path="ImagingStudy.series.bodySite", description="", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="uid", path="ImagingStudy.series.instance.uid", description="", type="token")
    public static final String SP_UID = "uid";
    public static final TokenClientParam UID = new TokenClientParam("uid");
    @SearchParamDefinition(name="dicom-class", path="ImagingStudy.series.instance.sopclass", description="", type="token")
    public static final String SP_DICOM_CLASS = "dicom-class";
    public static final TokenClientParam DICOM_CLASS = new TokenClientParam("dicom-class");
    @Child(name="dateTime", type={DateTimeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When the study was performed", formalDefinition="Date and Time the study took place")
    private DateTimeDt myDateTime;
    @Child(name="subject", order=1, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Who the images are of", formalDefinition="Who the images are of")
    private ResourceReferenceDt mySubject;
    @Child(name="uid", type={OidDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Formal identifier for the study (0020,000D)", formalDefinition="Formal identifier for the study")
    private OidDt myUid;
    @Child(name="accessionNo", type={IdentifierDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Accession Number (0008,0050)", formalDefinition="Accession Number")
    private IdentifierDt myAccessionNo;
    @Child(name="identifier", type={IdentifierDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Other identifiers for the study (0020,0010)", formalDefinition="Other identifiers for the study")
    private List<IdentifierDt> myIdentifier;
    @Child(name="order", order=5, min=0, max=-1, summary=false, modifier=false, type={DiagnosticOrder.class})
    @Description(shortDefinition="Order(s) that caused this study to be performed", formalDefinition="A list of the diagnostic orders that resulted in this imaging study being performed")
    private List<ResourceReferenceDt> myOrder;
    @Child(name="modality", type={CodeDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="All series.modality if actual acquisition modalities", formalDefinition="A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19)")
    private List<BoundCodeDt<ImagingModalityEnum>> myModality;
    @Child(name="referrer", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Referring physician (0008,0090)", formalDefinition="The requesting/referring physician")
    private ResourceReferenceDt myReferrer;
    @Child(name="availability", type={CodeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="ONLINE | OFFLINE | NEARLINE | UNAVAILABLE (0008,0056)", formalDefinition="Availability of study (online, offline or nearline)")
    private BoundCodeDt<InstanceAvailabilityEnum> myAvailability;
    @Child(name="url", type={UriDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Retrieve URI (0008,1190)", formalDefinition="WADO-RS URI where Study is available")
    private UriDt myUrl;
    @Child(name="numberOfSeries", type={IntegerDt.class}, order=10, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Number of Study Related Series (0020,1206)", formalDefinition="Number of Series in Study")
    private IntegerDt myNumberOfSeries;
    @Child(name="numberOfInstances", type={IntegerDt.class}, order=11, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Number of Study Related Instances (0020,1208)", formalDefinition="Number of SOP Instances in Study")
    private IntegerDt myNumberOfInstances;
    @Child(name="clinicalInformation", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Diagnoses etc with request (0040,1002)", formalDefinition="Diagnoses etc provided with request")
    private StringDt myClinicalInformation;
    @Child(name="procedure", type={CodingDt.class}, order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Type of procedure performed (0008,1032)", formalDefinition="Type of procedure performed")
    private List<CodingDt> myProcedure;
    @Child(name="interpreter", order=14, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Who interpreted images (0008,1060)", formalDefinition="Who read study and interpreted the images")
    private ResourceReferenceDt myInterpreter;
    @Child(name="description", type={StringDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Institution-generated description (0008,1030)", formalDefinition="Institution-generated description or classification of the Study (component) performed")
    private StringDt myDescription;
    @Child(name="series", order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Each study has one or more series of instances", formalDefinition="Each study has one or more series of image instances")
    private List<Series> mySeries;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDateTime, this.mySubject, this.myUid, this.myAccessionNo, this.myIdentifier, this.myOrder, this.myModality, this.myReferrer, this.myAvailability, this.myUrl, this.myNumberOfSeries, this.myNumberOfInstances, this.myClinicalInformation, this.myProcedure, this.myInterpreter, this.myDescription, this.mySeries});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDateTime, this.mySubject, this.myUid, this.myAccessionNo, this.myIdentifier, this.myOrder, this.myModality, this.myReferrer, this.myAvailability, this.myUrl, this.myNumberOfSeries, this.myNumberOfInstances, this.myClinicalInformation, this.myProcedure, this.myInterpreter, this.myDescription, this.mySeries});
    }

    public DateTimeDt getDateTime() {
        if (this.myDateTime == null) {
            this.myDateTime = new DateTimeDt();
        }
        return this.myDateTime;
    }

    public DateTimeDt getDateTimeElement() {
        if (this.myDateTime == null) {
            this.myDateTime = new DateTimeDt();
        }
        return this.myDateTime;
    }

    public ImagingStudy setDateTime(DateTimeDt theValue) {
        this.myDateTime = theValue;
        return this;
    }

    public ImagingStudy setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ImagingStudy setDateTimeWithSecondsPrecision(Date theDate) {
        this.myDateTime = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ImagingStudy setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public OidDt getUid() {
        if (this.myUid == null) {
            this.myUid = new OidDt();
        }
        return this.myUid;
    }

    public OidDt getUidElement() {
        if (this.myUid == null) {
            this.myUid = new OidDt();
        }
        return this.myUid;
    }

    public ImagingStudy setUid(OidDt theValue) {
        this.myUid = theValue;
        return this;
    }

    public IdentifierDt getAccessionNo() {
        if (this.myAccessionNo == null) {
            this.myAccessionNo = new IdentifierDt();
        }
        return this.myAccessionNo;
    }

    public IdentifierDt getAccessionNoElement() {
        if (this.myAccessionNo == null) {
            this.myAccessionNo = new IdentifierDt();
        }
        return this.myAccessionNo;
    }

    public ImagingStudy setAccessionNo(IdentifierDt theValue) {
        this.myAccessionNo = theValue;
        return this;
    }

    public ImagingStudy setAccessionNo(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myAccessionNo = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public ImagingStudy setAccessionNo(String theSystem, String theValue) {
        this.myAccessionNo = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ImagingStudy setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ImagingStudy addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public ImagingStudy addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public List<ResourceReferenceDt> getOrder() {
        if (this.myOrder == null) {
            this.myOrder = new ArrayList<ResourceReferenceDt>();
        }
        return this.myOrder;
    }

    public List<ResourceReferenceDt> getOrderElement() {
        if (this.myOrder == null) {
            this.myOrder = new ArrayList<ResourceReferenceDt>();
        }
        return this.myOrder;
    }

    public ImagingStudy setOrder(List<ResourceReferenceDt> theValue) {
        this.myOrder = theValue;
        return this;
    }

    public ResourceReferenceDt addOrder() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getOrder().add(newType);
        return newType;
    }

    public List<BoundCodeDt<ImagingModalityEnum>> getModality() {
        if (this.myModality == null) {
            this.myModality = new ArrayList<BoundCodeDt<ImagingModalityEnum>>();
        }
        return this.myModality;
    }

    public List<BoundCodeDt<ImagingModalityEnum>> getModalityElement() {
        if (this.myModality == null) {
            this.myModality = new ArrayList<BoundCodeDt<ImagingModalityEnum>>();
        }
        return this.myModality;
    }

    public ImagingStudy setModality(List<BoundCodeDt<ImagingModalityEnum>> theValue) {
        this.myModality = theValue;
        return this;
    }

    public BoundCodeDt<ImagingModalityEnum> addModality(ImagingModalityEnum theValue) {
        BoundCodeDt retVal = new BoundCodeDt(ImagingModalityEnum.VALUESET_BINDER, (Enum)theValue);
        this.getModality().add((BoundCodeDt<ImagingModalityEnum>)retVal);
        return retVal;
    }

    public BoundCodeDt<ImagingModalityEnum> getModalityFirstRep() {
        if (this.getModality().size() == 0) {
            this.addModality();
        }
        return this.getModality().get(0);
    }

    public BoundCodeDt<ImagingModalityEnum> addModality() {
        BoundCodeDt retVal = new BoundCodeDt(ImagingModalityEnum.VALUESET_BINDER);
        this.getModality().add((BoundCodeDt<ImagingModalityEnum>)retVal);
        return retVal;
    }

    public ImagingStudy setModality(ImagingModalityEnum theValue) {
        this.getModality().clear();
        this.addModality(theValue);
        return this;
    }

    public ResourceReferenceDt getReferrer() {
        if (this.myReferrer == null) {
            this.myReferrer = new ResourceReferenceDt();
        }
        return this.myReferrer;
    }

    public ResourceReferenceDt getReferrerElement() {
        if (this.myReferrer == null) {
            this.myReferrer = new ResourceReferenceDt();
        }
        return this.myReferrer;
    }

    public ImagingStudy setReferrer(ResourceReferenceDt theValue) {
        this.myReferrer = theValue;
        return this;
    }

    public BoundCodeDt<InstanceAvailabilityEnum> getAvailability() {
        if (this.myAvailability == null) {
            this.myAvailability = new BoundCodeDt(InstanceAvailabilityEnum.VALUESET_BINDER);
        }
        return this.myAvailability;
    }

    public BoundCodeDt<InstanceAvailabilityEnum> getAvailabilityElement() {
        if (this.myAvailability == null) {
            this.myAvailability = new BoundCodeDt(InstanceAvailabilityEnum.VALUESET_BINDER);
        }
        return this.myAvailability;
    }

    public ImagingStudy setAvailability(BoundCodeDt<InstanceAvailabilityEnum> theValue) {
        this.myAvailability = theValue;
        return this;
    }

    public ImagingStudy setAvailability(InstanceAvailabilityEnum theValue) {
        this.getAvailability().setValueAsEnum((Enum)theValue);
        return this;
    }

    public UriDt getUrl() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public ImagingStudy setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public ImagingStudy setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public IntegerDt getNumberOfSeries() {
        if (this.myNumberOfSeries == null) {
            this.myNumberOfSeries = new IntegerDt();
        }
        return this.myNumberOfSeries;
    }

    public IntegerDt getNumberOfSeriesElement() {
        if (this.myNumberOfSeries == null) {
            this.myNumberOfSeries = new IntegerDt();
        }
        return this.myNumberOfSeries;
    }

    public ImagingStudy setNumberOfSeries(IntegerDt theValue) {
        this.myNumberOfSeries = theValue;
        return this;
    }

    public ImagingStudy setNumberOfSeries(int theInteger) {
        this.myNumberOfSeries = new IntegerDt(theInteger);
        return this;
    }

    public IntegerDt getNumberOfInstances() {
        if (this.myNumberOfInstances == null) {
            this.myNumberOfInstances = new IntegerDt();
        }
        return this.myNumberOfInstances;
    }

    public IntegerDt getNumberOfInstancesElement() {
        if (this.myNumberOfInstances == null) {
            this.myNumberOfInstances = new IntegerDt();
        }
        return this.myNumberOfInstances;
    }

    public ImagingStudy setNumberOfInstances(IntegerDt theValue) {
        this.myNumberOfInstances = theValue;
        return this;
    }

    public ImagingStudy setNumberOfInstances(int theInteger) {
        this.myNumberOfInstances = new IntegerDt(theInteger);
        return this;
    }

    public StringDt getClinicalInformation() {
        if (this.myClinicalInformation == null) {
            this.myClinicalInformation = new StringDt();
        }
        return this.myClinicalInformation;
    }

    public StringDt getClinicalInformationElement() {
        if (this.myClinicalInformation == null) {
            this.myClinicalInformation = new StringDt();
        }
        return this.myClinicalInformation;
    }

    public ImagingStudy setClinicalInformation(StringDt theValue) {
        this.myClinicalInformation = theValue;
        return this;
    }

    public ImagingStudy setClinicalInformation(String theString) {
        this.myClinicalInformation = new StringDt(theString);
        return this;
    }

    public List<CodingDt> getProcedure() {
        if (this.myProcedure == null) {
            this.myProcedure = new ArrayList<CodingDt>();
        }
        return this.myProcedure;
    }

    public List<CodingDt> getProcedureElement() {
        if (this.myProcedure == null) {
            this.myProcedure = new ArrayList<CodingDt>();
        }
        return this.myProcedure;
    }

    public ImagingStudy setProcedure(List<CodingDt> theValue) {
        this.myProcedure = theValue;
        return this;
    }

    public CodingDt addProcedure() {
        CodingDt newType = new CodingDt();
        this.getProcedure().add(newType);
        return newType;
    }

    public CodingDt getProcedureFirstRep() {
        if (this.getProcedure().isEmpty()) {
            return this.addProcedure();
        }
        return this.getProcedure().get(0);
    }

    public ResourceReferenceDt getInterpreter() {
        if (this.myInterpreter == null) {
            this.myInterpreter = new ResourceReferenceDt();
        }
        return this.myInterpreter;
    }

    public ResourceReferenceDt getInterpreterElement() {
        if (this.myInterpreter == null) {
            this.myInterpreter = new ResourceReferenceDt();
        }
        return this.myInterpreter;
    }

    public ImagingStudy setInterpreter(ResourceReferenceDt theValue) {
        this.myInterpreter = theValue;
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public ImagingStudy setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ImagingStudy setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<Series> getSeries() {
        if (this.mySeries == null) {
            this.mySeries = new ArrayList<Series>();
        }
        return this.mySeries;
    }

    public List<Series> getSeriesElement() {
        if (this.mySeries == null) {
            this.mySeries = new ArrayList<Series>();
        }
        return this.mySeries;
    }

    public ImagingStudy setSeries(List<Series> theValue) {
        this.mySeries = theValue;
        return this;
    }

    public Series addSeries() {
        Series newType = new Series();
        this.getSeries().add(newType);
        return newType;
    }

    public Series getSeriesFirstRep() {
        if (this.getSeries().isEmpty()) {
            return this.addSeries();
        }
        return this.getSeries().get(0);
    }

    public String getResourceName() {
        return "ImagingStudy";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class SeriesInstance
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="number", type={IntegerDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The number of this instance in the series (0020,0013)", formalDefinition="The number of this image in the series")
        private IntegerDt myNumber;
        @Child(name="uid", type={OidDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Formal identifier for this instance (0008,0018)", formalDefinition="Formal identifier for this image")
        private OidDt myUid;
        @Child(name="sopclass", type={OidDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="DICOM class type (0008,0016)", formalDefinition="DICOM Image type")
        private OidDt mySopclass;
        @Child(name="type", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of instance (image etc) (0004,1430)", formalDefinition="")
        private StringDt myType;
        @Child(name="title", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Description (0070,0080 | 0040,A043 > 0008,0104 | 0042,0010 | 0008,0008)", formalDefinition="")
        private StringDt myTitle;
        @Child(name="url", type={UriDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="WADO-RS service where instance is available  (0008,1199 > 0008,1190)", formalDefinition="WADO-RS url where image is available")
        private UriDt myUrl;
        @Child(name="attachment", order=6, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="A FHIR resource with content for this instance", formalDefinition="")
        private ResourceReferenceDt myAttachment;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myNumber, this.myUid, this.mySopclass, this.myType, this.myTitle, this.myUrl, this.myAttachment});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myNumber, this.myUid, this.mySopclass, this.myType, this.myTitle, this.myUrl, this.myAttachment});
        }

        public IntegerDt getNumber() {
            if (this.myNumber == null) {
                this.myNumber = new IntegerDt();
            }
            return this.myNumber;
        }

        public IntegerDt getNumberElement() {
            if (this.myNumber == null) {
                this.myNumber = new IntegerDt();
            }
            return this.myNumber;
        }

        public SeriesInstance setNumber(IntegerDt theValue) {
            this.myNumber = theValue;
            return this;
        }

        public SeriesInstance setNumber(int theInteger) {
            this.myNumber = new IntegerDt(theInteger);
            return this;
        }

        public OidDt getUid() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public OidDt getUidElement() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public SeriesInstance setUid(OidDt theValue) {
            this.myUid = theValue;
            return this;
        }

        public OidDt getSopclass() {
            if (this.mySopclass == null) {
                this.mySopclass = new OidDt();
            }
            return this.mySopclass;
        }

        public OidDt getSopclassElement() {
            if (this.mySopclass == null) {
                this.mySopclass = new OidDt();
            }
            return this.mySopclass;
        }

        public SeriesInstance setSopclass(OidDt theValue) {
            this.mySopclass = theValue;
            return this;
        }

        public StringDt getType() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public StringDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public SeriesInstance setType(StringDt theValue) {
            this.myType = theValue;
            return this;
        }

        public SeriesInstance setType(String theString) {
            this.myType = new StringDt(theString);
            return this;
        }

        public StringDt getTitle() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public StringDt getTitleElement() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public SeriesInstance setTitle(StringDt theValue) {
            this.myTitle = theValue;
            return this;
        }

        public SeriesInstance setTitle(String theString) {
            this.myTitle = new StringDt(theString);
            return this;
        }

        public UriDt getUrl() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public SeriesInstance setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public SeriesInstance setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public ResourceReferenceDt getAttachment() {
            if (this.myAttachment == null) {
                this.myAttachment = new ResourceReferenceDt();
            }
            return this.myAttachment;
        }

        public ResourceReferenceDt getAttachmentElement() {
            if (this.myAttachment == null) {
                this.myAttachment = new ResourceReferenceDt();
            }
            return this.myAttachment;
        }

        public SeriesInstance setAttachment(ResourceReferenceDt theValue) {
            this.myAttachment = theValue;
            return this;
        }
    }

    @Block
    public static class Series
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="number", type={IntegerDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Number of this series in overall sequence (0020,0011)", formalDefinition="The number of this series in the overall sequence")
        private IntegerDt myNumber;
        @Child(name="modality", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The modality of the instances in the series (0008,0060)", formalDefinition="The modality of this series sequence")
        private BoundCodeDt<ModalityEnum> myModality;
        @Child(name="uid", type={OidDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Formal identifier for this series (0020,000E)", formalDefinition="Formal identifier for this series")
        private OidDt myUid;
        @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="A description of the series (0008,103E)", formalDefinition="A description of the series")
        private StringDt myDescription;
        @Child(name="numberOfInstances", type={IntegerDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Number of Series Related Instances (0020,1209)", formalDefinition="Sequence that contains attributes from the")
        private IntegerDt myNumberOfInstances;
        @Child(name="availability", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="ONLINE | OFFLINE | NEARLINE | UNAVAILABLE (0008,0056)", formalDefinition="Availability of series (online, offline or nearline)")
        private BoundCodeDt<InstanceAvailabilityEnum> myAvailability;
        @Child(name="url", type={UriDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Retrieve URI (0008,1115 > 0008,1190)", formalDefinition="WADO-RS URI where Series is available")
        private UriDt myUrl;
        @Child(name="bodySite", type={CodingDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Body part examined (Map from 0018,0015)", formalDefinition="Body part examined. See  DICOM Part 16 Annex L for the mapping from DICOM to Snomed")
        private CodingDt myBodySite;
        @Child(name="dateTime", type={DateTimeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="When the series started", formalDefinition="")
        private DateTimeDt myDateTime;
        @Child(name="instance", order=9, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="A single instance taken from a patient (image or other)", formalDefinition="A single image taken from a patient")
        private List<SeriesInstance> myInstance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myNumber, this.myModality, this.myUid, this.myDescription, this.myNumberOfInstances, this.myAvailability, this.myUrl, this.myBodySite, this.myDateTime, this.myInstance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myNumber, this.myModality, this.myUid, this.myDescription, this.myNumberOfInstances, this.myAvailability, this.myUrl, this.myBodySite, this.myDateTime, this.myInstance});
        }

        public IntegerDt getNumber() {
            if (this.myNumber == null) {
                this.myNumber = new IntegerDt();
            }
            return this.myNumber;
        }

        public IntegerDt getNumberElement() {
            if (this.myNumber == null) {
                this.myNumber = new IntegerDt();
            }
            return this.myNumber;
        }

        public Series setNumber(IntegerDt theValue) {
            this.myNumber = theValue;
            return this;
        }

        public Series setNumber(int theInteger) {
            this.myNumber = new IntegerDt(theInteger);
            return this;
        }

        public BoundCodeDt<ModalityEnum> getModality() {
            if (this.myModality == null) {
                this.myModality = new BoundCodeDt(ModalityEnum.VALUESET_BINDER);
            }
            return this.myModality;
        }

        public BoundCodeDt<ModalityEnum> getModalityElement() {
            if (this.myModality == null) {
                this.myModality = new BoundCodeDt(ModalityEnum.VALUESET_BINDER);
            }
            return this.myModality;
        }

        public Series setModality(BoundCodeDt<ModalityEnum> theValue) {
            this.myModality = theValue;
            return this;
        }

        public Series setModality(ModalityEnum theValue) {
            this.getModality().setValueAsEnum((Enum)theValue);
            return this;
        }

        public OidDt getUid() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public OidDt getUidElement() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public Series setUid(OidDt theValue) {
            this.myUid = theValue;
            return this;
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public Series setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Series setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public IntegerDt getNumberOfInstances() {
            if (this.myNumberOfInstances == null) {
                this.myNumberOfInstances = new IntegerDt();
            }
            return this.myNumberOfInstances;
        }

        public IntegerDt getNumberOfInstancesElement() {
            if (this.myNumberOfInstances == null) {
                this.myNumberOfInstances = new IntegerDt();
            }
            return this.myNumberOfInstances;
        }

        public Series setNumberOfInstances(IntegerDt theValue) {
            this.myNumberOfInstances = theValue;
            return this;
        }

        public Series setNumberOfInstances(int theInteger) {
            this.myNumberOfInstances = new IntegerDt(theInteger);
            return this;
        }

        public BoundCodeDt<InstanceAvailabilityEnum> getAvailability() {
            if (this.myAvailability == null) {
                this.myAvailability = new BoundCodeDt(InstanceAvailabilityEnum.VALUESET_BINDER);
            }
            return this.myAvailability;
        }

        public BoundCodeDt<InstanceAvailabilityEnum> getAvailabilityElement() {
            if (this.myAvailability == null) {
                this.myAvailability = new BoundCodeDt(InstanceAvailabilityEnum.VALUESET_BINDER);
            }
            return this.myAvailability;
        }

        public Series setAvailability(BoundCodeDt<InstanceAvailabilityEnum> theValue) {
            this.myAvailability = theValue;
            return this;
        }

        public Series setAvailability(InstanceAvailabilityEnum theValue) {
            this.getAvailability().setValueAsEnum((Enum)theValue);
            return this;
        }

        public UriDt getUrl() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public Series setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public Series setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public CodingDt getBodySite() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodingDt();
            }
            return this.myBodySite;
        }

        public CodingDt getBodySiteElement() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodingDt();
            }
            return this.myBodySite;
        }

        public Series setBodySite(CodingDt theValue) {
            this.myBodySite = theValue;
            return this;
        }

        public DateTimeDt getDateTime() {
            if (this.myDateTime == null) {
                this.myDateTime = new DateTimeDt();
            }
            return this.myDateTime;
        }

        public DateTimeDt getDateTimeElement() {
            if (this.myDateTime == null) {
                this.myDateTime = new DateTimeDt();
            }
            return this.myDateTime;
        }

        public Series setDateTime(DateTimeDt theValue) {
            this.myDateTime = theValue;
            return this;
        }

        public Series setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDateTime = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Series setDateTimeWithSecondsPrecision(Date theDate) {
            this.myDateTime = new DateTimeDt(theDate);
            return this;
        }

        public List<SeriesInstance> getInstance() {
            if (this.myInstance == null) {
                this.myInstance = new ArrayList<SeriesInstance>();
            }
            return this.myInstance;
        }

        public List<SeriesInstance> getInstanceElement() {
            if (this.myInstance == null) {
                this.myInstance = new ArrayList<SeriesInstance>();
            }
            return this.myInstance;
        }

        public Series setInstance(List<SeriesInstance> theValue) {
            this.myInstance = theValue;
            return this;
        }

        public SeriesInstance addInstance() {
            SeriesInstance newType = new SeriesInstance();
            this.getInstance().add(newType);
            return newType;
        }

        public SeriesInstance getInstanceFirstRep() {
            if (this.getInstance().isEmpty()) {
                return this.addInstance();
            }
            return this.getInstance().get(0);
        }
    }
}

