/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="GeneticAnalysis", profile="http://hl7.org/fhir/profiles/GeneticAnalysis", id="geneticanalysis")
public class GeneticAnalysis
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="GeneticAnalysis.subject", description="Subject of the analysis", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("GeneticAnalysis.subject");
    @SearchParamDefinition(name="author", path="GeneticAnalysis.author", description="Author of the analysis", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("GeneticAnalysis.author");
    @SearchParamDefinition(name="date", path="GeneticAnalysis.date", description="Date when result of the analysis is uploaded", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @Child(name="subject", order=0, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Subject of the analysis", formalDefinition="Subject of the analysis")
    private ResourceReferenceDt mySubject;
    @Child(name="author", order=1, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Author of the analysis", formalDefinition="Author of the analysis")
    private ResourceReferenceDt myAuthor;
    @Child(name="date", type={DateDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date when result of the analysis is updated", formalDefinition="Date when result of the analysis is updated")
    private DateDt myDate;
    @Child(name="geneticAnalysisSummary", order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Summary of the analysis", formalDefinition="Summary of the analysis")
    private GeneticAnalysisSummary myGeneticAnalysisSummary;
    @Child(name="dnaRegionAnalysisTestCoverage", order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Coverage of the genetic test", formalDefinition="Coverage of the genetic test")
    private DnaRegionAnalysisTestCoverage myDnaRegionAnalysisTestCoverage;
    @Child(name="geneticAnalysisDiscreteResult", order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Genetic analysis discrete result", formalDefinition="Genetic analysis discrete result")
    private GeneticAnalysisDiscreteResult myGeneticAnalysisDiscreteResult;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySubject, this.myAuthor, this.myDate, this.myGeneticAnalysisSummary, this.myDnaRegionAnalysisTestCoverage, this.myGeneticAnalysisDiscreteResult});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myAuthor, this.myDate, this.myGeneticAnalysisSummary, this.myDnaRegionAnalysisTestCoverage, this.myGeneticAnalysisDiscreteResult});
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public GeneticAnalysis setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ResourceReferenceDt getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public GeneticAnalysis setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public DateDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public DateDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public GeneticAnalysis setDate(DateDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public GeneticAnalysis setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public GeneticAnalysis setDateWithDayPrecision(Date theDate) {
        this.myDate = new DateDt(theDate);
        return this;
    }

    public GeneticAnalysisSummary getGeneticAnalysisSummary() {
        if (this.myGeneticAnalysisSummary == null) {
            this.myGeneticAnalysisSummary = new GeneticAnalysisSummary();
        }
        return this.myGeneticAnalysisSummary;
    }

    public GeneticAnalysisSummary getGeneticAnalysisSummaryElement() {
        if (this.myGeneticAnalysisSummary == null) {
            this.myGeneticAnalysisSummary = new GeneticAnalysisSummary();
        }
        return this.myGeneticAnalysisSummary;
    }

    public GeneticAnalysis setGeneticAnalysisSummary(GeneticAnalysisSummary theValue) {
        this.myGeneticAnalysisSummary = theValue;
        return this;
    }

    public DnaRegionAnalysisTestCoverage getDnaRegionAnalysisTestCoverage() {
        if (this.myDnaRegionAnalysisTestCoverage == null) {
            this.myDnaRegionAnalysisTestCoverage = new DnaRegionAnalysisTestCoverage();
        }
        return this.myDnaRegionAnalysisTestCoverage;
    }

    public DnaRegionAnalysisTestCoverage getDnaRegionAnalysisTestCoverageElement() {
        if (this.myDnaRegionAnalysisTestCoverage == null) {
            this.myDnaRegionAnalysisTestCoverage = new DnaRegionAnalysisTestCoverage();
        }
        return this.myDnaRegionAnalysisTestCoverage;
    }

    public GeneticAnalysis setDnaRegionAnalysisTestCoverage(DnaRegionAnalysisTestCoverage theValue) {
        this.myDnaRegionAnalysisTestCoverage = theValue;
        return this;
    }

    public GeneticAnalysisDiscreteResult getGeneticAnalysisDiscreteResult() {
        if (this.myGeneticAnalysisDiscreteResult == null) {
            this.myGeneticAnalysisDiscreteResult = new GeneticAnalysisDiscreteResult();
        }
        return this.myGeneticAnalysisDiscreteResult;
    }

    public GeneticAnalysisDiscreteResult getGeneticAnalysisDiscreteResultElement() {
        if (this.myGeneticAnalysisDiscreteResult == null) {
            this.myGeneticAnalysisDiscreteResult = new GeneticAnalysisDiscreteResult();
        }
        return this.myGeneticAnalysisDiscreteResult;
    }

    public GeneticAnalysis setGeneticAnalysisDiscreteResult(GeneticAnalysisDiscreteResult theValue) {
        this.myGeneticAnalysisDiscreteResult = theValue;
        return this;
    }

    public String getResourceName() {
        return "GeneticAnalysis";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="geneIdentifier", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier of the gene", formalDefinition="Identifier of the gene represented in NCBI genomic nucleotide RefSeq IDs with their version number")
        private StringDt myGeneIdentifier;
        @Child(name="genomicReferenceSequenceIdentifier", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Genomic reference sequence identifier", formalDefinition="Identifier of the reference sequence represented in NCBI genomic nucleotide RefSeq IDs with their version number")
        private StringDt myGenomicReferenceSequenceIdentifier;
        @Child(name="transcriptReferenceIdentifier", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier of the transcript reference identifier", formalDefinition="Reference transcript represented in NCBI genomic nucleotide RefSeq IDs with their version number")
        private StringDt myTranscriptReferenceIdentifier;
        @Child(name="alleleName", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of the allele", formalDefinition="Name of the allele")
        private StringDt myAlleleName;
        @Child(name="dnaSequenceVariationIdentifier", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier of the DNA variation", formalDefinition="Identifier of the DNA variation")
        private StringDt myDnaSequenceVariationIdentifier;
        @Child(name="dnaSequenceVariation", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="DNA variation represented in HGVS nomenclature", formalDefinition="DNA variation represented in HGVS nomenclature")
        private StringDt myDnaSequenceVariation;
        @Child(name="dnaSequenceVariationType", type={CodingDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of the variation", formalDefinition="Type of the variation")
        private CodingDt myDnaSequenceVariationType;
        @Child(name="aminoAcidChange", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amino acid change represented in HGVS nomenclature", formalDefinition="Amino acid change represented in HGVS nomenclature")
        private StringDt myAminoAcidChange;
        @Child(name="aminoAcidChangeType", type={CodingDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of the amino acid change", formalDefinition="Type of the amino acid change")
        private CodingDt myAminoAcidChangeType;
        @Child(name="dnaRegionName", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Human-readable name of the DNA region", formalDefinition="Human-readable name of the DNA region")
        private StringDt myDnaRegionName;
        @Child(name="allellicState", type={CodingDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Allelic state", formalDefinition="Allelic state")
        private CodingDt myAllellicState;
        @Child(name="genomicSourceClass", type={CodingDt.class}, order=11, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Class of the source of sample", formalDefinition="Class of the source of sample")
        private CodingDt myGenomicSourceClass;
        @Child(name="dnaSequenceVariationDisplayName", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Conventional display of the DNA region and its interpretation", formalDefinition="Conventional display of the DNA region and its interpretation")
        private StringDt myDnaSequenceVariationDisplayName;
        @Child(name="geneticDiseaseSequenceVariationInterpretation", type={CodingDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Interpretation of the genotype's effect on genetic disease", formalDefinition="Interpretation of the genotype's effect on genetic disease")
        private CodingDt myGeneticDiseaseSequenceVariationInterpretation;
        @Child(name="drugMetabolismSequenceVariationInterpretatioin", type={CodingDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Interpretation of the genotype's effect on the drug's metabolic effect", formalDefinition="Interpretation of the genotype's effect on the drug's metabolic effect")
        private CodingDt myDrugMetabolismSequenceVariationInterpretatioin;
        @Child(name="drugEfficacySequenceVariationInterpretation", type={CodingDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Interpretation of the genotype's effect on the drug's efficacy", formalDefinition="Interpretation of the genotype's effect on the drug's efficacy")
        private CodingDt myDrugEfficacySequenceVariationInterpretation;
        @Child(name="geneticVariantAssessment", type={CodingDt.class}, order=16, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Genotyping result on a known set of mutation", formalDefinition="Genotyping result on a known set of mutation")
        private CodingDt myGeneticVariantAssessment;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myGeneIdentifier, this.myGenomicReferenceSequenceIdentifier, this.myTranscriptReferenceIdentifier, this.myAlleleName, this.myDnaSequenceVariationIdentifier, this.myDnaSequenceVariation, this.myDnaSequenceVariationType, this.myAminoAcidChange, this.myAminoAcidChangeType, this.myDnaRegionName, this.myAllellicState, this.myGenomicSourceClass, this.myDnaSequenceVariationDisplayName, this.myGeneticDiseaseSequenceVariationInterpretation, this.myDrugMetabolismSequenceVariationInterpretatioin, this.myDrugEfficacySequenceVariationInterpretation, this.myGeneticVariantAssessment});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myGeneIdentifier, this.myGenomicReferenceSequenceIdentifier, this.myTranscriptReferenceIdentifier, this.myAlleleName, this.myDnaSequenceVariationIdentifier, this.myDnaSequenceVariation, this.myDnaSequenceVariationType, this.myAminoAcidChange, this.myAminoAcidChangeType, this.myDnaRegionName, this.myAllellicState, this.myGenomicSourceClass, this.myDnaSequenceVariationDisplayName, this.myGeneticDiseaseSequenceVariationInterpretation, this.myDrugMetabolismSequenceVariationInterpretatioin, this.myDrugEfficacySequenceVariationInterpretation, this.myGeneticVariantAssessment});
        }

        public StringDt getGeneIdentifier() {
            if (this.myGeneIdentifier == null) {
                this.myGeneIdentifier = new StringDt();
            }
            return this.myGeneIdentifier;
        }

        public StringDt getGeneIdentifierElement() {
            if (this.myGeneIdentifier == null) {
                this.myGeneIdentifier = new StringDt();
            }
            return this.myGeneIdentifier;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setGeneIdentifier(StringDt theValue) {
            this.myGeneIdentifier = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setGeneIdentifier(String theString) {
            this.myGeneIdentifier = new StringDt(theString);
            return this;
        }

        public StringDt getGenomicReferenceSequenceIdentifier() {
            if (this.myGenomicReferenceSequenceIdentifier == null) {
                this.myGenomicReferenceSequenceIdentifier = new StringDt();
            }
            return this.myGenomicReferenceSequenceIdentifier;
        }

        public StringDt getGenomicReferenceSequenceIdentifierElement() {
            if (this.myGenomicReferenceSequenceIdentifier == null) {
                this.myGenomicReferenceSequenceIdentifier = new StringDt();
            }
            return this.myGenomicReferenceSequenceIdentifier;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setGenomicReferenceSequenceIdentifier(StringDt theValue) {
            this.myGenomicReferenceSequenceIdentifier = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setGenomicReferenceSequenceIdentifier(String theString) {
            this.myGenomicReferenceSequenceIdentifier = new StringDt(theString);
            return this;
        }

        public StringDt getTranscriptReferenceIdentifier() {
            if (this.myTranscriptReferenceIdentifier == null) {
                this.myTranscriptReferenceIdentifier = new StringDt();
            }
            return this.myTranscriptReferenceIdentifier;
        }

        public StringDt getTranscriptReferenceIdentifierElement() {
            if (this.myTranscriptReferenceIdentifier == null) {
                this.myTranscriptReferenceIdentifier = new StringDt();
            }
            return this.myTranscriptReferenceIdentifier;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setTranscriptReferenceIdentifier(StringDt theValue) {
            this.myTranscriptReferenceIdentifier = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setTranscriptReferenceIdentifier(String theString) {
            this.myTranscriptReferenceIdentifier = new StringDt(theString);
            return this;
        }

        public StringDt getAlleleName() {
            if (this.myAlleleName == null) {
                this.myAlleleName = new StringDt();
            }
            return this.myAlleleName;
        }

        public StringDt getAlleleNameElement() {
            if (this.myAlleleName == null) {
                this.myAlleleName = new StringDt();
            }
            return this.myAlleleName;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setAlleleName(StringDt theValue) {
            this.myAlleleName = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setAlleleName(String theString) {
            this.myAlleleName = new StringDt(theString);
            return this;
        }

        public StringDt getDnaSequenceVariationIdentifier() {
            if (this.myDnaSequenceVariationIdentifier == null) {
                this.myDnaSequenceVariationIdentifier = new StringDt();
            }
            return this.myDnaSequenceVariationIdentifier;
        }

        public StringDt getDnaSequenceVariationIdentifierElement() {
            if (this.myDnaSequenceVariationIdentifier == null) {
                this.myDnaSequenceVariationIdentifier = new StringDt();
            }
            return this.myDnaSequenceVariationIdentifier;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaSequenceVariationIdentifier(StringDt theValue) {
            this.myDnaSequenceVariationIdentifier = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaSequenceVariationIdentifier(String theString) {
            this.myDnaSequenceVariationIdentifier = new StringDt(theString);
            return this;
        }

        public StringDt getDnaSequenceVariation() {
            if (this.myDnaSequenceVariation == null) {
                this.myDnaSequenceVariation = new StringDt();
            }
            return this.myDnaSequenceVariation;
        }

        public StringDt getDnaSequenceVariationElement() {
            if (this.myDnaSequenceVariation == null) {
                this.myDnaSequenceVariation = new StringDt();
            }
            return this.myDnaSequenceVariation;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaSequenceVariation(StringDt theValue) {
            this.myDnaSequenceVariation = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaSequenceVariation(String theString) {
            this.myDnaSequenceVariation = new StringDt(theString);
            return this;
        }

        public CodingDt getDnaSequenceVariationType() {
            if (this.myDnaSequenceVariationType == null) {
                this.myDnaSequenceVariationType = new CodingDt();
            }
            return this.myDnaSequenceVariationType;
        }

        public CodingDt getDnaSequenceVariationTypeElement() {
            if (this.myDnaSequenceVariationType == null) {
                this.myDnaSequenceVariationType = new CodingDt();
            }
            return this.myDnaSequenceVariationType;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaSequenceVariationType(CodingDt theValue) {
            this.myDnaSequenceVariationType = theValue;
            return this;
        }

        public StringDt getAminoAcidChange() {
            if (this.myAminoAcidChange == null) {
                this.myAminoAcidChange = new StringDt();
            }
            return this.myAminoAcidChange;
        }

        public StringDt getAminoAcidChangeElement() {
            if (this.myAminoAcidChange == null) {
                this.myAminoAcidChange = new StringDt();
            }
            return this.myAminoAcidChange;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setAminoAcidChange(StringDt theValue) {
            this.myAminoAcidChange = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setAminoAcidChange(String theString) {
            this.myAminoAcidChange = new StringDt(theString);
            return this;
        }

        public CodingDt getAminoAcidChangeType() {
            if (this.myAminoAcidChangeType == null) {
                this.myAminoAcidChangeType = new CodingDt();
            }
            return this.myAminoAcidChangeType;
        }

        public CodingDt getAminoAcidChangeTypeElement() {
            if (this.myAminoAcidChangeType == null) {
                this.myAminoAcidChangeType = new CodingDt();
            }
            return this.myAminoAcidChangeType;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setAminoAcidChangeType(CodingDt theValue) {
            this.myAminoAcidChangeType = theValue;
            return this;
        }

        public StringDt getDnaRegionName() {
            if (this.myDnaRegionName == null) {
                this.myDnaRegionName = new StringDt();
            }
            return this.myDnaRegionName;
        }

        public StringDt getDnaRegionNameElement() {
            if (this.myDnaRegionName == null) {
                this.myDnaRegionName = new StringDt();
            }
            return this.myDnaRegionName;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaRegionName(StringDt theValue) {
            this.myDnaRegionName = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaRegionName(String theString) {
            this.myDnaRegionName = new StringDt(theString);
            return this;
        }

        public CodingDt getAllellicState() {
            if (this.myAllellicState == null) {
                this.myAllellicState = new CodingDt();
            }
            return this.myAllellicState;
        }

        public CodingDt getAllellicStateElement() {
            if (this.myAllellicState == null) {
                this.myAllellicState = new CodingDt();
            }
            return this.myAllellicState;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setAllellicState(CodingDt theValue) {
            this.myAllellicState = theValue;
            return this;
        }

        public CodingDt getGenomicSourceClass() {
            if (this.myGenomicSourceClass == null) {
                this.myGenomicSourceClass = new CodingDt();
            }
            return this.myGenomicSourceClass;
        }

        public CodingDt getGenomicSourceClassElement() {
            if (this.myGenomicSourceClass == null) {
                this.myGenomicSourceClass = new CodingDt();
            }
            return this.myGenomicSourceClass;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setGenomicSourceClass(CodingDt theValue) {
            this.myGenomicSourceClass = theValue;
            return this;
        }

        public StringDt getDnaSequenceVariationDisplayName() {
            if (this.myDnaSequenceVariationDisplayName == null) {
                this.myDnaSequenceVariationDisplayName = new StringDt();
            }
            return this.myDnaSequenceVariationDisplayName;
        }

        public StringDt getDnaSequenceVariationDisplayNameElement() {
            if (this.myDnaSequenceVariationDisplayName == null) {
                this.myDnaSequenceVariationDisplayName = new StringDt();
            }
            return this.myDnaSequenceVariationDisplayName;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaSequenceVariationDisplayName(StringDt theValue) {
            this.myDnaSequenceVariationDisplayName = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDnaSequenceVariationDisplayName(String theString) {
            this.myDnaSequenceVariationDisplayName = new StringDt(theString);
            return this;
        }

        public CodingDt getGeneticDiseaseSequenceVariationInterpretation() {
            if (this.myGeneticDiseaseSequenceVariationInterpretation == null) {
                this.myGeneticDiseaseSequenceVariationInterpretation = new CodingDt();
            }
            return this.myGeneticDiseaseSequenceVariationInterpretation;
        }

        public CodingDt getGeneticDiseaseSequenceVariationInterpretationElement() {
            if (this.myGeneticDiseaseSequenceVariationInterpretation == null) {
                this.myGeneticDiseaseSequenceVariationInterpretation = new CodingDt();
            }
            return this.myGeneticDiseaseSequenceVariationInterpretation;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setGeneticDiseaseSequenceVariationInterpretation(CodingDt theValue) {
            this.myGeneticDiseaseSequenceVariationInterpretation = theValue;
            return this;
        }

        public CodingDt getDrugMetabolismSequenceVariationInterpretatioin() {
            if (this.myDrugMetabolismSequenceVariationInterpretatioin == null) {
                this.myDrugMetabolismSequenceVariationInterpretatioin = new CodingDt();
            }
            return this.myDrugMetabolismSequenceVariationInterpretatioin;
        }

        public CodingDt getDrugMetabolismSequenceVariationInterpretatioinElement() {
            if (this.myDrugMetabolismSequenceVariationInterpretatioin == null) {
                this.myDrugMetabolismSequenceVariationInterpretatioin = new CodingDt();
            }
            return this.myDrugMetabolismSequenceVariationInterpretatioin;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDrugMetabolismSequenceVariationInterpretatioin(CodingDt theValue) {
            this.myDrugMetabolismSequenceVariationInterpretatioin = theValue;
            return this;
        }

        public CodingDt getDrugEfficacySequenceVariationInterpretation() {
            if (this.myDrugEfficacySequenceVariationInterpretation == null) {
                this.myDrugEfficacySequenceVariationInterpretation = new CodingDt();
            }
            return this.myDrugEfficacySequenceVariationInterpretation;
        }

        public CodingDt getDrugEfficacySequenceVariationInterpretationElement() {
            if (this.myDrugEfficacySequenceVariationInterpretation == null) {
                this.myDrugEfficacySequenceVariationInterpretation = new CodingDt();
            }
            return this.myDrugEfficacySequenceVariationInterpretation;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setDrugEfficacySequenceVariationInterpretation(CodingDt theValue) {
            this.myDrugEfficacySequenceVariationInterpretation = theValue;
            return this;
        }

        public CodingDt getGeneticVariantAssessment() {
            if (this.myGeneticVariantAssessment == null) {
                this.myGeneticVariantAssessment = new CodingDt();
            }
            return this.myGeneticVariantAssessment;
        }

        public CodingDt getGeneticVariantAssessmentElement() {
            if (this.myGeneticVariantAssessment == null) {
                this.myGeneticVariantAssessment = new CodingDt();
            }
            return this.myGeneticVariantAssessment;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation setGeneticVariantAssessment(CodingDt theValue) {
            this.myGeneticVariantAssessment = theValue;
            return this;
        }
    }

    @Block
    public static class GeneticAnalysisDiscreteResult
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="dnaAnalysisDiscreteSequenceVariation", order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="DNA analysis discrete sequence variation", formalDefinition="DNA analysis discrete sequence variation")
        private List<GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation> myDnaAnalysisDiscreteSequenceVariation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty(this.myDnaAnalysisDiscreteSequenceVariation);
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDnaAnalysisDiscreteSequenceVariation});
        }

        public List<GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation> getDnaAnalysisDiscreteSequenceVariation() {
            if (this.myDnaAnalysisDiscreteSequenceVariation == null) {
                this.myDnaAnalysisDiscreteSequenceVariation = new ArrayList<GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation>();
            }
            return this.myDnaAnalysisDiscreteSequenceVariation;
        }

        public List<GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation> getDnaAnalysisDiscreteSequenceVariationElement() {
            if (this.myDnaAnalysisDiscreteSequenceVariation == null) {
                this.myDnaAnalysisDiscreteSequenceVariation = new ArrayList<GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation>();
            }
            return this.myDnaAnalysisDiscreteSequenceVariation;
        }

        public GeneticAnalysisDiscreteResult setDnaAnalysisDiscreteSequenceVariation(List<GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation> theValue) {
            this.myDnaAnalysisDiscreteSequenceVariation = theValue;
            return this;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation addDnaAnalysisDiscreteSequenceVariation() {
            GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation newType = new GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation();
            this.getDnaAnalysisDiscreteSequenceVariation().add(newType);
            return newType;
        }

        public GeneticAnalysisDiscreteResultDnaAnalysisDiscreteSequenceVariation getDnaAnalysisDiscreteSequenceVariationFirstRep() {
            if (this.getDnaAnalysisDiscreteSequenceVariation().isEmpty()) {
                return this.addDnaAnalysisDiscreteSequenceVariation();
            }
            return this.getDnaAnalysisDiscreteSequenceVariation().get(0);
        }
    }

    @Block
    public static class DnaRegionAnalysisTestCoverageDnaRegionOfInterest
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="genomicReferenceSequenceIdentifier", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Genomic reference sequence identifier", formalDefinition="Identifier of the sequence represented in NCBI genomic nucleotide RefSeq IDs with their version number")
        private StringDt myGenomicReferenceSequenceIdentifier;
        @Child(name="regionOfInterestStart", type={IntegerDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Start position of the DNA region of interest", formalDefinition="Start position of the DNA region of interest")
        private IntegerDt myRegionOfInterestStart;
        @Child(name="regionOfInterestStop", type={IntegerDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="End position of the DNA region of interest", formalDefinition="End position of the DNA region of interest")
        private IntegerDt myRegionOfInterestStop;
        @Child(name="referenceNucleotide", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Genotype of the region in reference genome", formalDefinition="Genotype of the region in reference genome")
        private StringDt myReferenceNucleotide;
        @Child(name="variableNucleotide", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The patient's genotype in the region", formalDefinition="The patient's genotype in the region")
        private StringDt myVariableNucleotide;
        @Child(name="genechipId", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="ID of the genechip", formalDefinition="ID of the genechip")
        private StringDt myGenechipId;
        @Child(name="genechipManufacturerId", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="ID of manufacturer of the genechip", formalDefinition="ID of manufacturer of the genechip")
        private StringDt myGenechipManufacturerId;
        @Child(name="genechipVersion", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Version of the genechip", formalDefinition="Version of the genechip")
        private StringDt myGenechipVersion;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myGenomicReferenceSequenceIdentifier, this.myRegionOfInterestStart, this.myRegionOfInterestStop, this.myReferenceNucleotide, this.myVariableNucleotide, this.myGenechipId, this.myGenechipManufacturerId, this.myGenechipVersion});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myGenomicReferenceSequenceIdentifier, this.myRegionOfInterestStart, this.myRegionOfInterestStop, this.myReferenceNucleotide, this.myVariableNucleotide, this.myGenechipId, this.myGenechipManufacturerId, this.myGenechipVersion});
        }

        public StringDt getGenomicReferenceSequenceIdentifier() {
            if (this.myGenomicReferenceSequenceIdentifier == null) {
                this.myGenomicReferenceSequenceIdentifier = new StringDt();
            }
            return this.myGenomicReferenceSequenceIdentifier;
        }

        public StringDt getGenomicReferenceSequenceIdentifierElement() {
            if (this.myGenomicReferenceSequenceIdentifier == null) {
                this.myGenomicReferenceSequenceIdentifier = new StringDt();
            }
            return this.myGenomicReferenceSequenceIdentifier;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenomicReferenceSequenceIdentifier(StringDt theValue) {
            this.myGenomicReferenceSequenceIdentifier = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenomicReferenceSequenceIdentifier(String theString) {
            this.myGenomicReferenceSequenceIdentifier = new StringDt(theString);
            return this;
        }

        public IntegerDt getRegionOfInterestStart() {
            if (this.myRegionOfInterestStart == null) {
                this.myRegionOfInterestStart = new IntegerDt();
            }
            return this.myRegionOfInterestStart;
        }

        public IntegerDt getRegionOfInterestStartElement() {
            if (this.myRegionOfInterestStart == null) {
                this.myRegionOfInterestStart = new IntegerDt();
            }
            return this.myRegionOfInterestStart;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setRegionOfInterestStart(IntegerDt theValue) {
            this.myRegionOfInterestStart = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setRegionOfInterestStart(int theInteger) {
            this.myRegionOfInterestStart = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getRegionOfInterestStop() {
            if (this.myRegionOfInterestStop == null) {
                this.myRegionOfInterestStop = new IntegerDt();
            }
            return this.myRegionOfInterestStop;
        }

        public IntegerDt getRegionOfInterestStopElement() {
            if (this.myRegionOfInterestStop == null) {
                this.myRegionOfInterestStop = new IntegerDt();
            }
            return this.myRegionOfInterestStop;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setRegionOfInterestStop(IntegerDt theValue) {
            this.myRegionOfInterestStop = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setRegionOfInterestStop(int theInteger) {
            this.myRegionOfInterestStop = new IntegerDt(theInteger);
            return this;
        }

        public StringDt getReferenceNucleotide() {
            if (this.myReferenceNucleotide == null) {
                this.myReferenceNucleotide = new StringDt();
            }
            return this.myReferenceNucleotide;
        }

        public StringDt getReferenceNucleotideElement() {
            if (this.myReferenceNucleotide == null) {
                this.myReferenceNucleotide = new StringDt();
            }
            return this.myReferenceNucleotide;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setReferenceNucleotide(StringDt theValue) {
            this.myReferenceNucleotide = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setReferenceNucleotide(String theString) {
            this.myReferenceNucleotide = new StringDt(theString);
            return this;
        }

        public StringDt getVariableNucleotide() {
            if (this.myVariableNucleotide == null) {
                this.myVariableNucleotide = new StringDt();
            }
            return this.myVariableNucleotide;
        }

        public StringDt getVariableNucleotideElement() {
            if (this.myVariableNucleotide == null) {
                this.myVariableNucleotide = new StringDt();
            }
            return this.myVariableNucleotide;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setVariableNucleotide(StringDt theValue) {
            this.myVariableNucleotide = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setVariableNucleotide(String theString) {
            this.myVariableNucleotide = new StringDt(theString);
            return this;
        }

        public StringDt getGenechipId() {
            if (this.myGenechipId == null) {
                this.myGenechipId = new StringDt();
            }
            return this.myGenechipId;
        }

        public StringDt getGenechipIdElement() {
            if (this.myGenechipId == null) {
                this.myGenechipId = new StringDt();
            }
            return this.myGenechipId;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenechipId(StringDt theValue) {
            this.myGenechipId = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenechipId(String theString) {
            this.myGenechipId = new StringDt(theString);
            return this;
        }

        public StringDt getGenechipManufacturerId() {
            if (this.myGenechipManufacturerId == null) {
                this.myGenechipManufacturerId = new StringDt();
            }
            return this.myGenechipManufacturerId;
        }

        public StringDt getGenechipManufacturerIdElement() {
            if (this.myGenechipManufacturerId == null) {
                this.myGenechipManufacturerId = new StringDt();
            }
            return this.myGenechipManufacturerId;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenechipManufacturerId(StringDt theValue) {
            this.myGenechipManufacturerId = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenechipManufacturerId(String theString) {
            this.myGenechipManufacturerId = new StringDt(theString);
            return this;
        }

        public StringDt getGenechipVersion() {
            if (this.myGenechipVersion == null) {
                this.myGenechipVersion = new StringDt();
            }
            return this.myGenechipVersion;
        }

        public StringDt getGenechipVersionElement() {
            if (this.myGenechipVersion == null) {
                this.myGenechipVersion = new StringDt();
            }
            return this.myGenechipVersion;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenechipVersion(StringDt theValue) {
            this.myGenechipVersion = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest setGenechipVersion(String theString) {
            this.myGenechipVersion = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class DnaRegionAnalysisTestCoverage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="dnaRegionOfInterest", order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="DNA studied", formalDefinition="DNA studied")
        private List<DnaRegionAnalysisTestCoverageDnaRegionOfInterest> myDnaRegionOfInterest;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty(this.myDnaRegionOfInterest);
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDnaRegionOfInterest});
        }

        public List<DnaRegionAnalysisTestCoverageDnaRegionOfInterest> getDnaRegionOfInterest() {
            if (this.myDnaRegionOfInterest == null) {
                this.myDnaRegionOfInterest = new ArrayList<DnaRegionAnalysisTestCoverageDnaRegionOfInterest>();
            }
            return this.myDnaRegionOfInterest;
        }

        public List<DnaRegionAnalysisTestCoverageDnaRegionOfInterest> getDnaRegionOfInterestElement() {
            if (this.myDnaRegionOfInterest == null) {
                this.myDnaRegionOfInterest = new ArrayList<DnaRegionAnalysisTestCoverageDnaRegionOfInterest>();
            }
            return this.myDnaRegionOfInterest;
        }

        public DnaRegionAnalysisTestCoverage setDnaRegionOfInterest(List<DnaRegionAnalysisTestCoverageDnaRegionOfInterest> theValue) {
            this.myDnaRegionOfInterest = theValue;
            return this;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest addDnaRegionOfInterest() {
            DnaRegionAnalysisTestCoverageDnaRegionOfInterest newType = new DnaRegionAnalysisTestCoverageDnaRegionOfInterest();
            this.getDnaRegionOfInterest().add(newType);
            return newType;
        }

        public DnaRegionAnalysisTestCoverageDnaRegionOfInterest getDnaRegionOfInterestFirstRep() {
            if (this.getDnaRegionOfInterest().isEmpty()) {
                return this.addDnaRegionOfInterest();
            }
            return this.getDnaRegionOfInterest().get(0);
        }
    }

    @Block
    public static class GeneticAnalysisSummary
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="geneticDiseaseAssessed", type={CodingDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Genetic disease being assesed", formalDefinition="Genetic disease being assesed")
        private CodingDt myGeneticDiseaseAssessed;
        @Child(name="medicationAssesed", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Medication being assesed", formalDefinition="Medication being assesed")
        private CodingDt myMedicationAssesed;
        @Child(name="genomicSourceClass", type={CodingDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Class of the source of sample", formalDefinition="Class of the source of sample")
        private CodingDt myGenomicSourceClass;
        @Child(name="geneticDiseaseAnalysisOverallInterpretation", type={CodingDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Overall interpretation of the patient's genotype on the genetic disease being assesed", formalDefinition="Overall interpretation of the patient's genotype on the genetic disease being assesed")
        private CodingDt myGeneticDiseaseAnalysisOverallInterpretation;
        @Child(name="geneticDiseaseAnalysisOverallCarrierInterpertation", type={CodingDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Carrier status of the patietn", formalDefinition="Carrier status of the patietn")
        private CodingDt myGeneticDiseaseAnalysisOverallCarrierInterpertation;
        @Child(name="drugEfficacyAnalysisOverallInterpretation", type={CodingDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Analysis on the efficacy of the drug being assessed", formalDefinition="Analysis on the efficacy of the drug being assessed")
        private CodingDt myDrugEfficacyAnalysisOverallInterpretation;
        @Child(name="geneticAnalysisSummaryReport", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Summary of the analysis", formalDefinition="Summary of the analysis")
        private StringDt myGeneticAnalysisSummaryReport;
        @Child(name="reasonForStudyAdditionalNote", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Additional notes", formalDefinition="Additional notes")
        private StringDt myReasonForStudyAdditionalNote;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myGeneticDiseaseAssessed, this.myMedicationAssesed, this.myGenomicSourceClass, this.myGeneticDiseaseAnalysisOverallInterpretation, this.myGeneticDiseaseAnalysisOverallCarrierInterpertation, this.myDrugEfficacyAnalysisOverallInterpretation, this.myGeneticAnalysisSummaryReport, this.myReasonForStudyAdditionalNote});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myGeneticDiseaseAssessed, this.myMedicationAssesed, this.myGenomicSourceClass, this.myGeneticDiseaseAnalysisOverallInterpretation, this.myGeneticDiseaseAnalysisOverallCarrierInterpertation, this.myDrugEfficacyAnalysisOverallInterpretation, this.myGeneticAnalysisSummaryReport, this.myReasonForStudyAdditionalNote});
        }

        public CodingDt getGeneticDiseaseAssessed() {
            if (this.myGeneticDiseaseAssessed == null) {
                this.myGeneticDiseaseAssessed = new CodingDt();
            }
            return this.myGeneticDiseaseAssessed;
        }

        public CodingDt getGeneticDiseaseAssessedElement() {
            if (this.myGeneticDiseaseAssessed == null) {
                this.myGeneticDiseaseAssessed = new CodingDt();
            }
            return this.myGeneticDiseaseAssessed;
        }

        public GeneticAnalysisSummary setGeneticDiseaseAssessed(CodingDt theValue) {
            this.myGeneticDiseaseAssessed = theValue;
            return this;
        }

        public CodingDt getMedicationAssesed() {
            if (this.myMedicationAssesed == null) {
                this.myMedicationAssesed = new CodingDt();
            }
            return this.myMedicationAssesed;
        }

        public CodingDt getMedicationAssesedElement() {
            if (this.myMedicationAssesed == null) {
                this.myMedicationAssesed = new CodingDt();
            }
            return this.myMedicationAssesed;
        }

        public GeneticAnalysisSummary setMedicationAssesed(CodingDt theValue) {
            this.myMedicationAssesed = theValue;
            return this;
        }

        public CodingDt getGenomicSourceClass() {
            if (this.myGenomicSourceClass == null) {
                this.myGenomicSourceClass = new CodingDt();
            }
            return this.myGenomicSourceClass;
        }

        public CodingDt getGenomicSourceClassElement() {
            if (this.myGenomicSourceClass == null) {
                this.myGenomicSourceClass = new CodingDt();
            }
            return this.myGenomicSourceClass;
        }

        public GeneticAnalysisSummary setGenomicSourceClass(CodingDt theValue) {
            this.myGenomicSourceClass = theValue;
            return this;
        }

        public CodingDt getGeneticDiseaseAnalysisOverallInterpretation() {
            if (this.myGeneticDiseaseAnalysisOverallInterpretation == null) {
                this.myGeneticDiseaseAnalysisOverallInterpretation = new CodingDt();
            }
            return this.myGeneticDiseaseAnalysisOverallInterpretation;
        }

        public CodingDt getGeneticDiseaseAnalysisOverallInterpretationElement() {
            if (this.myGeneticDiseaseAnalysisOverallInterpretation == null) {
                this.myGeneticDiseaseAnalysisOverallInterpretation = new CodingDt();
            }
            return this.myGeneticDiseaseAnalysisOverallInterpretation;
        }

        public GeneticAnalysisSummary setGeneticDiseaseAnalysisOverallInterpretation(CodingDt theValue) {
            this.myGeneticDiseaseAnalysisOverallInterpretation = theValue;
            return this;
        }

        public CodingDt getGeneticDiseaseAnalysisOverallCarrierInterpertation() {
            if (this.myGeneticDiseaseAnalysisOverallCarrierInterpertation == null) {
                this.myGeneticDiseaseAnalysisOverallCarrierInterpertation = new CodingDt();
            }
            return this.myGeneticDiseaseAnalysisOverallCarrierInterpertation;
        }

        public CodingDt getGeneticDiseaseAnalysisOverallCarrierInterpertationElement() {
            if (this.myGeneticDiseaseAnalysisOverallCarrierInterpertation == null) {
                this.myGeneticDiseaseAnalysisOverallCarrierInterpertation = new CodingDt();
            }
            return this.myGeneticDiseaseAnalysisOverallCarrierInterpertation;
        }

        public GeneticAnalysisSummary setGeneticDiseaseAnalysisOverallCarrierInterpertation(CodingDt theValue) {
            this.myGeneticDiseaseAnalysisOverallCarrierInterpertation = theValue;
            return this;
        }

        public CodingDt getDrugEfficacyAnalysisOverallInterpretation() {
            if (this.myDrugEfficacyAnalysisOverallInterpretation == null) {
                this.myDrugEfficacyAnalysisOverallInterpretation = new CodingDt();
            }
            return this.myDrugEfficacyAnalysisOverallInterpretation;
        }

        public CodingDt getDrugEfficacyAnalysisOverallInterpretationElement() {
            if (this.myDrugEfficacyAnalysisOverallInterpretation == null) {
                this.myDrugEfficacyAnalysisOverallInterpretation = new CodingDt();
            }
            return this.myDrugEfficacyAnalysisOverallInterpretation;
        }

        public GeneticAnalysisSummary setDrugEfficacyAnalysisOverallInterpretation(CodingDt theValue) {
            this.myDrugEfficacyAnalysisOverallInterpretation = theValue;
            return this;
        }

        public StringDt getGeneticAnalysisSummaryReport() {
            if (this.myGeneticAnalysisSummaryReport == null) {
                this.myGeneticAnalysisSummaryReport = new StringDt();
            }
            return this.myGeneticAnalysisSummaryReport;
        }

        public StringDt getGeneticAnalysisSummaryReportElement() {
            if (this.myGeneticAnalysisSummaryReport == null) {
                this.myGeneticAnalysisSummaryReport = new StringDt();
            }
            return this.myGeneticAnalysisSummaryReport;
        }

        public GeneticAnalysisSummary setGeneticAnalysisSummaryReport(StringDt theValue) {
            this.myGeneticAnalysisSummaryReport = theValue;
            return this;
        }

        public GeneticAnalysisSummary setGeneticAnalysisSummaryReport(String theString) {
            this.myGeneticAnalysisSummaryReport = new StringDt(theString);
            return this;
        }

        public StringDt getReasonForStudyAdditionalNote() {
            if (this.myReasonForStudyAdditionalNote == null) {
                this.myReasonForStudyAdditionalNote = new StringDt();
            }
            return this.myReasonForStudyAdditionalNote;
        }

        public StringDt getReasonForStudyAdditionalNoteElement() {
            if (this.myReasonForStudyAdditionalNote == null) {
                this.myReasonForStudyAdditionalNote = new StringDt();
            }
            return this.myReasonForStudyAdditionalNote;
        }

        public GeneticAnalysisSummary setReasonForStudyAdditionalNote(StringDt theValue) {
            this.myReasonForStudyAdditionalNote = theValue;
            return this;
        }

        public GeneticAnalysisSummary setReasonForStudyAdditionalNote(String theString) {
            this.myReasonForStudyAdditionalNote = new StringDt(theString);
            return this;
        }
    }
}

