/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.base.resource.BaseConformance;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Profile;
import ca.uhn.fhir.model.dstu.valueset.ConformanceEventModeEnum;
import ca.uhn.fhir.model.dstu.valueset.ConformanceStatementStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.DocumentModeEnum;
import ca.uhn.fhir.model.dstu.valueset.MessageSignificanceCategoryEnum;
import ca.uhn.fhir.model.dstu.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulConformanceModeEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulSecurityServiceEnum;
import ca.uhn.fhir.model.dstu.valueset.SearchParamTypeEnum;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Conformance", profile="http://hl7.org/fhir/profiles/Conformance", id="conformance")
public class Conformance
extends BaseResource
implements BaseConformance {
    @SearchParamDefinition(name="identifier", path="Conformance.identifier", description="The identifier of the conformance statement", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="Conformance.version", description="The version identifier of the conformance statement", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="Conformance.name", description="Name of the conformance statement", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="Conformance.publisher", description="Name of the publisher of the conformance statement", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="Conformance.description", description="Text search in the description of the conformance statement", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="Conformance.status", description="The current status of the conformance statement", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="Conformance.date", description="The conformance statement publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="software", path="Conformance.software.name", description="Part of a the name of a software application", type="string")
    public static final String SP_SOFTWARE = "software";
    public static final StringClientParam SOFTWARE = new StringClientParam("software");
    @SearchParamDefinition(name="fhirversion", path="Conformance.version", description="The version of FHIR", type="token")
    public static final String SP_FHIRVERSION = "fhirversion";
    public static final TokenClientParam FHIRVERSION = new TokenClientParam("fhirversion");
    @SearchParamDefinition(name="resource", path="Conformance.rest.resource.type", description="Name of a resource mentioned in a conformance statement", type="token")
    public static final String SP_RESOURCE = "resource";
    public static final TokenClientParam RESOURCE = new TokenClientParam("resource");
    @SearchParamDefinition(name="event", path="Conformance.messaging.event.code", description="Event code in a conformance statement", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="mode", path="Conformance.rest.mode", description="Mode - restful (server/client) or messaging (sender/receiver)", type="token")
    public static final String SP_MODE = "mode";
    public static final TokenClientParam MODE = new TokenClientParam("mode");
    @SearchParamDefinition(name="profile", path="Conformance.rest.resource.profile", description="A profile id invoked in a conformance statement", type="reference")
    public static final String SP_PROFILE = "profile";
    public static final ReferenceClientParam PROFILE = new ReferenceClientParam("profile");
    public static final Include INCLUDE_REST_RESOURCE_PROFILE = new Include("Conformance.rest.resource.profile");
    @SearchParamDefinition(name="format", path="Conformance.format", description="", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="security", path="Conformance.rest.security", description="", type="token")
    public static final String SP_SECURITY = "security";
    public static final TokenClientParam SECURITY = new TokenClientParam("security");
    @SearchParamDefinition(name="supported-profile", path="Conformance.profile", description="", type="reference")
    public static final String SP_SUPPORTED_PROFILE = "supported-profile";
    public static final ReferenceClientParam SUPPORTED_PROFILE = new ReferenceClientParam("supported-profile");
    public static final Include INCLUDE_PROFILE = new Include("Conformance.profile");
    @Child(name="identifier", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Logical id to reference this statement", formalDefinition="The identifier that is used to identify this conformance statement when it is referenced in a specification, model, design or an instance (should be globally unique OID, UUID, or URI)")
    private StringDt myIdentifier;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Logical id for this version of the statement", formalDefinition="The identifier that is used to identify this version of the conformance statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Informal name for this conformance statement", formalDefinition="A free text natural language name identifying the conformance statement")
    private StringDt myName;
    @Child(name="publisher", type={StringDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Publishing Organization", formalDefinition="Name of Organization publishing this conformance statement")
    private StringDt myPublisher;
    @Child(name="telecom", type={ContactDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Contacts for Organization", formalDefinition="Contacts for Organization relevant to this conformance statement.  The contacts may be a website, email, phone numbers, etc.")
    private List<ContactDt> myTelecom;
    @Child(name="description", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Human description of the conformance statement", formalDefinition="A free text natural language description of the conformance statement and its use. Typically, this is used when the profile describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP")
    private StringDt myDescription;
    @Child(name="status", type={CodeDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of this conformance statement")
    private BoundCodeDt<ConformanceStatementStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this conformance statement is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="date", type={DateTimeDt.class}, order=8, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Publication Date", formalDefinition="The date when the conformance statement was published")
    private DateTimeDt myDate;
    @Child(name="software", order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Software that is covered by this conformance statement", formalDefinition="Software that is covered by this conformance statement.  It is used when the profile describes the capabilities of a particular software version, independent of an installation.")
    private Software mySoftware;
    @Child(name="implementation", order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="If this describes a specific instance", formalDefinition="Identifies a specific implementation instance that is described by the conformance statement - i.e. a particular installation, rather than the capabilities of a software program")
    private Implementation myImplementation;
    @Child(name="fhirVersion", type={IdDt.class}, order=11, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="FHIR Version", formalDefinition="The version of the FHIR specification on which this conformance statement is based")
    private IdDt myFhirVersion;
    @Child(name="acceptUnknown", type={BooleanDt.class}, order=12, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="True if application accepts unknown elements", formalDefinition="A flag that indicates whether the application accepts unknown elements as part of a resource.")
    private BooleanDt myAcceptUnknown;
    @Child(name="format", type={CodeDt.class}, order=13, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="formats supported (xml | json | mime type)", formalDefinition="A list of the formats supported by this implementation")
    private List<CodeDt> myFormat;
    @Child(name="profile", order=14, min=0, max=-1, summary=false, modifier=false, type={Profile.class})
    @Description(shortDefinition="Profiles supported by the system", formalDefinition="A list of profiles supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of recourses, conformant to a particular profile, and allows its clients to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile.")
    private List<ResourceReferenceDt> myProfile;
    @Child(name="rest", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="If the endpoint is a RESTful one", formalDefinition="A definition of the restful capabilities of the solution, if any")
    private List<Rest> myRest;
    @Child(name="messaging", order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="If messaging is supported", formalDefinition="A description of the messaging capabilities of the solution")
    private List<Messaging> myMessaging;
    @Child(name="document", order=17, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Document definition", formalDefinition="A document definition")
    private List<Document> myDocument;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myStatus, this.myExperimental, this.myDate, this.mySoftware, this.myImplementation, this.myFhirVersion, this.myAcceptUnknown, this.myFormat, this.myProfile, this.myRest, this.myMessaging, this.myDocument});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myStatus, this.myExperimental, this.myDate, this.mySoftware, this.myImplementation, this.myFhirVersion, this.myAcceptUnknown, this.myFormat, this.myProfile, this.myRest, this.myMessaging, this.myDocument});
    }

    public StringDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public StringDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public Conformance setIdentifier(StringDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Conformance setIdentifier(String theString) {
        this.myIdentifier = new StringDt(theString);
        return this;
    }

    public StringDt getVersion() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public Conformance setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public Conformance setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public Conformance setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Conformance setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getPublisher() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public Conformance setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public Conformance setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public Conformance setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Conformance addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public Conformance addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public Conformance setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Conformance setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceStatementStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceStatementStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<ConformanceStatementStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceStatementStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Conformance setStatus(BoundCodeDt<ConformanceStatementStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Conformance setStatus(ConformanceStatementStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getExperimental() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Conformance setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public Conformance setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Conformance setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Conformance setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Conformance setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public Software getSoftware() {
        if (this.mySoftware == null) {
            this.mySoftware = new Software();
        }
        return this.mySoftware;
    }

    public Software getSoftwareElement() {
        if (this.mySoftware == null) {
            this.mySoftware = new Software();
        }
        return this.mySoftware;
    }

    public Conformance setSoftware(Software theValue) {
        this.mySoftware = theValue;
        return this;
    }

    public Implementation getImplementation() {
        if (this.myImplementation == null) {
            this.myImplementation = new Implementation();
        }
        return this.myImplementation;
    }

    public Implementation getImplementationElement() {
        if (this.myImplementation == null) {
            this.myImplementation = new Implementation();
        }
        return this.myImplementation;
    }

    public Conformance setImplementation(Implementation theValue) {
        this.myImplementation = theValue;
        return this;
    }

    public IdDt getFhirVersion() {
        if (this.myFhirVersion == null) {
            this.myFhirVersion = new IdDt();
        }
        return this.myFhirVersion;
    }

    public IdDt getFhirVersionElement() {
        if (this.myFhirVersion == null) {
            this.myFhirVersion = new IdDt();
        }
        return this.myFhirVersion;
    }

    public Conformance setFhirVersion(IdDt theValue) {
        this.myFhirVersion = theValue;
        return this;
    }

    public Conformance setFhirVersion(String theId) {
        this.myFhirVersion = new IdDt(theId);
        return this;
    }

    public BooleanDt getAcceptUnknown() {
        if (this.myAcceptUnknown == null) {
            this.myAcceptUnknown = new BooleanDt();
        }
        return this.myAcceptUnknown;
    }

    public BooleanDt getAcceptUnknownElement() {
        if (this.myAcceptUnknown == null) {
            this.myAcceptUnknown = new BooleanDt();
        }
        return this.myAcceptUnknown;
    }

    public Conformance setAcceptUnknown(BooleanDt theValue) {
        this.myAcceptUnknown = theValue;
        return this;
    }

    public Conformance setAcceptUnknown(boolean theBoolean) {
        this.myAcceptUnknown = new BooleanDt(theBoolean);
        return this;
    }

    public List<CodeDt> getFormat() {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<CodeDt>();
        }
        return this.myFormat;
    }

    public List<CodeDt> getFormatElement() {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<CodeDt>();
        }
        return this.myFormat;
    }

    public Conformance setFormat(List<CodeDt> theValue) {
        this.myFormat = theValue;
        return this;
    }

    public CodeDt addFormat() {
        CodeDt newType = new CodeDt();
        this.getFormat().add(newType);
        return newType;
    }

    public CodeDt getFormatFirstRep() {
        if (this.getFormat().isEmpty()) {
            return this.addFormat();
        }
        return this.getFormat().get(0);
    }

    public Conformance addFormat(String theCode) {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<CodeDt>();
        }
        this.myFormat.add(new CodeDt(theCode));
        return this;
    }

    public List<ResourceReferenceDt> getProfile() {
        if (this.myProfile == null) {
            this.myProfile = new ArrayList<ResourceReferenceDt>();
        }
        return this.myProfile;
    }

    public List<ResourceReferenceDt> getProfileElement() {
        if (this.myProfile == null) {
            this.myProfile = new ArrayList<ResourceReferenceDt>();
        }
        return this.myProfile;
    }

    public Conformance setProfile(List<ResourceReferenceDt> theValue) {
        this.myProfile = theValue;
        return this;
    }

    public ResourceReferenceDt addProfile() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getProfile().add(newType);
        return newType;
    }

    public List<Rest> getRest() {
        if (this.myRest == null) {
            this.myRest = new ArrayList<Rest>();
        }
        return this.myRest;
    }

    public List<Rest> getRestElement() {
        if (this.myRest == null) {
            this.myRest = new ArrayList<Rest>();
        }
        return this.myRest;
    }

    public Conformance setRest(List<Rest> theValue) {
        this.myRest = theValue;
        return this;
    }

    public Rest addRest() {
        Rest newType = new Rest();
        this.getRest().add(newType);
        return newType;
    }

    public Rest getRestFirstRep() {
        if (this.getRest().isEmpty()) {
            return this.addRest();
        }
        return this.getRest().get(0);
    }

    public List<Messaging> getMessaging() {
        if (this.myMessaging == null) {
            this.myMessaging = new ArrayList<Messaging>();
        }
        return this.myMessaging;
    }

    public List<Messaging> getMessagingElement() {
        if (this.myMessaging == null) {
            this.myMessaging = new ArrayList<Messaging>();
        }
        return this.myMessaging;
    }

    public Conformance setMessaging(List<Messaging> theValue) {
        this.myMessaging = theValue;
        return this;
    }

    public Messaging addMessaging() {
        Messaging newType = new Messaging();
        this.getMessaging().add(newType);
        return newType;
    }

    public Messaging getMessagingFirstRep() {
        if (this.getMessaging().isEmpty()) {
            return this.addMessaging();
        }
        return this.getMessaging().get(0);
    }

    public List<Document> getDocument() {
        if (this.myDocument == null) {
            this.myDocument = new ArrayList<Document>();
        }
        return this.myDocument;
    }

    public List<Document> getDocumentElement() {
        if (this.myDocument == null) {
            this.myDocument = new ArrayList<Document>();
        }
        return this.myDocument;
    }

    public Conformance setDocument(List<Document> theValue) {
        this.myDocument = theValue;
        return this;
    }

    public Document addDocument() {
        Document newType = new Document();
        this.getDocument().add(newType);
        return newType;
    }

    public Document getDocumentFirstRep() {
        if (this.getDocument().isEmpty()) {
            return this.addDocument();
        }
        return this.getDocument().get(0);
    }

    public String getResourceName() {
        return "Conformance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Document
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="mode", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="producer | consumer", formalDefinition="Mode of this document declaration - whether application is producer or consumer")
        private BoundCodeDt<DocumentModeEnum> myMode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Description of document support", formalDefinition="A description of how the application supports or uses the specified document profile.  For example, when are documents created, what action is taken with consumed documents, etc.")
        private StringDt myDocumentation;
        @Child(name="profile", order=2, min=1, max=1, summary=false, modifier=false, type={Profile.class})
        @Description(shortDefinition="Constraint on a resource used in the document", formalDefinition="A constraint on a resource used in the document")
        private ResourceReferenceDt myProfile;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myMode, this.myDocumentation, this.myProfile});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMode, this.myDocumentation, this.myProfile});
        }

        public BoundCodeDt<DocumentModeEnum> getMode() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(DocumentModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public BoundCodeDt<DocumentModeEnum> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(DocumentModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public Document setMode(BoundCodeDt<DocumentModeEnum> theValue) {
            this.myMode = theValue;
            return this;
        }

        public Document setMode(DocumentModeEnum theValue) {
            this.getMode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public Document setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Document setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public ResourceReferenceDt getProfileElement() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public Document setProfile(ResourceReferenceDt theValue) {
            this.myProfile = theValue;
            return this;
        }
    }

    @Block
    public static class MessagingEvent
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Event type", formalDefinition="A coded identifier of a supported messaging event")
        private CodingDt myCode;
        @Child(name="category", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Consequence | Currency | Notification", formalDefinition="The impact of the content of the message")
        private BoundCodeDt<MessageSignificanceCategoryEnum> myCategory;
        @Child(name="mode", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="sender | receiver", formalDefinition="The mode of this event declaration - whether application is sender or receiver")
        private BoundCodeDt<ConformanceEventModeEnum> myMode;
        @Child(name="protocol", type={CodingDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="http | ftp | mllp +", formalDefinition="A list of the messaging transport protocol(s) identifiers, supported by this endpoint")
        private List<CodingDt> myProtocol;
        @Child(name="focus", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Resource that's focus of message", formalDefinition="A resource associated with the event.  This is the resource that defines the event.")
        private BoundCodeDt<ResourceTypeEnum> myFocus;
        @Child(name="request", order=5, min=1, max=1, summary=false, modifier=false, type={Profile.class})
        @Description(shortDefinition="Profile that describes the request", formalDefinition="Information about the request for this event")
        private ResourceReferenceDt myRequest;
        @Child(name="response", order=6, min=1, max=1, summary=false, modifier=false, type={Profile.class})
        @Description(shortDefinition="Profile that describes the response", formalDefinition="Information about the response for this event")
        private ResourceReferenceDt myResponse;
        @Child(name="documentation", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Endpoint-specific event documentation", formalDefinition="Guidance on how this event is handled, such as internal system trigger points, business rules, etc.")
        private StringDt myDocumentation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myCategory, this.myMode, this.myProtocol, this.myFocus, this.myRequest, this.myResponse, this.myDocumentation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myCategory, this.myMode, this.myProtocol, this.myFocus, this.myRequest, this.myResponse, this.myDocumentation});
        }

        public CodingDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public CodingDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodingDt();
            }
            return this.myCode;
        }

        public MessagingEvent setCode(CodingDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public BoundCodeDt<MessageSignificanceCategoryEnum> getCategory() {
            if (this.myCategory == null) {
                this.myCategory = new BoundCodeDt(MessageSignificanceCategoryEnum.VALUESET_BINDER);
            }
            return this.myCategory;
        }

        public BoundCodeDt<MessageSignificanceCategoryEnum> getCategoryElement() {
            if (this.myCategory == null) {
                this.myCategory = new BoundCodeDt(MessageSignificanceCategoryEnum.VALUESET_BINDER);
            }
            return this.myCategory;
        }

        public MessagingEvent setCategory(BoundCodeDt<MessageSignificanceCategoryEnum> theValue) {
            this.myCategory = theValue;
            return this;
        }

        public MessagingEvent setCategory(MessageSignificanceCategoryEnum theValue) {
            this.getCategory().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeDt<ConformanceEventModeEnum> getMode() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(ConformanceEventModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public BoundCodeDt<ConformanceEventModeEnum> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(ConformanceEventModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public MessagingEvent setMode(BoundCodeDt<ConformanceEventModeEnum> theValue) {
            this.myMode = theValue;
            return this;
        }

        public MessagingEvent setMode(ConformanceEventModeEnum theValue) {
            this.getMode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<CodingDt> getProtocol() {
            if (this.myProtocol == null) {
                this.myProtocol = new ArrayList<CodingDt>();
            }
            return this.myProtocol;
        }

        public List<CodingDt> getProtocolElement() {
            if (this.myProtocol == null) {
                this.myProtocol = new ArrayList<CodingDt>();
            }
            return this.myProtocol;
        }

        public MessagingEvent setProtocol(List<CodingDt> theValue) {
            this.myProtocol = theValue;
            return this;
        }

        public CodingDt addProtocol() {
            CodingDt newType = new CodingDt();
            this.getProtocol().add(newType);
            return newType;
        }

        public CodingDt getProtocolFirstRep() {
            if (this.getProtocol().isEmpty()) {
                return this.addProtocol();
            }
            return this.getProtocol().get(0);
        }

        public BoundCodeDt<ResourceTypeEnum> getFocus() {
            if (this.myFocus == null) {
                this.myFocus = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            }
            return this.myFocus;
        }

        public BoundCodeDt<ResourceTypeEnum> getFocusElement() {
            if (this.myFocus == null) {
                this.myFocus = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            }
            return this.myFocus;
        }

        public MessagingEvent setFocus(BoundCodeDt<ResourceTypeEnum> theValue) {
            this.myFocus = theValue;
            return this;
        }

        public MessagingEvent setFocus(ResourceTypeEnum theValue) {
            this.getFocus().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getRequest() {
            if (this.myRequest == null) {
                this.myRequest = new ResourceReferenceDt();
            }
            return this.myRequest;
        }

        public ResourceReferenceDt getRequestElement() {
            if (this.myRequest == null) {
                this.myRequest = new ResourceReferenceDt();
            }
            return this.myRequest;
        }

        public MessagingEvent setRequest(ResourceReferenceDt theValue) {
            this.myRequest = theValue;
            return this;
        }

        public ResourceReferenceDt getResponse() {
            if (this.myResponse == null) {
                this.myResponse = new ResourceReferenceDt();
            }
            return this.myResponse;
        }

        public ResourceReferenceDt getResponseElement() {
            if (this.myResponse == null) {
                this.myResponse = new ResourceReferenceDt();
            }
            return this.myResponse;
        }

        public MessagingEvent setResponse(ResourceReferenceDt theValue) {
            this.myResponse = theValue;
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public MessagingEvent setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public MessagingEvent setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Messaging
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="endpoint", type={UriDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Actual endpoint being described", formalDefinition="An address to which messages and/or replies are to be sent.")
        private UriDt myEndpoint;
        @Child(name="reliableCache", type={IntegerDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Reliable Message Cache Length", formalDefinition="Length if the receiver's reliable messaging cache (if a receiver) or how long the cache length on the receiver should be (if a sender)")
        private IntegerDt myReliableCache;
        @Child(name="documentation", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Messaging interface behavior details", formalDefinition="Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the conformance statement.  For example, process for becoming an authorized messaging exchange partner.")
        private StringDt myDocumentation;
        @Child(name="event", order=3, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Declare support for this event", formalDefinition="A description of the solution's support for an event at this end point.")
        private List<MessagingEvent> myEvent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEndpoint, this.myReliableCache, this.myDocumentation, this.myEvent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEndpoint, this.myReliableCache, this.myDocumentation, this.myEvent});
        }

        public UriDt getEndpoint() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public UriDt getEndpointElement() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public Messaging setEndpoint(UriDt theValue) {
            this.myEndpoint = theValue;
            return this;
        }

        public Messaging setEndpoint(String theUri) {
            this.myEndpoint = new UriDt(theUri);
            return this;
        }

        public IntegerDt getReliableCache() {
            if (this.myReliableCache == null) {
                this.myReliableCache = new IntegerDt();
            }
            return this.myReliableCache;
        }

        public IntegerDt getReliableCacheElement() {
            if (this.myReliableCache == null) {
                this.myReliableCache = new IntegerDt();
            }
            return this.myReliableCache;
        }

        public Messaging setReliableCache(IntegerDt theValue) {
            this.myReliableCache = theValue;
            return this;
        }

        public Messaging setReliableCache(int theInteger) {
            this.myReliableCache = new IntegerDt(theInteger);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public Messaging setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Messaging setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public List<MessagingEvent> getEvent() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<MessagingEvent>();
            }
            return this.myEvent;
        }

        public List<MessagingEvent> getEventElement() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<MessagingEvent>();
            }
            return this.myEvent;
        }

        public Messaging setEvent(List<MessagingEvent> theValue) {
            this.myEvent = theValue;
            return this;
        }

        public MessagingEvent addEvent() {
            MessagingEvent newType = new MessagingEvent();
            this.getEvent().add(newType);
            return newType;
        }

        public MessagingEvent getEventFirstRep() {
            if (this.getEvent().isEmpty()) {
                return this.addEvent();
            }
            return this.getEvent().get(0);
        }
    }

    @Block
    public static class RestQuery
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Special named queries (_query=)", formalDefinition="The name of a query, which is used in the _query parameter when the query is called")
        private StringDt myName;
        @Child(name="definition", type={UriDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Where query is defined", formalDefinition="Identifies the custom query, defined either in FHIR core or another profile")
        private UriDt myDefinition;
        @Child(name="documentation", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Additional usage guidance", formalDefinition="Additional information about how the query functions in this particular implementation")
        private StringDt myDocumentation;
        @Child(name="parameter", type={RestResourceSearchParam.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Parameter for the named query", formalDefinition="Identifies which of the parameters for the named query are supported")
        private List<RestResourceSearchParam> myParameter;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myDefinition, this.myDocumentation, this.myParameter});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myDefinition, this.myDocumentation, this.myParameter});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public RestQuery setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public RestQuery setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public UriDt getDefinition() {
            if (this.myDefinition == null) {
                this.myDefinition = new UriDt();
            }
            return this.myDefinition;
        }

        public UriDt getDefinitionElement() {
            if (this.myDefinition == null) {
                this.myDefinition = new UriDt();
            }
            return this.myDefinition;
        }

        public RestQuery setDefinition(UriDt theValue) {
            this.myDefinition = theValue;
            return this;
        }

        public RestQuery setDefinition(String theUri) {
            this.myDefinition = new UriDt(theUri);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public RestQuery setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public RestQuery setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public List<RestResourceSearchParam> getParameter() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<RestResourceSearchParam>();
            }
            return this.myParameter;
        }

        public List<RestResourceSearchParam> getParameterElement() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<RestResourceSearchParam>();
            }
            return this.myParameter;
        }

        public RestQuery setParameter(List<RestResourceSearchParam> theValue) {
            this.myParameter = theValue;
            return this;
        }

        public RestResourceSearchParam addParameter() {
            RestResourceSearchParam newType = new RestResourceSearchParam();
            this.getParameter().add(newType);
            return newType;
        }

        public RestResourceSearchParam getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                return this.addParameter();
            }
            return this.getParameter().get(0);
        }
    }

    @Block
    public static class RestOperation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="transaction | search-system | history-system", formalDefinition="A coded identifier of the operation, supported by the system")
        private BoundCodeDt<RestfulOperationSystemEnum> myCode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented")
        private StringDt myDocumentation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myDocumentation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDocumentation});
        }

        public BoundCodeDt<RestfulOperationSystemEnum> getCode() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(RestfulOperationSystemEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public BoundCodeDt<RestfulOperationSystemEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(RestfulOperationSystemEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public RestOperation setCode(BoundCodeDt<RestfulOperationSystemEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RestOperation setCode(RestfulOperationSystemEnum theValue) {
            this.getCode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public RestOperation setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public RestOperation setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class RestResourceSearchParam
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of search parameter", formalDefinition="The name of the search parameter used in the interface")
        private StringDt myName;
        @Child(name="definition", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Source of definition for parameter", formalDefinition="A formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter")
        private UriDt myDefinition;
        @Child(name="type", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted")
        private BoundCodeDt<SearchParamTypeEnum> myType;
        @Child(name="documentation", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Server-specific usage", formalDefinition="This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.")
        private StringDt myDocumentation;
        @Child(name="target", type={CodeDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Types of resource (if a resource reference)", formalDefinition="Types of resource (if a resource is referenced)")
        private List<BoundCodeDt<ResourceTypeEnum>> myTarget;
        @Child(name="chain", type={StringDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Chained names supported", formalDefinition="")
        private List<StringDt> myChain;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myDefinition, this.myType, this.myDocumentation, this.myTarget, this.myChain});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myDefinition, this.myType, this.myDocumentation, this.myTarget, this.myChain});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public RestResourceSearchParam setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public RestResourceSearchParam setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public UriDt getDefinition() {
            if (this.myDefinition == null) {
                this.myDefinition = new UriDt();
            }
            return this.myDefinition;
        }

        public UriDt getDefinitionElement() {
            if (this.myDefinition == null) {
                this.myDefinition = new UriDt();
            }
            return this.myDefinition;
        }

        public RestResourceSearchParam setDefinition(UriDt theValue) {
            this.myDefinition = theValue;
            return this;
        }

        public RestResourceSearchParam setDefinition(String theUri) {
            this.myDefinition = new UriDt(theUri);
            return this;
        }

        public BoundCodeDt<SearchParamTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SearchParamTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<SearchParamTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SearchParamTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public RestResourceSearchParam setType(BoundCodeDt<SearchParamTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public RestResourceSearchParam setType(SearchParamTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public RestResourceSearchParam setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public RestResourceSearchParam setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public List<BoundCodeDt<ResourceTypeEnum>> getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
            }
            return this.myTarget;
        }

        public List<BoundCodeDt<ResourceTypeEnum>> getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
            }
            return this.myTarget;
        }

        public RestResourceSearchParam setTarget(List<BoundCodeDt<ResourceTypeEnum>> theValue) {
            this.myTarget = theValue;
            return this;
        }

        public BoundCodeDt<ResourceTypeEnum> addTarget(ResourceTypeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<ResourceTypeEnum> getTargetFirstRep() {
            if (this.getTarget().size() == 0) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        public BoundCodeDt<ResourceTypeEnum> addTarget() {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public RestResourceSearchParam setTarget(ResourceTypeEnum theValue) {
            this.getTarget().clear();
            this.addTarget(theValue);
            return this;
        }

        public List<StringDt> getChain() {
            if (this.myChain == null) {
                this.myChain = new ArrayList<StringDt>();
            }
            return this.myChain;
        }

        public List<StringDt> getChainElement() {
            if (this.myChain == null) {
                this.myChain = new ArrayList<StringDt>();
            }
            return this.myChain;
        }

        public RestResourceSearchParam setChain(List<StringDt> theValue) {
            this.myChain = theValue;
            return this;
        }

        public StringDt addChain() {
            StringDt newType = new StringDt();
            this.getChain().add(newType);
            return newType;
        }

        public StringDt getChainFirstRep() {
            if (this.getChain().isEmpty()) {
                return this.addChain();
            }
            return this.getChain().get(0);
        }

        public RestResourceSearchParam addChain(String theString) {
            if (this.myChain == null) {
                this.myChain = new ArrayList<StringDt>();
            }
            this.myChain.add(new StringDt(theString));
            return this;
        }
    }

    @Block
    public static class RestResourceOperation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="read | vread | update | delete | history-instance | validate | history-type | create | search-type", formalDefinition="Coded identifier of the operation, supported by the system resource")
        private BoundCodeDt<RestfulOperationTypeEnum> myCode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'")
        private StringDt myDocumentation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myDocumentation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDocumentation});
        }

        public BoundCodeDt<RestfulOperationTypeEnum> getCode() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(RestfulOperationTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public BoundCodeDt<RestfulOperationTypeEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(RestfulOperationTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public RestResourceOperation setCode(BoundCodeDt<RestfulOperationTypeEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RestResourceOperation setCode(RestfulOperationTypeEnum theValue) {
            this.getCode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public RestResourceOperation setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public RestResourceOperation setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class RestResource
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="A resource type that is supported", formalDefinition="A type of resource exposed via the restful interface")
        private BoundCodeDt<ResourceTypeEnum> myType;
        @Child(name="profile", order=1, min=0, max=1, summary=false, modifier=false, type={Profile.class})
        @Description(shortDefinition="What structural features are supported", formalDefinition="A specification of the profile that describes the solution's support for the resource, including any constraints on cardinality, bindings, lengths or other limitations")
        private ResourceReferenceDt myProfile;
        @Child(name="operation", order=2, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="Identifies a restful operation supported by the solution")
        private List<RestResourceOperation> myOperation;
        @Child(name="readHistory", type={BooleanDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Whether vRead can return past versions", formalDefinition="A flag for whether the server is able to return past versions as part of the vRead operation")
        private BooleanDt myReadHistory;
        @Child(name="updateCreate", type={BooleanDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="If allows/uses update to a new location", formalDefinition="A flag to indicate that the server allows the client to create new identities on the server. If the update operation is used (client) or allowed (server) to a new location where a resource doesn't already exist. This means that the server allows the client to create new identities on the server")
        private BooleanDt myUpdateCreate;
        @Child(name="searchInclude", type={StringDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="_include values supported by the server", formalDefinition="A list of _include values supported by the server")
        private List<StringDt> mySearchInclude;
        @Child(name="searchParam", order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Additional search params defined", formalDefinition="Additional search parameters for implementations to support and/or make use of")
        private List<RestResourceSearchParam> mySearchParam;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myProfile, this.myOperation, this.myReadHistory, this.myUpdateCreate, this.mySearchInclude, this.mySearchParam});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myProfile, this.myOperation, this.myReadHistory, this.myUpdateCreate, this.mySearchInclude, this.mySearchParam});
        }

        public BoundCodeDt<ResourceTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<ResourceTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public RestResource setType(BoundCodeDt<ResourceTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public RestResource setType(ResourceTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public ResourceReferenceDt getProfileElement() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public RestResource setProfile(ResourceReferenceDt theValue) {
            this.myProfile = theValue;
            return this;
        }

        public List<RestResourceOperation> getOperation() {
            if (this.myOperation == null) {
                this.myOperation = new ArrayList<RestResourceOperation>();
            }
            return this.myOperation;
        }

        public List<RestResourceOperation> getOperationElement() {
            if (this.myOperation == null) {
                this.myOperation = new ArrayList<RestResourceOperation>();
            }
            return this.myOperation;
        }

        public RestResource setOperation(List<RestResourceOperation> theValue) {
            this.myOperation = theValue;
            return this;
        }

        public RestResourceOperation addOperation() {
            RestResourceOperation newType = new RestResourceOperation();
            this.getOperation().add(newType);
            return newType;
        }

        public RestResourceOperation getOperationFirstRep() {
            if (this.getOperation().isEmpty()) {
                return this.addOperation();
            }
            return this.getOperation().get(0);
        }

        public BooleanDt getReadHistory() {
            if (this.myReadHistory == null) {
                this.myReadHistory = new BooleanDt();
            }
            return this.myReadHistory;
        }

        public BooleanDt getReadHistoryElement() {
            if (this.myReadHistory == null) {
                this.myReadHistory = new BooleanDt();
            }
            return this.myReadHistory;
        }

        public RestResource setReadHistory(BooleanDt theValue) {
            this.myReadHistory = theValue;
            return this;
        }

        public RestResource setReadHistory(boolean theBoolean) {
            this.myReadHistory = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getUpdateCreate() {
            if (this.myUpdateCreate == null) {
                this.myUpdateCreate = new BooleanDt();
            }
            return this.myUpdateCreate;
        }

        public BooleanDt getUpdateCreateElement() {
            if (this.myUpdateCreate == null) {
                this.myUpdateCreate = new BooleanDt();
            }
            return this.myUpdateCreate;
        }

        public RestResource setUpdateCreate(BooleanDt theValue) {
            this.myUpdateCreate = theValue;
            return this;
        }

        public RestResource setUpdateCreate(boolean theBoolean) {
            this.myUpdateCreate = new BooleanDt(theBoolean);
            return this;
        }

        public List<StringDt> getSearchInclude() {
            if (this.mySearchInclude == null) {
                this.mySearchInclude = new ArrayList<StringDt>();
            }
            return this.mySearchInclude;
        }

        public List<StringDt> getSearchIncludeElement() {
            if (this.mySearchInclude == null) {
                this.mySearchInclude = new ArrayList<StringDt>();
            }
            return this.mySearchInclude;
        }

        public RestResource setSearchInclude(List<StringDt> theValue) {
            this.mySearchInclude = theValue;
            return this;
        }

        public StringDt addSearchInclude() {
            StringDt newType = new StringDt();
            this.getSearchInclude().add(newType);
            return newType;
        }

        public StringDt getSearchIncludeFirstRep() {
            if (this.getSearchInclude().isEmpty()) {
                return this.addSearchInclude();
            }
            return this.getSearchInclude().get(0);
        }

        public RestResource addSearchInclude(String theString) {
            if (this.mySearchInclude == null) {
                this.mySearchInclude = new ArrayList<StringDt>();
            }
            this.mySearchInclude.add(new StringDt(theString));
            return this;
        }

        public List<RestResourceSearchParam> getSearchParam() {
            if (this.mySearchParam == null) {
                this.mySearchParam = new ArrayList<RestResourceSearchParam>();
            }
            return this.mySearchParam;
        }

        public List<RestResourceSearchParam> getSearchParamElement() {
            if (this.mySearchParam == null) {
                this.mySearchParam = new ArrayList<RestResourceSearchParam>();
            }
            return this.mySearchParam;
        }

        public RestResource setSearchParam(List<RestResourceSearchParam> theValue) {
            this.mySearchParam = theValue;
            return this;
        }

        public RestResourceSearchParam addSearchParam() {
            RestResourceSearchParam newType = new RestResourceSearchParam();
            this.getSearchParam().add(newType);
            return newType;
        }

        public RestResourceSearchParam getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                return this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }
    }

    @Block
    public static class RestSecurityCertificate
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Mime type for certificate", formalDefinition="Mime type for certificate")
        private CodeDt myType;
        @Child(name="blob", type={Base64BinaryDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Actual certificate", formalDefinition="Actual certificate")
        private Base64BinaryDt myBlob;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myBlob});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myBlob});
        }

        public CodeDt getType() {
            if (this.myType == null) {
                this.myType = new CodeDt();
            }
            return this.myType;
        }

        public CodeDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeDt();
            }
            return this.myType;
        }

        public RestSecurityCertificate setType(CodeDt theValue) {
            this.myType = theValue;
            return this;
        }

        public RestSecurityCertificate setType(String theCode) {
            this.myType = new CodeDt(theCode);
            return this;
        }

        public Base64BinaryDt getBlob() {
            if (this.myBlob == null) {
                this.myBlob = new Base64BinaryDt();
            }
            return this.myBlob;
        }

        public Base64BinaryDt getBlobElement() {
            if (this.myBlob == null) {
                this.myBlob = new Base64BinaryDt();
            }
            return this.myBlob;
        }

        public RestSecurityCertificate setBlob(Base64BinaryDt theValue) {
            this.myBlob = theValue;
            return this;
        }

        public RestSecurityCertificate setBlob(byte[] theBytes) {
            this.myBlob = new Base64BinaryDt(theBytes);
            return this;
        }
    }

    @Block
    public static class RestSecurity
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="cors", type={BooleanDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Adds CORS Headers (http://enable-cors.org/)", formalDefinition="Server adds CORS headers when responding to requests - this enables javascript applications to yuse the server")
        private BooleanDt myCors;
        @Child(name="service", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="OAuth | OAuth2 | NTLM | Basic | Kerberos", formalDefinition="Types of security services are supported/required by the system")
        private List<BoundCodeableConceptDt<RestfulSecurityServiceEnum>> myService;
        @Child(name="description", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="General description of how security works", formalDefinition="General description of how security works")
        private StringDt myDescription;
        @Child(name="certificate", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Certificates associated with security profiles", formalDefinition="Certificates associated with security profiles")
        private List<RestSecurityCertificate> myCertificate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCors, this.myService, this.myDescription, this.myCertificate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCors, this.myService, this.myDescription, this.myCertificate});
        }

        public BooleanDt getCors() {
            if (this.myCors == null) {
                this.myCors = new BooleanDt();
            }
            return this.myCors;
        }

        public BooleanDt getCorsElement() {
            if (this.myCors == null) {
                this.myCors = new BooleanDt();
            }
            return this.myCors;
        }

        public RestSecurity setCors(BooleanDt theValue) {
            this.myCors = theValue;
            return this;
        }

        public RestSecurity setCors(boolean theBoolean) {
            this.myCors = new BooleanDt(theBoolean);
            return this;
        }

        public List<BoundCodeableConceptDt<RestfulSecurityServiceEnum>> getService() {
            if (this.myService == null) {
                this.myService = new ArrayList<BoundCodeableConceptDt<RestfulSecurityServiceEnum>>();
            }
            return this.myService;
        }

        public List<BoundCodeableConceptDt<RestfulSecurityServiceEnum>> getServiceElement() {
            if (this.myService == null) {
                this.myService = new ArrayList<BoundCodeableConceptDt<RestfulSecurityServiceEnum>>();
            }
            return this.myService;
        }

        public RestSecurity setService(List<BoundCodeableConceptDt<RestfulSecurityServiceEnum>> theValue) {
            this.myService = theValue;
            return this;
        }

        public BoundCodeableConceptDt<RestfulSecurityServiceEnum> addService(RestfulSecurityServiceEnum theValue) {
            BoundCodeableConceptDt<RestfulSecurityServiceEnum> retVal = new BoundCodeableConceptDt<RestfulSecurityServiceEnum>(RestfulSecurityServiceEnum.VALUESET_BINDER, theValue);
            this.getService().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<RestfulSecurityServiceEnum> getServiceFirstRep() {
            if (this.getService().size() == 0) {
                this.addService();
            }
            return this.getService().get(0);
        }

        public BoundCodeableConceptDt<RestfulSecurityServiceEnum> addService() {
            BoundCodeableConceptDt<RestfulSecurityServiceEnum> retVal = new BoundCodeableConceptDt<RestfulSecurityServiceEnum>(RestfulSecurityServiceEnum.VALUESET_BINDER);
            this.getService().add(retVal);
            return retVal;
        }

        public RestSecurity setService(RestfulSecurityServiceEnum theValue) {
            this.getService().clear();
            this.addService(theValue);
            return this;
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public RestSecurity setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public RestSecurity setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public List<RestSecurityCertificate> getCertificate() {
            if (this.myCertificate == null) {
                this.myCertificate = new ArrayList<RestSecurityCertificate>();
            }
            return this.myCertificate;
        }

        public List<RestSecurityCertificate> getCertificateElement() {
            if (this.myCertificate == null) {
                this.myCertificate = new ArrayList<RestSecurityCertificate>();
            }
            return this.myCertificate;
        }

        public RestSecurity setCertificate(List<RestSecurityCertificate> theValue) {
            this.myCertificate = theValue;
            return this;
        }

        public RestSecurityCertificate addCertificate() {
            RestSecurityCertificate newType = new RestSecurityCertificate();
            this.getCertificate().add(newType);
            return newType;
        }

        public RestSecurityCertificate getCertificateFirstRep() {
            if (this.getCertificate().isEmpty()) {
                return this.addCertificate();
            }
            return this.getCertificate().get(0);
        }
    }

    @Block
    public static class Rest
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="mode", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="client | server", formalDefinition="Identifies whether this portion of the statement is describing ability to initiate or receive restful operations")
        private BoundCodeDt<RestfulConformanceModeEnum> myMode;
        @Child(name="documentation", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="General description of implementation", formalDefinition="Information about the system's restful capabilities that apply across all applications, such as security")
        private StringDt myDocumentation;
        @Child(name="security", order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Information about security of implementation", formalDefinition="Information about security of implementation")
        private RestSecurity mySecurity;
        @Child(name="resource", order=3, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Resource served on the REST interface", formalDefinition="A specification of the restful capabilities of the solution for a specific resource type")
        private List<RestResource> myResource;
        @Child(name="operation", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="A specification of restful operations supported by the system")
        private List<RestOperation> myOperation;
        @Child(name="query", order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Definition of a named query", formalDefinition="Definition of a named query and its parameters and their meaning")
        private List<RestQuery> myQuery;
        @Child(name="documentMailbox", type={UriDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="How documents are accepted in /Mailbox", formalDefinition="A list of profiles that this server implements for accepting documents in the mailbox. If this list is empty, then documents are not accepted. The base specification has the profile identifier \"http://hl7.org/fhir/documents/mailbox\". Other specifications can declare their own identifier for this purpose")
        private List<UriDt> myDocumentMailbox;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMode, this.myDocumentation, this.mySecurity, this.myResource, this.myOperation, this.myQuery, this.myDocumentMailbox});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMode, this.myDocumentation, this.mySecurity, this.myResource, this.myOperation, this.myQuery, this.myDocumentMailbox});
        }

        public BoundCodeDt<RestfulConformanceModeEnum> getMode() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(RestfulConformanceModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public BoundCodeDt<RestfulConformanceModeEnum> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new BoundCodeDt(RestfulConformanceModeEnum.VALUESET_BINDER);
            }
            return this.myMode;
        }

        public Rest setMode(BoundCodeDt<RestfulConformanceModeEnum> theValue) {
            this.myMode = theValue;
            return this;
        }

        public Rest setMode(RestfulConformanceModeEnum theValue) {
            this.getMode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public Rest setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Rest setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public RestSecurity getSecurity() {
            if (this.mySecurity == null) {
                this.mySecurity = new RestSecurity();
            }
            return this.mySecurity;
        }

        public RestSecurity getSecurityElement() {
            if (this.mySecurity == null) {
                this.mySecurity = new RestSecurity();
            }
            return this.mySecurity;
        }

        public Rest setSecurity(RestSecurity theValue) {
            this.mySecurity = theValue;
            return this;
        }

        public List<RestResource> getResource() {
            if (this.myResource == null) {
                this.myResource = new ArrayList<RestResource>();
            }
            return this.myResource;
        }

        public List<RestResource> getResourceElement() {
            if (this.myResource == null) {
                this.myResource = new ArrayList<RestResource>();
            }
            return this.myResource;
        }

        public Rest setResource(List<RestResource> theValue) {
            this.myResource = theValue;
            return this;
        }

        public RestResource addResource() {
            RestResource newType = new RestResource();
            this.getResource().add(newType);
            return newType;
        }

        public RestResource getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                return this.addResource();
            }
            return this.getResource().get(0);
        }

        public List<RestOperation> getOperation() {
            if (this.myOperation == null) {
                this.myOperation = new ArrayList<RestOperation>();
            }
            return this.myOperation;
        }

        public List<RestOperation> getOperationElement() {
            if (this.myOperation == null) {
                this.myOperation = new ArrayList<RestOperation>();
            }
            return this.myOperation;
        }

        public Rest setOperation(List<RestOperation> theValue) {
            this.myOperation = theValue;
            return this;
        }

        public RestOperation addOperation() {
            RestOperation newType = new RestOperation();
            this.getOperation().add(newType);
            return newType;
        }

        public RestOperation getOperationFirstRep() {
            if (this.getOperation().isEmpty()) {
                return this.addOperation();
            }
            return this.getOperation().get(0);
        }

        public List<RestQuery> getQuery() {
            if (this.myQuery == null) {
                this.myQuery = new ArrayList<RestQuery>();
            }
            return this.myQuery;
        }

        public List<RestQuery> getQueryElement() {
            if (this.myQuery == null) {
                this.myQuery = new ArrayList<RestQuery>();
            }
            return this.myQuery;
        }

        public Rest setQuery(List<RestQuery> theValue) {
            this.myQuery = theValue;
            return this;
        }

        public RestQuery addQuery() {
            RestQuery newType = new RestQuery();
            this.getQuery().add(newType);
            return newType;
        }

        public RestQuery getQueryFirstRep() {
            if (this.getQuery().isEmpty()) {
                return this.addQuery();
            }
            return this.getQuery().get(0);
        }

        public List<UriDt> getDocumentMailbox() {
            if (this.myDocumentMailbox == null) {
                this.myDocumentMailbox = new ArrayList<UriDt>();
            }
            return this.myDocumentMailbox;
        }

        public List<UriDt> getDocumentMailboxElement() {
            if (this.myDocumentMailbox == null) {
                this.myDocumentMailbox = new ArrayList<UriDt>();
            }
            return this.myDocumentMailbox;
        }

        public Rest setDocumentMailbox(List<UriDt> theValue) {
            this.myDocumentMailbox = theValue;
            return this;
        }

        public UriDt addDocumentMailbox() {
            UriDt newType = new UriDt();
            this.getDocumentMailbox().add(newType);
            return newType;
        }

        public UriDt getDocumentMailboxFirstRep() {
            if (this.getDocumentMailbox().isEmpty()) {
                return this.addDocumentMailbox();
            }
            return this.getDocumentMailbox().get(0);
        }

        public Rest addDocumentMailbox(String theUri) {
            if (this.myDocumentMailbox == null) {
                this.myDocumentMailbox = new ArrayList<UriDt>();
            }
            this.myDocumentMailbox.add(new UriDt(theUri));
            return this;
        }
    }

    @Block
    public static class Implementation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="description", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="Describes this specific instance", formalDefinition="Information about the specific installation that this conformance statement relates to")
        private StringDt myDescription;
        @Child(name="url", type={UriDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="Base URL for the installation", formalDefinition="A base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.")
        private UriDt myUrl;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDescription, this.myUrl});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDescription, this.myUrl});
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public Implementation setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Implementation setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public UriDt getUrl() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public Implementation setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public Implementation setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Software
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="A name the software is known by", formalDefinition="Name software is known by")
        private StringDt myName;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="Version covered by this statement", formalDefinition="The version identifier for the software covered by this statement")
        private StringDt myVersion;
        @Child(name="releaseDate", type={DateTimeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="Date this version released", formalDefinition="Date this version of the software released")
        private DateTimeDt myReleaseDate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myVersion, this.myReleaseDate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myVersion, this.myReleaseDate});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Software setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Software setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getVersion() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public Software setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public Software setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public DateTimeDt getReleaseDate() {
            if (this.myReleaseDate == null) {
                this.myReleaseDate = new DateTimeDt();
            }
            return this.myReleaseDate;
        }

        public DateTimeDt getReleaseDateElement() {
            if (this.myReleaseDate == null) {
                this.myReleaseDate = new DateTimeDt();
            }
            return this.myReleaseDate;
        }

        public Software setReleaseDate(DateTimeDt theValue) {
            this.myReleaseDate = theValue;
            return this;
        }

        public Software setReleaseDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myReleaseDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Software setReleaseDateWithSecondsPrecision(Date theDate) {
            this.myReleaseDate = new DateTimeDt(theDate);
            return this;
        }
    }
}

