/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.instance.model.api.IIdType;

@DatatypeDef(name="ResourceReferenceDt")
public class ResourceReferenceDt
extends BaseResourceReferenceDt
implements ICompositeDatatype {
    @Child(name="reference", type={IdDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="Relative, internal or absolute URL reference", formalDefinition="A reference to a location at which the other resource is found. The reference may a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources")
    private IdDt myReference;
    @Child(name="display", type={StringDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Text alternative for the resource", formalDefinition="Plain text narrative that identifies the resource in addition to the resource reference")
    private StringDt myDisplay;

    public ResourceReferenceDt() {
    }

    @SimpleSetter
    public ResourceReferenceDt(IResource theResource) {
        super(theResource);
    }

    public ResourceReferenceDt(String theId) {
        this.setReference(new IdDt(theId));
    }

    public ResourceReferenceDt(IIdType theResourceId) {
        this.setReference(theResourceId);
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myReference, this.myDisplay});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myReference, this.myDisplay});
    }

    public IdDt getReference() {
        if (this.myReference == null) {
            this.myReference = new IdDt();
        }
        return this.myReference;
    }

    public IdDt getReferenceElement() {
        return this.getReference();
    }

    public ResourceReferenceDt setReference(IdDt theValue) {
        this.myReference = theValue;
        return this;
    }

    public ResourceReferenceDt setReference(String theId) {
        this.myReference = new IdDt(theId);
        return this;
    }

    public StringDt getDisplay() {
        if (this.myDisplay == null) {
            this.myDisplay = new StringDt();
        }
        return this.myDisplay;
    }

    public ResourceReferenceDt setDisplay(StringDt theValue) {
        this.myDisplay = theValue;
        return this;
    }

    public ResourceReferenceDt setDisplay(String theString) {
        this.myDisplay = new StringDt(theString);
        return this;
    }

    public StringDt getDisplayElement() {
        return this.getDisplay();
    }
}

