/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.valueset.AddressUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@DatatypeDef(name="AddressDt")
public class AddressDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="use", type={CodeDt.class}, order=0, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="home | work | temp | old - purpose of this address", formalDefinition="The purpose of this address")
    private BoundCodeDt<AddressUseEnum> myUse;
    @Child(name="text", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Text representation of the address", formalDefinition="A full text representation of the address")
    private StringDt myText;
    @Child(name="line", type={StringDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Street name, number, direction & P.O. Box etc", formalDefinition="This component contains the house number, apartment number, street name, street direction, P.O. Box number, delivery hints, and similar address information")
    private List<StringDt> myLine;
    @Child(name="city", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Name of city, town etc.", formalDefinition="The name of the city, town, village or other community or delivery center.")
    private StringDt myCity;
    @Child(name="state", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Sub-unit of country (abreviations ok)", formalDefinition="Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (i.e. US 2 letter state codes).")
    private StringDt myState;
    @Child(name="zip", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Postal code for area", formalDefinition="A postal code designating a region defined by the postal service.")
    private StringDt myZip;
    @Child(name="country", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Country (can be ISO 3166 3 letter code)", formalDefinition="Country - a nation as commonly understood or generally accepted")
    private StringDt myCountry;
    @Child(name="period", type={PeriodDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Time period when address was/is in use", formalDefinition="Time period when address was/is in use")
    private PeriodDt myPeriod;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUse, this.myText, this.myLine, this.myCity, this.myState, this.myZip, this.myCountry, this.myPeriod});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUse, this.myText, this.myLine, this.myCity, this.myState, this.myZip, this.myCountry, this.myPeriod});
    }

    public BoundCodeDt<AddressUseEnum> getUse() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(AddressUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public BoundCodeDt<AddressUseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(AddressUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public AddressDt setUse(BoundCodeDt<AddressUseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public AddressDt setUse(AddressUseEnum theValue) {
        this.getUse().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getText() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public StringDt getTextElement() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public AddressDt setText(StringDt theValue) {
        this.myText = theValue;
        return this;
    }

    public AddressDt setText(String theString) {
        this.myText = new StringDt(theString);
        return this;
    }

    public List<StringDt> getLine() {
        if (this.myLine == null) {
            this.myLine = new ArrayList<StringDt>();
        }
        return this.myLine;
    }

    public List<StringDt> getLineElement() {
        if (this.myLine == null) {
            this.myLine = new ArrayList<StringDt>();
        }
        return this.myLine;
    }

    public AddressDt setLine(List<StringDt> theValue) {
        this.myLine = theValue;
        return this;
    }

    public StringDt addLine() {
        StringDt newType = new StringDt();
        this.getLine().add(newType);
        return newType;
    }

    public StringDt getLineFirstRep() {
        if (this.getLine().isEmpty()) {
            return this.addLine();
        }
        return this.getLine().get(0);
    }

    public AddressDt addLine(String theString) {
        if (this.myLine == null) {
            this.myLine = new ArrayList<StringDt>();
        }
        this.myLine.add(new StringDt(theString));
        return this;
    }

    public StringDt getCity() {
        if (this.myCity == null) {
            this.myCity = new StringDt();
        }
        return this.myCity;
    }

    public StringDt getCityElement() {
        if (this.myCity == null) {
            this.myCity = new StringDt();
        }
        return this.myCity;
    }

    public AddressDt setCity(StringDt theValue) {
        this.myCity = theValue;
        return this;
    }

    public AddressDt setCity(String theString) {
        this.myCity = new StringDt(theString);
        return this;
    }

    public StringDt getState() {
        if (this.myState == null) {
            this.myState = new StringDt();
        }
        return this.myState;
    }

    public StringDt getStateElement() {
        if (this.myState == null) {
            this.myState = new StringDt();
        }
        return this.myState;
    }

    public AddressDt setState(StringDt theValue) {
        this.myState = theValue;
        return this;
    }

    public AddressDt setState(String theString) {
        this.myState = new StringDt(theString);
        return this;
    }

    public StringDt getZip() {
        if (this.myZip == null) {
            this.myZip = new StringDt();
        }
        return this.myZip;
    }

    public StringDt getZipElement() {
        if (this.myZip == null) {
            this.myZip = new StringDt();
        }
        return this.myZip;
    }

    public AddressDt setZip(StringDt theValue) {
        this.myZip = theValue;
        return this;
    }

    public AddressDt setZip(String theString) {
        this.myZip = new StringDt(theString);
        return this;
    }

    public StringDt getCountry() {
        if (this.myCountry == null) {
            this.myCountry = new StringDt();
        }
        return this.myCountry;
    }

    public StringDt getCountryElement() {
        if (this.myCountry == null) {
            this.myCountry = new StringDt();
        }
        return this.myCountry;
    }

    public AddressDt setCountry(StringDt theValue) {
        this.myCountry = theValue;
        return this;
    }

    public AddressDt setCountry(String theString) {
        this.myCountry = new StringDt(theString);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public AddressDt setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }
}

