/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.tasks;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.tasks.api.ISchemaInitializationProvider;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SchemaInitializationProvider
implements ISchemaInitializationProvider {
    private final String mySchemaExistsIndicatorTable;
    private final boolean myCanInitializeSchema;
    private String mySchemaFileClassPath;
    private String mySchemaDescription;

    public SchemaInitializationProvider(String theSchemaDescription, String theSchemaFileClassPath, String theSchemaExistsIndicatorTable, boolean theCanInitializeSchema) {
        this.mySchemaDescription = theSchemaDescription;
        this.mySchemaFileClassPath = theSchemaFileClassPath;
        this.mySchemaExistsIndicatorTable = theSchemaExistsIndicatorTable;
        this.myCanInitializeSchema = theCanInitializeSchema;
    }

    @Override
    public List<String> getSqlStatements(DriverTypeEnum theDriverType) {
        ArrayList<String> retval = new ArrayList<String>();
        String initScript = this.mySchemaFileClassPath + "/" + this.getInitScript(theDriverType);
        try {
            String[] statements;
            InputStream sqlFileInputStream = SchemaInitializationProvider.class.getResourceAsStream(initScript);
            if (sqlFileInputStream == null) {
                throw new ConfigurationException(Msg.code((int)49) + "Schema initialization script " + initScript + " not found on classpath");
            }
            String sqlString = IOUtils.toString((InputStream)sqlFileInputStream, (Charset)Charsets.UTF_8);
            String sqlStringNoComments = this.preProcessSqlString(theDriverType, sqlString);
            for (String statement : statements = sqlStringNoComments.split("\\;")) {
                String cleanedStatement = this.preProcessSqlStatement(theDriverType, statement);
                if (StringUtils.isBlank((CharSequence)cleanedStatement)) continue;
                retval.add(cleanedStatement);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(Msg.code((int)50) + "Error reading schema initialization script " + initScript, (Throwable)e);
        }
        return retval;
    }

    protected String preProcessSqlString(DriverTypeEnum theDriverType, String sqlString) {
        return sqlString;
    }

    protected String preProcessSqlStatement(DriverTypeEnum theDriverType, String sqlStatement) {
        return sqlStatement;
    }

    @Nonnull
    protected String getInitScript(DriverTypeEnum theDriverType) {
        return theDriverType.getSchemaFilename();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        SchemaInitializationProvider that = (SchemaInitializationProvider)theO;
        return this.getClass().getSimpleName() == that.getClass().getSimpleName();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getClass().getSimpleName()).toHashCode();
    }

    @Override
    public String getSchemaExistsIndicatorTable() {
        return this.mySchemaExistsIndicatorTable;
    }

    public SchemaInitializationProvider setSchemaFileClassPath(String theSchemaFileClassPath) {
        this.mySchemaFileClassPath = theSchemaFileClassPath;
        return this;
    }

    @Override
    public String getSchemaDescription() {
        return this.mySchemaDescription;
    }

    @Override
    public SchemaInitializationProvider setSchemaDescription(String theSchemaDescription) {
        this.mySchemaDescription = theSchemaDescription;
        return this;
    }

    @Override
    public boolean canInitializeSchema() {
        return this.myCanInitializeSchema;
    }
}

