/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.AddColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTableByColumnTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddTableByColumnTask.class);
    private List<AddColumnTask> myAddColumnTasks = new ArrayList<AddColumnTask>();
    private List<String> myPkColumns;

    public AddTableByColumnTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Add table " + this.getTableName());
    }

    public void addAddColumnTask(AddColumnTask theTask) {
        Validate.notNull((Object)theTask);
        this.myAddColumnTasks.add(theTask);
    }

    public void setPkColumns(List<String> thePkColumns) {
        this.myPkColumns = thePkColumns;
    }

    @Override
    public void doExecute() throws SQLException {
        if (JdbcUtils.getTableNames(this.getConnectionProperties()).contains(this.getTableName())) {
            this.logInfo(ourLog, "Already have table named {} - No action performed", this.getTableName());
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.getTableName());
        sb.append(" ( ");
        for (AddColumnTask next : this.myAddColumnTasks) {
            next.setDriverType(this.getDriverType());
            next.setTableName(this.getTableName());
            next.validate();
            sb.append(next.getColumnName());
            sb.append(" ");
            sb.append(next.getTypeStatement());
            sb.append(", ");
        }
        sb.append(" PRIMARY KEY (");
        for (int i = 0; i < this.myPkColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.myPkColumns.get(i));
        }
        sb.append(")");
        sb.append(" ) ");
        switch (this.getDriverType()) {
            case MARIADB_10_1: 
            case MYSQL_5_7: {
                sb.append("engine=InnoDB");
                break;
            }
        }
        this.executeSql(this.getTableName(), sb.toString(), new Object[0]);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        super.generateEquals(theBuilder, theOtherObject);
        AddTableByColumnTask otherObject = (AddTableByColumnTask)theOtherObject;
        theBuilder.append(this.myAddColumnTasks, otherObject.myAddColumnTasks);
        theBuilder.append(this.myPkColumns, otherObject.myPkColumns);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append(this.myAddColumnTasks);
        theBuilder.append(this.myPkColumns);
    }
}

