/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.BaseMigrator;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.flywaydb.core.api.MigrationInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskOnlyMigrator
extends BaseMigrator {
    private static final Logger ourLog = LoggerFactory.getLogger(TaskOnlyMigrator.class);
    private List<BaseTask> myTasks = new ArrayList<BaseTask>();

    @Override
    public void migrate() {
        DriverTypeEnum.ConnectionProperties connectionProperties = this.getDriverType().newConnectionProperties(this.getDataSource());
        for (BaseTask next : this.myTasks) {
            next.setDriverType(this.getDriverType());
            next.setDryRun(this.isDryRun());
            next.setNoColumnShrink(this.isNoColumnShrink());
            next.setConnectionProperties(connectionProperties);
            try {
                if (this.isDryRun()) {
                    ourLog.info("Dry run {} {}", (Object)next.getFlywayVersion(), (Object)next.getDescription());
                } else {
                    ourLog.info("Executing {} {}", (Object)next.getFlywayVersion(), (Object)next.getDescription());
                }
                next.execute();
                this.addExecutedStatements(next.getExecutedStatements());
            }
            catch (SQLException e) {
                throw new InternalErrorException(Msg.code((int)48) + e);
            }
        }
        if (this.isDryRun()) {
            StringBuilder statementBuilder = this.buildExecutedStatementsString();
            ourLog.info("SQL that would be executed:\n\n***********************************\n{}***********************************", (Object)statementBuilder);
        }
    }

    @Override
    public Optional<MigrationInfoService> getMigrationInfo() {
        return Optional.empty();
    }

    @Override
    public void addTasks(List<BaseTask> theMigrationTasks) {
        this.myTasks.addAll(theMigrationTasks);
    }
}

