/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public class NarrativeUtil {
    private NarrativeUtil() {
    }

    public static String sanitize(String theHtml) {
        XhtmlNode node = new XhtmlNode();
        node.setValueAsString(theHtml);
        return NarrativeUtil.sanitize(node).getValueAsString();
    }

    public static XhtmlNode sanitize(XhtmlNode theNode) {
        String html = theNode.getValueAsString();
        PolicyFactory idPolicy = new HtmlPolicyBuilder().allowAttributes(new String[]{"id"}).globally().toFactory();
        PolicyFactory policy = Sanitizers.FORMATTING.and(Sanitizers.BLOCKS).and(Sanitizers.TABLES).and(Sanitizers.STYLES).and(idPolicy);
        String safeHTML = policy.sanitize(html);
        XhtmlNode retVal = new XhtmlNode();
        retVal.setValueAsString(safeHTML);
        return retVal;
    }
}

