/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation.helpers;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.PropertyModifyingHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;

public class AddressHelper
extends PropertyModifyingHelper {
    public static final String FIELD_LINE = "line";
    public static final String FIELD_CITY = "city";
    public static final String FIELD_TEXT = "text";
    public static final String FIELD_DISTRICT = "district";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_POSTAL = "postalCode";
    public static final String FIELD_COUNTRY = "country";
    public static final String[] FIELD_NAMES = new String[]{"text", "line", "city", "district", "state", "postalCode", "country"};
    public static final String[] ADDRESS_PARTS = new String[]{"city", "district", "state", "postalCode"};

    public AddressHelper(FhirContext theFhirContext, IBase theBase) {
        super(theFhirContext, theBase);
    }

    public String getCountry() {
        return this.get(FIELD_COUNTRY);
    }

    public String getCity() {
        return this.get(FIELD_CITY);
    }

    public String getState() {
        return this.get(FIELD_STATE);
    }

    public String getPostalCode() {
        return this.get(FIELD_POSTAL);
    }

    public String getText() {
        return this.get(FIELD_TEXT);
    }

    public void setCountry(String theCountry) {
        this.set(FIELD_COUNTRY, theCountry);
    }

    public void setCity(String theCity) {
        this.set(FIELD_CITY, theCity);
    }

    public void setState(String theState) {
        this.set(FIELD_STATE, theState);
    }

    public void setPostalCode(String thePostal) {
        this.set(FIELD_POSTAL, thePostal);
    }

    public void setText(String theText) {
        this.set(FIELD_TEXT, theText);
    }

    public String getParts() {
        return Arrays.stream(ADDRESS_PARTS).map(arg_0 -> ((AddressHelper)this).get(arg_0)).filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.joining(this.getDelimiter()));
    }

    public String getLine() {
        return this.get(FIELD_LINE);
    }

    public List<String> getLines() {
        return this.getMultiple(FIELD_LINE);
    }

    public AddressHelper addLine(String theLine) {
        this.set(FIELD_LINE, theLine);
        return this;
    }

    public <T> T getAddress() {
        return (T)this.getBase();
    }

    public String toString() {
        return this.getFields(FIELD_NAMES);
    }
}

