/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.s13n.standardizers;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.interceptor.ConfigLoader;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.Range;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class NoiseCharacters {
    private static final int RANGE_THRESHOLD = 150;
    private Set<Integer> myNoiseCharacters = new HashSet<Integer>();
    private Set<Range> myNoiseCharacterRanges = new HashSet<Range>();
    private int size;

    public int getSize() {
        return this.myNoiseCharacters.size();
    }

    public void initializeFromClasspath() {
        String noiseChars = ConfigLoader.loadResourceContent("classpath:noise-chars.txt");
        try (Scanner scanner = new Scanner(noiseChars);){
            while (scanner.hasNext()) {
                this.parse(scanner.nextLine());
            }
        }
    }

    public boolean isNoise(int theChar) {
        if (this.myNoiseCharacters.contains(theChar)) {
            return true;
        }
        for (Range r : this.myNoiseCharacterRanges) {
            if (!r.isInRange(theChar)) continue;
            return true;
        }
        return false;
    }

    private void parse(String theString) {
        if (theString.contains("-")) {
            this.addRange(theString);
        } else {
            this.add(theString);
        }
    }

    public NoiseCharacters add(String theLiteral) {
        this.myNoiseCharacters.add(this.toInt(theLiteral));
        return this;
    }

    public NoiseCharacters addRange(String theRange) {
        if (!theRange.contains("-")) {
            throw new IllegalArgumentException(Msg.code((int)350) + String.format("Invalid range %s", theRange));
        }
        String[] range = theRange.split("-");
        if (range.length < 2) {
            throw new IllegalArgumentException(Msg.code((int)351) + String.format("Invalid range %s", theRange));
        }
        this.addRange(range[0].trim(), range[1].trim());
        return this;
    }

    public NoiseCharacters addRange(String theLowerBound, String theUpperBound) {
        int upper;
        int lower = this.toInt(theLowerBound);
        if (lower > (upper = this.toInt(theUpperBound))) {
            throw new IllegalArgumentException(Msg.code((int)352) + String.format("Invalid character range %s-%s", theLowerBound, theUpperBound));
        }
        if (upper - lower >= 150) {
            this.myNoiseCharacterRanges.add(new Range(lower, upper));
            return this;
        }
        for (int i = lower; i <= upper; ++i) {
            this.myNoiseCharacters.add(i);
        }
        return this;
    }

    private int toInt(String theLiteral) {
        if (!theLiteral.startsWith("#x")) {
            throw new IllegalArgumentException(Msg.code((int)353) + "Unable to parse " + theLiteral);
        }
        return Integer.parseInt(theLiteral.substring(2), 16);
    }
}

