/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuleTarget {
    IBaseResource resource;
    Collection<IIdType> resourceIds = null;
    String resourceType = null;
    private Map<String, String[]> mySearchParams = null;

    public Map<String, String[]> getSearchParams() {
        return this.mySearchParams;
    }

    public void setSearchParams(RequestDetails theRequestDetails) {
        this.mySearchParams = this.stripMdmSuffix(theRequestDetails.getParameters());
    }

    private Map<String, String[]> stripMdmSuffix(Map<String, String[]> theParameters) {
        HashMap<String, String[]> retval = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : theParameters.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            key = this.stripMdmQualifier(key);
            key = this.stripNicknameQualifier(key);
            retval.put(key, value);
        }
        return retval;
    }

    private String stripMdmQualifier(String theKey) {
        if (theKey.endsWith(":mdm")) {
            theKey = theKey.split(":mdm")[0];
        }
        return theKey;
    }

    private String stripNicknameQualifier(String theKey) {
        if (theKey.endsWith(":nickname")) {
            theKey = theKey.split(":nickname")[0];
        }
        return theKey;
    }
}

