/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.util.ClasspathUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    private static final Logger ourLog = LoggerFactory.getLogger(ConfigLoader.class);
    public static final String CLASSPATH = "classpath:";

    public static String loadResourceContent(String theResourcePath) {
        if (theResourcePath.startsWith(CLASSPATH)) {
            theResourcePath = theResourcePath.substring(CLASSPATH.length());
        }
        return ClasspathUtil.loadResource((String)theResourcePath);
    }

    public static Properties loadProperties(String theResourcePath) {
        String propsString = ConfigLoader.loadResourceContent(theResourcePath);
        Properties props = new Properties();
        try {
            props.load(new StringReader(propsString));
        }
        catch (IOException e) {
            throw new RuntimeException(Msg.code((int)324) + String.format("Unable to load properties at %s", theResourcePath), e);
        }
        return props;
    }

    public static <T> T loadJson(String theResourcePath, Class<T> theModelClass) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(ConfigLoader.loadResourceContent(theResourcePath), theModelClass);
        }
        catch (Exception e) {
            throw new RuntimeException(Msg.code((int)325) + String.format("Unable to parse resource at %s", theResourcePath), e);
        }
    }
}

