/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.rest.server.provider.IResourceProviderFactoryObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ResourceProviderFactory {
    private Set<IResourceProviderFactoryObserver> myObservers = Collections.synchronizedSet(new HashSet());
    private List<Supplier<Object>> mySuppliers = new ArrayList<Supplier<Object>>();

    public void addSupplier(@Nonnull Supplier<Object> theSupplier) {
        this.mySuppliers.add(theSupplier);
        this.myObservers.forEach(observer -> observer.update(theSupplier));
    }

    public void removeSupplier(@Nonnull Supplier<Object> theSupplier) {
        this.mySuppliers.remove(theSupplier);
        this.myObservers.forEach(observer -> observer.remove(theSupplier));
    }

    public List<Object> createProviders() {
        ArrayList<Object> retVal = new ArrayList<Object>();
        for (Supplier<Object> next : this.mySuppliers) {
            Object nextRp = next.get();
            if (nextRp == null) continue;
            retVal.add(nextRp);
        }
        return retVal;
    }

    public void attach(IResourceProviderFactoryObserver theObserver) {
        this.myObservers.add(theObserver);
    }

    public void detach(IResourceProviderFactoryObserver theObserver) {
        this.myObservers.remove(theObserver);
    }
}

