/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

class PatchTypeParameter
implements IParameter {
    PatchTypeParameter() {
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        return PatchTypeParameter.getTypeForRequestOrThrowInvalidRequestException(theRequest);
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }

    public static PatchTypeEnum getTypeForRequestOrThrowInvalidRequestException(RequestDetails theRequest) {
        String contentTypeAll = StringUtils.defaultString((String)theRequest.getHeader("Content-Type"));
        int semicolonIndex = contentTypeAll.indexOf(59);
        if (semicolonIndex > 0) {
            contentTypeAll = contentTypeAll.substring(0, semicolonIndex);
        }
        contentTypeAll = StringUtils.trim((String)contentTypeAll);
        return PatchTypeEnum.forContentTypeOrThrowInvalidRequestException((FhirContext)theRequest.getFhirContext(), (String)contentTypeAll);
    }
}

