/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.DeleteCascadeModeEnum;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.PreferHandlingEnum;
import ca.uhn.fhir.rest.api.PreferHeader;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.ElementsSupportEnum;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.ElementsParameter;
import ca.uhn.fhir.rest.server.method.SummaryEnumParameter;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.BinaryUtil;
import ca.uhn.fhir.util.DateUtils;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServerUtils {
    static final Pattern ACCEPT_HEADER_PATTERN = Pattern.compile("\\s*([a-zA-Z0-9+.*/-]+)\\s*(;\\s*([a-zA-Z]+)\\s*=\\s*([a-zA-Z0-9.]+)\\s*)?(,?)");
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServerUtils.class);
    private static final HashSet<String> TEXT_ENCODE_ELEMENTS = new HashSet<String>(Arrays.asList("*.text", "*.id", "*.meta", "*.(mandatory)"));
    private static Map<FhirVersionEnum, FhirContext> myFhirContextMap = Collections.synchronizedMap(new HashMap());
    private static EnumSet<RestOperationTypeEnum> ourOperationsWhichAllowPreferHeader = EnumSet.of(RestOperationTypeEnum.CREATE, RestOperationTypeEnum.UPDATE, RestOperationTypeEnum.PATCH);

    public static void configureResponseParser(RequestDetails theRequestDetails, IParser parser) {
        String[] countParam;
        boolean summaryModeCount;
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theRequestDetails.getServer(), theRequestDetails);
        parser.setPrettyPrint(prettyPrint);
        parser.setServerBaseUrl(theRequestDetails.getFhirServerBase());
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequestDetails);
        Set<String> elements = ElementsParameter.getElementsValueOrNull(theRequestDetails, false);
        if (elements != null && !summaryMode.equals(Collections.singleton(SummaryEnum.FALSE))) {
            throw new InvalidRequestException(Msg.code((int)304) + "Cannot combine the " + "_summary" + " and " + "_elements" + " parameters");
        }
        Set<String> elementsExclude = ElementsParameter.getElementsValueOrNull(theRequestDetails, true);
        if (elementsExclude != null) {
            parser.setDontEncodeElements(elementsExclude);
        }
        boolean bl = summaryModeCount = summaryMode.contains(SummaryEnum.COUNT) && summaryMode.size() == 1;
        if (!summaryModeCount && (countParam = theRequestDetails.getParameters().get("_count")) != null && countParam.length > 0) {
            summaryModeCount = "0".equalsIgnoreCase(countParam[0]);
        }
        if (summaryModeCount) {
            parser.setEncodeElements((Set)Sets.newHashSet((Object[])new String[]{"Bundle.total", "Bundle.type"}));
        } else if (summaryMode.contains(SummaryEnum.TEXT) && summaryMode.size() == 1) {
            parser.setEncodeElements(TEXT_ENCODE_ELEMENTS);
            parser.setEncodeElementsAppliesToChildResourcesOnly(true);
        } else {
            parser.setSuppressNarratives(summaryMode.contains(SummaryEnum.DATA));
            parser.setSummaryMode(summaryMode.contains(SummaryEnum.TRUE));
        }
        if (elements != null && elements.size() > 0) {
            String elementsAppliesTo = "*";
            if (StringUtils.isNotBlank((CharSequence)theRequestDetails.getResourceName())) {
                elementsAppliesTo = theRequestDetails.getResourceName();
            }
            HashSet<String> newElements = new HashSet<String>();
            for (String next : elements) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                if (Character.isUpperCase(next.charAt(0))) {
                    newElements.add(next);
                    continue;
                }
                newElements.add(elementsAppliesTo + "." + next);
            }
            boolean haveExplicitBundleElement = false;
            for (String next : newElements) {
                if (!next.startsWith("Bundle.")) continue;
                haveExplicitBundleElement = true;
                break;
            }
            if (theRequestDetails.getRestOperationType() != null) {
                switch (theRequestDetails.getRestOperationType()) {
                    case SEARCH_SYSTEM: 
                    case SEARCH_TYPE: 
                    case HISTORY_SYSTEM: 
                    case HISTORY_TYPE: 
                    case HISTORY_INSTANCE: 
                    case GET_PAGE: {
                        if (haveExplicitBundleElement) break;
                        parser.setEncodeElementsAppliesToChildResourcesOnly(true);
                        break;
                    }
                }
            }
            parser.setEncodeElements(newElements);
        }
    }

    public static String createLinkSelf(String theServerBase, RequestDetails theRequest) {
        return RestfulServerUtils.createLinkSelfWithoutGivenParameters(theServerBase, theRequest, null);
    }

    public static String createLinkSelfWithoutGivenParameters(String theServerBase, RequestDetails theRequest, List<String> excludedParameterNames) {
        StringBuilder b = new StringBuilder();
        b.append(theServerBase);
        if (StringUtils.isNotBlank((CharSequence)theRequest.getRequestPath())) {
            b.append('/');
            if (StringUtils.isNotBlank((CharSequence)theRequest.getTenantId()) && theRequest.getRequestPath().startsWith(theRequest.getTenantId() + "/")) {
                b.append(theRequest.getRequestPath().substring(theRequest.getTenantId().length() + 1));
            } else {
                b.append(theRequest.getRequestPath());
            }
        }
        if (theRequest.getRequestType() == RequestTypeEnum.GET) {
            boolean first = true;
            Map<String, String[]> parameters = theRequest.getParameters();
            for (String nextParamName : new TreeSet<String>(parameters.keySet())) {
                if (excludedParameterNames != null && excludedParameterNames.contains(nextParamName)) continue;
                for (String nextParamValue : parameters.get(nextParamName)) {
                    if (first) {
                        b.append('?');
                        first = false;
                    } else {
                        b.append('&');
                    }
                    b.append(UrlUtil.escapeUrlParam((String)nextParamName));
                    b.append('=');
                    b.append(UrlUtil.escapeUrlParam((String)nextParamValue));
                }
            }
        }
        return b.toString();
    }

    public static String createOffsetPagingLink(BundleLinks theBundleLinks, String requestPath, String tenantId, Integer theOffset, Integer theCount, Map<String, String[]> theRequestParameters) {
        StringBuilder b = new StringBuilder();
        b.append(theBundleLinks.serverBase);
        if (StringUtils.isNotBlank((CharSequence)requestPath)) {
            b.append('/');
            if (StringUtils.isNotBlank((CharSequence)tenantId) && requestPath.startsWith(tenantId + "/")) {
                b.append(requestPath.substring(tenantId.length() + 1));
            } else {
                b.append(requestPath);
            }
        }
        LinkedHashMap params = Maps.newLinkedHashMap(theRequestParameters);
        params.put("_offset", new String[]{String.valueOf(theOffset)});
        params.put("_count", new String[]{String.valueOf(theCount)});
        boolean first = true;
        for (String nextParamName : new TreeSet(params.keySet())) {
            for (String nextParamValue : (String[])params.get(nextParamName)) {
                if (first) {
                    b.append('?');
                    first = false;
                } else {
                    b.append('&');
                }
                b.append(UrlUtil.escapeUrlParam((String)nextParamName));
                b.append('=');
                b.append(UrlUtil.escapeUrlParam((String)nextParamValue));
            }
        }
        return b.toString();
    }

    public static String createPagingLink(BundleLinks theBundleLinks, RequestDetails theRequestDetails, String theSearchId, int theOffset, int theCount, Map<String, String[]> theRequestParameters) {
        return RestfulServerUtils.createPagingLink(theBundleLinks, theRequestDetails, theSearchId, theOffset, theCount, theRequestParameters, null);
    }

    public static String createPagingLink(BundleLinks theBundleLinks, RequestDetails theRequestDetails, String theSearchId, String thePageId, Map<String, String[]> theRequestParameters) {
        return RestfulServerUtils.createPagingLink(theBundleLinks, theRequestDetails, theSearchId, null, null, theRequestParameters, thePageId);
    }

    private static String createPagingLink(BundleLinks theBundleLinks, RequestDetails theRequestDetails, String theSearchId, Integer theOffset, Integer theCount, Map<String, String[]> theRequestParameters, String thePageId) {
        Set<String> elementsExclude;
        Set<String> elements;
        String[] strings;
        String serverBase = theRequestDetails.getFhirServerBase();
        StringBuilder b = new StringBuilder();
        b.append(serverBase);
        b.append('?');
        b.append("_getpages");
        b.append('=');
        b.append(UrlUtil.escapeUrlParam((String)theSearchId));
        if (theOffset != null) {
            b.append('&');
            b.append("_getpagesoffset");
            b.append('=');
            b.append(theOffset);
        }
        if (theCount != null) {
            b.append('&');
            b.append("_count");
            b.append('=');
            b.append(theCount);
        }
        if (StringUtils.isNotBlank((CharSequence)thePageId)) {
            b.append('&');
            b.append("_pageId");
            b.append('=');
            b.append(UrlUtil.escapeUrlParam((String)thePageId));
        }
        if ((strings = theRequestParameters.get("_format")) != null && strings.length > 0) {
            b.append('&');
            b.append("_format");
            b.append('=');
            Object format = strings[0];
            format = StringUtils.replace((String)format, (String)" ", (String)"+");
            b.append(UrlUtil.escapeUrlParam((String)format));
        }
        if (theBundleLinks.prettyPrint) {
            b.append('&');
            b.append("_pretty");
            b.append('=');
            b.append("true");
        }
        if (theBundleLinks.getIncludes() != null) {
            for (Include nextInclude : theBundleLinks.getIncludes()) {
                if (!StringUtils.isNotBlank((CharSequence)nextInclude.getValue())) continue;
                b.append('&');
                b.append("_include");
                b.append('=');
                b.append(UrlUtil.escapeUrlParam((String)nextInclude.getValue()));
            }
        }
        if (theBundleLinks.bundleType != null) {
            b.append('&');
            b.append("_bundletype");
            b.append('=');
            b.append(theBundleLinks.bundleType.getCode());
        }
        if ((elements = ElementsParameter.getElementsValueOrNull(theRequestDetails, false)) != null) {
            b.append('&');
            b.append("_elements");
            b.append('=');
            String nextValue = elements.stream().sorted().map(UrlUtil::escapeUrlParam).collect(Collectors.joining(","));
            b.append(nextValue);
        }
        if (theRequestDetails.getServer().getElementsSupport() == ElementsSupportEnum.EXTENDED && (elementsExclude = ElementsParameter.getElementsValueOrNull(theRequestDetails, true)) != null) {
            b.append('&');
            b.append("_elements:exclude");
            b.append('=');
            String nextValue = elementsExclude.stream().sorted().map(UrlUtil::escapeUrlParam).collect(Collectors.joining(","));
            b.append(nextValue);
        }
        return b.toString();
    }

    @Nullable
    public static EncodingEnum determineRequestEncodingNoDefault(RequestDetails theReq) {
        return RestfulServerUtils.determineRequestEncodingNoDefault(theReq, false);
    }

    @Nullable
    public static EncodingEnum determineRequestEncodingNoDefault(RequestDetails theReq, boolean theStrict) {
        ResponseEncoding retVal = RestfulServerUtils.determineRequestEncodingNoDefaultReturnRE(theReq, theStrict);
        if (retVal == null) {
            return null;
        }
        return retVal.getEncoding();
    }

    private static ResponseEncoding determineRequestEncodingNoDefaultReturnRE(RequestDetails theReq, boolean theStrict) {
        Iterator<String> acceptValues;
        ResponseEncoding retVal = null;
        List<String> headers = theReq.getHeaders("Content-Type");
        if (headers != null && (acceptValues = headers.iterator()) != null) {
            block0: while (acceptValues.hasNext() && retVal == null) {
                String nextAcceptHeaderValue = acceptValues.next();
                if (nextAcceptHeaderValue == null || !StringUtils.isNotBlank((CharSequence)nextAcceptHeaderValue)) continue;
                for (String nextPart : nextAcceptHeaderValue.split(",")) {
                    int scIdx = nextPart.indexOf(59);
                    if (scIdx == 0) continue;
                    if (scIdx != -1) {
                        nextPart = nextPart.substring(0, scIdx);
                    }
                    nextPart = nextPart.trim();
                    EncodingEnum encoding = theStrict ? EncodingEnum.forContentTypeStrict((String)nextPart) : EncodingEnum.forContentType((String)nextPart);
                    if (encoding == null) continue;
                    retVal = new ResponseEncoding(theReq.getServer().getFhirContext(), encoding, nextPart);
                    continue block0;
                }
            }
        }
        return retVal;
    }

    public static ResponseEncoding determineResponseEncodingNoDefault(RequestDetails theReq, EncodingEnum thePrefer) {
        return RestfulServerUtils.determineResponseEncodingNoDefault(theReq, thePrefer, null);
    }

    public static ResponseEncoding determineResponseEncodingNoDefault(RequestDetails theReq, EncodingEnum thePrefer, String thePreferContentType) {
        String[] format = theReq.getParameters().get("_format");
        if (format != null) {
            for (String nextFormat : format) {
                EncodingEnum retVal = EncodingEnum.forContentType((String)nextFormat);
                if (retVal == null) continue;
                return new ResponseEncoding(theReq.getServer().getFhirContext(), retVal, nextFormat);
            }
        }
        boolean strict = false;
        if ("Binary".equals(theReq.getResourceName())) {
            strict = true;
        }
        List<String> acceptValues = theReq.getHeaders("Accept");
        float bestQ = -1.0f;
        ResponseEncoding retVal = null;
        if (acceptValues != null) {
            for (String nextAcceptHeaderValue : acceptValues) {
                StringTokenizer tok = new StringTokenizer(nextAcceptHeaderValue, ",");
                while (tok.hasMoreTokens()) {
                    ResponseEncoding encoding;
                    String nextToken = tok.nextToken();
                    int startSpaceIndex = -1;
                    for (int i = 0; i < nextToken.length(); ++i) {
                        if (nextToken.charAt(i) == ' ') continue;
                        startSpaceIndex = i;
                        break;
                    }
                    if (startSpaceIndex == -1) continue;
                    int endSpaceIndex = -1;
                    for (int i = startSpaceIndex; i < nextToken.length(); ++i) {
                        if (nextToken.charAt(i) != ' ' && nextToken.charAt(i) != ';') continue;
                        endSpaceIndex = i;
                        break;
                    }
                    float q = 1.0f;
                    if (endSpaceIndex == -1) {
                        encoding = startSpaceIndex == 0 ? RestfulServerUtils.getEncodingForContentType(theReq.getServer().getFhirContext(), strict, nextToken, thePreferContentType) : RestfulServerUtils.getEncodingForContentType(theReq.getServer().getFhirContext(), strict, nextToken.substring(startSpaceIndex), thePreferContentType);
                    } else {
                        encoding = RestfulServerUtils.getEncodingForContentType(theReq.getServer().getFhirContext(), strict, nextToken.substring(startSpaceIndex, endSpaceIndex), thePreferContentType);
                        String remaining = nextToken.substring(endSpaceIndex + 1);
                        StringTokenizer qualifierTok = new StringTokenizer(remaining, ";");
                        while (qualifierTok.hasMoreTokens()) {
                            String nextQualifier = qualifierTok.nextToken();
                            int equalsIndex = nextQualifier.indexOf(61);
                            if (equalsIndex == -1) continue;
                            String nextQualifierKey = nextQualifier.substring(0, equalsIndex).trim();
                            String nextQualifierValue = nextQualifier.substring(equalsIndex + 1, nextQualifier.length()).trim();
                            if (!nextQualifierKey.equals("q")) continue;
                            try {
                                q = Float.parseFloat(nextQualifierValue);
                                q = Math.max(q, 0.0f);
                            }
                            catch (NumberFormatException e) {
                                ourLog.debug("Invalid Accept header q value: {}", (Object)nextQualifierValue);
                            }
                        }
                    }
                    if (encoding == null || !(q > bestQ) && (q != bestQ || encoding.getEncoding() != thePrefer)) continue;
                    retVal = encoding;
                    bestQ = q;
                }
            }
        }
        if (retVal == null) {
            retVal = RestfulServerUtils.determineRequestEncodingNoDefaultReturnRE(theReq, strict);
        }
        return retVal;
    }

    public static ResponseEncoding determineResponseEncodingWithDefault(RequestDetails theReq) {
        ResponseEncoding retVal = RestfulServerUtils.determineResponseEncodingNoDefault(theReq, theReq.getServer().getDefaultResponseEncoding());
        if (retVal == null) {
            retVal = new ResponseEncoding(theReq.getServer().getFhirContext(), theReq.getServer().getDefaultResponseEncoding(), null);
        }
        return retVal;
    }

    @Nonnull
    public static Set<SummaryEnum> determineSummaryMode(RequestDetails theRequest) {
        String[] narrative;
        Map<String, String[]> requestParams = theRequest.getParameters();
        Set<SummaryEnum> retVal = SummaryEnumParameter.getSummaryValueOrNull(theRequest);
        if (retVal == null && (narrative = requestParams.get("_narrative")) != null && narrative.length > 0) {
            try {
                NarrativeModeEnum narrativeMode = NarrativeModeEnum.valueOfCaseInsensitive(narrative[0]);
                switch (narrativeMode) {
                    case NORMAL: {
                        retVal = Collections.singleton(SummaryEnum.FALSE);
                        break;
                    }
                    case ONLY: {
                        retVal = Collections.singleton(SummaryEnum.TEXT);
                        break;
                    }
                    case SUPPRESS: {
                        retVal = Collections.singleton(SummaryEnum.DATA);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ourLog.debug("Invalid {} parameter: {}", (Object)"_narrative", (Object)narrative[0]);
            }
        }
        if (retVal == null) {
            retVal = Collections.singleton(SummaryEnum.FALSE);
        }
        return retVal;
    }

    public static Integer extractCountParameter(RequestDetails theRequest) {
        return RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_count");
    }

    public static Integer extractOffsetParameter(RequestDetails theRequest) {
        return RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_offset");
    }

    public static IPrimitiveType<Date> extractLastUpdatedFromResource(IBaseResource theResource) {
        IPrimitiveType lastUpdated = null;
        if (theResource instanceof IResource) {
            lastUpdated = (IPrimitiveType)ResourceMetadataKeyEnum.UPDATED.get((IResource)theResource);
        } else if (theResource instanceof IAnyResource) {
            lastUpdated = new InstantDt(theResource.getMeta().getLastUpdated());
        }
        return lastUpdated;
    }

    public static IIdType fullyQualifyResourceIdOrReturnNull(IRestfulServerDefaults theServer, IBaseResource theResource, String theServerBase, IIdType theResourceId) {
        IIdType retVal = null;
        if (theResourceId.hasIdPart() && StringUtils.isNotBlank((CharSequence)theServerBase)) {
            String resName = theResourceId.getResourceType();
            if (theResource != null && StringUtils.isBlank((CharSequence)resName)) {
                FhirContext context = theServer.getFhirContext();
                context = RestfulServerUtils.getContextForVersion(context, theResource.getStructureFhirVersionEnum());
                resName = context.getResourceType(theResource);
            }
            if (StringUtils.isNotBlank((CharSequence)resName)) {
                retVal = theResourceId.withServerBase(theServerBase, resName);
            }
        }
        return retVal;
    }

    private static FhirContext getContextForVersion(FhirContext theContext, FhirVersionEnum theForVersion) {
        FhirContext context = theContext;
        if (context.getVersion().getVersion() != theForVersion && (context = myFhirContextMap.get(theForVersion)) == null) {
            context = theForVersion.newContext();
            myFhirContextMap.put(theForVersion, context);
        }
        return context;
    }

    private static ResponseEncoding getEncodingForContentType(FhirContext theFhirContext, boolean theStrict, String theContentType, String thePreferContentType) {
        EncodingEnum encoding = theStrict ? EncodingEnum.forContentTypeStrict((String)theContentType) : EncodingEnum.forContentType((String)theContentType);
        if (StringUtils.isNotBlank((CharSequence)thePreferContentType) && thePreferContentType.equals(theContentType)) {
            return new ResponseEncoding(theFhirContext, encoding, theContentType);
        }
        if (encoding == null) {
            return null;
        }
        return new ResponseEncoding(theFhirContext, encoding, theContentType);
    }

    public static IParser getNewParser(FhirContext theContext, FhirVersionEnum theForVersion, RequestDetails theRequestDetails) {
        IParser parser;
        FhirContext context = RestfulServerUtils.getContextForVersion(theContext, theForVersion);
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingWithDefault(theRequestDetails).getEncoding();
        switch (responseEncoding) {
            case JSON: {
                parser = context.newJsonParser();
                break;
            }
            case RDF: {
                parser = context.newRDFParser();
                break;
            }
            default: {
                parser = context.newXmlParser();
            }
        }
        RestfulServerUtils.configureResponseParser(theRequestDetails, parser);
        return parser;
    }

    public static Set<String> parseAcceptHeaderAndReturnHighestRankedOptions(HttpServletRequest theRequest) {
        HashSet<String> retVal = new HashSet<String>();
        Enumeration acceptValues = theRequest.getHeaders("Accept");
        if (acceptValues != null) {
            float bestQ = -1.0f;
            block2: while (acceptValues.hasMoreElements()) {
                String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                Matcher m = ACCEPT_HEADER_PATTERN.matcher(nextAcceptHeaderValue);
                float q = 1.0f;
                while (m.find()) {
                    String contentTypeGroup = m.group(1);
                    if (StringUtils.isNotBlank((CharSequence)contentTypeGroup)) {
                        String name = m.group(3);
                        String value = m.group(4);
                        if (name != null && value != null && "q".equals(name)) {
                            try {
                                q = Float.parseFloat(value);
                                q = Math.max(q, 0.0f);
                            }
                            catch (NumberFormatException e) {
                                ourLog.debug("Invalid Accept header q value: {}", (Object)value);
                            }
                        }
                        if (q > bestQ) {
                            retVal.clear();
                            bestQ = q;
                        }
                        if (q == bestQ) {
                            retVal.add(contentTypeGroup.trim());
                        }
                    }
                    if (",".equals(m.group(5))) continue;
                    continue block2;
                }
            }
        }
        return retVal;
    }

    public static boolean respectPreferHeader(RestOperationTypeEnum theRestOperationType) {
        return ourOperationsWhichAllowPreferHeader.contains(theRestOperationType);
    }

    @Nonnull
    public static PreferHeader parsePreferHeader(IRestfulServer<?> theServer, String theValue) {
        PreferHeader retVal = new PreferHeader();
        if (StringUtils.isNotBlank((CharSequence)theValue)) {
            StringTokenizer tok = new StringTokenizer(theValue, ";,");
            while (tok.hasMoreTokens()) {
                String value;
                String key;
                String next = StringUtils.trim((String)tok.nextToken());
                int eqIndex = next.indexOf(61);
                if (eqIndex == -1 || eqIndex >= next.length() - 2) {
                    key = next;
                    value = "";
                } else {
                    key = next.substring(0, eqIndex).trim();
                    value = next.substring(eqIndex + 1).trim();
                }
                if (key.equals("return")) {
                    value = RestfulServerUtils.cleanUpValue(value);
                    retVal.setReturn(PreferReturnEnum.fromHeaderValue((String)value));
                    continue;
                }
                if (key.equals("handling")) {
                    value = RestfulServerUtils.cleanUpValue(value);
                    retVal.setHanding(PreferHandlingEnum.fromHeaderValue((String)value));
                    continue;
                }
                if (!key.equals("respond-async")) continue;
                retVal.setRespondAsync(true);
            }
        }
        if (retVal.getReturn() == null && theServer != null && theServer.getDefaultPreferReturn() != null) {
            retVal.setReturn(theServer.getDefaultPreferReturn());
        }
        return retVal;
    }

    private static String cleanUpValue(String value) {
        if (value.length() < 2) {
            value = "";
        }
        if ('\"' == value.charAt(0) && '\"' == value.charAt(value.length() - 1)) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static boolean prettyPrintResponse(IRestfulServerDefaults theServer, RequestDetails theRequest) {
        boolean prettyPrint;
        Map<String, String[]> requestParams = theRequest.getParameters();
        String[] pretty = requestParams.get("_pretty");
        if (pretty != null && pretty.length > 0) {
            prettyPrint = "true".equals(pretty[0]);
        } else {
            prettyPrint = theServer.isDefaultPrettyPrint();
            List<String> acceptValues = theRequest.getHeaders("Accept");
            if (acceptValues != null) {
                for (String nextAcceptHeaderValue : acceptValues) {
                    if (!nextAcceptHeaderValue.contains("pretty=true")) continue;
                    prettyPrint = true;
                }
            }
        }
        return prettyPrint;
    }

    public static Object streamResponseAsResource(IRestfulServerDefaults theServer, IBaseResource theResource, Set<SummaryEnum> theSummaryMode, int stausCode, boolean theAddContentLocationHeader, boolean respondGzip, RequestDetails theRequestDetails) throws IOException {
        return RestfulServerUtils.streamResponseAsResource(theServer, theResource, theSummaryMode, stausCode, null, theAddContentLocationHeader, respondGzip, theRequestDetails, null, null);
    }

    public static Object streamResponseAsResource(IRestfulServerDefaults theServer, IBaseResource theResource, Set<SummaryEnum> theSummaryMode, int theStatusCode, String theStatusMessage, boolean theAddContentLocationHeader, boolean respondGzip, RequestDetails theRequestDetails, IIdType theOperationResourceId, IPrimitiveType<Date> theOperationResourceLastUpdated) throws IOException {
        IPrimitiveType<Date> lastUpdated;
        boolean encodingDomainResourceAsText;
        String contentType;
        IRestfulResponse response = theRequestDetails.getResponse();
        ResponseEncoding responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequestDetails, theServer.getDefaultResponseEncoding());
        String serverBase = theRequestDetails.getFhirServerBase();
        IIdType fullId = null;
        if (theOperationResourceId != null) {
            fullId = theOperationResourceId;
        } else if (theResource != null && theResource.getIdElement() != null) {
            IIdType resourceId = theResource.getIdElement();
            fullId = RestfulServerUtils.fullyQualifyResourceIdOrReturnNull(theServer, theResource, serverBase, resourceId);
        }
        if (theAddContentLocationHeader && fullId != null) {
            if (theRequestDetails.getRequestType() == RequestTypeEnum.POST) {
                response.addHeader("Location", fullId.getValue());
            }
            response.addHeader("Content-Location", fullId.getValue());
        }
        if (theServer.getETagSupport() == ETagSupportEnum.ENABLED && theRequestDetails.getRestOperationType() != null) {
            switch (theRequestDetails.getRestOperationType()) {
                case CREATE: 
                case UPDATE: 
                case READ: 
                case VREAD: {
                    if (fullId != null && fullId.hasVersionIdPart()) {
                        String versionIdPart = fullId.getVersionIdPart();
                        response.addHeader("ETag", RestfulServerUtils.createEtag(versionIdPart));
                        break;
                    }
                    if (theResource == null || theResource.getMeta() == null || !StringUtils.isNotBlank((CharSequence)theResource.getMeta().getVersionId())) break;
                    String versionId = theResource.getMeta().getVersionId();
                    response.addHeader("ETag", RestfulServerUtils.createEtag(versionId));
                }
            }
        }
        if (theResource instanceof IBaseBinary) {
            String securityContextRef;
            IBaseBinary bin = (IBaseBinary)theResource;
            IBaseReference securityContext = BinaryUtil.getSecurityContext((FhirContext)theServer.getFhirContext(), (IBaseBinary)bin);
            if (securityContext != null && StringUtils.isNotBlank((CharSequence)(securityContextRef = securityContext.getReferenceElement().getValue()))) {
                response.addHeader("X-Security-Context", securityContextRef);
            }
            if (responseEncoding == null) {
                contentType = StringUtils.isNotBlank((CharSequence)bin.getContentType()) ? bin.getContentType() : "application/octet-stream";
                response.addHeader("Content-Disposition", "Attachment;");
                return response.sendAttachmentResponse(bin, theStatusCode, contentType);
            }
        }
        if (responseEncoding == null) {
            responseEncoding = new ResponseEncoding(theServer.getFhirContext(), theServer.getDefaultResponseEncoding(), null);
        }
        boolean bl = encodingDomainResourceAsText = theSummaryMode.size() == 1 && theSummaryMode.contains(SummaryEnum.TEXT);
        if (encodingDomainResourceAsText && "Bundle".equals(theServer.getFhirContext().getResourceType(theResource))) {
            encodingDomainResourceAsText = false;
        }
        if ((lastUpdated = theOperationResourceLastUpdated != null ? theOperationResourceLastUpdated : RestfulServerUtils.extractLastUpdatedFromResource(theResource)) != null && !lastUpdated.isEmpty()) {
            response.addHeader("Last-Modified", DateUtils.formatDate((Date)((Date)lastUpdated.getValue())));
        }
        contentType = theResource == null ? null : (encodingDomainResourceAsText ? "text/html" : responseEncoding.getResourceContentType());
        String charset = "UTF-8";
        Writer writer = response.getResponseWriter(theStatusCode, theStatusMessage, contentType, charset, respondGzip);
        if (theServer.getInterceptorService() != null && theServer.getInterceptorService().hasHooks((IPointcut)Pointcut.SERVER_OUTGOING_WRITER_CREATED)) {
            HookParams params = new HookParams().add(Writer.class, (Object)writer).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
            Object newWriter = theServer.getInterceptorService().callHooksAndReturnObject((IPointcut)Pointcut.SERVER_OUTGOING_WRITER_CREATED, params);
            if (newWriter != null) {
                writer = (Writer)newWriter;
            }
        }
        if (theResource != null) {
            if (encodingDomainResourceAsText && theResource instanceof IResource) {
                writer.append(((IResource)theResource).getText().getDiv().getValueAsString());
            } else if (encodingDomainResourceAsText && theResource instanceof IDomainResource) {
                try {
                    writer.append(((IDomainResource)theResource).getText().getDivAsString());
                }
                catch (Exception e) {
                    throw new InternalErrorException(Msg.code((int)305) + e);
                }
            } else {
                FhirVersionEnum forVersion = theResource.getStructureFhirVersionEnum();
                IParser parser = RestfulServerUtils.getNewParser(theServer.getFhirContext(), forVersion, theRequestDetails);
                parser.encodeResourceToWriter(theResource, writer);
            }
        }
        return response.sendWriterResponse(theStatusCode, contentType, charset, writer);
    }

    public static String createEtag(String theVersionId) {
        return "W/\"" + theVersionId + '\"';
    }

    public static Integer tryToExtractNamedParameter(RequestDetails theRequest, String theParamName) {
        String[] retVal = theRequest.getParameters().get(theParamName);
        if (retVal == null) {
            return null;
        }
        try {
            return Integer.parseInt(retVal[0]);
        }
        catch (NumberFormatException e) {
            ourLog.debug("Failed to parse {} value '{}': {}", new Object[]{theParamName, retVal[0], e});
            return null;
        }
    }

    public static void validateResourceListNotNull(List<? extends IBaseResource> theResourceList) {
        if (theResourceList == null) {
            throw new InternalErrorException(Msg.code((int)306) + "IBundleProvider returned a null list of resources - This is not allowed");
        }
    }

    public static DeleteCascadeModeEnum extractDeleteCascadeParameter(RequestDetails theRequest) {
        if (theRequest != null) {
            String[] cascadeParameters = theRequest.getParameters().get("_cascade");
            if (cascadeParameters != null && Arrays.asList(cascadeParameters).contains("delete")) {
                return DeleteCascadeModeEnum.DELETE;
            }
            String cascadeHeader = theRequest.getHeader("X-Cascade");
            if ("delete".equals(cascadeHeader)) {
                return DeleteCascadeModeEnum.DELETE;
            }
        }
        return DeleteCascadeModeEnum.NONE;
    }

    public static class ResponseEncoding {
        private final String myContentType;
        private final EncodingEnum myEncoding;
        private final Boolean myNonLegacy;

        public ResponseEncoding(FhirContext theCtx, EncodingEnum theEncoding, String theContentType) {
            this.myEncoding = theEncoding;
            this.myContentType = theContentType;
            if (theContentType != null) {
                FhirVersionEnum ctxtEnum = theCtx.getVersion().getVersion();
                this.myNonLegacy = theContentType.equals("json") || theContentType.equals("xml") ? Boolean.valueOf(ctxtEnum.isNewerThan(FhirVersionEnum.DSTU2_1)) : Boolean.valueOf(ctxtEnum.isNewerThan(FhirVersionEnum.DSTU2_1) && !EncodingEnum.isLegacy((String)theContentType));
            } else {
                FhirVersionEnum ctxtEnum = theCtx.getVersion().getVersion();
                this.myNonLegacy = ctxtEnum.isOlderThan(FhirVersionEnum.DSTU3) ? null : Boolean.TRUE;
            }
        }

        public String getContentType() {
            return this.myContentType;
        }

        public EncodingEnum getEncoding() {
            return this.myEncoding;
        }

        public String getResourceContentType() {
            if (Boolean.TRUE.equals(this.isNonLegacy())) {
                return this.getEncoding().getResourceContentTypeNonLegacy();
            }
            return this.getEncoding().getResourceContentType();
        }

        Boolean isNonLegacy() {
            return this.myNonLegacy;
        }
    }

    private static enum NarrativeModeEnum {
        NORMAL,
        ONLY,
        SUPPRESS;


        public static NarrativeModeEnum valueOfCaseInsensitive(String theCode) {
            return NarrativeModeEnum.valueOf(NarrativeModeEnum.class, theCode.toUpperCase());
        }
    }
}

