/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.partition;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@Interceptor
public class RequestTenantPartitionInterceptor {
    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE)
    public RequestPartitionId PartitionIdentifyCreate(ServletRequestDetails theRequestDetails) {
        return this.extractPartitionIdFromRequest(theRequestDetails);
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_READ)
    public RequestPartitionId PartitionIdentifyRead(ServletRequestDetails theRequestDetails) {
        return this.extractPartitionIdFromRequest(theRequestDetails);
    }

    @Nonnull
    protected RequestPartitionId extractPartitionIdFromRequest(ServletRequestDetails theRequestDetails) {
        String tenantId = theRequestDetails.getTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalErrorException("No tenant ID has been specified");
        }
        return RequestPartitionId.fromPartitionName((String)tenantId);
    }
}

