/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class ResponseSizeCapturingInterceptor {
    public static final String RESPONSE_RESULT_KEY = ResponseSizeCapturingInterceptor.class.getName() + "_RESPONSE_RESULT_KEY";
    private static final String COUNTING_WRITER_KEY = ResponseSizeCapturingInterceptor.class.getName() + "_COUNTING_WRITER_KEY";
    private List<Consumer<Result>> myConsumers = new ArrayList<Consumer<Result>>();

    @Hook(value=Pointcut.SERVER_OUTGOING_WRITER_CREATED)
    public Writer capture(RequestDetails theRequestDetails, Writer theWriter) {
        CountingWriter retVal = new CountingWriter(theWriter);
        theRequestDetails.getUserData().put(COUNTING_WRITER_KEY, retVal);
        return retVal;
    }

    @Hook(value=Pointcut.SERVER_PROCESSING_COMPLETED, order=-1)
    public void completed(RequestDetails theRequestDetails) {
        CountingWriter countingWriter = (CountingWriter)theRequestDetails.getUserData().get(COUNTING_WRITER_KEY);
        if (countingWriter != null) {
            int charCount = countingWriter.getCount();
            Result result = new Result(theRequestDetails, charCount);
            this.notifyConsumers(result);
            theRequestDetails.getUserData().put(RESPONSE_RESULT_KEY, result);
        }
    }

    public void registerConsumer(@Nonnull Consumer<Result> theConsumer) {
        Validate.notNull(theConsumer);
        this.myConsumers.add(theConsumer);
    }

    private void notifyConsumers(Result theResult) {
        this.myConsumers.forEach(t -> t.accept(theResult));
    }

    private static class CountingWriter
    extends Writer {
        private final Writer myWrap;
        private int myCount;

        private CountingWriter(Writer theWrap) {
            this.myWrap = theWrap;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.myCount += len;
            this.myWrap.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.myWrap.flush();
        }

        @Override
        public void close() throws IOException {
            this.myWrap.close();
        }

        public int getCount() {
            return this.myCount;
        }
    }

    public static class Result {
        private final int myWrittenChars;
        private final RequestDetails myRequestDetails;

        public RequestDetails getRequestDetails() {
            return this.myRequestDetails;
        }

        public Result(RequestDetails theRequestDetails, int theWrittenChars) {
            this.myRequestDetails = theRequestDetails;
            this.myWrittenChars = theWrittenChars;
        }

        public int getWrittenChars() {
            return this.myWrittenChars;
        }
    }
}

