/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class SimpleBundleProvider
implements IBundleProvider {
    private final List<? extends IBaseResource> myList;
    private final String myUuid;
    private Integer myPreferredPageSize;
    private Integer mySize;
    private IPrimitiveType<Date> myPublished = InstantDt.withCurrentTime();

    public SimpleBundleProvider(List<? extends IBaseResource> theList) {
        this(theList, null);
    }

    public SimpleBundleProvider(IBaseResource theResource) {
        this(Collections.singletonList(theResource));
    }

    public SimpleBundleProvider() {
        this(Collections.emptyList());
    }

    public SimpleBundleProvider(List<? extends IBaseResource> theList, String theUuid) {
        this.myList = theList;
        this.myUuid = theUuid;
        this.setSize(theList.size());
    }

    protected List<? extends IBaseResource> getList() {
        return this.myList;
    }

    @Override
    public IPrimitiveType<Date> getPublished() {
        return this.myPublished;
    }

    public void setPublished(IPrimitiveType<Date> thePublished) {
        this.myPublished = thePublished;
    }

    @Override
    @Nonnull
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
        return this.myList.subList(theFromIndex, Math.min(theToIndex, this.myList.size()));
    }

    @Override
    public String getUuid() {
        return this.myUuid;
    }

    @Override
    public Integer preferredPageSize() {
        return this.myPreferredPageSize;
    }

    public void setPreferredPageSize(Integer thePreferredPageSize) {
        this.myPreferredPageSize = thePreferredPageSize;
    }

    public SimpleBundleProvider setSize(Integer theSize) {
        this.mySize = theSize;
        return this;
    }

    @Override
    public Integer size() {
        return this.mySize;
    }
}

