/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.server.ParseAction;
import ca.uhn.fhir.rest.server.RestfulResponse;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IBaseBinary;

public class ServletRestfulResponse
extends RestfulResponse<ServletRequestDetails> {
    public ServletRestfulResponse(ServletRequestDetails servletRequestDetails) {
        super(servletRequestDetails);
    }

    @Override
    public OutputStream sendAttachmentResponse(IBaseBinary theBinary, int theStatusCode, String contentType) throws IOException {
        this.addHeaders();
        HttpServletResponse theHttpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        theHttpResponse.setStatus(theStatusCode);
        theHttpResponse.setContentType(contentType);
        theHttpResponse.setCharacterEncoding(null);
        if (theBinary.getContent() == null || theBinary.getContent().length == 0) {
            return theHttpResponse.getOutputStream();
        }
        theHttpResponse.setContentLength(theBinary.getContent().length);
        ServletOutputStream oos = theHttpResponse.getOutputStream();
        oos.write(theBinary.getContent());
        return oos;
    }

    @Override
    public Writer getResponseWriter(int theStatusCode, String theStatusMessage, String theContentType, String theCharset, boolean theRespondGzip) throws IOException {
        this.addHeaders();
        HttpServletResponse theHttpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        theHttpResponse.setCharacterEncoding(theCharset);
        theHttpResponse.setStatus(theStatusCode);
        theHttpResponse.setContentType(theContentType);
        if (theRespondGzip) {
            theHttpResponse.addHeader("Content-Encoding", "gzip");
            return new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)theHttpResponse.getOutputStream()), StandardCharsets.UTF_8);
        }
        return theHttpResponse.getWriter();
    }

    private void addHeaders() {
        HttpServletResponse theHttpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        ((ServletRequestDetails)this.getRequestDetails()).getServer().addHeadersToResponse(theHttpResponse);
        for (Map.Entry<String, List<String>> header : this.getHeaders().entrySet()) {
            String key = header.getKey();
            boolean first = true;
            for (String value : header.getValue()) {
                if (first) {
                    theHttpResponse.setHeader(key, value);
                    first = false;
                    continue;
                }
                theHttpResponse.addHeader(key, value);
            }
        }
    }

    @Override
    public final Writer sendWriterResponse(int theStatus, String theContentType, String theCharset, Writer theWriter) {
        return theWriter;
    }

    @Override
    public Object returnResponse(ParseAction<?> outcome, int operationStatus, boolean allowPrefer, MethodOutcome response, String resourceName) throws IOException {
        this.addHeaders();
        return ((ServletRequestDetails)this.getRequestDetails()).getServer().returnResponse((ServletRequestDetails)this.getRequestDetails(), outcome, operationStatus, allowPrefer, response, resourceName);
    }
}

