/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashMapResourceProvider<T extends IBaseResource>
implements IResourceProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(HashMapResourceProvider.class);
    private final Class<T> myResourceType;
    private final FhirContext myFhirContext;
    private final String myResourceName;
    protected Map<String, TreeMap<Long, T>> myIdToVersionToResourceMap = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, LinkedList<T>> myIdToHistory = Collections.synchronizedMap(new LinkedHashMap());
    protected LinkedList<T> myTypeHistory = new LinkedList();
    protected AtomicLong mySearchCount = new AtomicLong(0L);
    private long myNextId;
    private AtomicLong myDeleteCount = new AtomicLong(0L);
    private AtomicLong myUpdateCount = new AtomicLong(0L);
    private AtomicLong myCreateCount = new AtomicLong(0L);
    private AtomicLong myReadCount = new AtomicLong(0L);

    public HashMapResourceProvider(FhirContext theFhirContext, Class<T> theResourceType) {
        this.myFhirContext = theFhirContext;
        this.myResourceType = theResourceType;
        this.myResourceName = this.myFhirContext.getResourceDefinition(theResourceType).getName();
        this.clear();
    }

    public void clear() {
        this.myNextId = 1L;
        this.myIdToVersionToResourceMap.clear();
        this.myIdToHistory.clear();
        this.myTypeHistory.clear();
    }

    public void clearCounts() {
        this.myReadCount.set(0L);
        this.myUpdateCount.set(0L);
        this.myCreateCount.set(0L);
        this.myDeleteCount.set(0L);
        this.mySearchCount.set(0L);
    }

    @Create
    public MethodOutcome create(@ResourceParam T theResource, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        this.createInternal(theResource, theRequestDetails, transactionDetails);
        this.myCreateCount.incrementAndGet();
        return new MethodOutcome().setCreated(Boolean.valueOf(true)).setResource(theResource).setId(theResource.getIdElement());
    }

    private void createInternal(@ResourceParam T theResource, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        long idPart = this.myNextId++;
        String idPartAsString = Long.toString(idPart);
        Long versionIdPart = 1L;
        IIdType id = this.store(theResource, idPartAsString, versionIdPart, theRequestDetails, theTransactionDetails);
        theResource.setId(id);
    }

    @Delete
    public MethodOutcome delete(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        TreeMap<Long, T> versions = this.myIdToVersionToResourceMap.get(theId.getIdPart());
        if (versions == null || versions.isEmpty()) {
            throw new ResourceNotFoundException(theId);
        }
        long nextVersion = versions.lastEntry().getKey() + 1L;
        IIdType id = this.store(null, theId.getIdPart(), nextVersion, theRequestDetails, transactionDetails);
        this.myDeleteCount.incrementAndGet();
        return new MethodOutcome().setId(id);
    }

    public long getCountCreate() {
        return this.myCreateCount.get();
    }

    public long getCountDelete() {
        return this.myDeleteCount.get();
    }

    public long getCountRead() {
        return this.myReadCount.get();
    }

    public long getCountSearch() {
        return this.mySearchCount.get();
    }

    public long getCountUpdate() {
        return this.myUpdateCount.get();
    }

    public Class<T> getResourceType() {
        return this.myResourceType;
    }

    private synchronized TreeMap<Long, T> getVersionToResource(String theIdPart) {
        this.myIdToVersionToResourceMap.computeIfAbsent(theIdPart, t -> new TreeMap());
        return this.myIdToVersionToResourceMap.get(theIdPart);
    }

    @History
    public List<IBaseResource> historyInstance(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        LinkedList<T> retVal = this.myIdToHistory.get(theId.getIdPart());
        if (retVal == null) {
            throw new ResourceNotFoundException(theId);
        }
        return HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(retVal, theRequestDetails);
    }

    @History
    public List<T> historyType() {
        return this.myTypeHistory;
    }

    @Read(version=true)
    public T read(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        IBaseResource retVal;
        TreeMap<Long, T> versions = this.myIdToVersionToResourceMap.get(theId.getIdPart());
        if (versions == null || versions.isEmpty()) {
            throw new ResourceNotFoundException(theId);
        }
        if (theId.hasVersionIdPart()) {
            Long versionId = theId.getVersionIdPartAsLong();
            if (!versions.containsKey(versionId)) {
                throw new ResourceNotFoundException(theId);
            }
            IBaseResource resource = (IBaseResource)versions.get(versionId);
            if (resource == null) {
                throw new ResourceGoneException(theId);
            }
            retVal = resource;
        } else {
            retVal = (IBaseResource)versions.lastEntry().getValue();
        }
        this.myReadCount.incrementAndGet();
        retVal = HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(retVal, theRequestDetails);
        if (retVal == null) {
            throw new ResourceNotFoundException(theId);
        }
        return (T)retVal;
    }

    @Search
    public List<IBaseResource> searchAll(RequestDetails theRequestDetails) {
        this.mySearchCount.incrementAndGet();
        List<T> retVal = this.getAllResources();
        return HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(retVal, theRequestDetails);
    }

    @Nonnull
    protected List<T> getAllResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (TreeMap<Long, T> next : this.myIdToVersionToResourceMap.values()) {
            IBaseResource nextResource;
            if (next.isEmpty() || (nextResource = (IBaseResource)next.lastEntry().getValue()) == null) continue;
            retVal.add(nextResource);
        }
        return retVal;
    }

    @Search
    public List<IBaseResource> searchById(@RequiredParam(name="_id") TokenAndListParam theIds, RequestDetails theRequestDetails) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (TreeMap<Long, T> next : this.myIdToVersionToResourceMap.values()) {
            if (next.isEmpty()) continue;
            IBaseResource nextResource = (IBaseResource)next.lastEntry().getValue();
            boolean matches = true;
            if (theIds != null && theIds.getValuesAsQueryTokens().size() > 0) {
                for (TokenOrListParam nextIdAnd : theIds.getValuesAsQueryTokens()) {
                    matches = false;
                    for (TokenParam nextOr : nextIdAnd.getValuesAsQueryTokens()) {
                        if (!nextOr.getValue().equals(nextResource.getIdElement().getIdPart())) continue;
                        matches = true;
                    }
                    if (matches) continue;
                    break;
                }
            }
            if (!matches) continue;
            retVal.add(nextResource);
        }
        this.mySearchCount.incrementAndGet();
        return HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(retVal, theRequestDetails);
    }

    private IIdType store(@ResourceParam T theResource, String theIdPart, Long theVersionIdPart, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IIdType id = this.myFhirContext.getVersion().newIdType();
        String versionIdPart = Long.toString(theVersionIdPart);
        id.setParts(null, this.myResourceName, theIdPart, versionIdPart);
        if (theResource != null) {
            theResource.setId(id);
        }
        if (theResource != null) {
            if (this.myFhirContext.getVersion().getVersion() == FhirVersionEnum.DSTU2) {
                ResourceMetadataKeyEnum.VERSION.put((IResource)theResource, (Object)versionIdPart);
            } else {
                IBase meta;
                BaseRuntimeElementCompositeDefinition metaDef;
                BaseRuntimeChildDefinition versionIdDef;
                List versionIdValues;
                BaseRuntimeChildDefinition metaChild = this.myFhirContext.getResourceDefinition(this.myResourceType).getChildByName("meta");
                List metaValues = metaChild.getAccessor().getValues(theResource);
                if (metaValues.size() > 0 && (versionIdValues = (versionIdDef = (metaDef = (BaseRuntimeElementCompositeDefinition)this.myFhirContext.getElementDefinition((meta = (IBase)metaValues.get(0)).getClass())).getChildByName("versionId")).getAccessor().getValues(meta)).size() > 0) {
                    IPrimitiveType versionId = (IPrimitiveType)versionIdValues.get(0);
                    versionId.setValueAsString(versionIdPart);
                }
            }
        }
        ourLog.info("Storing resource with ID: {}", (Object)id.getValue());
        TreeMap<Long, T> versionToResource = this.getVersionToResource(theIdPart);
        versionToResource.put(theVersionIdPart, theResource);
        if (theRequestDetails != null) {
            IInterceptorBroadcaster interceptorBroadcaster = theRequestDetails.getInterceptorBroadcaster();
            if (theResource != null) {
                HookParams params;
                if (!this.myIdToHistory.containsKey(theIdPart)) {
                    params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, theResource).add(TransactionDetails.class, (Object)theTransactionDetails);
                    interceptorBroadcaster.callHooks(Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED, params);
                    interceptorBroadcaster.callHooks(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED, params);
                } else {
                    params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, (Object)((IBaseResource)this.myIdToHistory.get(theIdPart).getFirst())).add(IBaseResource.class, theResource).add(TransactionDetails.class, (Object)theTransactionDetails);
                    interceptorBroadcaster.callHooks(Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED, params);
                    interceptorBroadcaster.callHooks(Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED, params);
                }
            }
        }
        this.myTypeHistory.addFirst(theResource);
        this.myIdToHistory.computeIfAbsent(theIdPart, t -> new LinkedList());
        this.myIdToHistory.get(theIdPart).addFirst(theResource);
        return id;
    }

    @Update
    public MethodOutcome update(@ResourceParam T theResource, @ConditionalUrlParam String theConditional, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        ValidateUtil.isTrueOrThrowInvalidRequest((boolean)StringUtils.isBlank((CharSequence)theConditional), (String)"This server doesn't support conditional update", (Object[])new Object[0]);
        boolean created = this.updateInternal(theResource, theRequestDetails, transactionDetails);
        this.myUpdateCount.incrementAndGet();
        return new MethodOutcome().setCreated(Boolean.valueOf(created)).setResource(theResource).setId(theResource.getIdElement());
    }

    private boolean updateInternal(@ResourceParam T theResource, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        boolean created;
        Long versionIdPart;
        String idPartAsString = theResource.getIdElement().getIdPart();
        TreeMap<Long, T> versionToResource = this.getVersionToResource(idPartAsString);
        if (versionToResource.isEmpty()) {
            versionIdPart = 1L;
            created = true;
        } else {
            versionIdPart = versionToResource.lastKey() + 1L;
            created = false;
        }
        IIdType id = this.store(theResource, idPartAsString, versionIdPart, theRequestDetails, theTransactionDetails);
        theResource.setId(id);
        return created;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public IIdType store(T theResource) {
        if (theResource.getIdElement().hasIdPart()) {
            this.updateInternal(theResource, null, new TransactionDetails());
        } else {
            this.createInternal(theResource, null, new TransactionDetails());
        }
        return theResource.getIdElement();
    }

    public List<T> getStoredResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (TreeMap<Long, T> next : this.myIdToVersionToResourceMap.values()) {
            retVal.add((IBaseResource)next.lastEntry().getValue());
        }
        return Collections.unmodifiableList(retVal);
    }

    private static <T extends IBaseResource> T fireInterceptorsAndFilterAsNeeded(T theResource, RequestDetails theRequestDetails) {
        List<IBaseResource> output = HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(Lists.newArrayList((Object[])new IBaseResource[]{theResource}), theRequestDetails);
        if (output.size() == 1) {
            return theResource;
        }
        return null;
    }

    protected static <T extends IBaseResource> List<IBaseResource> fireInterceptorsAndFilterAsNeeded(List<T> theResources, RequestDetails theRequestDetails) {
        List<IBaseResource> resourcesToReturn = new ArrayList<IBaseResource>(theResources);
        if (theRequestDetails != null) {
            IInterceptorBroadcaster interceptorBroadcaster = theRequestDetails.getInterceptorBroadcaster();
            SimplePreResourceAccessDetails preResourceAccessDetails = new SimplePreResourceAccessDetails(resourcesToReturn);
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IPreResourceAccessDetails.class, (Object)preResourceAccessDetails);
            interceptorBroadcaster.callHooks(Pointcut.STORAGE_PREACCESS_RESOURCES, params);
            preResourceAccessDetails.applyFilterToList();
            SimplePreResourceShowDetails preResourceShowDetails = new SimplePreResourceShowDetails(resourcesToReturn);
            HookParams preShowParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IPreResourceShowDetails.class, (Object)preResourceShowDetails);
            interceptorBroadcaster.callHooks(Pointcut.STORAGE_PRESHOW_RESOURCES, preShowParams);
            resourcesToReturn = preResourceShowDetails.toList();
        }
        return resourcesToReturn;
    }
}

