/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.annotation.AddTags;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.DeleteTags;
import ca.uhn.fhir.rest.annotation.GetPage;
import ca.uhn.fhir.rest.annotation.GraphQL;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.Patch;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.BundleProviders;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseQueryParameter;
import ca.uhn.fhir.rest.server.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.server.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.server.method.CreateMethodBinding;
import ca.uhn.fhir.rest.server.method.DeleteMethodBinding;
import ca.uhn.fhir.rest.server.method.GraphQLMethodBinding;
import ca.uhn.fhir.rest.server.method.HistoryMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.IncludeParameter;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.rest.server.method.MethodUtil;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.PageMethodBinding;
import ca.uhn.fhir.rest.server.method.PatchMethodBinding;
import ca.uhn.fhir.rest.server.method.ReadMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.TransactionMethodBinding;
import ca.uhn.fhir.rest.server.method.UpdateMethodBinding;
import ca.uhn.fhir.rest.server.method.ValidateMethodBindingDstu2Plus;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMethodBinding<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseMethodBinding.class);
    private final List<BaseQueryParameter> myQueryParameters;
    private FhirContext myContext;
    private Method myMethod;
    private List<IParameter> myParameters;
    private Object myProvider;
    private boolean mySupportsConditional;
    private boolean mySupportsConditionalMultiple;

    public BaseMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        assert (theMethod != null);
        assert (theContext != null);
        this.myMethod = theMethod;
        this.myContext = theContext;
        this.myProvider = theProvider;
        this.myParameters = MethodUtil.getResourceParameters(theContext, theMethod, theProvider, this.getRestOperationType());
        this.myQueryParameters = this.myParameters.stream().filter(t -> t instanceof BaseQueryParameter).map(t -> (BaseQueryParameter)t).collect(Collectors.toList());
        for (IParameter next : this.myParameters) {
            if (!(next instanceof ConditionalParamBinder)) continue;
            this.mySupportsConditional = true;
            if (!((ConditionalParamBinder)next).isSupportsMultiple()) break;
            this.mySupportsConditionalMultiple = true;
            break;
        }
        this.myMethod.setAccessible(true);
    }

    protected List<BaseQueryParameter> getQueryParameters() {
        return this.myQueryParameters;
    }

    protected Object[] createMethodParams(RequestDetails theRequest) {
        Object[] params = new Object[this.getParameters().size()];
        for (int i = 0; i < this.getParameters().size(); ++i) {
            IParameter param = this.getParameters().get(i);
            if (param == null) continue;
            params[i] = param.translateQueryParametersIntoServerArgument(theRequest, this);
        }
        return params;
    }

    protected Object[] createParametersForServerRequest(RequestDetails theRequest) {
        Object[] params = new Object[this.getParameters().size()];
        for (int i = 0; i < this.getParameters().size(); ++i) {
            IParameter param = this.getParameters().get(i);
            if (param == null) continue;
            params[i] = param.translateQueryParametersIntoServerArgument(theRequest, this);
        }
        return params;
    }

    public boolean isGlobalMethod() {
        return false;
    }

    public List<Class<?>> getAllowableParamAnnotations() {
        return null;
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    public Set<String> getIncludes() {
        TreeSet<String> retVal = new TreeSet<String>();
        for (IParameter next : this.myParameters) {
            if (!(next instanceof IncludeParameter)) continue;
            retVal.addAll(((IncludeParameter)next).getAllow());
        }
        return retVal;
    }

    public Method getMethod() {
        return this.myMethod;
    }

    public List<IParameter> getParameters() {
        return this.myParameters;
    }

    public void setParameters(List<IParameter> theParameters) {
        this.myParameters = theParameters;
    }

    public Object getProvider() {
        return this.myProvider;
    }

    public Set<Include> getRequestIncludesFromParams(Object[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        int index = 0;
        boolean match = false;
        for (IParameter parameter : this.myParameters) {
            if (parameter instanceof IncludeParameter) {
                match = true;
                break;
            }
            ++index;
        }
        if (!match) {
            return null;
        }
        if (index >= params.length) {
            ourLog.warn("index out of parameter range (should never happen");
            return null;
        }
        if (params[index] instanceof Set) {
            return (Set)params[index];
        }
        if (params[index] instanceof Iterable) {
            HashSet<Include> includes = new HashSet<Include>();
            for (Object o : (Iterable)params[index]) {
                if (!(o instanceof Include)) continue;
                includes.add((Include)o);
            }
            return includes;
        }
        ourLog.warn("include params wasn't Set or Iterable, it was {}", params[index].getClass());
        return null;
    }

    public abstract String getResourceName();

    @Nonnull
    public abstract RestOperationTypeEnum getRestOperationType();

    public RestOperationTypeEnum getRestOperationType(RequestDetails theRequestDetails) {
        return this.getRestOperationType();
    }

    public abstract MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails var1);

    public abstract Object invokeServer(IRestfulServer<?> var1, RequestDetails var2) throws BaseServerResponseException, IOException;

    protected final Object invokeServerMethod(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) {
        RestOperationTypeEnum operationType = this.getRestOperationType(theRequest);
        if (operationType != null) {
            IServerInterceptor.ActionRequestDetails details = new IServerInterceptor.ActionRequestDetails(theRequest);
            this.populateActionRequestDetailsForInterceptor(theRequest, details, theMethodParams);
            HookParams preHandledParams = new HookParams();
            preHandledParams.add(RestOperationTypeEnum.class, (Object)theRequest.getRestOperationType());
            preHandledParams.add(RequestDetails.class, (Object)theRequest);
            preHandledParams.addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            preHandledParams.add(IServerInterceptor.ActionRequestDetails.class, (Object)details);
            if (theRequest.getInterceptorBroadcaster() != null) {
                theRequest.getInterceptorBroadcaster().callHooks(Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED, preHandledParams);
            }
        }
        try {
            Method method = this.getMethod();
            return method.invoke(this.getProvider(), theMethodParams);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof BaseServerResponseException) {
                throw (BaseServerResponseException)e.getCause();
            }
            throw new InternalErrorException("Failed to call access method: " + e.getCause(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException("Failed to call access method: " + e.getCause(), (Throwable)e);
        }
    }

    public boolean isSupportsConditional() {
        return this.mySupportsConditional;
    }

    public boolean isSupportsConditionalMultiple() {
        return this.mySupportsConditionalMultiple;
    }

    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
    }

    protected IBundleProvider toResourceList(Object response) throws InternalErrorException {
        if (response == null) {
            return BundleProviders.newEmptyList();
        }
        if (response instanceof IBundleProvider) {
            return (IBundleProvider)response;
        }
        if (response instanceof IBaseResource) {
            return BundleProviders.newList((IBaseResource)response);
        }
        if (response instanceof Collection) {
            ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
            for (Object next : (Collection)response) {
                retVal.add((IBaseResource)next);
            }
            return BundleProviders.newList(retVal);
        }
        if (response instanceof MethodOutcome) {
            IBaseOperationOutcome retVal = ((MethodOutcome)response).getOperationOutcome();
            if (retVal == null) {
                retVal = (IBaseResource)this.getContext().getResourceDefinition("OperationOutcome").newInstance();
            }
            return BundleProviders.newList((IBaseResource)retVal);
        }
        throw new InternalErrorException("Unexpected return type: " + response.getClass().getCanonicalName());
    }

    public static BaseMethodBinding<?> bindMethod(Method theMethod, FhirContext theContext, Object theProvider) {
        Class returnType;
        GraphQL graphQL;
        Patch patch;
        GetPage getPage;
        Operation operation;
        Transaction transaction;
        DeleteTags deleteTags;
        AddTags addTags;
        Validate validate;
        History history;
        Delete delete;
        Update update;
        Create create;
        Metadata conformance;
        Search search;
        Read read = theMethod.getAnnotation(Read.class);
        if (!BaseMethodBinding.verifyMethodHasZeroOrOneOperationAnnotation(theMethod, read, search = theMethod.getAnnotation(Search.class), conformance = theMethod.getAnnotation(Metadata.class), create = theMethod.getAnnotation(Create.class), update = theMethod.getAnnotation(Update.class), delete = theMethod.getAnnotation(Delete.class), history = theMethod.getAnnotation(History.class), validate = theMethod.getAnnotation(Validate.class), addTags = theMethod.getAnnotation(AddTags.class), deleteTags = theMethod.getAnnotation(DeleteTags.class), transaction = theMethod.getAnnotation(Transaction.class), operation = theMethod.getAnnotation(Operation.class), getPage = theMethod.getAnnotation(GetPage.class), patch = theMethod.getAnnotation(Patch.class), graphQL = theMethod.getAnnotation(GraphQL.class))) {
            return null;
        }
        if (getPage != null) {
            return new PageMethodBinding(theContext, theMethod);
        }
        if (graphQL != null) {
            return new GraphQLMethodBinding(theMethod, theContext, theProvider);
        }
        Class returnTypeFromRp = null;
        if (theProvider instanceof IResourceProvider && !BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromRp = ((IResourceProvider)theProvider).getResourceType())) {
            throw new ConfigurationException("getResourceType() from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returned " + BaseMethodBinding.toLogString(returnTypeFromRp) + " - Must return a resource type");
        }
        Class returnTypeFromMethod = theMethod.getReturnType();
        if (!(MethodOutcome.class.isAssignableFrom(returnTypeFromMethod) || IBundleProvider.class.equals(returnTypeFromMethod) || Void.TYPE.equals(returnTypeFromMethod))) {
            if (Collection.class.isAssignableFrom(returnTypeFromMethod)) {
                returnTypeFromMethod = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType((Method)theMethod);
                if (returnTypeFromMethod == null) {
                    ourLog.trace("Method {} returns a non-typed list, can't verify return type", (Object)theMethod);
                } else if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod) && !BaseMethodBinding.isResourceInterface(returnTypeFromMethod)) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns a collection with generic type " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type or a collection (List, Set) with a resource type parameter (e.g. List<Patient> or List<IBaseResource> )");
                }
            } else if (!BaseMethodBinding.isResourceInterface(returnTypeFromMethod) && !BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod)) {
                throw new ConfigurationException("Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type (eg Patient, Bundle, " + IBundleProvider.class.getSimpleName() + ", etc., see the documentation for more details)");
            }
        }
        Class returnTypeFromAnnotation = IBaseResource.class;
        if (read != null) {
            returnTypeFromAnnotation = read.type();
        } else if (search != null) {
            returnTypeFromAnnotation = search.type();
        } else if (history != null) {
            returnTypeFromAnnotation = history.type();
        } else if (delete != null) {
            returnTypeFromAnnotation = delete.type();
        } else if (patch != null) {
            returnTypeFromAnnotation = patch.type();
        } else if (create != null) {
            returnTypeFromAnnotation = create.type();
        } else if (update != null) {
            returnTypeFromAnnotation = update.type();
        } else if (validate != null) {
            returnTypeFromAnnotation = validate.type();
        } else if (addTags != null) {
            returnTypeFromAnnotation = addTags.type();
        } else if (deleteTags != null) {
            returnTypeFromAnnotation = deleteTags.type();
        }
        if (returnTypeFromRp != null) {
            if (returnTypeFromAnnotation != null && !BaseMethodBinding.isResourceInterface(returnTypeFromAnnotation)) {
                if (returnTypeFromMethod != null && !returnTypeFromRp.isAssignableFrom(returnTypeFromMethod)) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " returns type " + returnTypeFromMethod.getCanonicalName() + " - Must return " + returnTypeFromRp.getCanonicalName() + " (or a subclass of it) per IResourceProvider contract");
                }
                if (!returnTypeFromRp.isAssignableFrom(returnTypeFromAnnotation)) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " claims to return type " + returnTypeFromAnnotation.getCanonicalName() + " per method annotation - Must return " + returnTypeFromRp.getCanonicalName() + " (or a subclass of it) per IResourceProvider contract");
                }
                returnType = returnTypeFromAnnotation;
            } else {
                returnType = returnTypeFromRp;
            }
        } else if (!BaseMethodBinding.isResourceInterface(returnTypeFromAnnotation)) {
            if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromAnnotation)) {
                throw new ConfigurationException("Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromAnnotation) + " according to annotation - Must return a resource type");
            }
            returnType = returnTypeFromAnnotation;
        } else {
            returnType = returnTypeFromMethod;
        }
        if (read != null) {
            return new ReadMethodBinding(returnType, theMethod, theContext, theProvider);
        }
        if (search != null) {
            return new SearchMethodBinding(returnType, returnTypeFromRp, theMethod, theContext, theProvider);
        }
        if (conformance != null) {
            return new ConformanceMethodBinding(theMethod, theContext, theProvider);
        }
        if (create != null) {
            return new CreateMethodBinding(theMethod, theContext, theProvider);
        }
        if (update != null) {
            return new UpdateMethodBinding(theMethod, theContext, theProvider);
        }
        if (delete != null) {
            return new DeleteMethodBinding(theMethod, theContext, theProvider);
        }
        if (patch != null) {
            return new PatchMethodBinding(theMethod, theContext, theProvider);
        }
        if (history != null) {
            return new HistoryMethodBinding(theMethod, theContext, theProvider);
        }
        if (validate != null) {
            return new ValidateMethodBindingDstu2Plus(returnType, (Class<? extends IBaseResource>)returnTypeFromRp, theMethod, theContext, theProvider, validate);
        }
        if (transaction != null) {
            return new TransactionMethodBinding(theMethod, theContext, theProvider);
        }
        if (operation != null) {
            return new OperationMethodBinding(returnType, returnTypeFromRp, theMethod, theContext, theProvider, operation);
        }
        throw new ConfigurationException("Did not detect any FHIR annotations on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
    }

    private static boolean isResourceInterface(Class<?> theReturnTypeFromMethod) {
        return theReturnTypeFromMethod.equals(IBaseResource.class) || theReturnTypeFromMethod.equals(IResource.class) || theReturnTypeFromMethod.equals(IAnyResource.class);
    }

    private static String toLogString(Class<?> theType) {
        if (theType == null) {
            return null;
        }
        return theType.getCanonicalName();
    }

    private static boolean verifyIsValidResourceReturnType(Class<?> theReturnType) {
        if (theReturnType == null) {
            return false;
        }
        return IBaseResource.class.isAssignableFrom(theReturnType);
    }

    public static boolean verifyMethodHasZeroOrOneOperationAnnotation(Method theNextMethod, Object ... theAnnotations) {
        Object obj1 = null;
        for (Object object : theAnnotations) {
            if (object == null) continue;
            if (obj1 == null) {
                obj1 = object;
                continue;
            }
            throw new ConfigurationException("Method " + theNextMethod.getName() + " on type '" + theNextMethod.getDeclaringClass().getSimpleName() + " has annotations @" + obj1.getClass().getSimpleName() + " and @" + object.getClass().getSimpleName() + ". Can not have both.");
        }
        return obj1 != null;
    }
}

