/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizedList;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletSubRequestDetails;
import ca.uhn.fhir.rest.server.util.ServletRequestUtil;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.bundle.ModifiableBundleEntry;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNarrowingInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchNarrowingInterceptor.class);

    protected AuthorizedList buildAuthorizedList(RequestDetails theRequestDetails) {
        return null;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_POST_PROCESSED)
    public boolean incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        List<String> resources;
        Validate.isTrue((theRequestDetails.getRestOperationType() != RestOperationTypeEnum.SEARCH_SYSTEM ? 1 : 0) != 0);
        if (theRequestDetails.getRestOperationType() != RestOperationTypeEnum.SEARCH_TYPE) {
            return true;
        }
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        RuntimeResourceDefinition resDef = ctx.getResourceDefinition(theRequestDetails.getResourceName());
        HashMap<String, List<String>> parameterToOrValues = new HashMap<String, List<String>>();
        AuthorizedList authorizedList = this.buildAuthorizedList(theRequestDetails);
        if (authorizedList == null) {
            return true;
        }
        List<String> compartments = authorizedList.getAllowedCompartments();
        if (compartments != null) {
            this.processResourcesOrCompartments(theRequestDetails, resDef, parameterToOrValues, compartments, true);
        }
        if ((resources = authorizedList.getAllowedInstances()) != null) {
            this.processResourcesOrCompartments(theRequestDetails, resDef, parameterToOrValues, resources, false);
        }
        if (parameterToOrValues.size() > 0) {
            HashMap<String, String[]> newParameters = new HashMap<String, String[]>(theRequestDetails.getParameters());
            for (Map.Entry<String, List<String>> nextEntry : parameterToOrValues.entrySet()) {
                String nextParamName = nextEntry.getKey();
                List<String> nextAllowedValues = nextEntry.getValue();
                if (!newParameters.containsKey(nextParamName)) {
                    String nextValuesJoined = ParameterUtil.escapeAndJoinOrList(nextAllowedValues);
                    String[] paramValues = new String[]{nextValuesJoined};
                    newParameters.put(nextParamName, paramValues);
                    continue;
                }
                String[] existingValues = (String[])newParameters.get(nextParamName);
                boolean restrictedExistingList = false;
                for (int i = 0; i < existingValues.length; ++i) {
                    String nextExistingValue = existingValues[i];
                    QualifiedParamList nextRequestedValues = QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, (String)nextExistingValue);
                    List nextPermittedValues = ListUtils.intersection((List)nextRequestedValues, nextAllowedValues);
                    if (nextPermittedValues.size() <= 0) continue;
                    restrictedExistingList = true;
                    existingValues[i] = ParameterUtil.escapeAndJoinOrList((Collection)nextPermittedValues);
                }
                if (restrictedExistingList) continue;
                String[] newValues = Arrays.copyOf(existingValues, existingValues.length + 1);
                newValues[existingValues.length] = ParameterUtil.escapeAndJoinOrList(nextAllowedValues);
                newParameters.put(nextParamName, newValues);
            }
            theRequestDetails.setParameters(newParameters);
        }
        return true;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void incomingRequestPreHandled(ServletRequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        if (theRequestDetails.getRestOperationType() != RestOperationTypeEnum.TRANSACTION) {
            return;
        }
        IBaseBundle bundle = (IBaseBundle)theRequestDetails.getResource();
        FhirContext ctx = theRequestDetails.getFhirContext();
        BundleEntryUrlProcessor processor = new BundleEntryUrlProcessor(ctx, theRequestDetails, theRequest, theResponse);
        BundleUtil.processEntries((FhirContext)ctx, (IBaseBundle)bundle, (Consumer)processor);
    }

    private void processResourcesOrCompartments(RequestDetails theRequestDetails, RuntimeResourceDefinition theResDef, HashMap<String, List<String>> theParameterToOrValues, Collection<String> theResourcesOrCompartments, boolean theAreCompartments) {
        String lastCompartmentName = null;
        String lastSearchParamName = null;
        for (String nextCompartment : theResourcesOrCompartments) {
            Validate.isTrue((StringUtils.countMatches((CharSequence)nextCompartment, (char)'/') == 1 ? 1 : 0) != 0, (String)"Invalid compartment name (must be in form \"ResourceType/xxx\": %s", (Object[])new Object[]{nextCompartment});
            String compartmentName = nextCompartment.substring(0, nextCompartment.indexOf(47));
            String searchParamName = null;
            if (compartmentName.equalsIgnoreCase(lastCompartmentName)) {
                searchParamName = lastSearchParamName;
            } else {
                List searchParams;
                if (compartmentName.equalsIgnoreCase(theRequestDetails.getResourceName())) {
                    searchParamName = "_id";
                } else if (theAreCompartments && (searchParams = theResDef.getSearchParamsForCompartmentName(compartmentName)).size() > 0) {
                    RuntimeSearchParam searchParam = searchParams.stream().filter(t -> t.getName().equalsIgnoreCase(compartmentName)).findFirst().orElse((RuntimeSearchParam)searchParams.get(0));
                    searchParamName = searchParam.getName();
                }
                lastCompartmentName = compartmentName;
                lastSearchParamName = searchParamName;
            }
            if (searchParamName == null) continue;
            List orValues = theParameterToOrValues.computeIfAbsent(searchParamName, t -> new ArrayList());
            orValues.add(nextCompartment);
        }
    }

    private class BundleEntryUrlProcessor
    implements Consumer<ModifiableBundleEntry> {
        private final FhirContext myFhirContext;
        private final ServletRequestDetails myRequestDetails;
        private final HttpServletRequest myRequest;
        private final HttpServletResponse myResponse;

        public BundleEntryUrlProcessor(FhirContext theFhirContext, ServletRequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) {
            this.myFhirContext = theFhirContext;
            this.myRequestDetails = theRequestDetails;
            this.myRequest = theRequest;
            this.myResponse = theResponse;
        }

        @Override
        public void accept(ModifiableBundleEntry theModifiableBundleEntry) {
            ArrayListMultimap paramValues = ArrayListMultimap.create();
            String url = theModifiableBundleEntry.getRequestUrl();
            ServletSubRequestDetails subServletRequestDetails = ServletRequestUtil.getServletSubRequestDetails(this.myRequestDetails, url, (ArrayListMultimap<String, String>)paramValues);
            BaseMethodBinding<?> method = subServletRequestDetails.getServer().determineResourceMethod(subServletRequestDetails, url);
            RestOperationTypeEnum restOperationType = method.getRestOperationType();
            subServletRequestDetails.setRestOperationType(restOperationType);
            SearchNarrowingInterceptor.this.incomingRequestPostProcessed(subServletRequestDetails, this.myRequest, this.myResponse);
            theModifiableBundleEntry.setRequestUrl(this.myFhirContext, ServletRequestUtil.extractUrl(subServletRequestDetails));
        }
    }
}

