/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

class OperationRule
extends BaseRule
implements IAuthRule {
    private String myOperationName;
    private boolean myAppliesToServer;
    private HashSet<Class<? extends IBaseResource>> myAppliesToTypes;
    private List<IIdType> myAppliesToIds;
    private HashSet<Class<? extends IBaseResource>> myAppliesToInstancesOfType;
    private boolean myAppliesToAnyType;
    private boolean myAppliesToAnyInstance;
    private boolean myAppliesAtAnyLevel;
    private boolean myAllowAllResponses;

    OperationRule(String theRuleName) {
        super(theRuleName);
    }

    void appliesAtAnyLevel(boolean theAppliesAtAnyLevel) {
        this.myAppliesAtAnyLevel = theAppliesAtAnyLevel;
    }

    public void allowAllResponses() {
        this.myAllowAllResponses = true;
    }

    void appliesToAnyInstance() {
        this.myAppliesToAnyInstance = true;
    }

    void appliesToAnyType() {
        this.myAppliesToAnyType = true;
    }

    void appliesToInstances(List<IIdType> theAppliesToIds) {
        this.myAppliesToIds = theAppliesToIds;
    }

    void appliesToInstancesOfType(HashSet<Class<? extends IBaseResource>> theAppliesToTypes) {
        this.myAppliesToInstancesOfType = theAppliesToTypes;
    }

    void appliesToServer() {
        this.myAppliesToServer = true;
    }

    void appliesToTypes(HashSet<Class<? extends IBaseResource>> theAppliesToTypes) {
        this.myAppliesToTypes = theAppliesToTypes;
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier, Set<AuthorizationFlagsEnum> theFlags, Pointcut thePointcut) {
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        boolean applies = false;
        block0 : switch (theOperation) {
            case ADD_TAGS: 
            case DELETE_TAGS: 
            case GET_TAGS: 
            case GET_PAGE: 
            case GRAPHQL_REQUEST: {
                return null;
            }
            case EXTENDED_OPERATION_SERVER: {
                if (!this.myAppliesToServer && !this.myAppliesAtAnyLevel) break;
                applies = true;
                break;
            }
            case EXTENDED_OPERATION_TYPE: {
                if (this.myAppliesToAnyType || this.myAppliesAtAnyLevel) {
                    applies = true;
                    break;
                }
                if (this.myAppliesToTypes == null) break;
                for (Class<? extends IBaseResource> next : this.myAppliesToTypes) {
                    String resName = ctx.getResourceDefinition(next).getName();
                    if (!resName.equals(theRequestDetails.getResourceName())) continue;
                    applies = true;
                    break block0;
                }
                break;
            }
            case EXTENDED_OPERATION_INSTANCE: {
                if (this.myAppliesToAnyInstance || this.myAppliesAtAnyLevel) {
                    applies = true;
                    break;
                }
                IIdType requestResourceId = null;
                if (theInputResourceId != null) {
                    requestResourceId = theInputResourceId;
                }
                if (requestResourceId == null && this.myAllowAllResponses) {
                    requestResourceId = theRequestDetails.getId();
                }
                if (requestResourceId == null) break;
                if (this.myAppliesToIds != null) {
                    String instanceId = requestResourceId.toUnqualifiedVersionless().getValue();
                    for (IIdType next : this.myAppliesToIds) {
                        if (!next.toUnqualifiedVersionless().getValue().equals(instanceId)) continue;
                        applies = true;
                        break;
                    }
                }
                if (this.myAppliesToInstancesOfType == null) break;
                for (Class<? extends IBaseResource> next : this.myAppliesToInstancesOfType) {
                    String resName = ctx.getResourceDefinition(next).getName();
                    if (!resName.equals(requestResourceId.getResourceType())) continue;
                    applies = true;
                    break block0;
                }
                break;
            }
            case CREATE: {
                break;
            }
            case DELETE: {
                break;
            }
            case HISTORY_INSTANCE: {
                break;
            }
            case HISTORY_SYSTEM: {
                break;
            }
            case HISTORY_TYPE: {
                break;
            }
            case READ: {
                break;
            }
            case SEARCH_SYSTEM: {
                break;
            }
            case SEARCH_TYPE: {
                break;
            }
            case TRANSACTION: {
                break;
            }
            case UPDATE: {
                break;
            }
            case VALIDATE: {
                break;
            }
            case VREAD: {
                break;
            }
            case METADATA: {
                break;
            }
            case META_ADD: {
                break;
            }
            case META: {
                break;
            }
            case META_DELETE: {
                break;
            }
            case PATCH: {
                break;
            }
            default: {
                return null;
            }
        }
        if (!applies) {
            return null;
        }
        if (this.myOperationName != null && !this.myOperationName.equals(theRequestDetails.getOperation())) {
            return null;
        }
        return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
    }

    public void setOperationName(String theOperationName) {
        this.myOperationName = theOperationName;
    }
}

