/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.BasePagingProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.commons.lang3.Validate;

public class FifoMemoryPagingProvider
extends BasePagingProvider
implements IPagingProvider {
    private LinkedHashMap<String, IBundleProvider> myBundleProviders;
    private int mySize;

    public FifoMemoryPagingProvider(int theSize) {
        Validate.isTrue((theSize > 0 ? 1 : 0) != 0, (String)"theSize must be greater than 0", (Object[])new Object[0]);
        this.mySize = theSize;
        this.myBundleProviders = new LinkedHashMap(this.mySize);
    }

    @Override
    public synchronized IBundleProvider retrieveResultList(RequestDetails theRequest, String theId) {
        return this.myBundleProviders.get(theId);
    }

    @Override
    public synchronized String storeResultList(RequestDetails theRequestDetails, IBundleProvider theList) {
        while (this.myBundleProviders.size() > this.mySize) {
            this.myBundleProviders.remove(this.myBundleProviders.keySet().iterator().next());
        }
        String key = UUID.randomUUID().toString();
        this.myBundleProviders.put(key, theList);
        return key;
    }
}

