/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server.storage;

import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hl7.fhir.instance.model.api.IIdType;

public class TransactionDetails {
    private final Date myTransactionDate;
    private Map<IIdType, ResourcePersistentId> myResolvedResourceIds = Collections.emptyMap();
    private Map<String, Object> myUserData;

    public TransactionDetails() {
        this.myTransactionDate = new Date();
    }

    public TransactionDetails(Date theTransactionDate) {
        this.myTransactionDate = theTransactionDate;
    }

    public Map<IIdType, ResourcePersistentId> getResolvedResourceIds() {
        return this.myResolvedResourceIds;
    }

    public void addResolvedResourceId(IIdType theResourceId, ResourcePersistentId thePersistentId) {
        assert (theResourceId != null);
        assert (thePersistentId != null);
        if (this.myResolvedResourceIds.isEmpty()) {
            this.myResolvedResourceIds = new HashMap<IIdType, ResourcePersistentId>();
        }
        this.myResolvedResourceIds.put(theResourceId, thePersistentId);
    }

    public Date getTransactionDate() {
        return this.myTransactionDate;
    }

    public void putUserData(String theKey, Object theValue) {
        if (this.myUserData == null) {
            this.myUserData = new HashMap<String, Object>();
        }
        this.myUserData.put(theKey, theValue);
    }

    public <T> T getUserData(String theKey) {
        if (this.myUserData != null) {
            return (T)this.myUserData.get(theKey);
        }
        return null;
    }

    public <T> T getOrCreateUserData(String theKey, Supplier<T> theSupplier) {
        T retVal = this.getUserData(theKey);
        if (retVal == null) {
            retVal = theSupplier.get();
            this.putUserData(theKey, retVal);
        }
        return retVal;
    }
}

