/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.util.BundleUtil;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionParameter
implements IParameter {
    private FhirContext myContext;
    private ParamStyle myParamStyle;
    private Class<? extends IBaseResource> myResourceBundleType;

    public TransactionParameter(FhirContext theContext) {
        this.myContext = theContext;
    }

    private String createParameterTypeError(Method theMethod) {
        return "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but is not of type List<" + IResource.class.getCanonicalName() + "> or Bundle";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but can not be a collection of collections");
        }
        if (!Modifier.isInterface(theParameterType.getModifiers()) && IBaseResource.class.isAssignableFrom(theParameterType)) {
            Class<?> parameterType = theParameterType;
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(parameterType);
            if (!"Bundle".equals(def.getName())) throw new ConfigurationException(this.createParameterTypeError(theMethod));
            this.myParamStyle = ParamStyle.RESOURCE_BUNDLE;
            this.myResourceBundleType = parameterType;
            return;
        } else {
            if (!theInnerCollectionType.equals(List.class)) {
                throw new ConfigurationException(this.createParameterTypeError(theMethod));
            }
            if (!theParameterType.equals(IResource.class)) {
                throw new ConfigurationException(this.createParameterTypeError(theMethod));
            }
            this.myParamStyle = ParamStyle.RESOURCE_LIST;
        }
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        EncodingEnum encoding = RestfulServerUtils.determineRequestEncoding(theRequest);
        IParser parser = encoding.newParser(theRequest.getServer().getFhirContext());
        Reader reader = ResourceParameter.createRequestReader(theRequest);
        try {
            switch (this.myParamStyle) {
                case RESOURCE_LIST: {
                    List resourceList;
                    Class type = this.myContext.getResourceDefinition("Bundle").getImplementingClass();
                    IBaseResource bundle = parser.parseResource(type, reader);
                    List list = resourceList = BundleUtil.toListOfResources((FhirContext)this.myContext, (IBaseBundle)((IBaseBundle)bundle));
                    return list;
                }
                case RESOURCE_BUNDLE: {
                    IBaseResource iBaseResource = parser.parseResource(this.myResourceBundleType, reader);
                    return iBaseResource;
                }
            }
            throw new IllegalStateException("Unknown type: " + (Object)((Object)this.myParamStyle));
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public ParamStyle getParamStyle() {
        return this.myParamStyle;
    }

    public static enum ParamStyle {
        RESOURCE_BUNDLE,
        RESOURCE_LIST;

    }
}

