/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class SortParameter
implements IParameter {
    private FhirContext myContext;

    public SortParameter(FhirContext theContext) {
        this.myContext = theContext;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null || theInnerCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Sort.class.getName() + " but can not be of collection type");
        }
        if (!theParameterType.equals(SortSpec.class)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Sort.class.getName() + " but is an invalid type, must be: " + SortSpec.class.getCanonicalName());
        }
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        if (!(theRequest.getParameters().containsKey("_sort") || theRequest.getParameters().containsKey("_sort:asc") || theRequest.getParameters().containsKey("_sort:desc"))) {
            return null;
        }
        SortSpec outerSpec = null;
        SortSpec innerSpec = null;
        for (String nextParamName : theRequest.getParameters().keySet()) {
            String[] values;
            SortOrderEnum order;
            if ("_sort".equals(nextParamName)) {
                order = null;
            } else if ("_sort:asc".equals(nextParamName)) {
                order = SortOrderEnum.ASC;
            } else {
                if (!"_sort:desc".equals(nextParamName)) continue;
                order = SortOrderEnum.DESC;
            }
            if ((values = theRequest.getParameters().get(nextParamName)) == null) continue;
            for (String nextValue : values) {
                if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2) && order == null) {
                    StringTokenizer tok = new StringTokenizer(nextValue, ",");
                    while (tok.hasMoreTokens()) {
                        String next = tok.nextToken();
                        if (!StringUtils.isNotBlank((CharSequence)next) || next.equals("-")) continue;
                        order = SortOrderEnum.ASC;
                        if (next.startsWith("-")) {
                            order = SortOrderEnum.DESC;
                            next = next.substring(1);
                        }
                        SortSpec spec = new SortSpec();
                        spec.setOrder(order);
                        spec.setParamName(next);
                        if (innerSpec == null) {
                            outerSpec = spec;
                            innerSpec = spec;
                            continue;
                        }
                        innerSpec.setChain(spec);
                        innerSpec = spec;
                    }
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)nextValue)) continue;
                SortSpec spec = new SortSpec();
                spec.setOrder(order);
                spec.setParamName(nextValue);
                if (innerSpec == null) {
                    outerSpec = spec;
                    innerSpec = spec;
                    continue;
                }
                innerSpec.setChain(spec);
                innerSpec = spec;
            }
        }
        return outerSpec;
    }

    public static String createSortStringDstu3(SortSpec ss) {
        StringBuilder val = new StringBuilder();
        while (ss != null) {
            if (StringUtils.isNotBlank((CharSequence)ss.getParamName())) {
                if (val.length() > 0) {
                    val.append(',');
                }
                if (ss.getOrder() == SortOrderEnum.DESC) {
                    val.append('-');
                }
                val.append(ParameterUtil.escape((String)ss.getParamName()));
            }
            ss = ss.getChain();
        }
        String string = val.toString();
        return string;
    }
}

