/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(PageMethodBinding.class);

    public PageMethodBinding(FhirContext theContext, Method theMethod) {
        super(null, theMethod, theContext, null);
    }

    public IBaseResource provider() {
        return null;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        return this.handlePagingRequest(theServer, theRequest, theRequest.getParameters().get("_getpages")[0]);
    }

    @Override
    public IBaseResource doInvokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) {
        return this.handlePagingRequest(theServer, theRequest, theRequest.getParameters().get("_getpages")[0]);
    }

    private IBaseResource handlePagingRequest(IRestfulServer<?> theServer, RequestDetails theRequest, String thePagingAction) {
        IPagingProvider pagingProvider = theServer.getPagingProvider();
        if (pagingProvider == null) {
            throw new InvalidRequestException("This server does not support paging");
        }
        IBundleProvider resultList = pagingProvider.retrieveResultList(thePagingAction);
        if (resultList == null) {
            ourLog.info("Client requested unknown paging ID[{}]", (Object)thePagingAction);
            String msg = this.getContext().getLocalizer().getMessage(PageMethodBinding.class, "unknownSearchId", new Object[]{thePagingAction});
            throw new ResourceGoneException(msg);
        }
        Integer count = RestfulServerUtils.extractCountParameter(theRequest);
        if (count == null) {
            count = pagingProvider.getDefaultPageSize();
        } else if (count > pagingProvider.getMaximumPageSize()) {
            count = pagingProvider.getMaximumPageSize();
        }
        Integer offsetI = RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_getpagesoffset");
        if (offsetI == null || offsetI < 0) {
            offsetI = 0;
        }
        Integer totalNum = resultList.size();
        int start = offsetI;
        if (totalNum != null) {
            start = Math.min(start, totalNum - 1);
        }
        RestfulServerUtils.ResponseEncoding responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequest, theServer.getDefaultResponseEncoding());
        HashSet<Include> includes = new HashSet<Include>();
        String[] reqIncludes = theRequest.getParameters().get("_include");
        if (reqIncludes != null) {
            for (String nextInclude : reqIncludes) {
                includes.add(new Include(nextInclude));
            }
        }
        String linkSelfBase = theRequest.getFhirServerBase();
        String completeUrl = theRequest.getCompleteUrl();
        String linkSelf = linkSelfBase + completeUrl.substring(theRequest.getCompleteUrl().indexOf(63));
        BundleTypeEnum bundleType = null;
        String[] bundleTypeValues = theRequest.getParameters().get(Constants.PARAM_BUNDLETYPE);
        if (bundleTypeValues != null) {
            bundleType = (BundleTypeEnum)BundleTypeEnum.VALUESET_BINDER.fromCodeString(bundleTypeValues[0]);
        }
        EncodingEnum encodingEnum = null;
        if (responseEncoding != null) {
            encodingEnum = responseEncoding.getEncoding();
        }
        return this.createBundleFromBundleProvider(theServer, theRequest, count, linkSelf, includes, resultList, start, bundleType, encodingEnum, thePagingAction);
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.GET_PAGE;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        String[] pageId = theRequest.getParameters().get("_getpages");
        if (pageId == null || pageId.length == 0 || StringUtils.isBlank((CharSequence)pageId[0])) {
            return false;
        }
        return theRequest.getRequestType() == RequestTypeEnum.GET;
    }
}

