/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class OperationMethodBinding
extends BaseResourceReturningMethodBinding {
    private BundleTypeEnum myBundleType;
    private boolean myCanOperateAtInstanceLevel;
    private boolean myCanOperateAtServerLevel;
    private boolean myCanOperateAtTypeLevel;
    private String myDescription;
    private final boolean myIdempotent;
    private final Integer myIdParamIndex;
    private final String myName;
    private final RestOperationTypeEnum myOtherOperatiopnType;
    private List<ReturnType> myReturnParams;
    private final BaseResourceReturningMethodBinding.ReturnTypeEnum myReturnType;

    protected OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, boolean theIdempotent, String theOperationName, Class<? extends IBaseResource> theOperationType, OperationParam[] theReturnParams, BundleTypeEnum theBundleType) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        Description description;
        this.myBundleType = theBundleType;
        this.myIdempotent = theIdempotent;
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        if (this.myIdParamIndex != null) {
            for (Annotation next : theMethod.getParameterAnnotations()[this.myIdParamIndex]) {
                if (!(next instanceof IdParam)) continue;
                this.myCanOperateAtTypeLevel = ((IdParam)next).optional();
            }
        } else {
            this.myCanOperateAtTypeLevel = true;
        }
        if ((description = theMethod.getAnnotation(Description.class)) != null) {
            this.myDescription = description.formalDefinition();
            if (StringUtils.isBlank((CharSequence)this.myDescription)) {
                this.myDescription = description.shortDefinition();
            }
        }
        if (StringUtils.isBlank((CharSequence)this.myDescription)) {
            this.myDescription = null;
        }
        if (StringUtils.isBlank((CharSequence)theOperationName)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getName() + " is annotated with @" + Operation.class.getSimpleName() + " but this annotation has no name defined");
        }
        if (!theOperationName.startsWith("$")) {
            theOperationName = "$" + theOperationName;
        }
        this.myName = theOperationName;
        if (theReturnTypeFromRp != null) {
            this.setResourceName(theContext.getResourceDefinition(theReturnTypeFromRp).getName());
        } else if (!Modifier.isAbstract(theOperationType.getModifiers())) {
            this.setResourceName(theContext.getResourceDefinition(theOperationType).getName());
        } else {
            this.setResourceName(null);
        }
        this.myReturnType = theMethod.getReturnType().equals(IBundleProvider.class) ? BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE : BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
        this.myOtherOperatiopnType = this.getResourceName() == null ? RestOperationTypeEnum.EXTENDED_OPERATION_SERVER : (this.myIdParamIndex == null ? RestOperationTypeEnum.EXTENDED_OPERATION_TYPE : RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE);
        this.myReturnParams = new ArrayList<ReturnType>();
        if (theReturnParams != null) {
            for (OperationParam next : theReturnParams) {
                ReturnType type = new ReturnType();
                type.setName(next.name());
                type.setMin(next.min());
                type.setMax(next.max());
                if (type.getMax() == -2) {
                    type.setMax(1);
                }
                if (!next.type().equals(IBase.class)) {
                    if (next.type().isInterface() || Modifier.isAbstract(next.type().getModifiers())) {
                        throw new ConfigurationException("Invalid value for @OperationParam.type(): " + next.type().getName());
                    }
                    type.setType(theContext.getElementDefinition(next.type()).getName());
                }
                this.myReturnParams.add(type);
            }
        }
        if (this.myIdParamIndex != null) {
            this.myCanOperateAtInstanceLevel = true;
        }
        if (this.getResourceName() == null) {
            this.myCanOperateAtServerLevel = true;
        }
    }

    public OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, Operation theAnnotation) {
        this(theReturnResourceType, theReturnTypeFromRp, theMethod, theContext, theProvider, theAnnotation.idempotent(), theAnnotation.name(), theAnnotation.type(), theAnnotation.returnParameters(), theAnnotation.bundleType());
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return this.myBundleType;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return this.myOtherOperatiopnType;
    }

    public List<ReturnType> getReturnParams() {
        return Collections.unmodifiableList(this.myReturnParams);
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return this.myReturnType;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        boolean requestHasId;
        if (this.getResourceName() == null ? StringUtils.isNotBlank((CharSequence)theRequest.getResourceName()) : !this.getResourceName().equals(theRequest.getResourceName())) {
            return false;
        }
        if (!this.myName.equals(theRequest.getOperation())) {
            return false;
        }
        RequestTypeEnum requestType = theRequest.getRequestType();
        if (requestType != RequestTypeEnum.GET && requestType != RequestTypeEnum.POST) {
            return false;
        }
        boolean bl = requestHasId = theRequest.getId() != null;
        return !(requestHasId ? !this.isCanOperateAtInstanceLevel() : !this.myCanOperateAtTypeLevel);
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        if (theRequest.getRequestType() == RequestTypeEnum.POST) {
            Object requestContents = ResourceParameter.loadResourceFromRequest(theRequest, this, null);
            theRequest.getUserData().put(OperationParameter.REQUEST_CONTENTS_USERDATA_KEY, requestContents);
        }
        return super.invokeServer(theServer, theRequest);
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws BaseServerResponseException {
        if (theRequest.getRequestType() != RequestTypeEnum.POST) {
            if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                if (!this.myIdempotent) {
                    String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.POST.name()});
                    throw new MethodNotAllowedException(message, new RequestTypeEnum[]{RequestTypeEnum.POST});
                }
            } else {
                if (!this.myIdempotent) {
                    String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.POST.name()});
                    throw new MethodNotAllowedException(message, new RequestTypeEnum[]{RequestTypeEnum.POST});
                }
                String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.GET.name(), RequestTypeEnum.POST.name()});
                throw new MethodNotAllowedException(message, new RequestTypeEnum[]{RequestTypeEnum.GET, RequestTypeEnum.POST});
            }
        }
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theServer, theRequest, theMethodParams);
        IBundleProvider retVal = this.toResourceList(response);
        return retVal;
    }

    public boolean isCanOperateAtInstanceLevel() {
        return this.myCanOperateAtInstanceLevel;
    }

    public boolean isCanOperateAtServerLevel() {
        return this.myCanOperateAtServerLevel;
    }

    public boolean isCanOperateAtTypeLevel() {
        return this.myCanOperateAtTypeLevel;
    }

    public boolean isIdempotent() {
        return this.myIdempotent;
    }

    @Override
    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
        super.populateActionRequestDetailsForInterceptor(theRequestDetails, theDetails, theMethodParams);
        theDetails.setResource((IBaseResource)theRequestDetails.getUserData().get(OperationParameter.REQUEST_CONTENTS_USERDATA_KEY));
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
    }

    public static class ReturnType {
        private int myMax;
        private int myMin;
        private String myName;
        private String myType;

        public int getMax() {
            return this.myMax;
        }

        public int getMin() {
            return this.myMin;
        }

        public String getName() {
            return this.myName;
        }

        public String getType() {
            return this.myType;
        }

        public void setMax(int theMax) {
            this.myMax = theMax;
        }

        public void setMin(int theMin) {
            this.myMin = theMin;
        }

        public void setName(String theName) {
            this.myName = theName;
        }

        public void setType(String theType) {
            this.myType = theType;
        }
    }
}

