/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.binder.CollectionBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class ElementsParameter
implements IParameter {
    private Class<? extends Collection> myInnerCollectionType;

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        Set<String> value = ElementsParameter.getElementsValueOrNull(theRequest);
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (this.myInnerCollectionType == null) {
            return StringUtils.join(value, (char)',');
        }
        try {
            Collection retVal = this.myInnerCollectionType.newInstance();
            retVal.addAll(value);
            return retVal;
        }
        catch (InstantiationException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
    }

    public static Set<String> getElementsValueOrNull(RequestDetails theRequest) {
        String[] summary = theRequest.getParameters().get("_elements");
        if (summary != null && summary.length > 0) {
            HashSet<String> retVal = new HashSet<String>();
            for (String next : summary) {
                StringTokenizer tok = new StringTokenizer(next, ",");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (!StringUtils.isNotBlank((CharSequence)token)) continue;
                    retVal.add(token);
                }
            }
            if (retVal.isEmpty()) {
                return null;
            }
            retVal.add("meta");
            return retVal;
        }
        return null;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of type " + SummaryEnum.class + " but can not be a collection of collections");
        }
        if (theInnerCollectionType != null) {
            this.myInnerCollectionType = CollectionBinder.getInstantiableCollectionType(theInnerCollectionType, (String)SummaryEnum.class.getSimpleName());
        }
    }
}

