/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class CountParameter
implements IParameter {
    private Class<?> myType;

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        String[] sinceParams = theRequest.getParameters().get("_count");
        if (sinceParams != null && sinceParams.length > 0 && StringUtils.isNotBlank((CharSequence)sinceParams[0])) {
            try {
                IntegerDt since = new IntegerDt(sinceParams[0]);
                return ParameterUtil.fromInteger(this.myType, (IntegerDt)since);
            }
            catch (DataFormatException e) {
                throw new InvalidRequestException("Invalid _count value: " + sinceParams[0]);
            }
        }
        return ParameterUtil.fromInteger(this.myType, null);
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Count.class.getName() + " but can not be of collection type");
        }
        if (!ParameterUtil.isBindableIntegerType(theParameterType)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Count.class.getName() + " but type '" + theParameterType + "' is an invalid type, must be one of Integer or IntegerType");
        }
        this.myType = theParameterType;
    }
}

