/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import java.lang.reflect.Method;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ConformanceMethodBinding
extends BaseResourceReturningMethodBinding {
    public ConformanceMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod.getReturnType(), theMethod, theContext, theProvider);
        BaseResourceReturningMethodBinding.MethodReturnTypeEnum methodReturnType = this.getMethodReturnType();
        Class genericReturnType = (Class)theMethod.getGenericReturnType();
        if (methodReturnType != BaseResourceReturningMethodBinding.MethodReturnTypeEnum.RESOURCE || !IBaseConformance.class.isAssignableFrom(genericReturnType)) {
            throw new ConfigurationException("Conformance resource provider method '" + theMethod.getName() + "' should return a Conformance resource class, returns: " + theMethod.getReturnType());
        }
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws BaseServerResponseException {
        IBaseResource conf = (IBaseResource)this.invokeServerMethod(theServer, theRequest, theMethodParams);
        return new SimpleBundleProvider(conf);
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() == RequestTypeEnum.OPTIONS && theRequest.getOperation() == null && theRequest.getResourceName() == null) {
            return true;
        }
        if (theRequest.getResourceName() != null) {
            return false;
        }
        if ("metadata".equals(theRequest.getOperation())) {
            if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                return true;
            }
            throw new MethodNotAllowedException("/metadata request must use HTTP GET", new RequestTypeEnum[]{RequestTypeEnum.GET});
        }
        return false;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.METADATA;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }
}

