/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

abstract class BaseOutcomeReturningMethodBindingWithResourceParam
extends BaseOutcomeReturningMethodBinding {
    private Integer myIdParamIndex;
    private String myResourceName;
    private int myResourceParameterIndex = -1;
    private Class<? extends IBaseResource> myResourceType;
    private Class<? extends IIdType> myIdParamType;
    private int myConditionalUrlIndex = -1;

    public BaseOutcomeReturningMethodBindingWithResourceParam(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theMethodAnnotation, theProvider);
        ResourceParameter resourceParameter = null;
        int index = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof ResourceParameter) {
                resourceParameter = (ResourceParameter)next;
                if (resourceParameter.getMode() != ResourceParameter.Mode.RESOURCE) continue;
                if (this.myResourceType != null) {
                    throw new ConfigurationException("Method " + theMethod.getName() + " on type " + theMethod.getDeclaringClass() + " has more than one @ResourceParam. Only one is allowed.");
                }
                this.myResourceType = resourceParameter.getResourceType();
                this.myResourceParameterIndex = index;
            } else if (next instanceof ConditionalParamBinder) {
                this.myConditionalUrlIndex = index;
            }
            ++index;
        }
        if ((this.myResourceType == null || Modifier.isAbstract(this.myResourceType.getModifiers())) && theProvider instanceof IResourceProvider) {
            this.myResourceType = ((IResourceProvider)theProvider).getResourceType();
        }
        if (this.myResourceType == null) {
            throw new ConfigurationException("Unable to determine resource type for method: " + theMethod);
        }
        this.myResourceName = theContext.getResourceDefinition(this.myResourceType).getName();
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        if (this.myIdParamIndex != null) {
            this.myIdParamType = theMethod.getParameterTypes()[this.myIdParamIndex];
        }
        if (resourceParameter == null) {
            throw new ConfigurationException("Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getCanonicalName() + " does not have a resource parameter annotated with @" + ResourceParam.class.getSimpleName());
        }
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        if (this.myIdParamIndex != null) {
            theParams[this.myIdParamIndex.intValue()] = ParameterUtil.convertIdToType((IIdType)theRequest.getId(), this.myIdParamType);
        }
        if (this.myResourceParameterIndex != -1) {
            String urlId;
            IBaseResource resource = (IBaseResource)theParams[this.myResourceParameterIndex];
            String resourceId = resource.getIdElement().getIdPart();
            String string = urlId = theRequest.getId() != null ? theRequest.getId().getIdPart() : null;
            if (!this.getContext().getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                resource.setId(theRequest.getId());
            }
            String matchUrl = null;
            if (this.myConditionalUrlIndex != -1) {
                matchUrl = (String)theParams[this.myConditionalUrlIndex];
                matchUrl = (String)StringUtils.defaultIfBlank((CharSequence)matchUrl, null);
            }
            this.validateResourceIdAndUrlIdForNonConditionalOperation(resource, resourceId, urlId, matchUrl);
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
        super.populateActionRequestDetailsForInterceptor(theRequestDetails, theDetails, theMethodParams);
        if (this.myResourceParameterIndex != -1) {
            theDetails.setResource((IBaseResource)theMethodParams[this.myResourceParameterIndex]);
        } else {
            theDetails.setResource(ResourceParameter.parseResourceFromRequest(theRequestDetails, this, this.myResourceType));
        }
    }

    protected void validateResourceIdAndUrlIdForNonConditionalOperation(IBaseResource theResource, String theResourceId, String theUrlId, String theMatchUrl) {
    }
}

