/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.TagListParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hl7.fhir.instance.model.api.IBaseResource;

abstract class BaseAddOrDeleteTagsMethodBinding
extends BaseMethodBinding<Void> {
    private Class<? extends IBaseResource> myType;
    private Integer myIdParamIndex;
    private String myResourceName;
    private Integer myTagListParamIndex;

    public BaseAddOrDeleteTagsMethodBinding(Method theMethod, FhirContext theContext, Object theProvider, Class<? extends IBaseResource> theTypeFromMethodAnnotation) {
        super(theMethod, theContext, theProvider);
        this.myType = theProvider instanceof IResourceProvider ? ((IResourceProvider)theProvider).getResourceType() : theTypeFromMethodAnnotation;
        if (Modifier.isInterface(this.myType.getModifiers())) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' does not specify a resource type, but has an @" + IdParam.class.getSimpleName() + " parameter. Please specity a resource type in the method annotation on this method");
        }
        this.myResourceName = theContext.getResourceDefinition(this.myType).getName();
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        this.myTagListParamIndex = ParameterUtil.findTagListParameterIndex((Method)theMethod);
        if (this.myIdParamIndex == null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' does not have an @" + IdParam.class.getSimpleName() + " parameter.");
        }
        if (this.myTagListParamIndex == null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' does not have a parameter of type " + TagList.class.getSimpleName() + ", or paramater is not annotated with the @" + TagListParam.class.getSimpleName() + " annotation");
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return null;
    }

    protected abstract boolean isDelete();

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() != RequestTypeEnum.POST) {
            return false;
        }
        if (!"_tags".equals(theRequest.getOperation())) {
            return false;
        }
        if (!this.myResourceName.equals(theRequest.getResourceName())) {
            return false;
        }
        if (theRequest.getId() == null) {
            return false;
        }
        return !(this.isDelete() ? !"_delete".equals(theRequest.getSecondaryOperation()) : theRequest.getSecondaryOperation() != null);
    }
}

