/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AppliesTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuleImplConditional
extends BaseRule
implements IAuthRule {
    private AppliesTypeEnum myAppliesTo;
    private Set<?> myAppliesToTypes;
    private RestOperationTypeEnum myOperationType;

    public RuleImplConditional(String theRuleName) {
        super(theRuleName);
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier) {
        if (theInputResourceId != null) {
            return null;
        }
        if (theOperation == this.myOperationType) {
            switch (this.myAppliesTo) {
                case ALL_RESOURCES: 
                case INSTANCES: {
                    break;
                }
                case TYPES: {
                    if (theInputResource != null && this.myAppliesToTypes.contains(theInputResource.getClass())) break;
                    return null;
                }
            }
            if (theRequestDetails.getConditionalUrl(this.myOperationType) == null) {
                return null;
            }
            return this.newVerdict();
        }
        return null;
    }

    void setAppliesTo(AppliesTypeEnum theAppliesTo) {
        this.myAppliesTo = theAppliesTo;
    }

    void setAppliesToTypes(Set<?> theAppliesToTypes) {
        this.myAppliesToTypes = theAppliesToTypes;
    }

    void setOperationType(RestOperationTypeEnum theOperationType) {
        this.myOperationType = theOperationType;
    }
}

