/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHighlighterInterceptor
extends InterceptorAdapter {
    public static final String PARAM_RAW = "_raw";
    public static final String PARAM_RAW_TRUE = "true";
    public static final String PARAM_TRUE = "true";
    private static final Logger ourLog = LoggerFactory.getLogger(ResponseHighlighterInterceptor.class);
    private static final String[] PARAM_FORMAT_VALUE_JSON = new String[]{"json"};
    private static final String[] PARAM_FORMAT_VALUE_XML = new String[]{"xml"};
    private boolean myShowRequestHeaders = false;
    private boolean myShowResponseHeaders = true;

    private String createLinkHref(Map<String, String[]> parameters, String formatValue) {
        StringBuilder rawB = new StringBuilder();
        for (String next : parameters.keySet()) {
            if ("_format".equals(next)) continue;
            for (String nextValue : parameters.get(next)) {
                if (StringUtils.isBlank((CharSequence)nextValue)) continue;
                if (rawB.length() == 0) {
                    rawB.append('?');
                } else {
                    rawB.append('&');
                }
                rawB.append(UrlUtil.escapeUrlParam((String)next));
                rawB.append('=');
                rawB.append(UrlUtil.escapeUrlParam((String)nextValue));
            }
        }
        if (rawB.length() == 0) {
            rawB.append('?');
        } else {
            rawB.append('&');
        }
        rawB.append("_format").append('=').append(formatValue);
        String link = rawB.toString();
        return link;
    }

    private int format(String theResultBody, StringBuilder theTarget, EncodingEnum theEncodingEnum) {
        String str = StringEscapeUtils.escapeHtml4((String)theResultBody);
        if (str == null || theEncodingEnum == null) {
            theTarget.append(str);
            return 0;
        }
        theTarget.append("<div id=\"line1\">");
        boolean inValue = false;
        boolean inQuote = false;
        boolean inTag = false;
        int lineCount = 1;
        for (int i = 0; i < str.length(); ++i) {
            int nextChar6;
            int prevChar = i > 0 ? (int)str.charAt(i - 1) : 32;
            char nextChar = str.charAt(i);
            int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
            int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
            int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
            int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
            int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
            if (nextChar == '\n') {
                theTarget.append("</div><div id=\"line");
                theTarget.append(++lineCount);
                theTarget.append("\" onclick=\"updateHighlightedLineTo('#L");
                theTarget.append(lineCount);
                theTarget.append("');\">");
                continue;
            }
            if (theEncodingEnum == EncodingEnum.JSON) {
                if (inQuote) {
                    theTarget.append(nextChar);
                    if (prevChar != 92 && nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        theTarget.append("quot;</span>");
                        i += 5;
                        inQuote = false;
                        continue;
                    }
                    if (nextChar != '\\' || nextChar2 != 34) continue;
                    theTarget.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (nextChar == ':') {
                    inValue = true;
                    theTarget.append(nextChar);
                    continue;
                }
                if (nextChar == '[' || nextChar == '{') {
                    theTarget.append("<span class='hlControl'>");
                    theTarget.append(nextChar);
                    theTarget.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '{' || nextChar == '}' || nextChar == ',') {
                    theTarget.append("<span class='hlControl'>");
                    theTarget.append(nextChar);
                    theTarget.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    if (inValue) {
                        theTarget.append("<span class='hlQuot'>&quot;");
                    } else {
                        theTarget.append("<span class='hlTagName'>&quot;");
                    }
                    inQuote = true;
                    i += 5;
                    continue;
                }
                if (nextChar == ':') {
                    theTarget.append("<span class='hlControl'>");
                    theTarget.append(nextChar);
                    theTarget.append("</span>");
                    inValue = true;
                    continue;
                }
                theTarget.append(nextChar);
                continue;
            }
            if (inQuote) {
                theTarget.append(nextChar);
                if (nextChar != '&' || nextChar2 != 113 || nextChar3 != 117 || nextChar4 != 111 || nextChar5 != 116 || nextChar6 != 59) continue;
                theTarget.append("quot;</span>");
                i += 5;
                inQuote = false;
                continue;
            }
            if (inTag) {
                if (nextChar == '&' && nextChar2 == 103 && nextChar3 == 116 && nextChar4 == 59) {
                    theTarget.append("</span><span class='hlControl'>&gt;</span>");
                    inTag = false;
                    i += 3;
                    continue;
                }
                if (nextChar == ' ') {
                    theTarget.append("</span><span class='hlAttr'>");
                    theTarget.append(nextChar);
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    theTarget.append("<span class='hlQuot'>&quot;");
                    inQuote = true;
                    i += 5;
                    continue;
                }
                theTarget.append(nextChar);
                continue;
            }
            if (nextChar == '&' && nextChar2 == 108 && nextChar3 == 116 && nextChar4 == 59) {
                theTarget.append("<span class='hlControl'>&lt;</span><span class='hlTagName'>");
                inTag = true;
                i += 3;
                continue;
            }
            theTarget.append(nextChar);
        }
        theTarget.append("</div>");
        return lineCount;
    }

    @Override
    public boolean handleException(RequestDetails theRequestDetails, BaseServerResponseException theException, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws ServletException, IOException {
        Set<String> accept = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theServletRequest);
        if (!accept.contains("text/html")) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        String requestedWith = theServletRequest.getHeader("X-Requested-With");
        if (requestedWith != null) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        if (theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        if (theException.getOperationOutcome() == null) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        this.streamResponse(theRequestDetails, theServletResponse, (IBaseResource)theException.getOperationOutcome(), (ServletRequest)theServletRequest, theException.getStatusCode());
        return false;
    }

    public boolean isShowRequestHeaders() {
        return this.myShowRequestHeaders;
    }

    public ResponseHighlighterInterceptor setShowRequestHeaders(boolean theShowRequestHeaders) {
        this.myShowRequestHeaders = theShowRequestHeaders;
        return this;
    }

    public boolean isShowResponseHeaders() {
        return this.myShowResponseHeaders;
    }

    public ResponseHighlighterInterceptor setShowResponseHeaders(boolean theShowResponseHeaders) {
        this.myShowResponseHeaders = theShowResponseHeaders;
        return this;
    }

    @Override
    public boolean outgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        String[] rawParamValues = theRequestDetails.getParameters().get(PARAM_RAW);
        if (rawParamValues != null && rawParamValues.length > 0 && rawParamValues[0].equals("true")) {
            ourLog.warn("Client is using non-standard/legacy  _raw parameter - Use _format=json or _format=xml instead, as this parmameter will be removed at some point");
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        boolean force = false;
        String[] formatParams = theRequestDetails.getParameters().get("_format");
        if (formatParams != null && formatParams.length > 0) {
            String formatParam = formatParams[0];
            if (Constants.FORMATS_HTML.contains(formatParam)) {
                force = true;
            } else if ("html/xml".equals(formatParam)) {
                force = true;
                theRequestDetails.getParameters().put("_format", PARAM_FORMAT_VALUE_XML);
            } else if ("html/json".equals(formatParam)) {
                force = true;
                theRequestDetails.getParameters().put("_format", PARAM_FORMAT_VALUE_JSON);
            } else {
                return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
            }
        }
        Set<String> highestRankedAcceptValues = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theServletRequest);
        if (!force && !highestRankedAcceptValues.contains("text/html")) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && StringUtils.isNotBlank((CharSequence)theServletRequest.getHeader("X-Requested-With"))) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && StringUtils.isNotBlank((CharSequence)theServletRequest.getHeader("Origin"))) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && "Binary".equals(theRequestDetails.getResourceName())) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        this.streamResponse(theRequestDetails, theServletResponse, theResponseObject, (ServletRequest)theServletRequest, 200);
        return false;
    }

    private void streamRequestHeaders(ServletRequest theServletRequest, StringBuilder b) {
        if (theServletRequest instanceof HttpServletRequest) {
            HttpServletRequest sr = (HttpServletRequest)theServletRequest;
            b.append("<h1>Request</h1>");
            b.append("<div class=\"headersDiv\">");
            Enumeration headerNamesEnum = sr.getHeaderNames();
            while (headerNamesEnum.hasMoreElements()) {
                String nextHeaderName = (String)headerNamesEnum.nextElement();
                Enumeration headerValuesEnum = sr.getHeaders(nextHeaderName);
                while (headerValuesEnum.hasMoreElements()) {
                    String nextHeaderValue = (String)headerValuesEnum.nextElement();
                    b.append("<div class=\"headersRow\">");
                    b.append("<span class=\"headerName\">").append(nextHeaderName).append(": ").append("</span>");
                    b.append("<span class=\"headerValue\">").append(nextHeaderValue).append("</span>");
                    b.append("</div>");
                }
            }
            b.append("</div>");
        }
    }

    private void streamResponse(RequestDetails theRequestDetails, HttpServletResponse theServletResponse, IBaseResource resource, ServletRequest theServletRequest, int theStatusCode) {
        IParser p;
        Map<String, String[]> parameters;
        if (theRequestDetails.getServer() instanceof RestfulServer) {
            RestfulServer rs = (RestfulServer)theRequestDetails.getServer();
            rs.addHeadersToResponse(theServletResponse);
        }
        if ((parameters = theRequestDetails.getParameters()).containsKey("_format")) {
            p = RestfulServerUtils.getNewParser(theRequestDetails.getServer().getFhirContext(), theRequestDetails);
        } else {
            EncodingEnum defaultResponseEncoding = theRequestDetails.getServer().getDefaultResponseEncoding();
            p = defaultResponseEncoding.newParser(theRequestDetails.getServer().getFhirContext());
            RestfulServerUtils.configureResponseParser(theRequestDetails, p);
        }
        boolean prettyPrintResponse = true;
        String[] prettyParams = parameters.get("_pretty");
        if (prettyParams != null && prettyParams.length > 0 && "false".equals(prettyParams[0])) {
            prettyPrintResponse = false;
        }
        if (prettyPrintResponse) {
            p.setPrettyPrint(true);
        }
        EncodingEnum encoding = p.getEncoding();
        String encoded = p.encodeResourceToString(resource);
        try {
            if (theStatusCode > 299) {
                theServletResponse.setStatus(theStatusCode);
            }
            theServletResponse.setContentType("text/html; charset=UTF-8");
            StringBuilder b = new StringBuilder();
            b.append("<html lang=\"en\">\n");
            b.append("\t<head>\n");
            b.append("\t\t<meta charset=\"utf-8\" />\n");
            b.append("       <style>\n");
            b.append(".httpStatusDiv {");
            b.append("  font-size: 1.2em;");
            b.append("  font-weight: bold;");
            b.append("}");
            b.append(".hlQuot { color: #88F; }\n");
            b.append(".hlQuot a { text-decoration: underline; text-decoration-color: #CCC; }\n");
            b.append(".hlQuot a:HOVER { text-decoration: underline; text-decoration-color: #008; }\n");
            b.append(".hlQuot .uuid, .hlQuot .dateTime {\n");
            b.append("  user-select: all;\n");
            b.append("  -moz-user-select: all;\n");
            b.append("  -webkit-user-select: all;\n");
            b.append("  -ms-user-select: element;\n");
            b.append("}\n");
            b.append(".hlAttr {\n");
            b.append("  color: #888;\n");
            b.append("}\n");
            b.append(".hlTagName {\n");
            b.append("  color: #006699;\n");
            b.append("}\n");
            b.append(".hlControl {\n");
            b.append("  color: #660000;\n");
            b.append("}\n");
            b.append(".hlText {\n");
            b.append("  color: #000000;\n");
            b.append("}\n");
            b.append(".hlUrlBase {\n");
            b.append("}");
            b.append(".headersDiv {\n");
            b.append("  padding: 10px;");
            b.append("  margin-left: 10px;");
            b.append("  border: 1px solid #CCC;");
            b.append("  border-radius: 10px;");
            b.append("}");
            b.append(".headersRow {\n");
            b.append("}");
            b.append(".headerName {\n");
            b.append("  color: #888;\n");
            b.append("  font-family: monospace;\n");
            b.append("}");
            b.append(".headerValue {\n");
            b.append("  color: #88F;\n");
            b.append("  font-family: monospace;\n");
            b.append("}");
            b.append(".responseBodyTable {");
            b.append("  width: 100%;\n");
            b.append("  margin-left: 0px;\n");
            b.append("  margin-top: -10px;\n");
            b.append("  position: relative;\n");
            b.append("}");
            b.append(".responseBodyTableFirstColumn {");
            b.append("  position: absolute;\n");
            b.append("  width: 70px;\n");
            b.append("}");
            b.append(".responseBodyTableSecondColumn {");
            b.append("  position: absolute;\n");
            b.append("  margin-left: 70px;\n");
            b.append("  vertical-align: top;\n");
            b.append("  left: 0px;\n");
            b.append("  right: 0px;\n");
            b.append("}");
            b.append(".lineAnchor A {");
            b.append("  text-decoration: none;");
            b.append("  padding-left: 20px;");
            b.append("}");
            b.append(".lineAnchor {");
            b.append("  display: block;");
            b.append("  padding-right: 20px;");
            b.append("}");
            b.append(".selectedLine {");
            b.append("  background-color: #EEF;");
            b.append("  font-weight: bold;");
            b.append("}");
            b.append("H1 {");
            b.append("  font-size: 1.1em;");
            b.append("  color: #666;");
            b.append("}");
            b.append("BODY {\n");
            b.append("  font-family: Arial;\n");
            b.append("}");
            b.append("       </style>\n");
            b.append("\t</head>\n");
            b.append("\n");
            b.append("\t<body>");
            b.append("<p>");
            b.append("This result is being rendered in HTML for easy viewing. ");
            b.append("You may access this content as ");
            b.append("<a href=\"");
            b.append(this.createLinkHref(parameters, "json"));
            b.append("\">Raw JSON</a> or ");
            b.append("<a href=\"");
            b.append(this.createLinkHref(parameters, "xml"));
            b.append("\">Raw XML</a>, ");
            b.append(" or view this content in ");
            b.append("<a href=\"");
            b.append(this.createLinkHref(parameters, "html/json"));
            b.append("\">HTML JSON</a> ");
            b.append("or ");
            b.append("<a href=\"");
            b.append(this.createLinkHref(parameters, "html/xml"));
            b.append("\">HTML XML</a>.");
            Date startTime = (Date)theServletRequest.getAttribute(RestfulServer.REQUEST_START_TIME);
            if (startTime != null) {
                long time = System.currentTimeMillis() - startTime.getTime();
                b.append(" Response generated in ");
                b.append(time);
                b.append("ms.");
            }
            b.append("</p>");
            b.append("\n");
            String statusName = (String)Constants.HTTP_STATUS_NAMES.get(theServletResponse.getStatus());
            statusName = StringUtils.defaultString((String)statusName);
            b.append("<div class=\"httpStatusDiv\">");
            b.append("HTTP ");
            b.append(theServletResponse.getStatus());
            b.append(" ");
            b.append(statusName);
            b.append("</div>");
            b.append("\n");
            b.append("\n");
            try {
                if (this.isShowRequestHeaders()) {
                    this.streamRequestHeaders(theServletRequest, b);
                }
                if (this.isShowResponseHeaders()) {
                    this.streamResponseHeaders(theRequestDetails, theServletResponse, b);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            b.append("<h1>Response Body</h1>");
            b.append("<div class=\"responseBodyTable\">");
            b.append("<div class=\"responseBodyTableSecondColumn\"><pre>");
            StringBuilder target = new StringBuilder();
            int linesCount = this.format(encoded, target, encoding);
            b.append((CharSequence)target);
            b.append("</pre></div>");
            b.append("<div class=\"responseBodyTableFirstColumn\"><pre>");
            for (int i = 1; i <= linesCount; ++i) {
                b.append("<div class=\"lineAnchor\" id=\"anchor");
                b.append(i);
                b.append("\">");
                b.append("<a href=\"#L");
                b.append(i);
                b.append("\" name=\"L");
                b.append(i);
                b.append("\" id=\"L");
                b.append(i);
                b.append("\">");
                b.append(i);
                b.append("</a></div>");
            }
            b.append("</div></td>");
            b.append("</div>");
            b.append("\n");
            InputStream jsStream = ResponseHighlighterInterceptor.class.getResourceAsStream("ResponseHighlighter.js");
            String jsStr = jsStream != null ? IOUtils.toString((InputStream)jsStream, (String)"UTF-8") : "console.log('ResponseHighlighterInterceptor: javascript resource not found')";
            jsStr = jsStr.replace("FHIR_BASE", theRequestDetails.getServerBaseForRequest());
            b.append("<script type=\"text/javascript\">");
            b.append(jsStr);
            b.append("</script>\n");
            b.append("</body>");
            b.append("</html>");
            String out = b.toString();
            theServletResponse.getWriter().append(out);
            theServletResponse.getWriter().close();
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void streamResponseHeaders(RequestDetails theRequestDetails, HttpServletResponse theServletResponse, StringBuilder b) {
        if (!theServletResponse.getHeaderNames().isEmpty()) {
            b.append("<h1>Response Headers</h1>");
            b.append("<div class=\"headersDiv\">");
            for (String nextHeaderName : theServletResponse.getHeaderNames()) {
                for (String nextHeaderValue : theServletResponse.getHeaders(nextHeaderName)) {
                    RestfulServerUtils.ResponseEncoding responseEncoding;
                    if (nextHeaderName.equalsIgnoreCase("Content-Type") && (responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequestDetails, theRequestDetails.getServer().getDefaultResponseEncoding())) != null && StringUtils.isNotBlank((CharSequence)responseEncoding.getResourceContentType())) {
                        nextHeaderValue = responseEncoding.getResourceContentType() + ";charset=utf-8";
                    }
                    b.append("<div class=\"headersRow\">");
                    b.append("<span class=\"headerName\">").append(nextHeaderName).append(": ").append("</span>");
                    b.append("<span class=\"headerValue\">").append(nextHeaderValue).append("</span>");
                    b.append("</div>");
                }
            }
            b.append("</div>");
        }
    }
}

