/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseValidatingInterceptor<T>
extends InterceptorAdapter {
    public static final String DEFAULT_RESPONSE_HEADER_VALUE = "${row}:${col} ${severity} ${message} (${location})";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseValidatingInterceptor.class);
    private Integer myAddResponseIssueHeaderOnSeverity = null;
    private Integer myAddResponseOutcomeHeaderOnSeverity = null;
    private Integer myFailOnSeverity = ResultSeverityEnum.ERROR.ordinal();
    private boolean myIgnoreValidatorExceptions;
    private int myMaximumHeaderLength = 200;
    private String myResponseIssueHeaderName = this.provideDefaultResponseHeaderName();
    private String myResponseIssueHeaderValue = "${row}:${col} ${severity} ${message} (${location})";
    private String myResponseIssueHeaderValueNoIssues = null;
    private String myResponseOutcomeHeaderName = this.provideDefaultResponseHeaderName();
    private List<IValidatorModule> myValidatorModules;

    BaseValidatingInterceptor() {
    }

    private void addResponseIssueHeader(RequestDetails theRequestDetails, SingleValidationMessage theNext) {
        MyLookup lookup = new MyLookup(theNext);
        StrSubstitutor subs = new StrSubstitutor((StrLookup)lookup, "${", "}", '\\');
        String headerValue = subs.replace(this.myResponseIssueHeaderValue);
        ourLog.trace("Adding header to response: {}", (Object)headerValue);
        theRequestDetails.getResponse().addHeader(this.myResponseIssueHeaderName, headerValue);
    }

    public BaseValidatingInterceptor<T> addValidatorModule(IValidatorModule theModule) {
        Validate.notNull((Object)theModule, (String)"theModule must not be null", (Object[])new Object[0]);
        if (this.getValidatorModules() == null) {
            this.setValidatorModules(new ArrayList<IValidatorModule>());
        }
        this.getValidatorModules().add(theModule);
        return this;
    }

    abstract ValidationResult doValidate(FhirValidator var1, T var2);

    protected void fail(RequestDetails theRequestDetails, ValidationResult theValidationResult) {
        throw new UnprocessableEntityException(theRequestDetails.getServer().getFhirContext(), theValidationResult.toOperationOutcome());
    }

    public ResultSeverityEnum getAddResponseOutcomeHeaderOnSeverity() {
        return this.myAddResponseOutcomeHeaderOnSeverity != null ? ResultSeverityEnum.values()[this.myAddResponseOutcomeHeaderOnSeverity] : null;
    }

    public int getMaximumHeaderLength() {
        return this.myMaximumHeaderLength;
    }

    public String getResponseOutcomeHeaderName() {
        return this.myResponseOutcomeHeaderName;
    }

    public List<IValidatorModule> getValidatorModules() {
        return this.myValidatorModules;
    }

    public boolean isIgnoreValidatorExceptions() {
        return this.myIgnoreValidatorExceptions;
    }

    abstract String provideDefaultResponseHeaderName();

    public void setAddResponseHeaderOnSeverity(ResultSeverityEnum theSeverity) {
        this.myAddResponseIssueHeaderOnSeverity = theSeverity != null ? Integer.valueOf(theSeverity.ordinal()) : null;
    }

    public void setAddResponseOutcomeHeaderOnSeverity(ResultSeverityEnum theAddResponseOutcomeHeaderOnSeverity) {
        this.myAddResponseOutcomeHeaderOnSeverity = theAddResponseOutcomeHeaderOnSeverity != null ? Integer.valueOf(theAddResponseOutcomeHeaderOnSeverity.ordinal()) : null;
    }

    public void setFailOnSeverity(ResultSeverityEnum theSeverity) {
        this.myFailOnSeverity = theSeverity != null ? Integer.valueOf(theSeverity.ordinal()) : null;
    }

    public void setIgnoreValidatorExceptions(boolean theIgnoreValidatorExceptions) {
        this.myIgnoreValidatorExceptions = theIgnoreValidatorExceptions;
    }

    public void setMaximumHeaderLength(int theMaximumHeaderLength) {
        Validate.isTrue((theMaximumHeaderLength >= 100 ? 1 : 0) != 0, (String)"theMaximumHeadeerLength must be >= 100", (Object[])new Object[0]);
        this.myMaximumHeaderLength = theMaximumHeaderLength;
    }

    protected void setResponseHeaderName(String theResponseHeaderName) {
        Validate.notBlank((CharSequence)theResponseHeaderName, (String)"theResponseHeaderName must not be blank or null", (Object[])new Object[0]);
        this.myResponseIssueHeaderName = theResponseHeaderName;
    }

    public void setResponseHeaderValue(String theResponseHeaderValue) {
        Validate.notBlank((CharSequence)theResponseHeaderValue, (String)"theResponseHeaderValue must not be blank or null", (Object[])new Object[0]);
        this.myResponseIssueHeaderValue = theResponseHeaderValue;
    }

    public void setResponseHeaderValueNoIssues(String theResponseHeaderValueNoIssues) {
        this.myResponseIssueHeaderValueNoIssues = theResponseHeaderValueNoIssues;
    }

    public void setResponseOutcomeHeaderName(String theResponseOutcomeHeaderName) {
        Validate.notEmpty((CharSequence)theResponseOutcomeHeaderName, (String)"theResponseOutcomeHeaderName can not be empty or null", (Object[])new Object[0]);
        this.myResponseOutcomeHeaderName = theResponseOutcomeHeaderName;
    }

    public void setValidatorModules(List<IValidatorModule> theValidatorModules) {
        this.myValidatorModules = theValidatorModules;
    }

    protected void postProcessResult(RequestDetails theRequestDetails, ValidationResult theValidationResult) {
    }

    protected void postProcessResultOnFailure(RequestDetails theRequestDetails, ValidationResult theValidationResult) {
    }

    protected ValidationResult validate(T theRequest, RequestDetails theRequestDetails) {
        ValidationResult validationResult;
        FhirValidator validator = theRequestDetails.getServer().getFhirContext().newValidator();
        if (this.myValidatorModules != null) {
            for (IValidatorModule next : this.myValidatorModules) {
                validator.registerValidatorModule(next);
            }
        }
        if (theRequest == null) {
            return null;
        }
        try {
            validationResult = this.doValidate(validator, theRequest);
        }
        catch (Exception e) {
            if (this.myIgnoreValidatorExceptions) {
                ourLog.warn("Validator threw an exception during validation", (Throwable)e);
                return null;
            }
            if (e instanceof BaseServerResponseException) {
                throw (BaseServerResponseException)e;
            }
            throw new InternalErrorException((Throwable)e);
        }
        if (this.myAddResponseIssueHeaderOnSeverity != null) {
            boolean found = false;
            for (SingleValidationMessage next : validationResult.getMessages()) {
                if (next.getSeverity().ordinal() < this.myAddResponseIssueHeaderOnSeverity) continue;
                this.addResponseIssueHeader(theRequestDetails, next);
                found = true;
            }
            if (!found && StringUtils.isNotBlank((CharSequence)this.myResponseIssueHeaderValueNoIssues)) {
                theRequestDetails.getResponse().addHeader(this.myResponseIssueHeaderName, this.myResponseIssueHeaderValueNoIssues);
            }
        }
        if (this.myFailOnSeverity != null) {
            for (SingleValidationMessage next : validationResult.getMessages()) {
                if (next.getSeverity().ordinal() < this.myFailOnSeverity) continue;
                this.postProcessResultOnFailure(theRequestDetails, validationResult);
                this.fail(theRequestDetails, validationResult);
                return validationResult;
            }
        }
        if (this.myAddResponseOutcomeHeaderOnSeverity != null) {
            IBaseOperationOutcome outcome = null;
            for (SingleValidationMessage next : validationResult.getMessages()) {
                if (next.getSeverity().ordinal() < this.myAddResponseOutcomeHeaderOnSeverity) continue;
                outcome = validationResult.toOperationOutcome();
                break;
            }
            if (outcome == null && this.myAddResponseOutcomeHeaderOnSeverity != null && this.myAddResponseOutcomeHeaderOnSeverity.intValue() == ResultSeverityEnum.INFORMATION.ordinal()) {
                FhirContext ctx = theRequestDetails.getServer().getFhirContext();
                outcome = OperationOutcomeUtil.newInstance((FhirContext)ctx);
                OperationOutcomeUtil.addIssue((FhirContext)ctx, (IBaseOperationOutcome)outcome, (String)"information", (String)"No issues detected", (String)"", (String)"informational");
            }
            if (outcome != null) {
                IParser parser = theRequestDetails.getServer().getFhirContext().newJsonParser().setPrettyPrint(false);
                String encoded = parser.encodeResourceToString((IBaseResource)outcome);
                if (encoded.length() > this.getMaximumHeaderLength()) {
                    encoded = encoded.substring(0, this.getMaximumHeaderLength() - 3) + "...";
                }
                theRequestDetails.getResponse().addHeader(this.myResponseOutcomeHeaderName, encoded);
            }
        }
        this.postProcessResult(theRequestDetails, validationResult);
        return validationResult;
    }

    private static class MyLookup
    extends StrLookup<String> {
        private SingleValidationMessage myMessage;

        public MyLookup(SingleValidationMessage theMessage) {
            this.myMessage = theMessage;
        }

        public String lookup(String theKey) {
            if ("line".equals(theKey)) {
                return MyLookup.toString(this.myMessage.getLocationLine());
            }
            if ("col".equals(theKey)) {
                return MyLookup.toString(this.myMessage.getLocationCol());
            }
            if ("message".equals(theKey)) {
                return MyLookup.toString(this.myMessage.getMessage());
            }
            if ("location".equals(theKey)) {
                return MyLookup.toString(this.myMessage.getLocationString());
            }
            if ("severity".equals(theKey)) {
                return this.myMessage.getSeverity() != null ? this.myMessage.getSeverity().name() : null;
            }
            return "";
        }

        private static String toString(Object theInt) {
            return theInt != null ? theInt.toString() : "";
        }
    }
}

