/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.ProvidedResourceScanner;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.api.AddProfileTagEnum;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.Destroy;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Initialize;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.server.IFhirVersionServer;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.ParseAction;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.IncomingRequestAddressStrategy;
import ca.uhn.fhir.rest.server.PageProvider;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.RestulfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.interceptor.ExceptionHandlingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.tenant.ITenantIdentificationStrategy;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlPathTokenizer;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.VersionUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Manifest;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServer
extends HttpServlet
implements IRestfulServer<ServletRequestDetails> {
    public static final String REQUEST_START_TIME = RestfulServer.class.getName() + "REQUEST_START_TIME";
    public static final ETagSupportEnum DEFAULT_ETAG_SUPPORT = ETagSupportEnum.ENABLED;
    public static final String SERVLET_CONTEXT_ATTRIBUTE = "ca.uhn.fhir.rest.server.RestfulServer.servlet_context";
    private static final ExceptionHandlingInterceptor DEFAULT_EXCEPTION_HANDLER = new ExceptionHandlingInterceptor();
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServer.class);
    private static final long serialVersionUID = 1L;
    private final List<IServerInterceptor> myInterceptors = new ArrayList<IServerInterceptor>();
    private final List<Object> myPlainProviders = new ArrayList<Object>();
    private final List<IResourceProvider> myResourceProviders = new ArrayList<IResourceProvider>();
    private BundleInclusionRule myBundleInclusionRule = BundleInclusionRule.BASED_ON_INCLUDES;
    private boolean myDefaultPrettyPrint = false;
    private EncodingEnum myDefaultResponseEncoding = EncodingEnum.XML;
    private ETagSupportEnum myETagSupport = DEFAULT_ETAG_SUPPORT;
    private FhirContext myFhirContext;
    private boolean myIgnoreServerParsedRequestParameters = true;
    private String myImplementationDescription;
    private IPagingProvider myPagingProvider;
    private Lock myProviderRegistrationMutex = new ReentrantLock();
    private Map<String, ResourceBinding> myResourceNameToBinding = new HashMap<String, ResourceBinding>();
    private IServerAddressStrategy myServerAddressStrategy = new IncomingRequestAddressStrategy();
    private ResourceBinding myServerBinding = new ResourceBinding();
    private ResourceBinding myGlobalBinding = new ResourceBinding();
    private BaseMethodBinding<?> myServerConformanceMethod;
    private Object myServerConformanceProvider;
    private String myServerName = "HAPI FHIR Server";
    private String myServerVersion = VersionUtil.getVersion();
    private boolean myStarted;
    private Map<String, IResourceProvider> myTypeToProvider = new HashMap<String, IResourceProvider>();
    private boolean myUncompressIncomingContents = true;
    private boolean myUseBrowserFriendlyContentTypes;
    private ITenantIdentificationStrategy myTenantIdentificationStrategy;

    public RestfulServer() {
        this(null);
    }

    public RestfulServer(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }

    private static boolean partIsOperation(String nextString) {
        return nextString.length() > 0 && (nextString.charAt(0) == '_' || nextString.charAt(0) == '$' || nextString.equals("metadata"));
    }

    private void addContentLocationHeaders(RequestDetails theRequest, HttpServletResponse servletResponse, MethodOutcome response, String resourceName) {
        if (response != null && response.getId() != null) {
            this.addLocationHeader(theRequest, servletResponse, response, "Location", resourceName);
            this.addLocationHeader(theRequest, servletResponse, response, "Content-Location", resourceName);
        }
    }

    public void addHeadersToResponse(HttpServletResponse theHttpResponse) {
        StringBuilder b = new StringBuilder();
        b.append("HAPI FHIR ");
        b.append(VersionUtil.getVersion());
        b.append(" REST Server (FHIR Server; FHIR ");
        b.append(this.myFhirContext.getVersion().getVersion().getFhirVersionString());
        b.append('/');
        b.append(this.myFhirContext.getVersion().getVersion().name());
        b.append(")");
        theHttpResponse.addHeader("X-Powered-By", b.toString());
    }

    private void addLocationHeader(RequestDetails theRequest, HttpServletResponse theResponse, MethodOutcome response, String headerLocation, String resourceName) {
        StringBuilder b = new StringBuilder();
        b.append(theRequest.getFhirServerBase());
        b.append('/');
        b.append(resourceName);
        b.append('/');
        b.append(response.getId().getIdPart());
        if (response.getId().hasVersionIdPart()) {
            b.append("/_history/");
            b.append(response.getId().getVersionIdPart());
        }
        theResponse.addHeader(headerLocation, b.toString());
    }

    private void assertProviderIsValid(Object theNext) throws ConfigurationException {
        if (!Modifier.isPublic(theNext.getClass().getModifiers())) {
            throw new ConfigurationException("Can not use provider '" + theNext.getClass() + "' - Class must be public");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestulfulServerConfiguration createConfiguration() {
        RestulfulServerConfiguration result = new RestulfulServerConfiguration();
        result.setResourceBindings(this.getResourceBindings());
        result.setServerBindings(this.getServerBindings());
        result.setImplementationDescription(this.getImplementationDescription());
        result.setServerVersion(this.getServerVersion());
        result.setServerName(this.getServerName());
        result.setFhirContext(this.getFhirContext());
        result.setServerAddressStrategy(this.myServerAddressStrategy);
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
            if (inputStream != null) {
                Manifest manifest = new Manifest(inputStream);
                result.setConformanceDate(manifest.getMainAttributes().getValue("Build-Time"));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return result;
    }

    public void destroy() {
        if (this.getResourceProviders() != null) {
            for (IResourceProvider iResourceProvider : this.getResourceProviders()) {
                this.invokeDestroy(iResourceProvider);
            }
        }
        if (this.myServerConformanceProvider != null) {
            this.invokeDestroy(this.myServerConformanceProvider);
        }
        if (this.getPlainProviders() != null) {
            for (Object next : this.getPlainProviders()) {
                this.invokeDestroy(next);
            }
        }
    }

    public BaseMethodBinding<?> determineResourceMethod(RequestDetails requestDetails, String requestPath) {
        RequestTypeEnum requestType = requestDetails.getRequestType();
        ResourceBinding resourceBinding = null;
        BaseMethodBinding<?> resourceMethod = null;
        String resourceName = requestDetails.getResourceName();
        if (this.myServerConformanceMethod.incomingServerRequestMatchesMethod(requestDetails)) {
            resourceMethod = this.myServerConformanceMethod;
        } else if (resourceName == null) {
            resourceBinding = this.myServerBinding;
        } else {
            resourceBinding = this.myResourceNameToBinding.get(resourceName);
            if (resourceBinding == null) {
                throw new ResourceNotFoundException("Unknown resource type '" + resourceName + "' - Server knows how to handle: " + this.myResourceNameToBinding.keySet());
            }
        }
        if (resourceMethod == null) {
            if (resourceBinding != null) {
                resourceMethod = resourceBinding.getMethod(requestDetails);
            }
            if (resourceMethod == null) {
                resourceMethod = this.myGlobalBinding.getMethod(requestDetails);
            }
        }
        if (resourceMethod == null) {
            if (StringUtils.isBlank((CharSequence)requestPath)) {
                throw new InvalidRequestException(this.myFhirContext.getLocalizer().getMessage(RestfulServer.class, "rootRequest", new Object[0]));
            }
            throw new InvalidRequestException(this.myFhirContext.getLocalizer().getMessage(RestfulServer.class, "unknownMethod", new Object[]{requestType.name(), requestPath, requestDetails.getParameters().keySet()}));
        }
        return resourceMethod;
    }

    protected int escapedLength(String theServletPath) {
        int delta = 0;
        for (int i = 0; i < theServletPath.length(); ++i) {
            char next = theServletPath.charAt(i);
            if (next != ' ') continue;
            delta += 2;
        }
        return theServletPath.length() + delta;
    }

    private void findResourceMethods(Object theProvider) {
        ourLog.info("Scanning type for RESTful methods: {}", theProvider.getClass());
        int count = 0;
        Class<?> clazz = theProvider.getClass();
        Class<?> supertype = clazz.getSuperclass();
        while (!Object.class.equals(supertype)) {
            count += this.findResourceMethods(theProvider, supertype);
            supertype = supertype.getSuperclass();
        }
        if ((count += this.findResourceMethods(theProvider, clazz)) == 0) {
            throw new ConfigurationException("Did not find any annotated RESTful methods on provider class " + theProvider.getClass().getCanonicalName());
        }
    }

    private int findResourceMethods(Object theProvider, Class<?> clazz) throws ConfigurationException {
        int count = 0;
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            ResourceBinding resourceBinding;
            BaseMethodBinding<?> foundMethodBinding = BaseMethodBinding.bindMethod(m, this.getFhirContext(), theProvider);
            if (foundMethodBinding == null) continue;
            ++count;
            if (foundMethodBinding instanceof ConformanceMethodBinding) {
                this.myServerConformanceMethod = foundMethodBinding;
                continue;
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is not public, FHIR RESTful methods must be public");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is static, FHIR RESTful methods must not be static");
            }
            ourLog.debug("Scanning public method: {}#{}", theProvider.getClass(), (Object)m.getName());
            String resourceName = foundMethodBinding.getResourceName();
            if (resourceName == null) {
                resourceBinding = foundMethodBinding.isGlobalMethod() ? this.myGlobalBinding : this.myServerBinding;
            } else {
                RuntimeResourceDefinition definition = this.getFhirContext().getResourceDefinition(resourceName);
                if (this.myResourceNameToBinding.containsKey(definition.getName())) {
                    resourceBinding = this.myResourceNameToBinding.get(definition.getName());
                } else {
                    resourceBinding = new ResourceBinding();
                    resourceBinding.setResourceName(resourceName);
                    this.myResourceNameToBinding.put(resourceName, resourceBinding);
                }
            }
            List<Class<?>> allowableParams = foundMethodBinding.getAllowableParamAnnotations();
            if (allowableParams != null) {
                Annotation[][] annotationArray = m.getParameterAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation[] nextParamAnnotations;
                    for (Annotation annotation : nextParamAnnotations = annotationArray[i]) {
                        Package pack = annotation.annotationType().getPackage();
                        if (!pack.equals(IdParam.class.getPackage()) || allowableParams.contains(annotation.annotationType())) continue;
                        throw new ConfigurationException("Method[" + m.toString() + "] is not allowed to have a parameter annotated with " + annotation);
                    }
                }
            }
            resourceBinding.addMethod(foundMethodBinding);
            ourLog.debug(" * Method: {}#{} is a handler", theProvider.getClass(), (Object)m.getName());
        }
        return count;
    }

    @Override
    @Deprecated
    public AddProfileTagEnum getAddProfileTag() {
        return this.myFhirContext.getAddProfileTagWhenEncoding();
    }

    @Deprecated
    @CoverageIgnore
    public void setAddProfileTag(AddProfileTagEnum theAddProfileTag) {
        Validate.notNull((Object)theAddProfileTag, (String)"theAddProfileTag must not be null", (Object[])new Object[0]);
        this.myFhirContext.setAddProfileTagWhenEncoding(theAddProfileTag);
    }

    @Override
    public BundleInclusionRule getBundleInclusionRule() {
        return this.myBundleInclusionRule;
    }

    public void setBundleInclusionRule(BundleInclusionRule theBundleInclusionRule) {
        this.myBundleInclusionRule = theBundleInclusionRule;
    }

    @Override
    public EncodingEnum getDefaultResponseEncoding() {
        return this.myDefaultResponseEncoding;
    }

    public void setDefaultResponseEncoding(EncodingEnum theDefaultResponseEncoding) {
        Validate.notNull((Object)theDefaultResponseEncoding, (String)"theDefaultResponseEncoding can not be null", (Object[])new Object[0]);
        this.myDefaultResponseEncoding = theDefaultResponseEncoding;
    }

    @Override
    public ETagSupportEnum getETagSupport() {
        return this.myETagSupport;
    }

    public void setETagSupport(ETagSupportEnum theETagSupport) {
        if (theETagSupport == null) {
            throw new NullPointerException("theETagSupport can not be null");
        }
        this.myETagSupport = theETagSupport;
    }

    @Override
    public FhirContext getFhirContext() {
        if (this.myFhirContext == null) {
            this.myFhirContext = new FhirContext();
        }
        return this.myFhirContext;
    }

    public void setFhirContext(FhirContext theFhirContext) {
        Validate.notNull((Object)theFhirContext, (String)"FhirContext must not be null", (Object[])new Object[0]);
        this.myFhirContext = theFhirContext;
    }

    public String getImplementationDescription() {
        return this.myImplementationDescription;
    }

    public void setImplementationDescription(String theImplementationDescription) {
        this.myImplementationDescription = theImplementationDescription;
    }

    @Override
    public List<IServerInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.myInterceptors);
    }

    public void setInterceptors(IServerInterceptor ... theList) {
        this.myInterceptors.clear();
        if (theList != null) {
            this.myInterceptors.addAll(Arrays.asList(theList));
        }
    }

    public void setInterceptors(List<IServerInterceptor> theList) {
        this.myInterceptors.clear();
        if (theList != null) {
            this.myInterceptors.addAll(theList);
        }
    }

    @Override
    public IPagingProvider getPagingProvider() {
        return this.myPagingProvider;
    }

    public void setPagingProvider(IPagingProvider thePagingProvider) {
        this.myPagingProvider = thePagingProvider;
    }

    public Collection<Object> getPlainProviders() {
        return this.myPlainProviders;
    }

    public void setPlainProviders(Collection<Object> theProviders) {
        this.myPlainProviders.clear();
        if (theProviders != null) {
            this.myPlainProviders.addAll(theProviders);
        }
    }

    public void setPlainProviders(Object ... theProv) {
        this.setPlainProviders(Arrays.asList(theProv));
    }

    protected String getRequestPath(String requestFullPath, String servletContextPath, String servletPath) {
        return requestFullPath.substring(this.escapedLength(servletContextPath) + this.escapedLength(servletPath));
    }

    public Collection<ResourceBinding> getResourceBindings() {
        return this.myResourceNameToBinding.values();
    }

    public Collection<IResourceProvider> getResourceProviders() {
        return this.myResourceProviders;
    }

    public void setResourceProviders(Collection<IResourceProvider> theResourceProviders) {
        this.myResourceProviders.clear();
        if (theResourceProviders != null) {
            this.myResourceProviders.addAll(theResourceProviders);
        }
    }

    public void setResourceProviders(IResourceProvider ... theResourceProviders) {
        this.myResourceProviders.clear();
        if (theResourceProviders != null) {
            this.myResourceProviders.addAll(Arrays.asList(theResourceProviders));
        }
    }

    public IServerAddressStrategy getServerAddressStrategy() {
        return this.myServerAddressStrategy;
    }

    public void setServerAddressStrategy(IServerAddressStrategy theServerAddressStrategy) {
        Validate.notNull((Object)theServerAddressStrategy, (String)"Server address strategy can not be null", (Object[])new Object[0]);
        this.myServerAddressStrategy = theServerAddressStrategy;
    }

    public String getServerBaseForRequest(ServletRequestDetails theRequest) {
        String fhirServerBase = this.myServerAddressStrategy.determineServerBase(this.getServletContext(), theRequest.getServletRequest());
        if (fhirServerBase.endsWith("/")) {
            fhirServerBase = fhirServerBase.substring(0, fhirServerBase.length() - 1);
        }
        if (this.myTenantIdentificationStrategy != null) {
            fhirServerBase = this.myTenantIdentificationStrategy.massageServerBaseUrl(fhirServerBase, theRequest);
        }
        return fhirServerBase;
    }

    public List<BaseMethodBinding<?>> getServerBindings() {
        return this.myServerBinding.getMethodBindings();
    }

    public Object getServerConformanceProvider() {
        return this.myServerConformanceProvider;
    }

    public void setServerConformanceProvider(Object theServerConformanceProvider) {
        if (this.myStarted) {
            throw new IllegalStateException("Server is already started");
        }
        try {
            Method setRestfulServer = theServerConformanceProvider.getClass().getMethod("setRestfulServer", RestfulServer.class);
            if (setRestfulServer != null) {
                setRestfulServer.invoke(theServerConformanceProvider, this);
            }
        }
        catch (Exception e) {
            ourLog.warn("Error calling IServerConformanceProvider.setRestfulServer", (Throwable)e);
        }
        this.myServerConformanceProvider = theServerConformanceProvider;
    }

    public void setTenantIdentificationStrategy(ITenantIdentificationStrategy theTenantIdentificationStrategy) {
        this.myTenantIdentificationStrategy = theTenantIdentificationStrategy;
    }

    public String getServerName() {
        return this.myServerName;
    }

    public void setServerName(String theServerName) {
        this.myServerName = theServerName;
    }

    public IResourceProvider getServerProfilesProvider() {
        IFhirVersionServer versionServer = (IFhirVersionServer)this.getFhirContext().getVersion().getServerVersion();
        return versionServer.createServerProfilesProvider(this);
    }

    public String getServerVersion() {
        return this.myServerVersion;
    }

    public void setServerVersion(String theServerVersion) {
        this.myServerVersion = theServerVersion;
    }

    protected void handleRequest(RequestTypeEnum theRequestType, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException, IOException {
        ServletRequestDetails requestDetails = new ServletRequestDetails();
        requestDetails.setServer(this);
        requestDetails.setRequestType(theRequestType);
        requestDetails.setServletRequest(theRequest);
        requestDetails.setServletResponse(theResponse);
        theRequest.setAttribute(SERVLET_CONTEXT_ATTRIBUTE, (Object)this.getServletContext());
        try {
            String contentLocation;
            String completeUrl;
            String requestFullPath = StringUtils.defaultString((String)theRequest.getRequestURI());
            String servletPath = StringUtils.defaultString((String)theRequest.getServletPath());
            StringBuffer requestUrl = theRequest.getRequestURL();
            String servletContextPath = IncomingRequestAddressStrategy.determineServletContextPath(theRequest, this);
            if (ourLog.isTraceEnabled()) {
                ourLog.trace("Request FullPath: {}", (Object)requestFullPath);
                ourLog.trace("Servlet Path: {}", (Object)servletPath);
                ourLog.trace("Request Url: {}", (Object)requestUrl);
                ourLog.trace("Context Path: {}", (Object)servletContextPath);
            }
            Map params = null;
            if (StringUtils.isNotBlank((CharSequence)theRequest.getQueryString())) {
                completeUrl = requestUrl + "?" + theRequest.getQueryString();
                if (this.isIgnoreServerParsedRequestParameters()) {
                    String contentType = theRequest.getHeader("Content-Type");
                    if (theRequestType == RequestTypeEnum.POST && StringUtils.isNotBlank((CharSequence)contentType) && contentType.startsWith("application/x-www-form-urlencoded")) {
                        String requestBody = new String(requestDetails.loadRequestContents(), Constants.CHARSET_UTF8);
                        params = UrlUtil.parseQueryStrings((String[])new String[]{theRequest.getQueryString(), requestBody});
                    } else if (theRequestType == RequestTypeEnum.GET) {
                        params = UrlUtil.parseQueryString((String)theRequest.getQueryString());
                    }
                }
            } else {
                completeUrl = requestUrl.toString();
            }
            if (params == null) {
                params = new HashMap(theRequest.getParameterMap());
            }
            requestDetails.setParameters(params);
            for (IServerInterceptor next : this.myInterceptors) {
                boolean continueProcessing = next.incomingRequestPreProcessed(theRequest, theResponse);
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            String requestPath = this.getRequestPath(requestFullPath, servletContextPath, servletPath);
            if (requestPath.length() > 0 && requestPath.charAt(0) == '/') {
                requestPath = requestPath.substring(1);
            }
            this.populateRequestDetailsFromRequestPath(requestDetails, requestPath);
            String fhirServerBase = this.getServerBaseForRequest(requestDetails);
            if (theRequestType == RequestTypeEnum.PUT && (contentLocation = theRequest.getHeader("Content-Location")) != null) {
                IIdType id = this.myFhirContext.getVersion().newIdType();
                id.setValue(contentLocation);
                requestDetails.setId(id);
            }
            String acceptEncoding = theRequest.getHeader("Accept-Encoding");
            boolean respondGzip = false;
            if (acceptEncoding != null) {
                String[] parts = acceptEncoding.trim().split("\\s*,\\s*");
                for (String string : parts) {
                    if (!string.equals("gzip")) continue;
                    respondGzip = true;
                }
            }
            requestDetails.setRespondGzip(respondGzip);
            requestDetails.setRequestPath(requestPath);
            requestDetails.setFhirServerBase(fhirServerBase);
            requestDetails.setCompleteUrl(completeUrl);
            BaseMethodBinding<ServletRequestDetails> resourceMethod = this.determineResourceMethod(requestDetails, requestPath);
            requestDetails.setRestOperationType(resourceMethod.getRestOperationType());
            for (IServerInterceptor next : this.myInterceptors) {
                boolean continueProcessing = next.incomingRequestPostProcessed(requestDetails, theRequest, theResponse);
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            Closeable outputStreamOrWriter = (Closeable)resourceMethod.invokeServer(this, requestDetails);
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                next.processingCompletedNormally(requestDetails);
            }
            if (outputStreamOrWriter != null) {
                outputStreamOrWriter.close();
            }
        }
        catch (AuthenticationException | NotModifiedException e) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                if (next.handleException(requestDetails, (BaseServerResponseException)e, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            this.writeExceptionToResponse(theResponse, (BaseServerResponseException)e);
        }
        catch (Throwable e) {
            IServerInterceptor next;
            int i;
            BaseServerResponseException exception = null;
            for (i = this.getInterceptors().size() - 1; i >= 0; --i) {
                next = this.getInterceptors().get(i);
                exception = next.preProcessOutgoingException(requestDetails, e, theRequest);
                if (exception == null) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                break;
            }
            if (exception == null) {
                exception = DEFAULT_EXCEPTION_HANDLER.preProcessOutgoingException(requestDetails, e, theRequest);
            }
            for (i = this.getInterceptors().size() - 1; i >= 0; --i) {
                next = this.getInterceptors().get(i);
                if (next.handleException(requestDetails, exception, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            requestDetails.getParameters().remove("_summary");
            requestDetails.getParameters().remove("_elements");
            DEFAULT_EXCEPTION_HANDLER.handleException(requestDetails, exception, theRequest, theResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() throws ServletException {
        this.myProviderRegistrationMutex.lock();
        try {
            this.initialize();
            try {
                ourLog.info("Initializing HAPI FHIR restful server running in " + this.getFhirContext().getVersion().getVersion().name() + " mode");
                ProvidedResourceScanner providedResourceScanner = new ProvidedResourceScanner(this.getFhirContext());
                providedResourceScanner.scanForProvidedResources((Object)this);
                Collection<IResourceProvider> resourceProvider = this.getResourceProviders();
                this.registerProviders(resourceProvider, true);
                Collection<Object> providers = this.getPlainProviders();
                this.registerProviders(providers, true);
                this.findResourceMethods(this.getServerProfilesProvider());
                IServerConformanceProvider<? extends IBaseResource> confProvider = this.getServerConformanceProvider();
                if (confProvider == null) {
                    IFhirVersionServer versionServer = (IFhirVersionServer)this.getFhirContext().getVersion().getServerVersion();
                    confProvider = versionServer.createServerConformanceProvider(this);
                }
                this.findResourceMethods(confProvider);
                ourLog.trace("Invoking provider initialize methods");
                if (this.getResourceProviders() != null) {
                    for (IResourceProvider iResourceProvider : this.getResourceProviders()) {
                        this.invokeInitialize(iResourceProvider);
                    }
                }
                if (confProvider != null) {
                    this.invokeInitialize(confProvider);
                }
                if (this.getPlainProviders() != null) {
                    for (Object next : this.getPlainProviders()) {
                        this.invokeInitialize(next);
                    }
                }
                this.findResourceMethods(new PageProvider());
            }
            catch (Exception ex) {
                ourLog.error("An error occurred while loading request handlers!", (Throwable)ex);
                throw new ServletException("Failed to initialize FHIR Restful server", (Throwable)ex);
            }
            this.myStarted = true;
            ourLog.info("A FHIR has been lit on this server");
        }
        finally {
            this.myProviderRegistrationMutex.unlock();
        }
    }

    protected void initialize() throws ServletException {
    }

    private void invokeDestroy(Object theProvider) {
        this.invokeDestroy(theProvider, theProvider.getClass());
    }

    private void invokeDestroy(Object theProvider, Class<?> clazz) {
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            Destroy destroy = m.getAnnotation(Destroy.class);
            if (destroy == null) continue;
            this.invokeInitializeOrDestroyMethod(theProvider, m, "destroy");
        }
        Class<?> supertype = clazz.getSuperclass();
        if (!Object.class.equals(supertype)) {
            this.invokeDestroy(theProvider, supertype);
        }
    }

    private void invokeInitializeOrDestroyMethod(Object theProvider, Method m, String theMethodDescription) {
        Class<?>[] paramTypes = m.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        int index = 0;
        for (Class<?> nextParamType : paramTypes) {
            if (RestfulServer.class.equals(nextParamType) || IRestfulServerDefaults.class.equals(nextParamType)) {
                params[index] = this;
            }
            ++index;
        }
        try {
            m.invoke(theProvider, params);
        }
        catch (Exception e) {
            ourLog.error("Exception occurred in " + theMethodDescription + " method '" + m.getName() + "'", (Throwable)e);
        }
    }

    private void invokeInitialize(Object theProvider) {
        this.invokeInitialize(theProvider, theProvider.getClass());
    }

    private void invokeInitialize(Object theProvider, Class<?> clazz) {
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            Initialize initialize = m.getAnnotation(Initialize.class);
            if (initialize == null) continue;
            this.invokeInitializeOrDestroyMethod(theProvider, m, "initialize");
        }
        Class<?> supertype = clazz.getSuperclass();
        if (!Object.class.equals(supertype)) {
            this.invokeInitialize(theProvider, supertype);
        }
    }

    @Override
    public boolean isDefaultPrettyPrint() {
        return this.myDefaultPrettyPrint;
    }

    public void setDefaultPrettyPrint(boolean theDefaultPrettyPrint) {
        this.myDefaultPrettyPrint = theDefaultPrettyPrint;
    }

    public boolean isIgnoreServerParsedRequestParameters() {
        return this.myIgnoreServerParsedRequestParameters;
    }

    public void setIgnoreServerParsedRequestParameters(boolean theIgnoreServerParsedRequestParameters) {
        this.myIgnoreServerParsedRequestParameters = theIgnoreServerParsedRequestParameters;
    }

    public boolean isUncompressIncomingContents() {
        return this.myUncompressIncomingContents;
    }

    public void setUncompressIncomingContents(boolean theUncompressIncomingContents) {
        this.myUncompressIncomingContents = theUncompressIncomingContents;
    }

    @Override
    @Deprecated
    public boolean isUseBrowserFriendlyContentTypes() {
        return this.myUseBrowserFriendlyContentTypes;
    }

    @Deprecated
    public void setUseBrowserFriendlyContentTypes(boolean theUseBrowserFriendlyContentTypes) {
        this.myUseBrowserFriendlyContentTypes = theUseBrowserFriendlyContentTypes;
    }

    public void populateRequestDetailsFromRequestPath(RequestDetails theRequestDetails, String theRequestPath) {
        String nextString;
        UrlPathTokenizer tok = new UrlPathTokenizer(theRequestPath);
        String resourceName = null;
        if (this.myTenantIdentificationStrategy != null) {
            this.myTenantIdentificationStrategy.extractTenant(tok, theRequestDetails);
        }
        IIdType id = null;
        String operation = null;
        String compartment = null;
        if (tok.hasMoreTokens() && RestfulServer.partIsOperation(resourceName = tok.nextToken())) {
            operation = resourceName;
            resourceName = null;
        }
        theRequestDetails.setResourceName(resourceName);
        if (tok.hasMoreTokens()) {
            nextString = tok.nextToken();
            if (RestfulServer.partIsOperation(nextString)) {
                operation = nextString;
            } else {
                id = this.myFhirContext.getVersion().newIdType();
                id.setParts(null, resourceName, UrlUtil.unescape((String)nextString), null);
            }
        }
        if (tok.hasMoreTokens()) {
            nextString = tok.nextToken();
            if (nextString.equals("_history")) {
                if (tok.hasMoreTokens()) {
                    String versionString = tok.nextToken();
                    if (id == null) {
                        throw new InvalidRequestException("Don't know how to handle request path: " + theRequestPath);
                    }
                    id.setParts(null, resourceName, id.getIdPart(), UrlUtil.unescape((String)versionString));
                } else {
                    operation = "_history";
                }
            } else if (RestfulServer.partIsOperation(nextString)) {
                if (operation != null) {
                    throw new InvalidRequestException("URL Path contains two operations: " + theRequestPath);
                }
                operation = nextString;
            } else {
                compartment = nextString;
            }
        }
        String secondaryOperation = null;
        while (tok.hasMoreTokens()) {
            String nextString2 = tok.nextToken();
            if (operation == null) {
                operation = nextString2;
                continue;
            }
            if (secondaryOperation == null) {
                secondaryOperation = nextString2;
                continue;
            }
            throw new InvalidRequestException("URL path has unexpected token '" + nextString2 + "' at the end: " + theRequestPath);
        }
        theRequestDetails.setId(id);
        theRequestDetails.setOperation(operation);
        theRequestDetails.setSecondaryOperation(secondaryOperation);
        theRequestDetails.setCompartmentName(compartment);
    }

    public void registerInterceptor(IServerInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.add(theInterceptor);
    }

    public void registerProvider(Object provider) {
        if (provider != null) {
            ArrayList<Object> providerList = new ArrayList<Object>(1);
            providerList.add(provider);
            this.registerProviders(providerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProviders(Collection<? extends Object> providers) {
        this.myProviderRegistrationMutex.lock();
        try {
            if (!this.myStarted) {
                for (Object object : providers) {
                    ourLog.info("Registration of provider [" + object.getClass().getName() + "] will be delayed until FHIR server startup");
                    if (object instanceof IResourceProvider) {
                        this.myResourceProviders.add((IResourceProvider)object);
                        continue;
                    }
                    this.myPlainProviders.add(object);
                }
                return;
            }
        }
        finally {
            this.myProviderRegistrationMutex.unlock();
        }
        this.registerProviders(providers, false);
    }

    protected void registerProviders(Collection<? extends Object> providers, boolean inInit) {
        ArrayList<IResourceProvider> newResourceProviders = new ArrayList<IResourceProvider>();
        ArrayList<Object> newPlainProviders = new ArrayList<Object>();
        ProvidedResourceScanner providedResourceScanner = new ProvidedResourceScanner(this.getFhirContext());
        if (providers != null) {
            for (Object object : providers) {
                if (object instanceof IResourceProvider) {
                    IResourceProvider rsrcProvider = (IResourceProvider)object;
                    Class<? extends IBaseResource> resourceType = rsrcProvider.getResourceType();
                    if (resourceType == null) {
                        throw new NullPointerException("getResourceType() on class '" + rsrcProvider.getClass().getCanonicalName() + "' returned null");
                    }
                    String resourceName = this.getFhirContext().getResourceDefinition(resourceType).getName();
                    if (this.myTypeToProvider.containsKey(resourceName)) {
                        throw new ConfigurationException("Multiple resource providers return resource type[" + resourceName + "]: First[" + this.myTypeToProvider.get(resourceName).getClass().getCanonicalName() + "] and Second[" + rsrcProvider.getClass().getCanonicalName() + "]");
                    }
                    if (!inInit) {
                        this.myResourceProviders.add(rsrcProvider);
                    }
                    this.myTypeToProvider.put(resourceName, rsrcProvider);
                    providedResourceScanner.scanForProvidedResources((Object)rsrcProvider);
                    newResourceProviders.add(rsrcProvider);
                    continue;
                }
                if (!inInit) {
                    this.myPlainProviders.add(object);
                }
                newPlainProviders.add(object);
            }
            if (!newResourceProviders.isEmpty()) {
                ourLog.info("Added {} resource provider(s). Total {}", (Object)newResourceProviders.size(), (Object)this.myTypeToProvider.size());
                for (IResourceProvider iResourceProvider : newResourceProviders) {
                    this.assertProviderIsValid(iResourceProvider);
                    this.findResourceMethods(iResourceProvider);
                }
            }
            if (!newPlainProviders.isEmpty()) {
                ourLog.info("Added {} plain provider(s). Total {}", (Object)newPlainProviders.size(), (Object)this.myPlainProviders.size());
                for (Object object : newPlainProviders) {
                    this.assertProviderIsValid(object);
                    this.findResourceMethods(object);
                }
            }
            if (!inInit) {
                ourLog.trace("Invoking provider initialize methods");
                if (!newResourceProviders.isEmpty()) {
                    for (IResourceProvider iResourceProvider : newResourceProviders) {
                        this.invokeInitialize(iResourceProvider);
                    }
                }
                if (!newPlainProviders.isEmpty()) {
                    for (Object object : newPlainProviders) {
                        this.invokeInitialize(object);
                    }
                }
            }
        }
    }

    private void removeResourceMethods(Object theProvider) throws Exception {
        ourLog.info("Removing RESTful methods for: {}", theProvider.getClass());
        Class<?> clazz = theProvider.getClass();
        Class<?> supertype = clazz.getSuperclass();
        ArrayList<String> resourceNames = new ArrayList<String>();
        while (!Object.class.equals(supertype)) {
            this.removeResourceMethods(theProvider, supertype, resourceNames);
            supertype = supertype.getSuperclass();
        }
        this.removeResourceMethods(theProvider, clazz, resourceNames);
        for (String resourceName : resourceNames) {
            this.myResourceNameToBinding.remove(resourceName);
        }
    }

    private void removeResourceMethods(Object theProvider, Class<?> clazz, Collection<String> resourceNames) throws ConfigurationException {
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            BaseMethodBinding<?> foundMethodBinding = BaseMethodBinding.bindMethod(m, this.getFhirContext(), theProvider);
            if (foundMethodBinding == null) continue;
            if (foundMethodBinding instanceof ConformanceMethodBinding) {
                this.myServerConformanceMethod = null;
                continue;
            }
            String resourceName = foundMethodBinding.getResourceName();
            if (resourceNames.contains(resourceName)) continue;
            resourceNames.add(resourceName);
        }
    }

    public Object returnResponse(ServletRequestDetails theRequest, ParseAction<?> outcome, int operationStatus, boolean allowPrefer, MethodOutcome response, String resourceName) throws IOException {
        PrintWriter writer;
        HttpServletResponse servletResponse = theRequest.getServletResponse();
        servletResponse.setStatus(operationStatus);
        servletResponse.setCharacterEncoding("UTF-8");
        this.addHeadersToResponse(servletResponse);
        if (allowPrefer) {
            this.addContentLocationHeaders(theRequest, servletResponse, response, resourceName);
        }
        if (outcome != null) {
            RestfulServerUtils.ResponseEncoding encoding = RestfulServerUtils.determineResponseEncodingWithDefault(theRequest);
            servletResponse.setContentType(encoding.getResourceContentType());
            writer = servletResponse.getWriter();
            IParser parser = encoding.getEncoding().newParser(this.getFhirContext());
            parser.setPrettyPrint(RestfulServerUtils.prettyPrintResponse(this, theRequest));
            outcome.execute(parser, writer);
        } else {
            servletResponse.setContentType("text/plain; charset=UTF-8");
            writer = servletResponse.getWriter();
        }
        return writer;
    }

    protected void service(HttpServletRequest theReq, HttpServletResponse theResp) throws ServletException, IOException {
        RequestTypeEnum method;
        theReq.setAttribute(REQUEST_START_TIME, (Object)new Date());
        try {
            method = RequestTypeEnum.valueOf((String)theReq.getMethod());
        }
        catch (IllegalArgumentException e) {
            super.service(theReq, theResp);
            return;
        }
        switch (method) {
            case DELETE: {
                this.doDelete(theReq, theResp);
                break;
            }
            case GET: {
                this.doGet(theReq, theResp);
                break;
            }
            case OPTIONS: {
                this.doOptions(theReq, theResp);
                break;
            }
            case POST: {
                this.doPost(theReq, theResp);
                break;
            }
            case PUT: {
                this.doPut(theReq, theResp);
                break;
            }
            default: {
                this.handleRequest(method, theReq, theResp);
            }
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.DELETE, request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.GET, request, response);
    }

    protected void doOptions(HttpServletRequest theReq, HttpServletResponse theResp) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.OPTIONS, theReq, theResp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.POST, request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.PUT, request, response);
    }

    public void setProviders(Object ... theProviders) {
        this.myPlainProviders.clear();
        if (theProviders != null) {
            this.myPlainProviders.addAll(Arrays.asList(theProviders));
        }
    }

    public void unregisterInterceptor(IServerInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.remove(theInterceptor);
    }

    public void unregisterProvider(Object provider) throws Exception {
        if (provider != null) {
            ArrayList<Object> providerList = new ArrayList<Object>(1);
            providerList.add(provider);
            this.unregisterProviders(providerList);
        }
    }

    public void unregisterProviders(Collection<? extends Object> providers) throws Exception {
        ProvidedResourceScanner providedResourceScanner = new ProvidedResourceScanner(this.getFhirContext());
        if (providers != null) {
            for (Object object : providers) {
                this.removeResourceMethods(object);
                if (object instanceof IResourceProvider) {
                    this.myResourceProviders.remove(object);
                    IResourceProvider rsrcProvider = (IResourceProvider)object;
                    Class<? extends IBaseResource> resourceType = rsrcProvider.getResourceType();
                    String resourceName = this.getFhirContext().getResourceDefinition(resourceType).getName();
                    this.myTypeToProvider.remove(resourceName);
                    providedResourceScanner.removeProvidedResources((Object)rsrcProvider);
                } else {
                    this.myPlainProviders.remove(object);
                }
                this.invokeDestroy(object);
            }
        }
    }

    private void writeExceptionToResponse(HttpServletResponse theResponse, BaseServerResponseException theException) throws IOException {
        theResponse.setStatus(theException.getStatusCode());
        this.addHeadersToResponse(theResponse);
        if (theException.hasResponseHeaders()) {
            for (Map.Entry nextEntry : theException.getResponseHeaders().entrySet()) {
                for (String nextValue : (List)nextEntry.getValue()) {
                    if (!StringUtils.isNotBlank((CharSequence)nextValue)) continue;
                    theResponse.addHeader((String)nextEntry.getKey(), nextValue);
                }
            }
        }
        theResponse.setContentType("text/plain");
        theResponse.setCharacterEncoding("UTF-8");
        theResponse.getWriter().write(theException.getMessage());
    }
}

