/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.openapi;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ClasspathUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.Resource;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.linkbuilder.AbstractLinkBuilder;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.templateresource.ClassLoaderTemplateResource;
import org.thymeleaf.templateresource.ITemplateResource;

public class OpenApiInterceptor {
    public static final String FHIR_JSON_RESOURCE = "FHIR-JSON-RESOURCE";
    public static final String FHIR_XML_RESOURCE = "FHIR-XML-RESOURCE";
    public static final String PAGE_SYSTEM = "System Level Operations";
    public static final String PAGE_ALL = "All";
    public static final FhirContext FHIR_CONTEXT_CANONICAL = FhirContext.forR4();
    public static final String REQUEST_DETAILS = "REQUEST_DETAILS";
    public static final String RACCOON_PNG = "raccoon.png";
    private final String mySwaggerUiVersion;
    private final TemplateEngine myTemplateEngine;
    private final Parser myFlexmarkParser;
    private final HtmlRenderer myFlexmarkRenderer;
    private final Map<String, String> myResourcePathToClasspath = new HashMap<String, String>();
    private final Map<String, String> myExtensionToContentType = new HashMap<String, String>();
    private String myBannerImage;

    public OpenApiInterceptor() {
        this.mySwaggerUiVersion = this.initSwaggerUiWebJar();
        this.myTemplateEngine = new TemplateEngine();
        SwaggerUiTemplateResolver resolver = new SwaggerUiTemplateResolver();
        this.myTemplateEngine.setTemplateResolver((ITemplateResolver)resolver);
        StandardDialect dialect = new StandardDialect();
        this.myTemplateEngine.setDialect((IDialect)dialect);
        this.myTemplateEngine.setLinkBuilder((ILinkBuilder)new TemplateLinkBuilder());
        this.myFlexmarkParser = Parser.builder().build();
        this.myFlexmarkRenderer = HtmlRenderer.builder().build();
        this.initResources();
    }

    private void initResources() {
        this.setBannerImage(RACCOON_PNG);
        this.addResourcePathToClasspath("/swagger-ui/index.html", "/ca/uhn/fhir/rest/openapi/index.html");
        this.addResourcePathToClasspath("/swagger-ui/raccoon.png", "/ca/uhn/fhir/rest/openapi/raccoon.png");
        this.addResourcePathToClasspath("/swagger-ui/index.css", "/ca/uhn/fhir/rest/openapi/index.css");
        this.myExtensionToContentType.put(".png", "image/png");
        this.myExtensionToContentType.put(".css", "text/css; charset=UTF-8");
    }

    protected void addResourcePathToClasspath(String thePath, String theClasspath) {
        this.myResourcePathToClasspath.put(thePath, theClasspath);
    }

    private String initSwaggerUiWebJar() {
        Properties props = new Properties();
        String resourceName = "/META-INF/maven/org.webjars/swagger-ui/pom.properties";
        try {
            InputStream resourceAsStream = ClasspathUtil.loadResourceAsStream((String)resourceName);
            props.load(resourceAsStream);
        }
        catch (IOException e) {
            throw new ConfigurationException(Msg.code((int)239) + "Failed to load resource: " + resourceName);
        }
        String mySwaggerUiVersion = props.getProperty("version");
        return mySwaggerUiVersion;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLER_SELECTED)
    public boolean serveSwaggerUi(HttpServletRequest theRequest, HttpServletResponse theResponse, ServletRequestDetails theRequestDetails) throws IOException {
        String requestPath = theRequest.getPathInfo();
        String queryString = theRequest.getQueryString();
        if (StringUtils.isBlank((CharSequence)requestPath) || requestPath.equals("/")) {
            Set highestRankedAcceptValues;
            if (StringUtils.isBlank((CharSequence)queryString) && (highestRankedAcceptValues = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions((HttpServletRequest)theRequest)).contains("text/html")) {
                String serverBase = ".";
                if (theRequestDetails.getServletRequest() != null) {
                    IServerAddressStrategy addressStrategy = theRequestDetails.getServer().getServerAddressStrategy();
                    serverBase = addressStrategy.determineServerBase(theRequest.getServletContext(), theRequest);
                }
                String redirectUrl = theResponse.encodeRedirectURL(serverBase + "/swagger-ui/");
                theResponse.sendRedirect(redirectUrl);
                theResponse.getWriter().close();
                return false;
            }
            return true;
        }
        if (requestPath.startsWith("/swagger-ui/")) {
            return !this.handleResourceRequest(theResponse, theRequestDetails, requestPath);
        }
        if (requestPath.equals("/api-docs")) {
            OpenAPI openApi = this.generateOpenApi(theRequestDetails);
            String response = Yaml.pretty((Object)openApi);
            theResponse.setContentType("text/yaml");
            theResponse.setStatus(200);
            theResponse.getWriter().write(response);
            theResponse.getWriter().close();
            return false;
        }
        return true;
    }

    protected boolean handleResourceRequest(HttpServletResponse theResponse, ServletRequestDetails theRequestDetails, String requestPath) throws IOException {
        if (requestPath.equals("/swagger-ui/") || requestPath.equals("/swagger-ui/index.html")) {
            this.serveSwaggerUiHtml(theRequestDetails, theResponse);
            return true;
        }
        String resourceClasspath = this.myResourcePathToClasspath.get(requestPath);
        if (resourceClasspath != null) {
            theResponse.setStatus(200);
            String extension = requestPath.substring(requestPath.lastIndexOf(46));
            String contentType = this.myExtensionToContentType.get(extension);
            assert (contentType != null);
            theResponse.setContentType(contentType);
            try (InputStream resource = ClasspathUtil.loadResourceAsStream((String)resourceClasspath);){
                IOUtils.copy((InputStream)resource, (OutputStream)theResponse.getOutputStream());
                theResponse.getOutputStream().close();
            }
            return true;
        }
        String resourcePath = requestPath.substring("/swagger-ui/".length());
        try (InputStream resource = ClasspathUtil.loadResourceAsStream((String)("/META-INF/resources/webjars/swagger-ui/" + this.mySwaggerUiVersion + "/" + resourcePath));){
            if (resourcePath.endsWith(".js") || resourcePath.endsWith(".map")) {
                theResponse.setContentType("application/javascript");
                theResponse.setStatus(200);
                IOUtils.copy((InputStream)resource, (OutputStream)theResponse.getOutputStream());
                theResponse.getOutputStream().close();
                boolean bl = true;
                return bl;
            }
            if (resourcePath.endsWith(".css")) {
                theResponse.setContentType("text/css");
                theResponse.setStatus(200);
                IOUtils.copy((InputStream)resource, (OutputStream)theResponse.getOutputStream());
                theResponse.getOutputStream().close();
                boolean bl = true;
                return bl;
            }
            if (resourcePath.endsWith(".html")) {
                theResponse.setContentType("text/html");
                theResponse.setStatus(200);
                IOUtils.copy((InputStream)resource, (OutputStream)theResponse.getOutputStream());
                theResponse.getOutputStream().close();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public String removeTrailingSlash(String theUrl) {
        while (theUrl != null && theUrl.endsWith("/")) {
            theUrl = theUrl.substring(0, theUrl.length() - 1);
        }
        return theUrl;
    }

    private void serveSwaggerUiHtml(ServletRequestDetails theRequestDetails, HttpServletResponse theResponse) throws IOException {
        CapabilityStatement cs = this.getCapabilityStatement(theRequestDetails);
        String baseUrl = this.removeTrailingSlash(cs.getImplementation().getUrl());
        theResponse.setStatus(200);
        theResponse.setContentType("text/html");
        HttpServletRequest servletRequest = theRequestDetails.getServletRequest();
        ServletContext servletContext = servletRequest.getServletContext();
        WebContext context = new WebContext(servletRequest, theResponse, servletContext);
        context.setVariable(REQUEST_DETAILS, (Object)theRequestDetails);
        context.setVariable("DESCRIPTION", (Object)cs.getImplementation().getDescription());
        context.setVariable("SERVER_NAME", (Object)cs.getSoftware().getName());
        context.setVariable("SERVER_VERSION", (Object)cs.getSoftware().getVersion());
        context.setVariable("BASE_URL", (Object)cs.getImplementation().getUrl());
        context.setVariable("BANNER_IMAGE_URL", (Object)this.getBannerImage());
        context.setVariable("OPENAPI_DOCS", (Object)(baseUrl + "/api-docs"));
        context.setVariable("FHIR_VERSION", (Object)cs.getFhirVersion().toCode());
        context.setVariable("FHIR_VERSION_CODENAME", (Object)FhirVersionEnum.forVersionString((String)cs.getFhirVersion().toCode()).name());
        String copyright = cs.getCopyright();
        if (StringUtils.isNotBlank((CharSequence)copyright)) {
            copyright = this.myFlexmarkRenderer.render((Node)this.myFlexmarkParser.parse(copyright));
            context.setVariable("COPYRIGHT_HTML", (Object)copyright);
        }
        ArrayList<String> pageNames = new ArrayList<String>();
        HashMap resourceToCount = new HashMap();
        cs.getRestFirstRep().getResource().stream().forEach(t -> {
            IPrimitiveType countExtensionValue;
            String type = t.getType();
            pageNames.add(type);
            Extension countExtension = t.getExtensionByUrl("http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount");
            if (countExtension != null && (countExtensionValue = countExtension.getValueAsPrimitive()) != null && countExtensionValue.hasValue()) {
                resourceToCount.put(type, ((Number)countExtensionValue.getValue()).intValue());
            }
        });
        pageNames.sort((o1, o2) -> {
            Integer count1 = (Integer)resourceToCount.get(o1);
            Integer count2 = (Integer)resourceToCount.get(o2);
            if (count1 != null && count2 != null) {
                return count2 - count1;
            }
            if (count1 != null) {
                return -1;
            }
            if (count2 != null) {
                return 1;
            }
            return o1.compareTo((String)o2);
        });
        pageNames.add(0, PAGE_ALL);
        pageNames.add(1, PAGE_SYSTEM);
        context.setVariable("PAGE_NAMES", pageNames);
        context.setVariable("PAGE_NAME_TO_COUNT", resourceToCount);
        String page = this.extractPageName(theRequestDetails, PAGE_SYSTEM);
        context.setVariable("PAGE", (Object)page);
        this.populateOIDCVariables(theRequestDetails, context);
        String outcome = this.myTemplateEngine.process("index.html", (IContext)context);
        theResponse.getWriter().write(outcome);
        theResponse.getWriter().close();
    }

    protected void populateOIDCVariables(ServletRequestDetails theRequestDetails, WebContext theContext) {
        theContext.setVariable("OAUTH2_REDIRECT_URL_PROPERTY", (Object)"");
    }

    private String extractPageName(ServletRequestDetails theRequestDetails, String theDefault) {
        String[] pageValues = (String[])theRequestDetails.getParameters().get("page");
        String page = null;
        if (pageValues != null && pageValues.length > 0) {
            page = pageValues[0];
        }
        if (StringUtils.isBlank(page)) {
            page = theDefault;
        }
        return page;
    }

    protected OpenAPI generateOpenApi(ServletRequestDetails theRequestDetails) {
        String page = this.extractPageName(theRequestDetails, null);
        CapabilityStatement cs = this.getCapabilityStatement(theRequestDetails);
        FhirContext ctx = theRequestDetails.getFhirContext();
        IServerConformanceProvider capabilitiesProvider = null;
        RestfulServer restfulServer = theRequestDetails.getServer();
        if (restfulServer.getServerConformanceProvider() instanceof IServerConformanceProvider) {
            capabilitiesProvider = (IServerConformanceProvider)restfulServer.getServerConformanceProvider();
        }
        OpenAPI openApi = new OpenAPI();
        openApi.setInfo(new Info());
        openApi.getInfo().setDescription(cs.getDescription());
        openApi.getInfo().setTitle(cs.getSoftware().getName());
        openApi.getInfo().setVersion(cs.getSoftware().getVersion());
        openApi.getInfo().setContact(new Contact());
        openApi.getInfo().getContact().setName(cs.getContactFirstRep().getName());
        openApi.getInfo().getContact().setEmail(cs.getContactFirstRep().getTelecomFirstRep().getValue());
        Server server = new Server();
        openApi.addServersItem(server);
        server.setUrl(cs.getImplementation().getUrl());
        server.setDescription(cs.getSoftware().getName());
        Paths paths = new Paths();
        openApi.setPaths(paths);
        if (page == null || page.equals(PAGE_SYSTEM) || page.equals(PAGE_ALL)) {
            Tag serverTag = new Tag();
            serverTag.setName(PAGE_SYSTEM);
            serverTag.setDescription("Server-level operations");
            openApi.addTagsItem(serverTag);
            Operation capabilitiesOperation = this.getPathItem(paths, "/metadata", PathItem.HttpMethod.GET);
            capabilitiesOperation.addTagsItem(PAGE_SYSTEM);
            capabilitiesOperation.setSummary("server-capabilities: Fetch the server FHIR CapabilityStatement");
            this.addFhirResourceResponse(ctx, openApi, capabilitiesOperation, "CapabilityStatement");
            Set systemInteractions = cs.getRestFirstRep().getInteraction().stream().map(t -> t.getCode()).collect(Collectors.toSet());
            if (systemInteractions.contains(CapabilityStatement.SystemRestfulInteraction.TRANSACTION) || systemInteractions.contains(CapabilityStatement.SystemRestfulInteraction.BATCH)) {
                Operation transaction = this.getPathItem(paths, "/", PathItem.HttpMethod.POST);
                transaction.addTagsItem(PAGE_SYSTEM);
                transaction.setSummary("server-transaction: Execute a FHIR Transaction (or FHIR Batch) Bundle");
                this.addFhirResourceResponse(ctx, openApi, transaction, null);
                this.addFhirResourceRequestBody(openApi, transaction, ctx, null);
            }
            if (systemInteractions.contains(CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM)) {
                Operation systemHistory = this.getPathItem(paths, "/_history", PathItem.HttpMethod.GET);
                systemHistory.addTagsItem(PAGE_SYSTEM);
                systemHistory.setSummary("server-history: Fetch the resource change history across all resource types on the server");
                this.addFhirResourceResponse(ctx, openApi, systemHistory, null);
            }
            for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent nextOperation : cs.getRestFirstRep().getOperation()) {
                this.addFhirOperation(ctx, openApi, theRequestDetails, capabilitiesProvider, paths, null, nextOperation);
            }
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent nextResource : cs.getRestFirstRep().getResource()) {
            Operation operation;
            String resourceType = nextResource.getType();
            if (page != null && !page.equals(resourceType) && !page.equals(PAGE_ALL)) continue;
            Set typeRestfulInteractions = nextResource.getInteraction().stream().map(t -> (CapabilityStatement.TypeRestfulInteraction)t.getCodeElement().getValue()).collect(Collectors.toSet());
            Tag resourceTag = new Tag();
            resourceTag.setName(resourceType);
            resourceTag.setDescription("The " + resourceType + " FHIR resource type");
            openApi.addTagsItem(resourceTag);
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.READ)) {
                operation = this.getPathItem(paths, "/" + resourceType + "/{id}", PathItem.HttpMethod.GET);
                operation.addTagsItem(resourceType);
                operation.setSummary("read-instance: Read " + resourceType + " instance");
                this.addResourceIdParameter(operation);
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.VREAD)) {
                operation = this.getPathItem(paths, "/" + resourceType + "/{id}/_history/{version_id}", PathItem.HttpMethod.GET);
                operation.addTagsItem(resourceType);
                operation.setSummary("vread-instance: Read " + resourceType + " instance with specific version");
                this.addResourceIdParameter(operation);
                this.addResourceVersionIdParameter(operation);
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.CREATE)) {
                operation = this.getPathItem(paths, "/" + resourceType, PathItem.HttpMethod.POST);
                operation.addTagsItem(resourceType);
                operation.setSummary("create-type: Create a new " + resourceType + " instance");
                this.addFhirResourceRequestBody(openApi, operation, ctx, this.genericExampleSupplier(ctx, resourceType));
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.UPDATE)) {
                operation = this.getPathItem(paths, "/" + resourceType + "/{id}", PathItem.HttpMethod.PUT);
                operation.addTagsItem(resourceType);
                operation.setSummary("update-instance: Update an existing " + resourceType + " instance, or create using a client-assigned ID");
                this.addResourceIdParameter(operation);
                this.addFhirResourceRequestBody(openApi, operation, ctx, this.genericExampleSupplier(ctx, resourceType));
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE)) {
                operation = this.getPathItem(paths, "/" + resourceType + "/_history", PathItem.HttpMethod.GET);
                operation.addTagsItem(resourceType);
                operation.setSummary("type-history: Fetch the resource change history for all resources of type " + resourceType);
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE)) {
                operation = this.getPathItem(paths, "/" + resourceType + "/{id}/_history", PathItem.HttpMethod.GET);
                operation.addTagsItem(resourceType);
                operation.setSummary("instance-history: Fetch the resource change history for all resources of type " + resourceType);
                this.addResourceIdParameter(operation);
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.PATCH)) {
                operation = this.getPathItem(paths, "/" + resourceType + "/{id}", PathItem.HttpMethod.PATCH);
                operation.addTagsItem(resourceType);
                operation.setSummary("instance-patch: Patch a resource instance of type " + resourceType + " by ID");
                this.addResourceIdParameter(operation);
                this.addFhirResourceRequestBody(openApi, operation, FHIR_CONTEXT_CANONICAL, this.patchExampleSupplier());
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.DELETE)) {
                operation = this.getPathItem(paths, "/" + resourceType + "/{id}", PathItem.HttpMethod.DELETE);
                operation.addTagsItem(resourceType);
                operation.setSummary("instance-delete: Perform a logical delete on a resource instance");
                this.addResourceIdParameter(operation);
                this.addFhirResourceResponse(ctx, openApi, operation, null);
            }
            if (typeRestfulInteractions.contains(CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE)) {
                operation = this.getPathItem(paths, "/" + resourceType, PathItem.HttpMethod.GET);
                operation.addTagsItem(resourceType);
                operation.setDescription("This is a search type");
                operation.setSummary("search-type: Search for " + resourceType + " instances");
                this.addFhirResourceResponse(ctx, openApi, operation, null);
                for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent nextSearchParam : nextResource.getSearchParam()) {
                    Parameter parametersItem = new Parameter();
                    operation.addParametersItem(parametersItem);
                    parametersItem.setName(nextSearchParam.getName());
                    parametersItem.setIn("query");
                    parametersItem.setDescription(nextSearchParam.getDocumentation());
                    parametersItem.setStyle(Parameter.StyleEnum.SIMPLE);
                }
            }
            for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent nextOperation : nextResource.getOperation()) {
                this.addFhirOperation(ctx, openApi, theRequestDetails, capabilitiesProvider, paths, resourceType, nextOperation);
            }
        }
        return openApi;
    }

    private Supplier<IBaseResource> patchExampleSupplier() {
        return () -> {
            Parameters example = new Parameters();
            Parameters.ParametersParameterComponent operation = example.addParameter().setName("operation");
            operation.addPart().setName("type").setValue((Type)new StringType("add"));
            operation.addPart().setName("path").setValue((Type)new StringType("Patient"));
            operation.addPart().setName("name").setValue((Type)new StringType("birthDate"));
            operation.addPart().setName("value").setValue((Type)new DateType("1930-01-01"));
            return example;
        };
    }

    private void addSchemaFhirResource(OpenAPI theOpenApi) {
        this.ensureComponentsSchemasPopulated(theOpenApi);
        if (!theOpenApi.getComponents().getSchemas().containsKey(FHIR_JSON_RESOURCE)) {
            ObjectSchema fhirJsonSchema = new ObjectSchema();
            fhirJsonSchema.setDescription("A FHIR resource");
            theOpenApi.getComponents().addSchemas(FHIR_JSON_RESOURCE, (Schema)fhirJsonSchema);
        }
        if (!theOpenApi.getComponents().getSchemas().containsKey(FHIR_XML_RESOURCE)) {
            ObjectSchema fhirXmlSchema = new ObjectSchema();
            fhirXmlSchema.setDescription("A FHIR resource");
            theOpenApi.getComponents().addSchemas(FHIR_XML_RESOURCE, (Schema)fhirXmlSchema);
        }
    }

    private void ensureComponentsSchemasPopulated(OpenAPI theOpenApi) {
        if (theOpenApi.getComponents() == null) {
            theOpenApi.setComponents(new Components());
        }
        if (theOpenApi.getComponents().getSchemas() == null) {
            theOpenApi.getComponents().setSchemas(new LinkedHashMap());
        }
    }

    private CapabilityStatement getCapabilityStatement(ServletRequestDetails theRequestDetails) {
        RestfulServer restfulServer = theRequestDetails.getServer();
        IBaseConformance versionIndependentCapabilityStatement = restfulServer.getCapabilityStatement(theRequestDetails);
        return (CapabilityStatement)OpenApiInterceptor.toCanonicalVersion((IBaseResource)versionIndependentCapabilityStatement);
    }

    private void addFhirOperation(FhirContext theFhirContext, OpenAPI theOpenApi, ServletRequestDetails theRequestDetails, IServerConformanceProvider<?> theCapabilitiesProvider, Paths thePaths, String theResourceType, CapabilityStatement.CapabilityStatementRestResourceOperationComponent theOperation) {
        if (theCapabilitiesProvider != null) {
            IdType definitionId = new IdType(theOperation.getDefinition());
            IBaseResource operationDefinitionNonCanonical = theCapabilitiesProvider.readOperationDefinition((IIdType)definitionId, (RequestDetails)theRequestDetails);
            if (operationDefinitionNonCanonical == null) {
                return;
            }
            OperationDefinition operationDefinition = (OperationDefinition)OpenApiInterceptor.toCanonicalVersion(operationDefinitionNonCanonical);
            if (!operationDefinition.getAffectsState()) {
                if (theResourceType != null) {
                    Operation operation;
                    if (operationDefinition.getType()) {
                        operation = this.getPathItem(thePaths, "/" + theResourceType + "/$" + operationDefinition.getCode(), PathItem.HttpMethod.GET);
                        this.populateOperation(theFhirContext, theOpenApi, theResourceType, operationDefinition, operation, true);
                    }
                    if (operationDefinition.getInstance()) {
                        operation = this.getPathItem(thePaths, "/" + theResourceType + "/{id}/$" + operationDefinition.getCode(), PathItem.HttpMethod.GET);
                        this.addResourceIdParameter(operation);
                        this.populateOperation(theFhirContext, theOpenApi, theResourceType, operationDefinition, operation, true);
                    }
                } else if (operationDefinition.getSystem()) {
                    Operation operation = this.getPathItem(thePaths, "/$" + operationDefinition.getCode(), PathItem.HttpMethod.GET);
                    this.populateOperation(theFhirContext, theOpenApi, null, operationDefinition, operation, true);
                }
            } else if (theResourceType != null) {
                Operation operation;
                if (operationDefinition.getType()) {
                    operation = this.getPathItem(thePaths, "/" + theResourceType + "/$" + operationDefinition.getCode(), PathItem.HttpMethod.POST);
                    this.populateOperation(theFhirContext, theOpenApi, theResourceType, operationDefinition, operation, false);
                }
                if (operationDefinition.getInstance()) {
                    operation = this.getPathItem(thePaths, "/" + theResourceType + "/{id}/$" + operationDefinition.getCode(), PathItem.HttpMethod.POST);
                    this.addResourceIdParameter(operation);
                    this.populateOperation(theFhirContext, theOpenApi, theResourceType, operationDefinition, operation, false);
                }
            } else if (operationDefinition.getSystem()) {
                Operation operation = this.getPathItem(thePaths, "/$" + operationDefinition.getCode(), PathItem.HttpMethod.POST);
                this.populateOperation(theFhirContext, theOpenApi, null, operationDefinition, operation, false);
            }
        }
    }

    private void populateOperation(FhirContext theFhirContext, OpenAPI theOpenApi, String theResourceType, OperationDefinition theOperationDefinition, Operation theOperation, boolean theGet) {
        if (theResourceType == null) {
            theOperation.addTagsItem(PAGE_SYSTEM);
        } else {
            theOperation.addTagsItem(theResourceType);
        }
        theOperation.setSummary(theOperationDefinition.getTitle());
        theOperation.setDescription(theOperationDefinition.getDescription());
        this.addFhirResourceResponse(theFhirContext, theOpenApi, theOperation, null);
        if (theGet) {
            for (OperationDefinition.OperationDefinitionParameterComponent nextParameter : theOperationDefinition.getParameter()) {
                Parameter parametersItem = new Parameter();
                theOperation.addParametersItem(parametersItem);
                parametersItem.setName(nextParameter.getName());
                parametersItem.setIn("query");
                parametersItem.setDescription(nextParameter.getDocumentation());
                parametersItem.setStyle(Parameter.StyleEnum.SIMPLE);
                parametersItem.setRequired(Boolean.valueOf(nextParameter.getMin() > 0));
                List exampleExtensions = nextParameter.getExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/op-parameter-example-value");
                if (exampleExtensions.size() == 1) {
                    parametersItem.setExample((Object)((Extension)exampleExtensions.get(0)).getValueAsPrimitive().getValueAsString());
                    continue;
                }
                if (exampleExtensions.size() <= 1) continue;
                for (Extension next : exampleExtensions) {
                    String nextExample = next.getValueAsPrimitive().getValueAsString();
                    parametersItem.addExample(nextExample, new Example().value((Object)nextExample));
                }
            }
        } else {
            Parameters exampleRequestBody = new Parameters();
            for (OperationDefinition.OperationDefinitionParameterComponent nextSearchParam : theOperationDefinition.getParameter()) {
                Parameters.ParametersParameterComponent param = exampleRequestBody.addParameter();
                param.setName(nextSearchParam.getName());
                String paramType = nextSearchParam.getType();
                switch (StringUtils.defaultString((String)paramType)) {
                    case "uri": 
                    case "url": 
                    case "code": 
                    case "string": {
                        CodeableConcept type = (IPrimitiveType)FHIR_CONTEXT_CANONICAL.getElementDefinition(paramType).newInstance();
                        type.setValueAsString("example");
                        param.setValue((Type)type);
                        break;
                    }
                    case "integer": {
                        CodeableConcept type = (IPrimitiveType)FHIR_CONTEXT_CANONICAL.getElementDefinition(paramType).newInstance();
                        type.setValueAsString("0");
                        param.setValue((Type)type);
                        break;
                    }
                    case "boolean": {
                        CodeableConcept type = (IPrimitiveType)FHIR_CONTEXT_CANONICAL.getElementDefinition(paramType).newInstance();
                        type.setValueAsString("false");
                        param.setValue((Type)type);
                        break;
                    }
                    case "CodeableConcept": {
                        CodeableConcept type = new CodeableConcept();
                        type.getCodingFirstRep().setSystem("http://example.com");
                        type.getCodingFirstRep().setCode("1234");
                        param.setValue((Type)type);
                        break;
                    }
                    case "Coding": {
                        CodeableConcept type = new Coding();
                        type.setSystem("http://example.com");
                        type.setCode("1234");
                        param.setValue((Type)type);
                        break;
                    }
                    case "Reference": {
                        Reference reference = new Reference("example");
                        param.setValue((Type)reference);
                        break;
                    }
                    case "Resource": {
                        if (theResourceType == null) break;
                        IBaseResource resource = (IBaseResource)FHIR_CONTEXT_CANONICAL.getResourceDefinition(theResourceType).newInstance();
                        resource.setId("1");
                        param.setResource((org.hl7.fhir.r4.model.Resource)resource);
                    }
                }
            }
            String exampleRequestBodyString = FHIR_CONTEXT_CANONICAL.newJsonParser().setPrettyPrint(true).encodeResourceToString((IBaseResource)exampleRequestBody);
            theOperation.setRequestBody(new RequestBody());
            theOperation.getRequestBody().setContent(new Content());
            MediaType mediaType = new MediaType();
            mediaType.setExample((Object)exampleRequestBodyString);
            mediaType.setSchema(new Schema().type("object").title("FHIR Resource"));
            theOperation.getRequestBody().getContent().addMediaType("application/fhir+json", mediaType);
        }
    }

    protected Operation getPathItem(Paths thePaths, String thePath, PathItem.HttpMethod theMethod) {
        PathItem pathItem;
        if (thePaths.containsKey((Object)thePath)) {
            pathItem = (PathItem)thePaths.get((Object)thePath);
        } else {
            pathItem = new PathItem();
            thePaths.addPathItem(thePath, pathItem);
        }
        switch (theMethod) {
            case POST: {
                assert (pathItem.getPost() == null) : "Have duplicate POST at path: " + thePath;
                return pathItem.post(new Operation()).getPost();
            }
            case GET: {
                assert (pathItem.getGet() == null) : "Have duplicate GET at path: " + thePath;
                return pathItem.get(new Operation()).getGet();
            }
            case PUT: {
                assert (pathItem.getPut() == null);
                return pathItem.put(new Operation()).getPut();
            }
            case PATCH: {
                assert (pathItem.getPatch() == null);
                return pathItem.patch(new Operation()).getPatch();
            }
            case DELETE: {
                assert (pathItem.getDelete() == null);
                return pathItem.delete(new Operation()).getDelete();
            }
        }
        throw new IllegalStateException(Msg.code((int)240));
    }

    private void addFhirResourceRequestBody(OpenAPI theOpenApi, Operation theOperation, FhirContext theExampleFhirContext, Supplier<IBaseResource> theExampleSupplier) {
        RequestBody requestBody = new RequestBody();
        requestBody.setContent(this.provideContentFhirResource(theOpenApi, theExampleFhirContext, theExampleSupplier));
        theOperation.setRequestBody(requestBody);
    }

    private void addResourceVersionIdParameter(Operation theOperation) {
        Parameter parameter = new Parameter();
        parameter.setName("version_id");
        parameter.setIn("path");
        parameter.setDescription("The resource version ID");
        parameter.setExample((Object)"1");
        parameter.setSchema(new Schema().type("string").minimum(new BigDecimal(1)));
        parameter.setStyle(Parameter.StyleEnum.SIMPLE);
        theOperation.addParametersItem(parameter);
    }

    private void addFhirResourceResponse(FhirContext theFhirContext, OpenAPI theOpenApi, Operation theOperation, String theResourceType) {
        theOperation.setResponses(new ApiResponses());
        ApiResponse response200 = new ApiResponse();
        response200.setDescription("Success");
        response200.setContent(this.provideContentFhirResource(theOpenApi, theFhirContext, this.genericExampleSupplier(theFhirContext, theResourceType)));
        theOperation.getResponses().addApiResponse("200", response200);
    }

    private Supplier<IBaseResource> genericExampleSupplier(FhirContext theFhirContext, String theResourceType) {
        if (theResourceType == null) {
            return null;
        }
        return () -> {
            IBaseResource example = null;
            if (theResourceType != null) {
                example = (IBaseResource)theFhirContext.getResourceDefinition(theResourceType).newInstance();
            }
            return example;
        };
    }

    private Content provideContentFhirResource(OpenAPI theOpenApi, FhirContext theExampleFhirContext, Supplier<IBaseResource> theExampleSupplier) {
        this.addSchemaFhirResource(theOpenApi);
        Content retVal = new Content();
        MediaType jsonSchema = new MediaType().schema(new ObjectSchema().$ref("#/components/schemas/FHIR-JSON-RESOURCE"));
        if (theExampleSupplier != null) {
            jsonSchema.setExample((Object)theExampleFhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToString(theExampleSupplier.get()));
        }
        retVal.addMediaType("application/fhir+json", jsonSchema);
        MediaType xmlSchema = new MediaType().schema(new ObjectSchema().$ref("#/components/schemas/FHIR-XML-RESOURCE"));
        if (theExampleSupplier != null) {
            xmlSchema.setExample((Object)theExampleFhirContext.newXmlParser().setPrettyPrint(true).encodeResourceToString(theExampleSupplier.get()));
        }
        retVal.addMediaType("application/fhir+xml", xmlSchema);
        return retVal;
    }

    private void addResourceIdParameter(Operation theOperation) {
        Parameter parameter = new Parameter();
        parameter.setName("id");
        parameter.setIn("path");
        parameter.setDescription("The resource ID");
        parameter.setExample((Object)"123");
        parameter.setSchema(new Schema().type("string").minimum(new BigDecimal(1)));
        parameter.setStyle(Parameter.StyleEnum.SIMPLE);
        theOperation.addParametersItem(parameter);
    }

    protected ClassLoaderTemplateResource getIndexTemplate() {
        return new ClassLoaderTemplateResource(this.myResourcePathToClasspath.get("/swagger-ui/index.html"), StandardCharsets.UTF_8.name());
    }

    public void setBannerImage(String theBannerImage) {
        this.myBannerImage = theBannerImage;
    }

    public String getBannerImage() {
        return this.myBannerImage;
    }

    private static <T extends org.hl7.fhir.r4.model.Resource> T toCanonicalVersion(IBaseResource theNonCanonical) {
        Object canonical = theNonCanonical instanceof org.hl7.fhir.dstu3.model.Resource ? VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theNonCanonical)) : (theNonCanonical instanceof Resource ? VersionConvertorFactory_40_50.convertResource((Resource)((Resource)theNonCanonical)) : theNonCanonical);
        return (T)canonical;
    }

    private class SwaggerUiTemplateResolver
    implements ITemplateResolver {
        private SwaggerUiTemplateResolver() {
        }

        public String getName() {
            return this.getClass().getName();
        }

        public Integer getOrder() {
            return 0;
        }

        public TemplateResolution resolveTemplate(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
            ClassLoaderTemplateResource resource = OpenApiInterceptor.this.getIndexTemplate();
            AlwaysValidCacheEntryValidity cacheValidity = new AlwaysValidCacheEntryValidity();
            return new TemplateResolution((ITemplateResource)resource, TemplateMode.HTML, (ICacheEntryValidity)cacheValidity);
        }
    }

    private static class TemplateLinkBuilder
    extends AbstractLinkBuilder {
        private TemplateLinkBuilder() {
        }

        public String buildLink(IExpressionContext theExpressionContext, String theBase, Map<String, Object> theParameters) {
            ServletRequestDetails requestDetails = (ServletRequestDetails)theExpressionContext.getVariable(OpenApiInterceptor.REQUEST_DETAILS);
            IServerAddressStrategy addressStrategy = requestDetails.getServer().getServerAddressStrategy();
            String baseUrl = addressStrategy.determineServerBase(requestDetails.getServletRequest().getServletContext(), requestDetails.getServletRequest());
            StringBuilder builder = new StringBuilder();
            builder.append(baseUrl);
            builder.append(theBase);
            if (!theParameters.isEmpty()) {
                builder.append("?");
                Iterator<Map.Entry<String, Object>> iter = theParameters.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Object> nextEntry = iter.next();
                    builder.append(UrlUtil.escapeUrlParam((String)nextEntry.getKey()));
                    builder.append("=");
                    builder.append(UrlUtil.escapeUrlParam((String)ObjectUtils.defaultIfNull((Object)nextEntry.getValue(), (Object)"").toString()));
                    if (!iter.hasNext()) continue;
                    builder.append("&");
                }
            }
            return builder.toString();
        }
    }
}

