/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

@Interceptor
public class CapturingInterceptor {
    private IHttpRequest myLastRequest;
    private IHttpResponse myLastResponse;

    public void clear() {
        this.myLastRequest = null;
        this.myLastResponse = null;
    }

    public IHttpRequest getLastRequest() {
        return this.myLastRequest;
    }

    public IHttpResponse getLastResponse() {
        return this.myLastResponse;
    }

    @Hook(value=Pointcut.CLIENT_REQUEST, order=1000)
    public void interceptRequest(IHttpRequest theRequest) {
        this.myLastRequest = theRequest;
    }

    @Hook(value=Pointcut.CLIENT_RESPONSE, order=-1)
    public void interceptResponse(IHttpResponse theResponse) {
        CapturingInterceptor.bufferResponse(theResponse);
        this.myLastResponse = theResponse;
    }

    static void bufferResponse(IHttpResponse theResponse) {
        try {
            if (theResponse.getResponse() instanceof HttpResponse) {
                HttpEntity entity = ((HttpResponse)theResponse.getResponse()).getEntity();
                if (entity != null && !entity.isRepeatable()) {
                    theResponse.bufferEntity();
                }
            } else {
                theResponse.bufferEntity();
            }
        }
        catch (IOException e) {
            throw new InternalErrorException("Unable to buffer the entity for capturing", (Throwable)e);
        }
    }
}

