/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody;
import ca.uhn.fhir.rest.client.method.HttpDeleteClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class DeleteMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody {
    public DeleteMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider, Delete.class, theMethod.getAnnotation(Delete.class).type());
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.DELETE;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.DELETE);
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IBaseResource theResource) {
        StringBuilder urlExtension = new StringBuilder();
        urlExtension.append(this.getContext().getResourceDefinition(theResource).getName());
        return new HttpPostClientInvocation(this.getContext(), theResource, urlExtension.toString());
    }

    @Override
    protected boolean allowVoidReturnType() {
        return true;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IIdType id = (IIdType)theArgs[this.getIdParameterIndex()];
        if (id == null) {
            throw new NullPointerException("ID can not be null");
        }
        if (!id.hasResourceType()) {
            id = id.withResourceType(this.getResourceName());
        } else if (!this.getResourceName().equals(id.getResourceType())) {
            throw new InvalidRequestException("ID parameter has the wrong resource type, expected '" + this.getResourceName() + "', found: " + id.getResourceType());
        }
        HttpDeleteClientInvocation retVal = DeleteMethodBinding.createDeleteInvocation(this.getContext(), id, Collections.emptyMap());
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    public static HttpDeleteClientInvocation createDeleteInvocation(FhirContext theContext, IIdType theId, Map<String, List<String>> theAdditionalParams) {
        return new HttpDeleteClientInvocation(theContext, theId, theAdditionalParams);
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }

    public static HttpDeleteClientInvocation createDeleteInvocation(FhirContext theContext, String theSearchUrl, Map<String, List<String>> theParams) {
        return new HttpDeleteClientInvocation(theContext, theSearchUrl, theParams);
    }
}

