/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.OperationMethodBinding;
import ca.uhn.fhir.rest.client.method.OperationParameter;
import ca.uhn.fhir.rest.client.method.ResourceParameter;
import ca.uhn.fhir.util.ParametersUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ValidateMethodBindingDstu2Plus
extends OperationMethodBinding {
    public ValidateMethodBindingDstu2Plus(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, Validate theAnnotation) {
        super(null, theReturnTypeFromRp, theMethod, theContext, theProvider, true, "$validate", theAnnotation.type(), new OperationParam[0], BundleTypeEnum.COLLECTION);
        ArrayList<IParameter> newParams = new ArrayList<IParameter>();
        int idx = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof ResourceParameter) {
                if (IBaseResource.class.isAssignableFrom(((ResourceParameter)next).getResourceType())) {
                    Class<?> parameterType = theMethod.getParameterTypes()[idx];
                    if (String.class.equals(parameterType) || EncodingEnum.class.equals(parameterType)) {
                        newParams.add(next);
                    } else {
                        OperationParameter parameter = new OperationParameter(theContext, "$validate", "resource", 0, 1);
                        parameter.initializeTypes(theMethod, null, null, parameterType);
                        newParams.add(parameter);
                    }
                } else {
                    newParams.add(next);
                }
            } else {
                newParams.add(next);
            }
            ++idx;
        }
        this.setParameters(newParams);
    }

    public static BaseHttpClientInvocation createValidateInvocation(FhirContext theContext, IBaseResource theResource) {
        IBaseParameters parameters = (IBaseParameters)theContext.getResourceDefinition("Parameters").newInstance();
        ParametersUtil.addParameterToParameters((FhirContext)theContext, (IBaseResource)parameters, (Object)theResource, (String)"resource");
        String resourceName = theContext.getResourceDefinition(theResource).getName();
        String resourceId = theResource.getIdElement().getIdPart();
        BaseHttpClientInvocation retVal = ValidateMethodBindingDstu2Plus.createOperationInvocation(theContext, resourceName, resourceId, "$validate", parameters, false);
        return retVal;
    }
}

